/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.runtime.engine;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.FiniteType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.constraint.Constraints;
import io.ballerina.stdlib.graphql.runtime.engine.EngineUtils;
import io.ballerina.stdlib.graphql.runtime.exception.ConstraintValidationException;
import io.ballerina.stdlib.graphql.runtime.exception.IdTypeInputValidationException;
import io.ballerina.stdlib.graphql.runtime.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public final class ArgumentHandler {
    private final BMap<BString, Object> argumentsMap;
    private final MethodType method;
    private final BMap<BString, Object> fileInfo;
    private final BObject context;
    private final BObject field;
    private final BObject responseGenerator;
    private final boolean validation;
    private final BArray idTypeErrors;
    private static final String REPRESENTATION_TYPENAME = "Representation";
    private static final String ADD_CONSTRAINT_ERRORS_METHOD = "addConstraintValidationErrors";
    private static final String CONSTRAINT_ERROR_MESSAGE = "Constraint validation errors found.";
    private static final String ADD_ID_TYPE_ERRORS_METHOD = "addIdTypeInputValidationErrors";
    private static final String ID_TYPE_ERROR_MESSAGE = "ID type input validation error found.";
    private static final BString KIND_FIELD = StringUtils.fromString((String)"kind");
    private static final int T_STRING = 2;
    private static final int T_INT = 3;
    private static final int T_FLOAT = 4;
    private static final int T_BOOLEAN = 5;
    private static final int T_INPUT_OBJECT = 22;
    private static final int T_LIST = 23;
    private static final ArrayList<String> idsList = new ArrayList();
    private static final String ID_ANNOTATION = "ID";
    private static final String PACKAGE_NAME = "ballerina/graphql";
    private static final String RETURN_TYPE_PARAM = "$returns$";
    private static final String ARGUMENT_TYPE_PARAM = "$param$";
    private static final String RECORD_FIELD_TYPE = "$field$";

    public ArgumentHandler(MethodType method, BObject context, BObject field, BObject responseGenerator, boolean validation) {
        this.method = method;
        this.fileInfo = (BMap)context.getNativeData("graphql.context.fileInfo");
        this.context = context;
        this.field = field;
        this.populateIdTypeArguments((BMap<BString, Object>)method.getAnnotations());
        this.argumentsMap = ValueCreator.createMapValue();
        this.responseGenerator = responseGenerator;
        this.validation = validation;
        this.idTypeErrors = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_ERROR));
        BObject fieldNode = this.field.getObjectValue(Utils.INTERNAL_NODE);
        this.populateArgumentsMap(fieldNode);
    }

    private void populateIdTypeArguments(BMap<BString, Object> annotations) {
        int i = 0;
        for (Object annotation : annotations.values().toArray()) {
            BMap annotationMap = (BMap)annotation;
            for (Object annotationKey : annotationMap.getKeys()) {
                if (!this.isIdAnnotation(annotationKey) || ((BString[])annotations.getKeys())[i].getValue().equals(RETURN_TYPE_PARAM)) continue;
                String[] annotationValue = ((BString[])annotations.getKeys())[i].getValue().split("\\.");
                if (annotationValue.length == 2 && annotationValue[0].equals(ARGUMENT_TYPE_PARAM)) {
                    idsList.add(annotationValue[1]);
                }
                ++i;
            }
        }
    }

    private boolean isIdAnnotation(Object annotationKey) {
        String[] fullTypeName = annotationKey.toString().replaceAll("\\d", "").split("::");
        return fullTypeName[0].equals(PACKAGE_NAME) && fullTypeName[1].equals(ID_ANNOTATION);
    }

    public Object[] getArguments(Environment environment) throws IdTypeInputValidationException {
        if (!this.idTypeErrors.isEmpty()) {
            this.addValidationErrors(environment, this.idTypeErrors, ADD_ID_TYPE_ERRORS_METHOD);
            throw new IdTypeInputValidationException(ID_TYPE_ERROR_MESSAGE);
        }
        return this.getArgumentsForMethod();
    }

    public void validateInputConstraint(Environment environment) throws ConstraintValidationException {
        if (this.validation) {
            BArray errors = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_ERROR));
            BObject fieldNode = this.field.getObjectValue(Utils.INTERNAL_NODE);
            BArray argumentArray = fieldNode.getArrayValue(EngineUtils.ARGUMENTS_FIELD);
            for (int i = 0; i < argumentArray.size(); ++i) {
                BTypedesc bTypedesc;
                BObject argumentNode = (BObject)argumentArray.get((long)i);
                BString argumentName = argumentNode.getStringValue(EngineUtils.NAME_FIELD);
                Parameter parameter = Objects.requireNonNull(this.getParameterForArgumentNode(argumentName));
                Object argumentValue = this.argumentsMap.get((Object)argumentName);
                Object validationResult = Constraints.validate((Object)argumentValue, (BTypedesc)(bTypedesc = ArgumentHandler.getTypeDescFromParameter(parameter)));
                if (!(validationResult instanceof BError)) continue;
                errors.append(validationResult);
            }
            if (!errors.isEmpty()) {
                this.addValidationErrors(environment, errors, ADD_CONSTRAINT_ERRORS_METHOD);
                throw new ConstraintValidationException(CONSTRAINT_ERROR_MESSAGE);
            }
        }
    }

    private void populateArgumentsMap(BObject fieldNode) {
        BArray argumentArray = fieldNode.getArrayValue(EngineUtils.ARGUMENTS_FIELD);
        for (int i = 0; i < argumentArray.size(); ++i) {
            Object argumentValue;
            BObject argumentNode = (BObject)argumentArray.get((long)i);
            BString argumentName = argumentNode.getStringValue(EngineUtils.NAME_FIELD);
            Type parameterType = Objects.requireNonNull(this.getParameterForArgumentNode((BString)argumentName)).type;
            boolean isVariableValue = argumentNode.getBooleanValue(EngineUtils.VARIABLE_DEFINITION);
            if (Utils.isFileUpload(parameterType)) {
                argumentValue = this.getFileUploadParameter(argumentNode, parameterType);
            } else if (this.isRepresentationArgument(parameterType)) {
                argumentValue = this.getRepresentationArgument(argumentNode, parameterType);
            } else {
                argumentValue = isVariableValue ? argumentNode.get(EngineUtils.VARIABLE_VALUE_FIELD) : argumentNode.get(EngineUtils.VALUE_FIELD);
                try {
                    argumentValue = this.getArgumentValue(argumentName.getValue(), argumentValue, parameterType, isVariableValue);
                }
                catch (IdTypeInputValidationException e) {
                    argumentValue = null;
                }
            }
            this.argumentsMap.put((Object)argumentName, argumentValue);
        }
    }

    private Object getArgumentValue(String argName, Object argValue, Type parameterType, boolean isVariableValue) throws IdTypeInputValidationException {
        if (idsList.contains(argName)) {
            Object value = this.getIdArgumentValue(argName, argValue, parameterType, isVariableValue);
            idsList.remove(argName);
            return value;
        }
        if (parameterType.getTag() == 24) {
            return this.getInputObjectArgument(argValue, (RecordType)parameterType, isVariableValue);
        }
        if (parameterType.getTag() == 34) {
            return this.getIntersectionTypeArgument(argName, argValue, (IntersectionType)parameterType, isVariableValue);
        }
        if (parameterType.getTag() == 32) {
            return this.getArrayTypeArgument(argName, argValue, (ArrayType)parameterType, isVariableValue);
        }
        if (parameterType.getTag() == 33) {
            return this.getUnionTypeArgument(argName, argValue, (UnionType)parameterType, isVariableValue);
        }
        if (parameterType.getTag() == 53) {
            return this.getArgumentValue(argName, argValue, TypeUtils.getReferredType((Type)parameterType), isVariableValue);
        }
        return argValue;
    }

    private Object getIdArgumentValue(String argName, Object argValue, Type parameterType, boolean isVariableValue) throws IdTypeInputValidationException {
        Object value = argValue;
        if (value instanceof BString) {
            value = this.getIdValueFromString(argName, value, parameterType, isVariableValue);
        } else if (value instanceof Long) {
            value = this.getIdValueFromInteger(argName, value, parameterType, isVariableValue);
        } else if (value instanceof BArray) {
            BArray bArray = (BArray)value;
            if (parameterType.getTag() == 32) {
                ArrayType arrayType = (ArrayType)parameterType;
                BArray valueArray = ValueCreator.createArrayValue((ArrayType)arrayType);
                for (Object obj : bArray.getValues()) {
                    Object elementValue = this.getIdArgumentValue(argName, obj, arrayType.getElementType(), isVariableValue);
                    valueArray.append(elementValue);
                }
                value = valueArray;
            } else if (parameterType.getTag() == 33) {
                value = this.getIdValueFromUnionType(argName, argValue, (UnionType)parameterType, isVariableValue);
            }
        } else if (argValue instanceof BObject) {
            BObject bObject = (BObject)argValue;
            if (isVariableValue) {
                Object objectValue = bObject.get(EngineUtils.VARIABLE_VALUE_FIELD);
                value = this.getIdArgumentValue(argName, objectValue, parameterType, true);
            } else {
                Object objectValue = bObject.get(EngineUtils.VALUE_FIELD);
                value = this.getIdArgumentValue(argName, objectValue, parameterType, false);
            }
        }
        return value;
    }

    private Object getIdValueFromString(String argName, Object argValue, Type parameterType, boolean isVariableValue) throws IdTypeInputValidationException {
        String stringValue = ((BString)argValue).getValue();
        try {
            if (parameterType.getTag() == 5) {
                return StringUtils.fromString((String)stringValue);
            }
            if (parameterType.getTag() == 1) {
                return Long.parseLong(stringValue);
            }
            if (parameterType.getTag() == 3) {
                return ValueUtils.convert((Object)JsonUtils.parse((String)stringValue), (Type)parameterType);
            }
            if (parameterType.getTag() == 4) {
                return ValueUtils.convert((Object)JsonUtils.parse((String)stringValue), (Type)parameterType);
            }
            if (parameterType.getTag() == 53) {
                return ValueCreator.createRecordValue((Module)parameterType.getPackage(), (String)parameterType.getName(), (BMap)((BMap)JsonUtils.parse((String)stringValue.replaceAll("\\\\", ""))));
            }
            if (parameterType.getTag() == 33) {
                return this.getIdValueFromUnionType(argName, argValue, (UnionType)parameterType, isVariableValue);
            }
        }
        catch (BError | NumberFormatException e) {
            BError cause = ErrorCreator.createError((BString)StringUtils.fromString((String)e.getMessage()));
            BError error = Utils.createError(stringValue, "Error", cause);
            this.idTypeErrors.append((Object)error);
            throw new IdTypeInputValidationException(ID_TYPE_ERROR_MESSAGE);
        }
        return argValue;
    }

    private Object getIdValueFromInteger(String argName, Object argValue, Type parameterType, boolean isVariableValue) throws IdTypeInputValidationException {
        Long longValue = (Long)argValue;
        try {
            if (parameterType.getTag() == 5) {
                return StringUtils.fromString((String)longValue.toString());
            }
            if (parameterType.getTag() == 3 || parameterType.getTag() == 4) {
                return ValueUtils.convert((Object)longValue, (Type)parameterType);
            }
            if (parameterType.getTag() == 1) {
                return longValue;
            }
            if (parameterType.getTag() == 33) {
                return this.getIdValueFromUnionType(argName, argValue, (UnionType)parameterType, isVariableValue);
            }
        }
        catch (BError | NumberFormatException e) {
            BError cause = ErrorCreator.createError((BString)StringUtils.fromString((String)e.getMessage()));
            BError error = Utils.createError(longValue.toString(), "Error", cause);
            this.idTypeErrors.append((Object)error);
            throw new IdTypeInputValidationException(ID_TYPE_ERROR_MESSAGE);
        }
        return argValue;
    }

    private Object getIdValueFromUnionType(String argName, Object argValue, UnionType unionType, boolean isVariableValue) throws IdTypeInputValidationException {
        if (EngineUtils.isEnum(unionType)) {
            return this.getEnumTypeArgument(argValue, unionType);
        }
        if (unionType.isNilable() && argValue == null) {
            return null;
        }
        Type effectiveType = ArgumentHandler.getEffectiveType(unionType);
        return this.getIdArgumentValue(argName, argValue, effectiveType, isVariableValue);
    }

    private BMap<BString, Object> getRepresentationValue(Object jsonRepresentation, Type parameterType) {
        BMap map = JsonUtils.convertJSONToMap((Object)jsonRepresentation, (MapType)PredefinedTypes.TYPE_MAP);
        return ValueCreator.createRecordValue((Module)parameterType.getPackage(), (String)parameterType.getName(), (BMap)map);
    }

    private Object getFileUploadParameter(BObject argumentNode, Type parameterType) {
        if (parameterType.getTag() == 32) {
            return this.fileInfo.getArrayValue(argumentNode.getStringValue(EngineUtils.VARIABLE_NAME_FIELD));
        }
        return this.fileInfo.getMapValue(argumentNode.getStringValue(EngineUtils.VARIABLE_NAME_FIELD));
    }

    private BMap<BString, Object> getInputObjectArgument(Object argValue, RecordType recordType, boolean isVariableValue) throws IdTypeInputValidationException {
        this.populateInputObjectFieldIdTypeArguments((BMap<BString, Object>)recordType.getAnnotations());
        BMap recordValue = (BMap)recordType.getZeroValue();
        if (argValue == null) {
            return null;
        }
        if (isVariableValue) {
            BMap variablesMap = (BMap)argValue;
            Map fields = recordType.getFields();
            BMap variables = ValueCreator.createMapValue();
            for (Field field : fields.values()) {
                BString fieldName = StringUtils.fromString((String)field.getFieldName());
                Object value = this.getArgumentValue(fieldName.getValue(), variablesMap.get((Object)fieldName), field.getFieldType(), true);
                variables.put((Object)fieldName, value);
            }
            return ValueCreator.createRecordValue((Module)recordType.getPackage(), (String)recordType.getName(), (BMap)variables);
        }
        BArray inputObjectFields = (BArray)argValue;
        for (int i = 0; i < inputObjectFields.size(); ++i) {
            BObject inputObjectField = (BObject)inputObjectFields.get((long)i);
            BString inputObjectFieldName = inputObjectField.getStringValue(EngineUtils.NAME_FIELD);
            boolean isVariable = inputObjectField.getBooleanValue(EngineUtils.VARIABLE_DEFINITION);
            Object inputObjectFieldValue = isVariable ? inputObjectField.get(EngineUtils.VARIABLE_VALUE_FIELD) : inputObjectField.get(EngineUtils.VALUE_FIELD);
            Field field = (Field)recordType.getFields().get(inputObjectFieldName.getValue());
            Object fieldValue = this.getArgumentValue(inputObjectFieldName.getValue(), inputObjectFieldValue, field.getFieldType(), isVariable);
            recordValue.put((Object)inputObjectFieldName, fieldValue);
        }
        return recordValue;
    }

    private Object getJsonArgument(BObject argumentNode) {
        int kind = (int)argumentNode.getIntValue(KIND_FIELD);
        Object valueField = argumentNode.get(EngineUtils.VALUE_FIELD);
        return switch (kind) {
            case 2, 3, 4, 5 -> JsonUtils.convertToJson((Object)valueField);
            case 22 -> this.getJsonObject(argumentNode);
            case 23 -> this.getJsonList(argumentNode);
            default -> null;
        };
    }

    private Object getJsonList(BObject argumentNode) {
        BArray valueArray = ValueCreator.createArrayValue((ArrayType)PredefinedTypes.TYPE_JSON_ARRAY);
        BArray argumentArray = argumentNode.getArrayValue(EngineUtils.VALUE_FIELD);
        for (int i = 0; i < argumentArray.size(); ++i) {
            BObject argumentElementNode = (BObject)argumentArray.get((long)i);
            Object elementValue = this.getJsonArgument(argumentElementNode);
            valueArray.append(elementValue);
        }
        return JsonUtils.convertToJson((Object)valueArray);
    }

    private Object getJsonObject(BObject argumentNode) {
        BMap mapValue = ValueCreator.createMapValue();
        BArray inputObjectFields = argumentNode.getArrayValue(EngineUtils.VALUE_FIELD);
        for (int i = 0; i < inputObjectFields.size(); ++i) {
            BObject inputObjectField = (BObject)inputObjectFields.get((long)i);
            BString inputObjectFieldName = inputObjectField.getStringValue(EngineUtils.NAME_FIELD);
            Object fieldValue = this.getJsonArgument(inputObjectField);
            mapValue.put((Object)inputObjectFieldName, fieldValue);
        }
        return JsonUtils.convertToJson((Object)mapValue);
    }

    private Object getIntersectionTypeArgument(String argName, Object argValue, IntersectionType intersectionType, boolean isVariableValue) throws IdTypeInputValidationException {
        Type effectiveType = TypeUtils.getReferredType((Type)ArgumentHandler.getEffectiveType(intersectionType));
        if (effectiveType.getTag() == 32) {
            BArray valueArray = this.getArrayTypeArgument(argName, argValue, (ArrayType)effectiveType, isVariableValue);
            valueArray.freezeDirect();
            return valueArray;
        }
        BMap<BString, Object> argumentValue = this.getInputObjectArgument(argValue, (RecordType)effectiveType, isVariableValue);
        argumentValue.freezeDirect();
        return argumentValue;
    }

    private BArray getArrayTypeArgument(String argName, Object argValue, ArrayType arrayType, boolean isVariableValue) throws IdTypeInputValidationException {
        BArray argumentArray = (BArray)argValue;
        if (argumentArray == null) {
            return null;
        }
        if (isVariableValue) {
            BArray argumentArrValue = ValueCreator.createArrayValue((ArrayType)arrayType);
            for (int i = 0; i < argumentArray.size(); ++i) {
                Object elementValue = argumentArray.get((long)i);
                Object elementArgValue = this.getArgumentValue(argName, elementValue, arrayType.getElementType(), true);
                argumentArrValue.append(elementArgValue);
            }
            return argumentArrValue;
        }
        BArray valueArray = ValueCreator.createArrayValue((ArrayType)arrayType);
        for (int i = 0; i < argumentArray.size(); ++i) {
            BObject argumentElementNode = (BObject)argumentArray.get((long)i);
            boolean isVariable = argumentElementNode.getBooleanValue(EngineUtils.VARIABLE_DEFINITION);
            Object argElementValue = isVariable ? argumentElementNode.get(EngineUtils.VARIABLE_VALUE_FIELD) : argumentElementNode.get(EngineUtils.VALUE_FIELD);
            Object elementValue = this.getArgumentValue(argName, argElementValue, arrayType.getElementType(), isVariable);
            valueArray.append(elementValue);
        }
        return valueArray;
    }

    private Object getUnionTypeArgument(String argName, Object argValue, UnionType unionType, boolean isVariableValue) throws IdTypeInputValidationException {
        if (EngineUtils.isEnum(unionType)) {
            return this.getEnumTypeArgument(argValue, unionType);
        }
        if (unionType.isNilable() && argValue == null) {
            return null;
        }
        Type effectiveType = ArgumentHandler.getEffectiveType(unionType);
        return this.getArgumentValue(argName, argValue, effectiveType, isVariableValue);
    }

    private Object getEnumTypeArgument(Object argValue, UnionType enumType) {
        BString enumName;
        Object result = enumName = (BString)argValue;
        for (Type memberType : enumType.getMemberTypes()) {
            if (memberType.getTag() != 46) continue;
            FiniteType finiteType = (FiniteType)memberType;
            if (!enumName.getValue().equals(finiteType.getName())) continue;
            result = finiteType.getZeroValue();
        }
        return result;
    }

    private Parameter getParameterForArgumentNode(BString paramName) {
        for (Parameter parameter : this.method.getParameters()) {
            if (!parameter.name.equals(paramName.getValue())) continue;
            return parameter;
        }
        return null;
    }

    private Object[] getArgumentsForMethod() {
        Parameter[] parameters = this.method.getParameters();
        Object[] result = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            result[i] = Utils.isContext(parameters[i].type) ? this.context : (Utils.isField(parameters[i].type) ? this.field : (this.argumentsMap.get((Object)StringUtils.fromString((String)parameters[i].name)) == null ? parameters[i].type.getZeroValue() : this.argumentsMap.get((Object)StringUtils.fromString((String)parameters[i].name))));
        }
        return result;
    }

    static Type getEffectiveType(IntersectionType intersectionType) {
        for (Type constituentType : intersectionType.getConstituentTypes()) {
            if (constituentType.getTag() == 51) continue;
            return constituentType;
        }
        return intersectionType;
    }

    private static Type getEffectiveType(UnionType unionType) {
        for (Type memberType : unionType.getOriginalMemberTypes()) {
            if (EngineUtils.isIgnoreType(memberType)) continue;
            return memberType;
        }
        return unionType;
    }

    private boolean isRepresentationArgument(Type type) {
        Type refferedType = TypeUtils.getReferredType((Type)type);
        if (refferedType.getTag() == 32) {
            return this.isRepresentationArgument(((ArrayType)refferedType).getElementType());
        }
        return TypeUtils.getReferredType((Type)type).getTag() == 24 && Utils.isSubgraphModule(type) && type.getName().equals(REPRESENTATION_TYPENAME);
    }

    private Object getRepresentationArgument(BObject argumentNode, Type parameterType) {
        if (parameterType.getTag() == 32) {
            ArrayType arrayType = (ArrayType)parameterType;
            if (argumentNode.getBooleanValue(EngineUtils.VARIABLE_DEFINITION)) {
                BArray nestedArgArray = argumentNode.getArrayValue(EngineUtils.VARIABLE_VALUE_FIELD);
                Object[] representations = nestedArgArray.getValues();
                Object[] representationRecords = Arrays.stream(representations).map(entity -> this.getRepresentationValue(entity, arrayType.getElementType())).toArray();
                return ValueCreator.createArrayValue((Object[])representationRecords, (ArrayType)arrayType);
            }
            BArray valueArray = ValueCreator.createArrayValue((ArrayType)arrayType);
            BArray nestedArgArray = argumentNode.getArrayValue(EngineUtils.VALUE_FIELD);
            for (int j = 0; j < nestedArgArray.size(); ++j) {
                BObject argumentElementNode = (BObject)nestedArgArray.get((long)j);
                Object jsonRepresentation = this.getJsonArgument(argumentElementNode);
                BMap<BString, Object> elementValue = this.getRepresentationValue(jsonRepresentation, arrayType.getElementType());
                valueArray.append(elementValue);
            }
            return valueArray;
        }
        Object jsonRepresentation = this.getJsonArgument(argumentNode);
        return this.getRepresentationValue(jsonRepresentation, parameterType);
    }

    private void addValidationErrors(Environment environment, BArray errors, String methodName) {
        environment.yieldAndRun(() -> {
            BObject fieldNode = this.field.getObjectValue(Utils.INTERNAL_NODE);
            Object[] arguments = new Object[]{errors, fieldNode};
            try {
                return environment.getRuntime().callMethod(this.responseGenerator, methodName, null, arguments);
            }
            catch (BError bError) {
                Utils.handleFailureAndExit(bError);
                return null;
            }
        });
    }

    private static BTypedesc getTypeDescFromParameter(Parameter parameter) {
        BTypedesc bTypedesc = ValueCreator.createTypedescValue((Type)parameter.type);
        if (bTypedesc.getDescribingType().getTag() == 34) {
            Type type = ArgumentHandler.getEffectiveType((IntersectionType)bTypedesc.getDescribingType());
            return ValueCreator.createTypedescValue((Type)type);
        }
        return bTypedesc;
    }

    private void populateInputObjectFieldIdTypeArguments(BMap<BString, Object> annotations) {
        int i = 0;
        for (Object annotation : annotations.values().toArray()) {
            BMap annotationMap = (BMap)annotation;
            for (Object annotationKey : annotationMap.getKeys()) {
                if (!this.isIdAnnotation(annotationKey)) continue;
                String[] annotationValue = ((BString[])annotations.getKeys())[i].getValue().split("\\.");
                if (annotationValue.length == 2 && (annotationValue[0].equals(ARGUMENT_TYPE_PARAM) || annotationValue[0].equals(RECORD_FIELD_TYPE))) {
                    idsList.add(annotationValue[1]);
                }
                ++i;
            }
        }
    }
}

