/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.runtime.engine;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BValue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class Context {
    private final ConcurrentHashMap<BString, Object> attributes = new ConcurrentHashMap();
    private final ConcurrentHashMap<BString, BObject> idDataLoaderMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<BString, BObject> uuidPlaceholderMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<BString, BObject> unResolvedPlaceholders = new ConcurrentHashMap();
    private final AtomicBoolean containPlaceholders = new AtomicBoolean(false);
    private final AtomicInteger unResolvedPlaceholderCount = new AtomicInteger(0);
    private final AtomicInteger unResolvedPlaceholderNodeCount = new AtomicInteger(0);
    private static final String CONTEXT = "context";

    private Context() {
    }

    public static void initializeContext(BObject context) {
        context.addNativeData(CONTEXT, (Object)new Context());
    }

    public static void registerDataLoader(BObject object, BString key, BObject dataLoader) {
        Context context = (Context)object.getNativeData(CONTEXT);
        context.registerDataLoader(key, dataLoader);
    }

    public static void setAttribute(BObject object, BString key, Object value) {
        Context context = (Context)object.getNativeData(CONTEXT);
        context.setAttribute(key, value);
    }

    public static Object getAttribute(BObject object, BString key) {
        Context context = (Context)object.getNativeData(CONTEXT);
        return context.getAttribute(key);
    }

    public static Object removeAttribute(BObject object, BString key) {
        Context context = (Context)object.getNativeData(CONTEXT);
        return context.removeAttribute(key);
    }

    public static BObject getDataLoader(BObject object, BString key) {
        Context context = (Context)object.getNativeData(CONTEXT);
        return context.getDataLoader(key);
    }

    public static BArray getDataLoaderIds(BObject object) {
        Context context = (Context)object.getNativeData(CONTEXT);
        return context.getDataLoaderIds();
    }

    public static BArray getUnresolvedPlaceholders(BObject object) {
        Context context = (Context)object.getNativeData(CONTEXT);
        return context.getUnresolvedPlaceholders();
    }

    public static void removeAllUnresolvedPlaceholders(BObject object) {
        Context context = (Context)object.getNativeData(CONTEXT);
        context.removeAllUnresolvedPlaceholders();
    }

    public static BObject getPlaceholder(BObject object, BString uuid) {
        Context context = (Context)object.getNativeData(CONTEXT);
        return context.getPlaceholder(uuid);
    }

    public static int getUnresolvedPlaceholderCount(BObject object) {
        Context context = (Context)object.getNativeData(CONTEXT);
        return context.getUnresolvedPlaceholderCount();
    }

    public static int getUnresolvedPlaceholderNodeCount(BObject object) {
        Context context = (Context)object.getNativeData(CONTEXT);
        return context.getUnresolvedPlaceholderNodeCount();
    }

    public static void decrementUnresolvedPlaceholderNodeCount(BObject object) {
        Context context = (Context)object.getNativeData(CONTEXT);
        context.decrementUnresolvedPlaceholderNodeCount();
    }

    public static void decrementUnresolvedPlaceholderCount(BObject object) {
        Context context = (Context)object.getNativeData(CONTEXT);
        context.decrementUnresolvedPlaceholderCount();
    }

    public static void addUnresolvedPlaceholder(BObject object, BString uuid, BObject placeholder) {
        Context context = (Context)object.getNativeData(CONTEXT);
        context.addUnresolvedPlaceholder(uuid, placeholder);
    }

    public static boolean hasPlaceholders(BObject object) {
        Context context = (Context)object.getNativeData(CONTEXT);
        return context.hasPlaceholders();
    }

    public static void clearPlaceholders(BObject object) {
        Context context = (Context)object.getNativeData(CONTEXT);
        context.clearPlaceholders();
    }

    private void setAttribute(BString key, Object value) {
        this.attributes.put(key, value);
    }

    private Object getAttribute(BString key) {
        return this.attributes.get(key);
    }

    private Object removeAttribute(BString key) {
        return this.attributes.remove(key);
    }

    private void registerDataLoader(BString key, BObject dataLoader) {
        this.idDataLoaderMap.put(key, dataLoader);
    }

    private BObject getDataLoader(BString key) {
        return this.idDataLoaderMap.get(key);
    }

    private BArray getDataLoaderIds() {
        BArray values = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_STRING));
        this.idDataLoaderMap.forEach((key, value) -> values.append(key));
        return values;
    }

    private BArray getUnresolvedPlaceholders() {
        Object[] valueArray = this.unResolvedPlaceholders.values().toArray();
        ArrayType arrayType = TypeCreator.createArrayType((Type)((BValue)valueArray[0]).getType());
        return ValueCreator.createArrayValue((Object[])valueArray, (ArrayType)arrayType);
    }

    private void removeAllUnresolvedPlaceholders() {
        this.unResolvedPlaceholders.clear();
    }

    private BObject getPlaceholder(BString uuid) {
        return this.uuidPlaceholderMap.remove(uuid);
    }

    private int getUnresolvedPlaceholderCount() {
        return this.unResolvedPlaceholderCount.get();
    }

    private int getUnresolvedPlaceholderNodeCount() {
        return this.unResolvedPlaceholderNodeCount.get();
    }

    private void decrementUnresolvedPlaceholderNodeCount() {
        this.unResolvedPlaceholderNodeCount.decrementAndGet();
    }

    private void decrementUnresolvedPlaceholderCount() {
        this.unResolvedPlaceholderCount.decrementAndGet();
    }

    private void addUnresolvedPlaceholder(BString uuid, BObject placeholder) {
        this.containPlaceholders.set(true);
        this.uuidPlaceholderMap.put(uuid, placeholder);
        this.unResolvedPlaceholders.put(uuid, placeholder);
        this.unResolvedPlaceholderCount.incrementAndGet();
        this.unResolvedPlaceholderNodeCount.incrementAndGet();
    }

    private boolean hasPlaceholders() {
        return this.containPlaceholders.get();
    }

    private void clearPlaceholders() {
        this.unResolvedPlaceholders.clear();
        this.uuidPlaceholderMap.clear();
        this.containPlaceholders.set(false);
    }
}

