/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.runtime.utils;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.graphql.runtime.utils.ModuleUtils;

public class Utils {
    public static final String ERROR_TYPE = "Error";
    public static final String CONTEXT_OBJECT = "Context";
    public static final String FIELD_OBJECT = "Field";
    public static final String DATA_LOADER_OBJECT = "DataLoader";
    public static final String UPLOAD = "Upload";
    public static final BString INTERNAL_NODE = StringUtils.fromString((String)"internalNode");
    public static final String SUBGRAPH_SUB_MODULE_NAME = "graphql.subgraph";
    public static final String PACKAGE_ORG = "ballerina";
    public static final String SOURCE_STREAM = "sourceStream";
    private static final String EXECUTE_RESOURCE_FUNCTION = "executeQueryResource";
    private static final String EXECUTE_INTERCEPTOR_FUNCTION = "executeInterceptor";

    private Utils() {
    }

    public static BError createError(String message, String errorTypeName) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)errorTypeName, (BString)StringUtils.fromString((String)message), null, null);
    }

    public static BError createError(String message, String errorTypeName, BError cause) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)errorTypeName, (BString)StringUtils.fromString((String)message), (BError)cause, null);
    }

    public static boolean isContext(Type type) {
        return Utils.isGraphqlModule(type) && type.getName().equals(CONTEXT_OBJECT);
    }

    public static boolean isField(Type type) {
        return Utils.isGraphqlModule(type) && type.getName().equals(FIELD_OBJECT);
    }

    public static boolean isFileUpload(Type type) {
        if (type.getTag() == 32) {
            return Utils.isFileUpload(((ArrayType)type).getElementType());
        }
        return Utils.isGraphqlModule(type) && type.getName().equals(UPLOAD);
    }

    public static boolean isGraphqlModule(Type type) {
        return Utils.hasExpectedModuleName(type, ModuleUtils.getModule().getName(), ModuleUtils.getModule().getOrg());
    }

    public static boolean isSubgraphModule(Type type) {
        return Utils.hasExpectedModuleName(type, SUBGRAPH_SUB_MODULE_NAME, PACKAGE_ORG);
    }

    private static boolean hasExpectedModuleName(Type type, String expectedModuleName, String expectedOrgName) {
        if (type.getPackage() == null) {
            return false;
        }
        if (type.getPackage().getOrg() == null || type.getPackage().getName() == null) {
            return false;
        }
        return type.getPackage().getOrg().equals(expectedOrgName) && type.getPackage().getName().equals(expectedModuleName);
    }

    public static BString getHashCode(BObject object) {
        return StringUtils.fromString((String)Integer.toString(object.hashCode()));
    }

    public static void setSourceStream(BObject bObject, BStream sourceStream) {
        bObject.addNativeData(SOURCE_STREAM, (Object)sourceStream);
    }

    public static Object getSourceStream(BObject bObject) {
        Object streamObj = bObject.getNativeData(SOURCE_STREAM);
        if (streamObj instanceof BStream) {
            BStream bStream = (BStream)streamObj;
            return bStream;
        }
        return ErrorCreator.createError((BString)StringUtils.fromString((String)"sourceStream not found"));
    }

    public static void handleFailureAndExit(BError bError) {
        bError.printStackTrace();
        System.exit(1);
    }
}

