/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai;

import io.ballerina.stdlib.ai.RecursiveChunker;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class AbstractTagSplitter
implements RecursiveChunker.Splitter {
    private final String tagName;
    private final Pattern openTagPattern;
    private final Pattern closeTagPattern;

    AbstractTagSplitter(String tagName) {
        this.tagName = tagName;
        this.openTagPattern = Pattern.compile("<" + Pattern.quote(tagName) + "(?:\\s[^>]*)?>", 2);
        this.closeTagPattern = Pattern.compile("</" + Pattern.quote(tagName) + ">", 2);
    }

    @Override
    public Iterator<RecursiveChunker.Chunk> split(String content) {
        return new TagSplitterIterator(content);
    }

    void onBreakdown(TagSplitterIterator iterator) {
    }

    protected class TagSplitterIterator
    implements Iterator<RecursiveChunker.Chunk> {
        private String content;
        SplitterState currentState;
        String prefix;
        String tag;
        Map<String, String> tagAttributes = Map.of();
        String suffix;
        Map<String, String> suffixAttributes = Map.of();

        TagSplitterIterator(String content) {
            this.content = content;
            this.currentState = SplitterState.INIT;
        }

        @Override
        public boolean hasNext() {
            if (this.currentState == SplitterState.INIT) {
                this.breakdownContent();
                assert (this.currentState != SplitterState.INIT);
                return this.hasNext();
            }
            return this.currentState != SplitterState.END || !this.content.isEmpty();
        }

        @Override
        public RecursiveChunker.Chunk next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return switch (this.currentState.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    this.breakdownContent();
                    yield this.next();
                }
                case 1 -> {
                    this.currentState = SplitterState.TAG;
                    yield new RecursiveChunker.Chunk(this.prefix, Map.of());
                }
                case 2 -> {
                    this.currentState = SplitterState.SUFFIX;
                    yield new RecursiveChunker.Chunk(this.tag, this.tagAttributes);
                }
                case 3 -> {
                    this.currentState = !this.content.isEmpty() ? SplitterState.INIT : SplitterState.END;
                    yield new RecursiveChunker.Chunk(this.suffix, this.suffixAttributes);
                }
                case 4 -> {
                    String response = this.content;
                    this.content = "";
                    yield new RecursiveChunker.Chunk(response, Map.of());
                }
            };
        }

        private void breakdownContentInner() {
            assert (this.currentState == SplitterState.INIT);
            assert (this.content != null);
            Matcher openTagMatcher = AbstractTagSplitter.this.openTagPattern.matcher(this.content);
            if (!openTagMatcher.find()) {
                this.currentState = SplitterState.END;
                return;
            }
            int openTagIndex = openTagMatcher.start();
            this.prefix = this.content.substring(0, openTagIndex);
            this.currentState = SplitterState.PREFIX;
            Matcher closeTagMatcher = AbstractTagSplitter.this.closeTagPattern.matcher(this.content);
            closeTagMatcher.region(openTagMatcher.end(), this.content.length());
            if (!closeTagMatcher.find()) {
                throw new IndexOutOfBoundsException("Invalid HTML <%s> is not properly terminated".formatted(AbstractTagSplitter.this.tagName));
            }
            this.tag = this.content.substring(openTagIndex, closeTagMatcher.end());
            this.content = this.content.substring(closeTagMatcher.end());
            Matcher nextOpenTagMatcher = AbstractTagSplitter.this.openTagPattern.matcher(this.content);
            if (!nextOpenTagMatcher.find()) {
                this.suffix = this.content;
                this.content = "";
                return;
            }
            int nextOpenTagIndex = nextOpenTagMatcher.start();
            this.suffix = this.content.substring(0, nextOpenTagIndex);
            this.content = this.content.substring(nextOpenTagIndex);
        }

        private void breakdownContent() {
            this.breakdownContentInner();
            this.breakdownContentCallback();
        }

        private void breakdownContentCallback() {
            AbstractTagSplitter.this.onBreakdown(this);
        }
    }

    static enum SplitterState {
        INIT,
        PREFIX,
        TAG,
        SUFFIX,
        END;

    }
}

