/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai;

import io.ballerina.stdlib.ai.AbstractTagSplitter;
import java.util.Map;

class HtmlHeaderSplitter
extends AbstractTagSplitter {
    final String type;

    HtmlHeaderSplitter(int level) {
        super("h" + level);
        this.type = "header" + level;
    }

    @Override
    void onBreakdown(AbstractTagSplitter.TagSplitterIterator iterator) {
        if (iterator.currentState != AbstractTagSplitter.SplitterState.PREFIX) {
            return;
        }
        String tagContent = iterator.tag;
        String cleanContent = tagContent.replaceAll("<[^>]*>", "").trim();
        Map<String, String> attributes = Map.of(this.type, cleanContent, "header", cleanContent);
        iterator.suffixAttributes = attributes;
        iterator.tagAttributes = attributes;
    }
}

