/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;

public final class ModuleUtils {
    private static final String PACKAGE_ORG = "ballerina";
    private static final String PACKAGE_NAME = "ai";
    private static final String ERROR_TYPE_NAME = "Error";
    private static Module module;

    private ModuleUtils() {
    }

    public static Module getModule() {
        return module;
    }

    public static void setModule(Environment env) {
        module = env.getCurrentModule();
    }

    public static BError createError(String errorMessage) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)ERROR_TYPE_NAME, (BString)StringUtils.fromString((String)errorMessage), null, null);
    }

    static boolean isModuleDefinedError(BError error) {
        Type errorType = error.getType();
        Module packageDetails = errorType.getPackage();
        String orgName = packageDetails.getOrg();
        String packageName = packageDetails.getName();
        return PACKAGE_ORG.equals(orgName) && PACKAGE_NAME.equals(packageName);
    }
}

