/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.segment.TextSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class RecursiveChunker {
    private final Set<String> nonMergeableTypes;

    RecursiveChunker(Set<String> nonMergeableTypes) {
        this.nonMergeableTypes = nonMergeableTypes;
    }

    List<Chunk> chunkUsingSplitters(String content, List<Splitter> splitters, int maxChunkSize, int maxOverlapSize) {
        return this.chunkUsingSplittersInner(content, splitters, maxChunkSize, maxOverlapSize, Collections.emptyMap());
    }

    private List<Chunk> chunkUsingSplittersInner(String content, List<Splitter> splitters, int maxChunkSize, int maxOverlapSize, Map<String, String> parentMetadata) {
        return this.mergeChunksWithOverlap(splitters, this.chunkWithNoMerge(content, splitters, maxChunkSize, parentMetadata), maxChunkSize, maxOverlapSize);
    }

    private List<Chunk> chunkWithNoMerge(String content, List<Splitter> delimiters, int maxChunkSize, Map<String, String> parentMetadata) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        List<Splitter> rest = delimiters.subList(1, delimiters.size());
        Iterator<Chunk> pieces = delimiters.getFirst().split(content);
        while (pieces.hasNext()) {
            Chunk piece = pieces.next();
            if (this.isNonMergeable(piece)) {
                if (piece.length() > maxChunkSize) {
                    chunks.addAll(RecursiveChunker.breakUpChunk(piece, maxChunkSize));
                    continue;
                }
                chunks.add(piece);
                continue;
            }
            if (piece.length() <= maxChunkSize) {
                chunks.add(piece);
                continue;
            }
            chunks.addAll(this.chunkWithNoMerge(piece.piece, rest, maxChunkSize, piece.metadata));
        }
        if (parentMetadata.isEmpty()) {
            return chunks;
        }
        return chunks.stream().map(chunk -> {
            HashMap<String, String> metadata = new HashMap<String, String>(parentMetadata);
            metadata.putAll(chunk.metadata);
            return new Chunk(chunk.piece(), Collections.unmodifiableMap(metadata));
        }).toList();
    }

    private boolean isNonMergeable(Chunk chunk) {
        if (!chunk.metadata().containsKey("type")) {
            return false;
        }
        String type = chunk.metadata().get("type");
        return this.nonMergeableTypes.contains(type);
    }

    static List<Chunk> breakUpChunk(Chunk chunk, int maxChunkSize) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        Chunk remainder = chunk;
        Chunk previousChunk = null;
        while (remainder.length() > maxChunkSize) {
            HashMap<String, String> chunkMetadata = new HashMap<String, String>(remainder.metadata);
            if (previousChunk != null) {
                chunkMetadata.put("prev", String.valueOf(previousChunk.id()));
            }
            Chunk part = new Chunk(remainder.piece().substring(0, maxChunkSize), chunkMetadata);
            chunks.add(part);
            previousChunk = part;
            remainder = new Chunk(remainder.piece().substring(maxChunkSize, remainder.length()), remainder.metadata);
        }
        if (!remainder.isEmpty()) {
            HashMap<String, String> remainderMetadata = new HashMap<String, String>(remainder.metadata);
            if (previousChunk != null) {
                remainderMetadata.put("prev", String.valueOf(previousChunk.id()));
            }
            chunks.add(new Chunk(remainder.piece(), remainderMetadata));
        }
        return chunks;
    }

    private List<Chunk> mergeChunksWithOverlap(List<Splitter> splitters, List<Chunk> pieces, int maxChunkSize, int maxOverlapSize) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        ArrayList<Chunk> mergeBuffer = new ArrayList<Chunk>();
        int mergeBufferSize = 0;
        for (Chunk piece : pieces) {
            Chunk lastPiece;
            if (piece.isEmpty()) continue;
            if (this.isNonMergeable(piece)) {
                assert (piece.length() <= maxChunkSize);
                mergeBuffer.stream().reduce(Chunk::merge).ifPresent(chunks::add);
                mergeBuffer.clear();
                mergeBufferSize = 0;
                chunks.add(piece);
                continue;
            }
            if (piece.length() > maxChunkSize) {
                List<Chunk> p = RecursiveChunker.breakUpChunk(piece, maxChunkSize);
                assert (p.size() > 1);
                chunks.addAll(p.subList(0, p.size() - 2));
                piece = p.getLast();
            }
            if (mergeBuffer.isEmpty()) {
                assert (piece.length() <= maxChunkSize);
                mergeBuffer.add(piece);
                mergeBufferSize += piece.length();
                continue;
            }
            if (mergeBufferSize + piece.length() <= maxChunkSize) {
                mergeBuffer.add(piece);
                mergeBufferSize += piece.length();
                continue;
            }
            mergeBuffer.stream().reduce(Chunk::merge).ifPresent(chunks::add);
            if (maxOverlapSize > 0) {
                lastPiece = (Chunk)mergeBuffer.getLast();
                if (lastPiece.length() > maxOverlapSize) {
                    List<Chunk> p = this.chunkWithNoMerge(lastPiece.piece(), splitters, maxOverlapSize, lastPiece.metadata);
                    assert (p.size() > 1);
                    lastPiece = p.getLast();
                }
            } else {
                lastPiece = Chunk.EMPTY;
            }
            mergeBuffer.clear();
            if (lastPiece.length() + piece.length() <= maxChunkSize) {
                Map<String, String> pieceMetadata = piece.metadata;
                piece = Chunk.merge(lastPiece, piece);
                piece = piece.appendMetadata(piece, pieceMetadata);
            }
            assert (piece.length() <= maxChunkSize);
            mergeBuffer.add(piece);
            mergeBufferSize = piece.length();
        }
        mergeBuffer.stream().reduce(Chunk::merge).ifPresent(chunks::add);
        return chunks;
    }

    @FunctionalInterface
    static interface Splitter {
        public Iterator<Chunk> split(String var1);

        public static Splitter createSentenceSplitter() {
            return new SimpleDelimiterSplitter("\\.");
        }

        public static Splitter createWordSplitter() {
            return new SimpleDelimiterSplitter(" ");
        }

        public static Splitter createCharacterSplitter() {
            return new SimpleDelimiterSplitter("");
        }
    }

    record Chunk(long id, String piece, Map<String, String> metadata) {
        private static final AtomicLong nextId = new AtomicLong(0L);
        public static final Chunk EMPTY = new Chunk("", Collections.emptyMap());

        Chunk {
            assert (piece != null);
            assert (metadata != null);
        }

        Chunk(String piece, Map<String, String> metadata) {
            this(nextId.getAndIncrement(), piece, metadata);
        }

        public int length() {
            return this.piece.length();
        }

        public boolean isEmpty() {
            return this.piece.isEmpty();
        }

        public static Chunk merge(Chunk first, Chunk second) {
            String mergedPiece = first.piece + second.piece;
            HashMap<String, String> mergedMetadata = new HashMap<String, String>();
            for (String key : first.metadata().keySet()) {
                if (!second.metadata.containsKey(key) || !second.metadata.get(key).equals(first.metadata.get(key))) continue;
                mergedMetadata.put(key, first.metadata.get(key));
            }
            return new Chunk(mergedPiece, Collections.unmodifiableMap(mergedMetadata));
        }

        public TextSegment toTextSegment(int index) {
            HashMap<String, String> metadata = new HashMap<String, String>(this.metadata);
            metadata.put("id", (String)((Object)Long.valueOf(this.id)));
            metadata.put("index", (String)((Object)Integer.valueOf(index)));
            return new TextSegment(this.piece, new Metadata(metadata));
        }

        public Chunk appendMetadata(Chunk base, Map<String, String> metadata) {
            HashMap<String, String> newMetadata = new HashMap<String, String>(base.metadata);
            newMetadata.putAll(metadata);
            return new Chunk(base.piece, Collections.unmodifiableMap(newMetadata));
        }
    }

    static class SimpleDelimiterSplitter
    implements Splitter {
        private final Pattern pattern;

        SimpleDelimiterSplitter(String delimiter) {
            this.pattern = Pattern.compile(Pattern.quote(delimiter));
        }

        @Override
        public Iterator<Chunk> split(final String content) {
            return new Iterator<Chunk>(){
                private final Matcher matcher;
                private int lastIndex;
                private String nextPiece;
                private boolean hasNextPiece;
                private boolean finished;
                {
                    this.matcher = pattern.matcher(content);
                    this.lastIndex = 0;
                    this.nextPiece = null;
                    this.hasNextPiece = false;
                    this.finished = false;
                }

                private void prepareNext() {
                    if (this.finished) {
                        return;
                    }
                    if (this.matcher.find()) {
                        int delimiterStart = this.matcher.start();
                        int delimiterEnd = this.matcher.end();
                        if (delimiterStart > this.lastIndex) {
                            this.nextPiece = content.substring(this.lastIndex, delimiterStart);
                            this.lastIndex = delimiterStart;
                            this.hasNextPiece = true;
                            return;
                        }
                        this.nextPiece = content.substring(delimiterStart, delimiterEnd);
                        this.lastIndex = delimiterEnd;
                        this.hasNextPiece = true;
                        return;
                    }
                    if (this.lastIndex < content.length()) {
                        this.nextPiece = content.substring(this.lastIndex);
                        this.lastIndex = content.length();
                        this.hasNextPiece = true;
                    } else {
                        this.hasNextPiece = false;
                    }
                    this.finished = true;
                }

                @Override
                public boolean hasNext() {
                    if (!this.hasNextPiece && !this.finished) {
                        this.prepareNext();
                    }
                    return this.hasNextPiece;
                }

                @Override
                public Chunk next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.hasNextPiece = false;
                    return new Chunk(this.nextPiece, Map.of());
                }
            };
        }
    }
}

