/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.ai.ModuleUtils;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class Utils {
    private static final String CONTEXT_TYPE_NAME = "Context";
    private static final String AI_MODULE_NAME = "ai";

    public static BMap<BString, Object> getParameterTypes(BFunctionPointer functionPointer) {
        FunctionType functionType = (FunctionType)functionPointer.getType();
        Parameter[] parameters = functionType.getParameters();
        BMap typedefs = ValueCreator.createMapValue();
        Arrays.stream(parameters).forEach(param -> typedefs.put((Object)StringUtils.fromString((String)param.name), (Object)ValueCreator.createTypedescValue((Type)param.type)));
        return typedefs;
    }

    public static boolean isContextType(BTypedesc targetTypedesc, BTypedesc contextTypedesc) {
        return TypeUtils.isSameType((Type)contextTypedesc.getDescribingType(), (Type)targetTypedesc.getDescribingType());
    }

    public static boolean isMapType(BTypedesc typedesc) {
        Type type = typedesc.getDescribingType();
        if (type instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)type;
            return Utils.isMapType(referenceType.getReferredType());
        }
        return Utils.isMapType(typedesc.getDescribingType());
    }

    private static boolean isMapType(Type type) {
        return type instanceof MapType || type instanceof RecordType;
    }

    public static BString getFunctionName(BFunctionPointer functionPointer) {
        return StringUtils.fromString((String)functionPointer.getType().getName());
    }

    public static BMap<BString, Object> getArgsWithDefaultsExcludingContext(Environment env, BFunctionPointer functionPointer, BMap<BString, Object> args) {
        FunctionType functionType = (FunctionType)functionPointer.getType();
        Parameter[] parameters = functionType.getParameters();
        LinkedHashMap<String, Object> argsWithDefaultValues = new LinkedHashMap<String, Object>();
        Optional<BString> contextParamName = Optional.empty();
        for (Parameter parameter : parameters) {
            if (Utils.isContextType(parameter.type)) {
                contextParamName = Optional.of(StringUtils.fromString((String)parameter.name));
            } else if (!parameter.type.isAnydata()) continue;
            BString parameterName = StringUtils.fromString((String)parameter.name);
            Object value2 = args.containsKey((Object)parameterName) ? args.get((Object)parameterName) : Utils.getDefaultParameterValue(env, functionPointer, parameter, argsWithDefaultValues.values().toArray());
            argsWithDefaultValues.put(parameter.name, value2);
        }
        MapType anydataMapType = TypeCreator.createMapType((Type)PredefinedTypes.TYPE_ANYDATA);
        BMap parametersWithDefaultValue = ValueCreator.createMapValue((MapType)anydataMapType);
        argsWithDefaultValues.forEach((key, value) -> parametersWithDefaultValue.put((Object)StringUtils.fromString((String)key), value));
        contextParamName.ifPresent(arg_0 -> ((BMap)parametersWithDefaultValue).remove(arg_0));
        return parametersWithDefaultValue;
    }

    private static boolean isContextType(Type paramType) {
        return paramType.getName().equals(CONTEXT_TYPE_NAME) && paramType.getPackage().getName().equals(AI_MODULE_NAME);
    }

    private static Object getDefaultParameterValue(Environment env, BFunctionPointer functionPointer, Parameter parameter, Object[] previousPositionalArgs) {
        if (!parameter.isDefault) {
            return null;
        }
        return env.getRuntime().callFunction(functionPointer.getType().getPackage(), parameter.defaultFunctionName, null, previousPositionalArgs);
    }

    public static void notifySuccess(CompletableFuture<Object> future, Object result) {
        BError error;
        if (result instanceof BError && !ModuleUtils.isModuleDefinedError(error = (BError)((Object)result))) {
            error.printStackTrace();
        }
        future.complete(result);
    }

    public static Object getResult(CompletableFuture<Object> balFuture) {
        try {
            return balFuture.get();
        }
        catch (BError error) {
            throw error;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ErrorCreator.createError((Throwable)e);
        }
        catch (Throwable throwable) {
            throw ErrorCreator.createError((Throwable)throwable);
        }
    }
}

