/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai.wso2;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.AnnotatableType;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.JsonType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;

public class Native {
    public static final String ANY_OF = "anyOf";
    public static final String BALLERINA_AI = "ballerina/ai";
    public static final String JSON_SCHEMA = "JsonSchema";

    public static Object generateJsonSchemaForTypedescNative(BTypedesc td) {
        SchemaGenerationContext schemaGenerationContext = new SchemaGenerationContext();
        try {
            Object schema = Native.generateJsonSchemaForType(td.getDescribingType(), schemaGenerationContext);
            return schemaGenerationContext.isSchemaGeneratedAtCompileTime ? schema : null;
        }
        catch (BError e) {
            return Native.createAIError(e.getErrorMessage());
        }
    }

    private static Object generateJsonSchemaForType(Type t, SchemaGenerationContext schemaGenerationContext) throws BError {
        Type impliedType = TypeUtils.getImpliedType((Type)t);
        if (Native.isSimpleType(impliedType)) {
            return Native.createSimpleTypeSchema(impliedType);
        }
        Type type = impliedType;
        Objects.requireNonNull(type);
        Type type2 = type;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonType.class, ArrayType.class, UnionType.class, ReferenceType.class}, (Object)type2, n)) {
            case 0 -> {
                JsonType ignored = (JsonType)type2;
                yield Native.generateJsonSchemaForJson();
            }
            case 1 -> {
                ArrayType arrayType = (ArrayType)type2;
                yield Native.generateJsonSchemaForArrayType(arrayType, schemaGenerationContext);
            }
            case 2 -> {
                UnionType unionType = (UnionType)type2;
                yield Native.generateUnionTypeSchema(unionType, schemaGenerationContext);
            }
            case 3 -> {
                ReferenceType referenceType = (ReferenceType)type2;
                yield Native.getJsonSchemaFromAnnotatableType(referenceType, schemaGenerationContext);
            }
            default -> throw ErrorCreator.createError((BString)StringUtils.fromString((String)("Runtime schema generation is not yet supported for type: " + impliedType.getName())));
        };
    }

    private static Object generateUnionTypeSchema(UnionType unionType, SchemaGenerationContext schemaGenerationContext) {
        BMap schemaMap = ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_JSON));
        List memberTypes = unionType.getMemberTypes();
        BArray schemas = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_JSON));
        for (Type memberType : memberTypes) {
            Object schema = Native.generateJsonSchemaForType(memberType, schemaGenerationContext);
            schemas.append(schema);
        }
        if (schemas.size() == 1) {
            return schemas.get(0L);
        }
        schemaMap.put((Object)StringUtils.fromString((String)ANY_OF), (Object)schemas);
        return schemaMap;
    }

    private static Object getJsonSchemaFromAnnotatableType(ReferenceType referenceType, SchemaGenerationContext schemaGenerationContext) {
        Type referredType = referenceType.getReferredType();
        if (referredType instanceof AnnotatableType) {
            AnnotatableType annotatableType = (AnnotatableType)referredType;
            BMap annotations = annotatableType.getAnnotations();
            for (BString key : (BString[])annotations.getKeys()) {
                Object schema;
                if (!key.getValue().startsWith(BALLERINA_AI) || !key.getValue().endsWith(JSON_SCHEMA) || !((schema = annotations.get((Object)key)) instanceof BMap)) continue;
                return schema;
            }
        }
        throw ErrorCreator.createError((BString)StringUtils.fromString((String)("Runtime schema generation is not yet supported for type: " + referenceType.getName())));
    }

    private static BError createAIError(BString message) {
        return ErrorCreator.createError((Module)new Module("ballerina", "ai", "1"), (String)"Error", (BString)message, null, null);
    }

    private static BMap<BString, Object> createSimpleTypeSchema(Type type) {
        BMap schemaMap = ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_JSON));
        schemaMap.put((Object)StringUtils.fromString((String)"type"), (Object)StringUtils.fromString((String)Native.getStringRepresentation(type)));
        return schemaMap;
    }

    private static BMap<BString, Object> generateJsonSchemaForJson() {
        BString[] bStringValues = new BString[]{StringUtils.fromString((String)"object"), StringUtils.fromString((String)"array"), StringUtils.fromString((String)"string"), StringUtils.fromString((String)"number"), StringUtils.fromString((String)"boolean"), StringUtils.fromString((String)"null")};
        BMap schemaMap = ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_JSON));
        schemaMap.put((Object)StringUtils.fromString((String)"type"), (Object)ValueCreator.createArrayValue((BString[])bStringValues));
        return schemaMap;
    }

    private static boolean isSimpleType(Type type) {
        return type.getBasicType().all() <= 32;
    }

    private static String getStringRepresentation(Type type) {
        if (type.getTag() == 14) {
            return "null";
        }
        return switch (type.getBasicType().all()) {
            case 0 -> "null";
            case 2 -> "boolean";
            case 4 -> "integer";
            case 8, 16 -> "number";
            case 32 -> "string";
            default -> null;
        };
    }

    private static Object generateJsonSchemaForArrayType(ArrayType arrayType, SchemaGenerationContext schemaGenerationContext) throws BError {
        BMap schemaMap = ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_JSON));
        Type elementType = TypeUtils.getImpliedType((Type)arrayType.getElementType());
        schemaMap.put((Object)StringUtils.fromString((String)"type"), (Object)StringUtils.fromString((String)"array"));
        schemaMap.put((Object)StringUtils.fromString((String)"items"), Native.generateJsonSchemaForType(elementType, schemaGenerationContext));
        return schemaMap;
    }

    public static BTypedesc getArrayMemberType(BTypedesc expectedResponseTypedesc) {
        return ValueCreator.createTypedescValue((Type)((ArrayType)TypeUtils.getImpliedType((Type)expectedResponseTypedesc.getDescribingType())).getElementType());
    }

    public static boolean containsNil(BTypedesc expectedResponseTypedesc) {
        return expectedResponseTypedesc.getDescribingType().isNilable();
    }

    private static class SchemaGenerationContext {
        boolean isSchemaGeneratedAtCompileTime = true;

        private SchemaGenerationContext() {
        }
    }
}

