/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.xmldata.xml;

import io.ballerina.lib.data.xmldata.FromString;
import io.ballerina.lib.data.xmldata.utils.Constants;
import io.ballerina.lib.data.xmldata.utils.DataUtils;
import io.ballerina.lib.data.xmldata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.xmldata.utils.DiagnosticLog;
import io.ballerina.lib.data.xmldata.utils.QualifiedName;
import io.ballerina.lib.data.xmldata.utils.QualifiedNameFactory;
import io.ballerina.lib.data.xmldata.utils.QualifiedNameMap;
import io.ballerina.lib.data.xmldata.utils.XsdUtils;
import io.ballerina.lib.data.xmldata.utils.xsd.ModelGroupInfo;
import io.ballerina.lib.data.xmldata.xml.XmlTraversal;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.XmlUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BXml;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class XmlParser {
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private XMLStreamReader xmlStreamReader;
    public static final String PARSE_ERROR = "failed to parse xml";
    public static final String PARSE_ERROR_PREFIX = "failed to parse xml: ";

    XmlParser(Reader stringReader) {
        try {
            this.xmlStreamReader = xmlInputFactory.createXMLStreamReader(stringReader);
        }
        catch (XMLStreamException e) {
            this.handleXMLStreamException(e);
        }
    }

    public static Object parse(Reader reader, BMap<BString, Object> options, BTypedesc typed) {
        Object convertedValue = XmlParser.parse(reader, options, typed.getDescribingType());
        if (convertedValue instanceof BError) {
            return convertedValue;
        }
        return DataUtils.validateConstraints(convertedValue, typed, (Boolean)options.get((Object)Constants.ENABLE_CONSTRAINT_VALIDATION));
    }

    public static Object parse(Reader reader, BMap<BString, Object> options, Type type) {
        try {
            DataUtils.XmlParserData xmlParserData = new DataUtils.XmlParserData();
            if (DataUtils.isContainsUnionType(type)) {
                String xmlStr = DataUtils.generateStringFromXmlReader(reader);
                BXml xmlValue = XmlUtils.parse((String)xmlStr);
                return XmlTraversal.traverse(xmlValue, options, type);
            }
            XmlParser.updateOptions(options, xmlParserData);
            XmlParser xmlParser = new XmlParser(reader);
            return xmlParser.parse(type, xmlParserData);
        }
        catch (BError e) {
            return e;
        }
        catch (Throwable e) {
            return DiagnosticLog.error(DiagnosticErrorCode.XML_PARSE_ERROR, e.getMessage());
        }
    }

    private static void updateOptions(BMap<BString, Object> options, DataUtils.XmlParserData xmlParserData) {
        xmlParserData.attributePrefix = options.get((Object)Constants.ATTRIBUTE_PREFIX).toString();
        xmlParserData.textFieldName = options.get((Object)Constants.TEXT_FIELD_NAME).toString();
        xmlParserData.allowDataProjection = (Boolean)options.get((Object)Constants.ALLOW_DATA_PROJECTION);
        xmlParserData.useSemanticEquality = (Boolean)options.get((Object)Constants.USE_SEMANTIC_EQUALITY);
    }

    private void handleXMLStreamException(Exception e) {
        String reason;
        String string = reason = e.getCause() == null ? e.getMessage() : e.getCause().getMessage();
        if (reason == null) {
            throw DiagnosticLog.createXmlError(PARSE_ERROR);
        }
        throw DiagnosticLog.createXmlError(PARSE_ERROR_PREFIX + reason);
    }

    public Object parse(Type type, DataUtils.XmlParserData xmlParserData) {
        if (type.getTag() != 24) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, "record", type.getName());
        }
        xmlParserData.rootRecord = (RecordType)type;
        Object result = this.parse(xmlParserData);
        this.reset(xmlParserData);
        return result;
    }

    private void reset(DataUtils.XmlParserData xmlParserData) {
        xmlParserData.fieldHierarchy.clear();
        xmlParserData.visitedFieldHierarchy.clear();
        xmlParserData.attributeHierarchy.clear();
        xmlParserData.restTypes.clear();
        xmlParserData.nodesStack.clear();
        xmlParserData.parents.clear();
        xmlParserData.siblings.clear();
        xmlParserData.recordTypeStack.clear();
        xmlParserData.restFieldsPoints.clear();
        xmlParserData.arrayIndexes.clear();
    }

    public Object parse(DataUtils.XmlParserData xmlParserData) {
        try {
            this.parseRootElement(this.xmlStreamReader, xmlParserData);
            boolean readNext = false;
            while (this.xmlStreamReader.hasNext()) {
                int next = readNext ? this.xmlStreamReader.getEventType() : this.xmlStreamReader.next();
                readNext = this.parseXmlElements(next, xmlParserData);
            }
        }
        catch (NumberFormatException e) {
            throw DiagnosticLog.createXmlError(PARSE_ERROR_PREFIX + String.valueOf(e));
        }
        catch (BError e) {
            throw e;
        }
        catch (Exception e) {
            this.handleXMLStreamException(e);
        }
        XsdUtils.validateElementInfoStack(xmlParserData);
        XsdUtils.validateModelGroupInfoStack(xmlParserData);
        return xmlParserData.currentNode;
    }

    private boolean parseXmlElements(int next, DataUtils.XmlParserData xmlParserData) throws XMLStreamException {
        switch (next) {
            case 1: {
                this.readElement(this.xmlStreamReader, xmlParserData);
                break;
            }
            case 2: {
                this.endElement(this.xmlStreamReader, xmlParserData);
                break;
            }
            case 12: {
                this.readText(this.xmlStreamReader, true, xmlParserData);
                break;
            }
            case 4: {
                this.readText(this.xmlStreamReader, false, xmlParserData);
                return true;
            }
            case 8: {
                this.buildDocument(xmlParserData);
                break;
            }
            case 3: 
            case 5: 
            case 11: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return false;
    }

    public void parseRecordRest(String startElementName, DataUtils.XmlParserData xmlParserData) {
        try {
            boolean readNext = false;
            while (this.xmlStreamReader.hasNext()) {
                QName endElement;
                int next = readNext ? this.xmlStreamReader.getEventType() : this.xmlStreamReader.next();
                if (next == 2 && (endElement = this.xmlStreamReader.getName()).getLocalPart().equals(startElementName)) {
                    XsdUtils.validateCurrentElementInfo(xmlParserData);
                    this.validateRequiredFields(xmlParserData);
                    this.popExpectedTypeStacks(xmlParserData);
                    break;
                }
                readNext = this.parseXmlElements(next, xmlParserData);
            }
        }
        catch (BError e) {
            throw e;
        }
        catch (Exception e) {
            this.handleXMLStreamException(e);
        }
    }

    private void parseRootElement(XMLStreamReader xmlStreamReader, DataUtils.XmlParserData xmlParserData) throws XMLStreamException {
        if (xmlStreamReader.hasNext()) {
            int next = xmlStreamReader.next();
            if (next == 5 || next == 3) {
                this.parseRootElement(xmlStreamReader, xmlParserData);
                return;
            }
            if (next != 1) {
                throw DiagnosticLog.error(DiagnosticErrorCode.XML_ROOT_MISSING, new Object[0]);
            }
        }
        RecordType rootRecord = xmlParserData.rootRecord;
        xmlParserData.currentNode = ValueCreator.createRecordValue((Module)rootRecord.getPackage(), (String)rootRecord.getName());
        boolean useSemanticEquality = xmlParserData.useSemanticEquality;
        QualifiedName elementQName = this.getElementName(xmlStreamReader, useSemanticEquality);
        DataUtils.validateAndGetXmlNameFromRecordAnnotation(rootRecord, rootRecord.getName(), elementQName, useSemanticEquality);
        DataUtils.validateTypeNamespace(elementQName.getPrefix(), elementQName.getNamespaceURI(), rootRecord);
        xmlParserData.recordTypeStack.push(rootRecord);
        this.updateExpectedTypeStacks(rootRecord, xmlParserData);
        XsdUtils.initializeXsdInformation(rootRecord, xmlParserData);
        this.handleAttributes(xmlStreamReader, xmlParserData);
        xmlParserData.arrayIndexes.push(new HashMap());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readText(XMLStreamReader xmlStreamReader, boolean isCData, DataUtils.XmlParserData xmlParserData) throws XMLStreamException {
        String text;
        Field currentField = xmlParserData.currentField;
        TextValue textValue = new TextValue();
        if (isCData) {
            text = xmlStreamReader.getText();
        } else {
            this.handleTruncatedCharacters(xmlStreamReader, textValue);
            text = textValue.text;
        }
        if (text.strip().isBlank()) {
            return;
        }
        String textFieldName = xmlParserData.textFieldName;
        if (currentField == null) {
            QualifiedName contentQName = QualifiedNameFactory.createQualifiedName("", textFieldName, "", xmlParserData.useSemanticEquality);
            if (!((QualifiedNameMap)xmlParserData.fieldHierarchy.peek()).contains(contentQName)) {
                if (!((QualifiedNameMap)xmlParserData.visitedFieldHierarchy.peek()).contains(contentQName)) {
                    if (xmlParserData.allowDataProjection) return;
                    throw DiagnosticLog.error(DiagnosticErrorCode.UNDEFINED_FIELD, textFieldName, xmlParserData.rootRecord);
                }
                currentField = (Field)((QualifiedNameMap)xmlParserData.visitedFieldHierarchy.peek()).get(contentQName);
            } else {
                currentField = (Field)((QualifiedNameMap)xmlParserData.fieldHierarchy.peek()).remove(contentQName);
            }
        }
        BString bText = StringUtils.fromString((String)text);
        String fieldName = currentField.getFieldName();
        BString bFieldName = StringUtils.fromString((String)fieldName);
        Type fieldType = TypeUtils.getReferredType((Type)currentField.getFieldType());
        if (textValue.isCommentInTheMiddle && !DataUtils.isStringValueAssignable(fieldType.getTag())) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, fieldType, PredefinedTypes.TYPE_STRING);
        }
        Object temp = xmlParserData.currentNode.get((Object)bFieldName);
        if (temp instanceof BArray && !DataUtils.isAnydataOrJson(fieldType.getTag())) {
            if (fieldName.equals(textFieldName)) {
                xmlParserData.currentNode.put((Object)bFieldName, this.convertStringToRestExpType(bText, fieldType));
                return;
            }
            ArrayType arrayType = (ArrayType)fieldType;
            int currentIndex = (Integer)((HashMap)xmlParserData.arrayIndexes.peek()).get(fieldName);
            if (arrayType.getState() == ArrayType.ArrayState.CLOSED && arrayType.getSize() <= currentIndex) {
                DataUtils.logArrayMismatchErrorIfProjectionNotAllowed(xmlParserData.allowDataProjection);
                return;
            }
            ((BArray)xmlParserData.currentNode.get((Object)bFieldName)).add((long)currentIndex, this.convertStringToRestExpType(bText, fieldType));
            return;
        }
        switch (fieldType.getTag()) {
            case 24: {
                this.handleContentFieldInRecordType((RecordType)fieldType, bText, xmlParserData);
                return;
            }
            case 32: {
                this.addTextToCurrentNodeIfExpTypeIsArray((ArrayType)fieldType, bFieldName, bText, xmlParserData);
                return;
            }
            case 15: 
            case 23: {
                this.convertTextAndUpdateCurrentNode((BMap<BString, Object>)xmlParserData.currentNode, (BMap<BString, Object>)((BMap)xmlParserData.nodesStack.pop()), bFieldName, bText, fieldType, xmlParserData);
                return;
            }
        }
        xmlParserData.currentNode.put((Object)bFieldName, this.convertStringToRestExpType(bText, fieldType));
    }

    private void convertTextAndUpdateCurrentNode(BMap<BString, Object> currentNode, BMap<BString, Object> parent, BString currentFieldName, BString bText, Type restType, DataUtils.XmlParserData xmlParserData) {
        Object currentElement = currentNode.get((Object)currentFieldName);
        Object result = this.convertStringToRestExpType(bText, restType);
        if (currentElement == null && !currentNode.isEmpty()) {
            currentNode.put((Object)StringUtils.fromString((String)"#content"), result);
        } else {
            Object object = parent.get((Object)currentFieldName);
            if (object instanceof BArray) {
                BArray bArray = (BArray)object;
                bArray.add(bArray.getLength() - 1L, result);
            } else {
                parent.put((Object)currentFieldName, result);
            }
        }
        xmlParserData.currentNode = parent;
        XsdUtils.validateCurrentElementInfo(xmlParserData);
        this.popExpectedTypeStacks(xmlParserData);
        this.updateSiblingAndRootRecord(xmlParserData);
    }

    private void addTextToCurrentNodeIfExpTypeIsArray(ArrayType fieldType, BString bFieldName, BString bText, DataUtils.XmlParserData xmlParserData) {
        Type elementType = TypeUtils.getReferredType((Type)fieldType.getElementType());
        switch (elementType.getTag()) {
            case 24: {
                this.handleContentFieldInRecordType((RecordType)elementType, bText, xmlParserData);
                break;
            }
            case 15: 
            case 23: {
                BArray tempArr = (BArray)((BMap)xmlParserData.nodesStack.peek()).get((Object)bFieldName);
                HashMap indexes = (HashMap)xmlParserData.arrayIndexes.get(xmlParserData.arrayIndexes.size() - 2);
                int currentIndex = (Integer)indexes.get(bFieldName.getValue());
                if (fieldType.getState() == ArrayType.ArrayState.CLOSED && currentIndex >= fieldType.getSize()) {
                    DataUtils.logArrayMismatchErrorIfProjectionNotAllowed(xmlParserData.allowDataProjection);
                    return;
                }
                tempArr.add((long)currentIndex, this.convertStringToRestExpType(bText, (Type)fieldType));
            }
        }
    }

    private void handleTruncatedCharacters(XMLStreamReader xmlStreamReader, TextValue textValue) throws XMLStreamException {
        StringBuilder textBuilder = new StringBuilder();
        while (xmlStreamReader.getEventType() == 4) {
            textBuilder.append(xmlStreamReader.getText());
            if (xmlStreamReader.next() != 5) continue;
            textValue.isCommentInTheMiddle = true;
            xmlStreamReader.next();
        }
        textValue.text = textBuilder.toString();
    }

    private void handleContentFieldInRecordType(RecordType recordType, BString text, DataUtils.XmlParserData xmlParserData) {
        XsdUtils.validateCurrentElementInfo(xmlParserData);
        this.popExpectedTypeStacks(xmlParserData);
        this.updateSiblingAndRootRecord(xmlParserData);
        for (String key : recordType.getFields().keySet()) {
            if (!key.contains(xmlParserData.textFieldName)) continue;
            xmlParserData.currentNode.put((Object)StringUtils.fromString((String)key), this.convertStringToExpType(text, ((Field)recordType.getFields().get(key)).getFieldType()));
            xmlParserData.currentNode = (BMap)xmlParserData.nodesStack.pop();
            return;
        }
        Type restType = TypeUtils.getReferredType((Type)recordType.getRestFieldType());
        if (restType == null) {
            return;
        }
        xmlParserData.currentNode.put((Object)StringUtils.fromString((String)xmlParserData.textFieldName), this.convertStringToRestExpType(text, restType));
        xmlParserData.currentNode = (BMap)xmlParserData.nodesStack.pop();
    }

    private Object convertStringToExpType(BString value, Type expType) {
        Object result;
        if (expType.getTag() == 32) {
            expType = ((ArrayType)expType).getElementType();
        }
        if ((result = FromString.fromStringWithType(value, expType)) instanceof BError) {
            throw (BError)((Object)result);
        }
        return result;
    }

    private Object convertStringToRestExpType(BString value, Type expType) {
        switch (expType.getTag()) {
            case 32: {
                return this.convertStringToRestExpType(value, ((ArrayType)expType).getElementType());
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 33: 
            case 46: {
                return this.convertStringToExpType(value, expType);
            }
            case 15: 
            case 23: {
                return this.convertStringToExpType(value, (Type)PredefinedTypes.TYPE_JSON);
            }
            case 53: {
                return this.convertStringToRestExpType(value, TypeUtils.getReferredType((Type)expType));
            }
        }
        throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_REST_TYPE, expType.getName());
    }

    private void buildDocument(DataUtils.XmlParserData xmlParserData) {
        if (xmlParserData.fieldHierarchy.empty()) {
            return;
        }
        XsdUtils.validateCurrentElementInfo(xmlParserData);
        this.validateRequiredFields(xmlParserData);
    }

    private void endElement(XMLStreamReader xmlStreamReader, DataUtils.XmlParserData xmlParserData) {
        xmlParserData.currentField = null;
        QualifiedName elemQName = this.getElementName(xmlStreamReader, xmlParserData.useSemanticEquality);
        QualifiedNameMap<Boolean> siblings = xmlParserData.siblings;
        Stack<QualifiedNameMap<Boolean>> parents = xmlParserData.parents;
        if (siblings.contains(elemQName) && !siblings.get(elemQName).booleanValue()) {
            siblings.put(elemQName, true);
        }
        if (parents.isEmpty() || !parents.peek().contains(elemQName)) {
            XsdUtils.validateModelGroupStack(xmlParserData, elemQName, false);
            return;
        }
        XsdUtils.validateCurrentElementInfo(xmlParserData);
        this.validateRequiredFields(xmlParserData);
        XsdUtils.validateModelGroupStack(xmlParserData, elemQName, false);
        xmlParserData.currentNode = (BMap)xmlParserData.nodesStack.pop();
        this.popExpectedTypeStacks(xmlParserData);
        this.updateSiblingAndRootRecord(xmlParserData);
    }

    private void validateRequiredFields(DataUtils.XmlParserData xmlParserData) {
        Map remainingFields = ((QualifiedNameMap)xmlParserData.fieldHierarchy.peek()).getMembers();
        for (Field field : remainingFields.values()) {
            if (!SymbolFlags.isFlagOn((long)field.getFlags(), (long)256L)) continue;
            throw DiagnosticLog.error(DiagnosticErrorCode.REQUIRED_FIELD_NOT_PRESENT, field.getFieldName());
        }
        Map remainingAttributes = ((QualifiedNameMap)xmlParserData.attributeHierarchy.peek()).getMembers();
        for (Field attribute : remainingAttributes.values()) {
            if (SymbolFlags.isFlagOn((long)attribute.getFlags(), (long)4096L)) continue;
            throw DiagnosticLog.error(DiagnosticErrorCode.REQUIRED_ATTRIBUTE_NOT_PRESENT, attribute.getFieldName());
        }
    }

    private void readElement(XMLStreamReader xmlStreamReader, DataUtils.XmlParserData xmlParserData) {
        QualifiedName elemQName = this.getElementName(xmlStreamReader, xmlParserData.useSemanticEquality);
        XsdUtils.updateElementOccurrence(xmlParserData, elemQName);
        XsdUtils.validateModelGroupStack(xmlParserData, elemQName, true);
        QualifiedNameMap fieldMap = (QualifiedNameMap)xmlParserData.fieldHierarchy.peek();
        Field currentField = null;
        if (((QualifiedNameMap)xmlParserData.visitedFieldHierarchy.peek()).contains(elemQName)) {
            currentField = (Field)((QualifiedNameMap)xmlParserData.visitedFieldHierarchy.peek()).get(elemQName);
        } else if (fieldMap.contains(elemQName)) {
            elemQName = fieldMap.getMatchedQualifiedName(elemQName);
            currentField = (Field)fieldMap.remove(elemQName);
        }
        xmlParserData.currentField = currentField;
        if (currentField == null) {
            HashMap modelGroupInfo = null;
            if (!xmlParserData.xsdModelGroupInfo.isEmpty()) {
                modelGroupInfo = (HashMap)xmlParserData.xsdModelGroupInfo.peek();
            }
            if (modelGroupInfo != null && !modelGroupInfo.isEmpty()) {
                this.validateElementInXsdSequenceOrElement(elemQName, modelGroupInfo, xmlStreamReader, xmlParserData, (QualifiedNameMap)xmlParserData.visitedFieldHierarchy.peek(), fieldMap);
                return;
            }
            String elemName = elemQName.getLocalPart();
            if (xmlParserData.restTypes.peek() != null) {
                if (fieldMap.contains(elemName)) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.UNDEFINED_FIELD, elemName, xmlParserData.rootRecord);
                }
                xmlParserData.currentNode = this.handleRestField(elemQName, xmlParserData);
            } else if (!xmlParserData.allowDataProjection) {
                throw DiagnosticLog.error(DiagnosticErrorCode.UNDEFINED_FIELD, elemName, xmlParserData.rootRecord);
            }
            return;
        }
        ((QualifiedNameMap)xmlParserData.visitedFieldHierarchy.peek()).put(elemQName, currentField);
        BMap currentNode = xmlParserData.currentNode;
        String fieldName = currentField.getFieldName();
        BString bFieldName = StringUtils.fromString((String)fieldName);
        Object temp = currentNode.get((Object)bFieldName);
        Type fieldType = currentField.getFieldType();
        Type referredFieldType = TypeUtils.getReferredType((Type)fieldType);
        if (!xmlParserData.siblings.contains(elemQName)) {
            xmlParserData.siblings.put(elemQName, false);
        } else if (DataUtils.isAnydataOrJson(referredFieldType.getTag()) && !(temp instanceof BArray)) {
            BArray tempArray = DataUtils.createArrayValue(referredFieldType);
            tempArray.append(temp);
            currentNode.put((Object)bFieldName, (Object)tempArray);
        } else if (!xmlParserData.modelGroupStack.isEmpty()) {
            ModelGroupInfo modelGroup = (ModelGroupInfo)xmlParserData.modelGroupStack.peek();
            if (referredFieldType.getTag() != 32 && modelGroup == null) {
                throw DiagnosticLog.error(DiagnosticErrorCode.FOUND_ARRAY_FOR_NON_ARRAY_TYPE, fieldType, fieldName);
            }
        } else if (referredFieldType.getTag() != 32) {
            throw DiagnosticLog.error(DiagnosticErrorCode.FOUND_ARRAY_FOR_NON_ARRAY_TYPE, fieldType, fieldName);
        }
        if (DataUtils.isRegExpType(fieldType)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.UNSUPPORTED_TYPE, new Object[0]);
        }
        this.initializeNextValueBasedOnExpectedType(fieldName, fieldType, temp, (BMap<BString, Object>)currentNode, xmlParserData);
    }

    private void validateElementInXsdSequenceOrElement(QualifiedName elemQName, HashMap<String, ModelGroupInfo> modelGroupInfo, XMLStreamReader xmlStreamReader, DataUtils.XmlParserData xmlParserData, QualifiedNameMap<Field> visitedFields, QualifiedNameMap<Field> fieldMap) {
        if (modelGroupInfo != null) {
            for (Map.Entry<String, ModelGroupInfo> entry : modelGroupInfo.entrySet()) {
                ModelGroupInfo modelGroupValue = entry.getValue();
                String key = entry.getKey();
                QualifiedName qualifiedName = QualifiedNameFactory.createQualifiedName("", key, "", xmlParserData.useSemanticEquality);
                if (!modelGroupValue.isElementContains(elemQName.getLocalPart())) continue;
                Object temp = null;
                Field field = (Field)xmlParserData.rootRecord.getFields().get(key);
                if (visitedFields.contains(qualifiedName)) {
                    temp = xmlParserData.currentNode.get((Object)StringUtils.fromString((String)key));
                }
                xmlParserData.modelGroupStack.push(modelGroupValue);
                visitedFields.put(qualifiedName, field);
                fieldMap.remove(qualifiedName);
                Type referredType = TypeUtils.getReferredType((Type)field.getFieldType());
                this.updateNextRecordForXsd(xmlParserData, key, referredType, temp, (BMap<BString, Object>)xmlParserData.currentNode);
                this.readElement(xmlStreamReader, xmlParserData);
                return;
            }
        }
    }

    private void updateNextRecordForXsd(DataUtils.XmlParserData xmlParserData, String fieldName, Type fieldType, Object temp, BMap<BString, Object> currentNode) {
        xmlParserData.recordTypeStack.push(xmlParserData.rootRecord);
        if (fieldType.getTag() == 24) {
            RecordType recType = (RecordType)fieldType;
            xmlParserData.currentNode = this.updateNextValue(recType, fieldName, fieldType, xmlParserData);
            xmlParserData.rootRecord = recType;
            return;
        }
        if (fieldType.getTag() == 32) {
            Type elementType = TypeUtils.getReferredType((Type)((ArrayType)fieldType).getElementType());
            if (temp == null) {
                ((HashMap)xmlParserData.arrayIndexes.peek()).put(fieldName, 0);
                currentNode.put((Object)StringUtils.fromString((String)fieldName), (Object)ValueCreator.createArrayValue((ArrayType)((ArrayType)fieldType)));
            } else {
                HashMap indexes = (HashMap)xmlParserData.arrayIndexes.peek();
                indexes.put(fieldName, (Integer)indexes.get(fieldName) + 1);
            }
            if (elementType.getTag() == 24) {
                RecordType recType;
                xmlParserData.rootRecord = recType = (RecordType)elementType;
                xmlParserData.currentNode = this.updateNextValue(recType, fieldName, fieldType, xmlParserData);
                return;
            }
        }
        throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_XSD_ANNOTATION, fieldName, fieldType);
    }

    private void initializeNextValueBasedOnExpectedType(String fieldName, Type fieldType, Object temp, BMap<BString, Object> currentNode, DataUtils.XmlParserData xmlParserData) {
        switch (fieldType.getTag()) {
            case 24: {
                this.updateNextRecord(this.xmlStreamReader, xmlParserData, fieldName, fieldType, (RecordType)fieldType);
                break;
            }
            case 32: {
                if (temp == null) {
                    ((HashMap)xmlParserData.arrayIndexes.peek()).put(fieldName, 0);
                    currentNode.put((Object)StringUtils.fromString((String)fieldName), (Object)ValueCreator.createArrayValue((ArrayType)((ArrayType)fieldType)));
                } else {
                    HashMap indexes = (HashMap)xmlParserData.arrayIndexes.peek();
                    indexes.put(fieldName, (Integer)indexes.get(fieldName) + 1);
                }
                this.updateNextArrayMember(this.xmlStreamReader, xmlParserData, fieldName, fieldType, ((ArrayType)fieldType).getElementType());
                break;
            }
            case 15: 
            case 23: 
            case 27: {
                this.initializeAttributesForNextMappingValue(xmlParserData, fieldName, fieldType);
                break;
            }
            case 53: {
                this.initializeNextValueBasedOnExpectedType(fieldName, TypeUtils.getReferredType((Type)fieldType), temp, currentNode, xmlParserData);
            }
        }
    }

    private void updateNextArrayMember(XMLStreamReader xmlStreamReader, DataUtils.XmlParserData xmlParserData, String fieldName, Type fieldType, Type type) {
        if (DataUtils.isRegExpType(type)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.UNSUPPORTED_TYPE, new Object[0]);
        }
        switch (type.getTag()) {
            case 24: {
                this.updateNextRecord(xmlStreamReader, xmlParserData, fieldName, fieldType, (RecordType)type);
                break;
            }
            case 15: 
            case 23: 
            case 27: {
                this.initializeAttributesForNextMappingValue(xmlParserData, fieldName, fieldType);
                break;
            }
            case 53: {
                this.updateNextArrayMember(xmlStreamReader, xmlParserData, fieldName, fieldType, TypeUtils.getReferredType((Type)type));
            }
        }
    }

    private void initializeAttributesForNextMappingValue(DataUtils.XmlParserData xmlParserData, String fieldName, Type fieldType) {
        xmlParserData.parents.push(xmlParserData.siblings);
        xmlParserData.siblings = new QualifiedNameMap(new LinkedHashMap());
        BMap<BString, Object> nextMapValue = this.updateNextMappingValue(xmlParserData, fieldName, fieldType);
        this.handleAttributesRest(this.xmlStreamReader, fieldType, nextMapValue, xmlParserData.useSemanticEquality);
        xmlParserData.currentNode = nextMapValue;
    }

    private BMap<BString, Object> updateNextMappingValue(DataUtils.XmlParserData xmlParserData, String fieldName, Type fieldType) {
        BMap nextValue;
        Type type = fieldType;
        if (fieldType.getTag() == 32) {
            type = ((ArrayType)fieldType).getElementType();
        }
        if (type.getTag() == 27) {
            nextValue = ValueCreator.createMapValue((MapType)((MapType)type));
            xmlParserData.restTypes.push(((MapType)type).getConstrainedType());
        } else {
            nextValue = ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)type));
            xmlParserData.restTypes.push(type);
        }
        xmlParserData.attributeHierarchy.push(new QualifiedNameMap(new HashMap()));
        xmlParserData.fieldHierarchy.push(new QualifiedNameMap(new HashMap()));
        xmlParserData.visitedFieldHierarchy.push(new QualifiedNameMap(new HashMap()));
        xmlParserData.recordTypeStack.push(null);
        xmlParserData.xsdModelGroupInfo.push(new HashMap());
        xmlParserData.xmlElementInfo.push(new HashMap());
        BMap currentNode = xmlParserData.currentNode;
        Object temp = currentNode.get((Object)StringUtils.fromString((String)fieldName));
        if (temp instanceof BArray) {
            if (DataUtils.isAnydataOrJson(fieldType.getTag())) {
                ((BArray)temp).append((Object)nextValue);
            } else {
                int arraySize = this.getArraySize(fieldType, temp);
                int currentIndex = (Integer)((HashMap)xmlParserData.arrayIndexes.peek()).get(fieldName);
                if (currentIndex < arraySize || arraySize == -1) {
                    ((BArray)temp).add((long)currentIndex, (Object)nextValue);
                } else {
                    DataUtils.logArrayMismatchErrorIfProjectionNotAllowed(xmlParserData.allowDataProjection);
                }
            }
        } else {
            currentNode.put((Object)StringUtils.fromString((String)fieldName), (Object)nextValue);
        }
        xmlParserData.nodesStack.push(currentNode);
        xmlParserData.arrayIndexes.push(new HashMap());
        return nextValue;
    }

    private int getArraySize(Type type, Object temp) {
        return type.getTag() == 32 ? ((ArrayType)type).getSize() : ((ArrayType)TypeUtils.getType((Object)temp)).getSize();
    }

    private void updateNextRecord(XMLStreamReader xmlStreamReader, DataUtils.XmlParserData xmlParserData, String fieldName, Type fieldType, RecordType recordType) {
        xmlParserData.parents.push(xmlParserData.siblings);
        xmlParserData.siblings = new QualifiedNameMap(new LinkedHashMap());
        xmlParserData.recordTypeStack.push(xmlParserData.rootRecord);
        xmlParserData.rootRecord = recordType;
        xmlParserData.currentNode = this.updateNextValue(recordType, fieldName, fieldType, xmlParserData);
        QName qName = xmlStreamReader.getName();
        DataUtils.validateTypeNamespace(qName.getPrefix(), qName.getNamespaceURI(), recordType);
        this.handleAttributes(xmlStreamReader, xmlParserData);
    }

    private BMap<BString, Object> updateNextValue(RecordType rootRecord, String fieldName, Type fieldType, DataUtils.XmlParserData xmlParserData) {
        BMap nextValue = ValueCreator.createRecordValue((Module)rootRecord.getPackage(), (String)rootRecord.getName());
        this.updateExpectedTypeStacks(rootRecord, xmlParserData);
        XsdUtils.initializeXsdInformation(rootRecord, xmlParserData);
        BMap currentNode = xmlParserData.currentNode;
        Object temp = currentNode.get((Object)StringUtils.fromString((String)fieldName));
        if (temp instanceof BArray) {
            ArrayType arrayType = (ArrayType)fieldType;
            int currentIndex = (Integer)((HashMap)xmlParserData.arrayIndexes.peek()).get(fieldName);
            if (arrayType.getState() == ArrayType.ArrayState.OPEN || currentIndex < arrayType.getSize()) {
                ((BArray)temp).add((long)currentIndex, (Object)nextValue);
            } else {
                DataUtils.logArrayMismatchErrorIfProjectionNotAllowed(xmlParserData.allowDataProjection);
            }
        } else {
            currentNode.put((Object)StringUtils.fromString((String)fieldName), (Object)nextValue);
        }
        xmlParserData.nodesStack.push(currentNode);
        xmlParserData.arrayIndexes.push(new HashMap());
        return nextValue;
    }

    private void updateExpectedTypeStacks(RecordType recordType, DataUtils.XmlParserData xmlParserData) {
        xmlParserData.attributeHierarchy.push(new QualifiedNameMap<Field>(this.getAllAttributesInRecordType(recordType, xmlParserData.useSemanticEquality)));
        xmlParserData.fieldHierarchy.push(new QualifiedNameMap<Field>(this.getAllFieldsInRecordType(recordType, xmlParserData)));
        xmlParserData.visitedFieldHierarchy.push(new QualifiedNameMap(new HashMap()));
        xmlParserData.restTypes.push(recordType.getRestFieldType());
        xmlParserData.xsdModelGroupInfo.push(new HashMap());
        xmlParserData.xmlElementInfo.push(new HashMap());
    }

    private void popExpectedTypeStacks(DataUtils.XmlParserData xmlParserData) {
        this.popMappingTypeStacks(xmlParserData);
        xmlParserData.attributeHierarchy.pop();
        xmlParserData.arrayIndexes.pop();
        XsdUtils.popXsdValidationStacks(xmlParserData);
    }

    private void popMappingTypeStacks(DataUtils.XmlParserData xmlParserData) {
        DataUtils.popMappingTypeStacks(xmlParserData);
    }

    private void updateSiblingAndRootRecord(DataUtils.XmlParserData xmlParserData) {
        xmlParserData.siblings = xmlParserData.parents.pop();
        xmlParserData.rootRecord = (RecordType)xmlParserData.recordTypeStack.pop();
    }

    private BMap<BString, Object> handleRestField(QualifiedName elemQName, DataUtils.XmlParserData xmlParserData) {
        xmlParserData.nodesStack.push(xmlParserData.currentNode);
        xmlParserData.restFieldsPoints.push(elemQName);
        xmlParserData.parents.push(xmlParserData.siblings);
        return (BMap)this.parseRestField(xmlParserData);
    }

    private Object parseRestField(DataUtils.XmlParserData xmlParserData) {
        int next = this.xmlStreamReader.getEventType();
        Optional<Object> restNode = this.handleRecordRestType(xmlParserData, this.xmlStreamReader);
        if (restNode.isPresent()) {
            return restNode.get();
        }
        BString currentFieldName = null;
        try {
            boolean readNext = false;
            boolean isRestExit = false;
            while (!xmlParserData.restFieldsPoints.isEmpty()) {
                switch (next) {
                    case 1: {
                        currentFieldName = this.readElementRest(this.xmlStreamReader, xmlParserData);
                        break;
                    }
                    case 2: {
                        isRestExit = this.endElementRest(this.xmlStreamReader, xmlParserData);
                        break;
                    }
                    case 12: {
                        this.readTextRest(this.xmlStreamReader, currentFieldName, true, xmlParserData);
                        break;
                    }
                    case 4: {
                        this.readTextRest(this.xmlStreamReader, currentFieldName, false, xmlParserData);
                        readNext = true;
                    }
                }
                if (!isRestExit && this.xmlStreamReader.hasNext() && !xmlParserData.restFieldsPoints.isEmpty()) {
                    if (readNext) {
                        readNext = false;
                        next = this.xmlStreamReader.getEventType();
                        continue;
                    }
                    next = this.xmlStreamReader.next();
                    continue;
                }
                break;
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return xmlParserData.currentNode;
    }

    private void updateExpectedTypeStacksOfRestType(Type restType, DataUtils.XmlParserData xmlParserData) {
        if (restType.getTag() == 32) {
            this.updateExpectedTypeStacksOfRestType(((ArrayType)restType).getElementType(), xmlParserData);
        } else if (restType.getTag() == 23 || restType.getTag() == 15) {
            xmlParserData.fieldHierarchy.push(new QualifiedNameMap(new HashMap()));
            xmlParserData.visitedFieldHierarchy.push(new QualifiedNameMap(new HashMap()));
            xmlParserData.restTypes.push(restType);
            xmlParserData.arrayIndexes.push(new HashMap());
            xmlParserData.xsdModelGroupInfo.push(new HashMap());
            xmlParserData.xmlElementInfo.push(new HashMap());
        }
    }

    private BString readElementRest(XMLStreamReader xmlStreamReader, DataUtils.XmlParserData xmlParserData) {
        boolean useSemanticEquality = xmlParserData.useSemanticEquality;
        QualifiedName elemQName = this.getElementName(xmlStreamReader, useSemanticEquality);
        BString currentFieldName = StringUtils.fromString((String)elemQName.getLocalPart());
        QualifiedName lastElement = this.getLastElementInSiblings(xmlParserData.siblings.getMembers());
        Type restType = TypeUtils.getReferredType((Type)((Type)xmlParserData.restTypes.peek()));
        if (!xmlParserData.siblings.isEmpty() && lastElement != null && !xmlParserData.siblings.getOrDefault(lastElement, true).booleanValue()) {
            xmlParserData.parents.push(xmlParserData.siblings);
            xmlParserData.siblings = new QualifiedNameMap(new LinkedHashMap());
            xmlParserData.restFieldsPoints.push(null);
            this.updateExpectedTypeStacksOfRestType(restType, xmlParserData);
            xmlParserData.siblings.put(elemQName, false);
            BMap next = ValueCreator.createMapValue((MapType)DataUtils.getMapTypeFromConstraintType(restType));
            this.handleAttributesRest(xmlStreamReader, restType, (BMap<BString, Object>)next, useSemanticEquality);
            Object temp = xmlParserData.currentNode.get((Object)StringUtils.fromString((String)lastElement.getLocalPart()));
            BMap mapValue = xmlParserData.currentNode;
            if (temp == null) {
                xmlParserData.currentNode.put((Object)currentFieldName, (Object)next);
            } else if (temp instanceof BArray) {
                BArray bArray = (BArray)temp;
                mapValue = (BMap)bArray.get(bArray.getLength() - 1L);
                mapValue.put((Object)currentFieldName, (Object)next);
            } else if (temp instanceof BMap) {
                mapValue = (BMap)temp;
                mapValue.put((Object)currentFieldName, (Object)next);
            }
            xmlParserData.nodesStack.add(xmlParserData.currentNode);
            xmlParserData.currentNode = mapValue;
            return currentFieldName;
        }
        if (!xmlParserData.siblings.contains(elemQName)) {
            xmlParserData.siblings.put(elemQName, false);
            if (restType.getTag() == 32) {
                BArray tempArray = DataUtils.createArrayValue(restType);
                this.updateNextArrayMemberForRestType(tempArray, ((ArrayType)restType).getElementType(), useSemanticEquality);
                xmlParserData.currentNode.put((Object)currentFieldName, (Object)tempArray);
            } else {
                BMap next = ValueCreator.createMapValue((MapType)DataUtils.getMapTypeFromConstraintType(restType));
                xmlParserData.currentNode.put((Object)currentFieldName, (Object)next);
                this.handleAttributesRest(xmlStreamReader, restType, (BMap<BString, Object>)next, useSemanticEquality);
            }
            return currentFieldName;
        }
        Object currentElement = xmlParserData.currentNode.get((Object)currentFieldName);
        if (currentElement instanceof BArray) {
            BArray bArray = (BArray)currentElement;
            this.updateNextArrayMemberForRestType(bArray, restType, useSemanticEquality);
            xmlParserData.siblings.put(elemQName, false);
            return currentFieldName;
        }
        if (!DataUtils.isArrayValueAssignable(restType.getTag())) {
            throw DiagnosticLog.error(DiagnosticErrorCode.FOUND_ARRAY_FOR_NON_ARRAY_TYPE, restType, elemQName.getLocalPart());
        }
        BArray tempArray = DataUtils.createArrayValue(restType);
        tempArray.append(currentElement);
        this.updateNextArrayMemberForRestType(tempArray, restType, useSemanticEquality);
        xmlParserData.currentNode.put((Object)currentFieldName, (Object)tempArray);
        xmlParserData.siblings.put(elemQName, false);
        return currentFieldName;
    }

    private void updateNextArrayMemberForRestType(BArray tempArray, Type restType, boolean useSemanticEquality) {
        if (DataUtils.isSimpleType(restType)) {
            return;
        }
        BMap temp = ValueCreator.createMapValue((MapType)DataUtils.getMapTypeFromConstraintType(restType));
        tempArray.append((Object)temp);
        this.handleAttributesRest(this.xmlStreamReader, restType, (BMap<BString, Object>)temp, useSemanticEquality);
    }

    private boolean endElementRest(XMLStreamReader xmlStreamReader, DataUtils.XmlParserData xmlParserData) {
        QualifiedName elemQName = this.getElementName(xmlStreamReader, xmlParserData.useSemanticEquality);
        if (xmlParserData.siblings.contains(elemQName) && !xmlParserData.siblings.get(elemQName).booleanValue()) {
            xmlParserData.siblings.put(elemQName, true);
        }
        if (DataUtils.isEqualQualifiedName(xmlParserData.restFieldsPoints.peek(), elemQName)) {
            xmlParserData.currentNode = (BMap)xmlParserData.nodesStack.pop();
            xmlParserData.siblings = xmlParserData.parents.pop();
            xmlParserData.restFieldsPoints.pop();
            xmlParserData.siblings.put(elemQName, true);
            return true;
        }
        if (xmlParserData.parents.isEmpty() || !xmlParserData.parents.peek().contains(elemQName)) {
            return false;
        }
        xmlParserData.currentNode = (BMap)xmlParserData.nodesStack.pop();
        xmlParserData.siblings = xmlParserData.parents.pop();
        if (xmlParserData.siblings.contains(elemQName)) {
            this.popMappingTypeStacks(xmlParserData);
            xmlParserData.arrayIndexes.pop();
        }
        xmlParserData.restFieldsPoints.pop();
        xmlParserData.siblings.put(elemQName, true);
        return false;
    }

    private void readTextRest(XMLStreamReader xmlStreamReader, BString currentFieldName, boolean isCData, DataUtils.XmlParserData xmlParserData) throws XMLStreamException {
        String text;
        TextValue textValue = new TextValue();
        if (isCData) {
            text = xmlStreamReader.getText();
        } else {
            this.handleTruncatedCharacters(xmlStreamReader, textValue);
            text = textValue.text;
        }
        if (text.strip().isBlank()) {
            return;
        }
        BString bText = StringUtils.fromString((String)text);
        Type restType = TypeUtils.getReferredType((Type)((Type)xmlParserData.restTypes.peek()));
        if (textValue.isCommentInTheMiddle && !DataUtils.isStringValueAssignable(restType.getTag())) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, restType, PredefinedTypes.TYPE_STRING);
        }
        this.convertTextRestAndUpdateCurrentNodeForRestType((BMap<BString, Object>)xmlParserData.currentNode, currentFieldName, bText, restType, StringUtils.fromString((String)xmlParserData.textFieldName));
    }

    private void convertTextRestAndUpdateCurrentNodeForRestType(BMap<BString, Object> currentNode, BString currentFieldName, BString bText, Type restType, BString textFieldName) {
        Object currentElement = currentNode.get((Object)currentFieldName);
        Object result = this.convertStringToRestExpType(bText, restType);
        if (currentElement instanceof BArray) {
            BArray bArray = (BArray)currentElement;
            if (DataUtils.isSimpleType(restType)) {
                bArray.append(result);
            } else {
                bArray.add(bArray.getLength() - 1L, result);
            }
        } else if (currentElement instanceof BMap && !((BMap)currentElement).isEmpty()) {
            ((BMap)currentElement).put((Object)textFieldName, result);
        } else {
            currentNode.put((Object)currentFieldName, result);
        }
    }

    private QualifiedName getLastElementInSiblings(Map<QualifiedName, Boolean> siblings) {
        Object[] arr = siblings.keySet().toArray();
        QualifiedName lastElement = null;
        if (arr.length != 0) {
            lastElement = (QualifiedName)arr[arr.length - 1];
        }
        return lastElement;
    }

    private Map<QualifiedName, Field> getAllFieldsInRecordType(RecordType recordType, DataUtils.XmlParserData xmlParserData) {
        BMap annotations = recordType.getAnnotations();
        LinkedHashMap<String, QualifiedName> modifiedNames = new LinkedHashMap<String, QualifiedName>();
        for (BString annotationKey : (BString[])annotations.getKeys()) {
            String keyStr = annotationKey.getValue();
            if (!keyStr.contains("$field$.")) continue;
            String fieldName = keyStr.split("\\$field\\$\\.")[1];
            Map fieldAnnotation = (Map)annotations.get((Object)annotationKey);
            QualifiedName fieldQName = DataUtils.getFieldNameFromRecord(fieldAnnotation, fieldName, xmlParserData.useSemanticEquality);
            fieldQName.setLocalPart(this.getModifiedName(fieldAnnotation, fieldName));
            modifiedNames.put(fieldName, fieldQName);
        }
        HashMap<QualifiedName, Field> fieldMap = new HashMap<QualifiedName, Field>();
        HashMap<String, ArrayList<QualifiedName>> fieldNames = new HashMap<String, ArrayList<QualifiedName>>();
        Map recordFields = recordType.getFields();
        for (String key : recordFields.keySet()) {
            QualifiedNameMap attributeMap = (QualifiedNameMap)xmlParserData.attributeHierarchy.peek();
            QualifiedName modifiedQName = ((HashMap)modifiedNames).getOrDefault(key, QualifiedNameFactory.createQualifiedName("$$ns_annot_not_defined$$", key, "", xmlParserData.useSemanticEquality));
            String localName = modifiedQName.getLocalPart();
            if (attributeMap.contains(modifiedQName) && modifiedQName.getAttributeState() == QualifiedName.AttributeState.NOT_DEFINED) {
                if (key.equals(((Field)attributeMap.get(modifiedQName)).getFieldName())) continue;
                modifiedQName.setAttributeState(QualifiedName.AttributeState.ELEMENT);
                fieldMap.put(modifiedQName, (Field)recordFields.get(key));
                fieldNames.put(localName, new ArrayList<QualifiedName>(List.of(modifiedQName)));
                continue;
            }
            if (fieldMap.containsKey(modifiedQName)) {
                throw DiagnosticLog.error(DiagnosticErrorCode.DUPLICATE_FIELD, localName);
            }
            if (fieldNames.containsKey(localName)) {
                List qNames = (List)fieldNames.get(localName);
                qNames.forEach(qName -> {
                    if (DataUtils.isSameAttributeFlag(qName.getAttributeState(), modifiedQName.getAttributeState()) && DataUtils.isSameNamespace(qName, modifiedQName)) {
                        throw DiagnosticLog.error(DiagnosticErrorCode.DUPLICATE_FIELD, localName);
                    }
                });
                fieldMap.put(modifiedQName, (Field)recordFields.get(key));
                ((List)fieldNames.get(localName)).add(modifiedQName);
                continue;
            }
            if (attributeMap.contains(modifiedQName)) continue;
            fieldMap.put(modifiedQName, (Field)recordFields.get(key));
            fieldNames.put(localName, new ArrayList<QualifiedName>(List.of(modifiedQName)));
        }
        return fieldMap;
    }

    private Map<QualifiedName, Field> getAllAttributesInRecordType(RecordType recordType, boolean useSemanticEquality) {
        BMap annotations = recordType.getAnnotations();
        HashMap<QualifiedName, Field> attributes = new HashMap<QualifiedName, Field>();
        for (BString annotationKey : (BString[])annotations.getKeys()) {
            String keyStr = annotationKey.getValue();
            if (!keyStr.contains("$field$.") || !DataUtils.isAttributeField(annotationKey, (BMap<BString, Object>)annotations)) continue;
            String attributeName = keyStr.split("\\$field\\$\\.")[1].replaceAll("\\\\", "");
            Map fieldAnnotation = (Map)annotations.get((Object)annotationKey);
            QualifiedName fieldQName = DataUtils.getFieldNameFromRecord(fieldAnnotation, attributeName, useSemanticEquality);
            fieldQName.setLocalPart(this.getModifiedName(fieldAnnotation, attributeName));
            fieldQName.setAttributeState(QualifiedName.AttributeState.ATTRIBUTE);
            attributes.put(fieldQName, (Field)recordType.getFields().get(attributeName));
        }
        return attributes;
    }

    private String getModifiedName(Map<BString, Object> fieldAnnotation, String attributeName) {
        for (BString key : fieldAnnotation.keySet()) {
            if (!key.getValue().endsWith("Name")) continue;
            return ((Map)fieldAnnotation.get(key)).get(Constants.VALUE).toString();
        }
        return attributeName;
    }

    private void handleAttributes(XMLStreamReader xmlStreamReader, DataUtils.XmlParserData xmlParserData) {
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            QName attributeQName = xmlStreamReader.getAttributeName(i);
            QualifiedName attQName = QualifiedNameFactory.createQualifiedName(attributeQName.getNamespaceURI(), xmlParserData.attributePrefix + attributeQName.getLocalPart(), attributeQName.getPrefix(), QualifiedName.AttributeState.ATTRIBUTE, xmlParserData.useSemanticEquality);
            Field field = (Field)((QualifiedNameMap)xmlParserData.attributeHierarchy.peek()).remove(attQName);
            if (field == null) {
                attQName.setAttributeState(QualifiedName.AttributeState.NOT_DEFINED);
                Optional<Field> f = this.getFieldFromFieldHierarchy(attQName, xmlParserData);
                if (f.isEmpty()) continue;
                field = f.get();
            }
            try {
                xmlParserData.currentNode.put((Object)StringUtils.fromString((String)field.getFieldName()), this.convertStringToExpType(StringUtils.fromString((String)xmlStreamReader.getAttributeValue(i)), field.getFieldType()));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Optional<Field> getFieldFromFieldHierarchy(QualifiedName attQName, DataUtils.XmlParserData xmlParserData) {
        Field field;
        if (((QualifiedNameMap)xmlParserData.visitedFieldHierarchy.peek()).contains(attQName)) {
            field = (Field)((QualifiedNameMap)xmlParserData.visitedFieldHierarchy.peek()).get(attQName);
        } else {
            field = (Field)((QualifiedNameMap)xmlParserData.fieldHierarchy.peek()).remove(attQName);
            ((QualifiedNameMap)xmlParserData.visitedFieldHierarchy.peek()).put(attQName, field);
        }
        if (field != null) {
            return Optional.of(field);
        }
        if (xmlParserData.allowDataProjection) {
            return Optional.empty();
        }
        throw DiagnosticLog.error(DiagnosticErrorCode.UNDEFINED_FIELD, attQName.getLocalPart(), xmlParserData.rootRecord);
    }

    private void handleAttributesRest(XMLStreamReader xmlStreamReader, Type restType, BMap<BString, Object> mapNode, boolean useSemanticEquality) {
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            QName attributeQName = xmlStreamReader.getAttributeName(i);
            QualifiedName attQName = QualifiedNameFactory.createQualifiedName(attributeQName.getNamespaceURI(), attributeQName.getLocalPart(), attributeQName.getPrefix(), QualifiedName.AttributeState.ATTRIBUTE, useSemanticEquality);
            try {
                mapNode.put((Object)StringUtils.fromString((String)attQName.getLocalPart()), this.convertStringToRestExpType(StringUtils.fromString((String)xmlStreamReader.getAttributeValue(i)), restType));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Optional<Object> handleRecordRestType(DataUtils.XmlParserData xmlParserData, XMLStreamReader xmlStreamReader) {
        xmlParserData.currentField = null;
        Type restType = TypeUtils.getReferredType((Type)((Type)xmlParserData.restTypes.peek()));
        QualifiedName elementQName = this.getElementName(xmlStreamReader, xmlParserData.useSemanticEquality);
        String fieldName = elementQName.getLocalPart();
        switch (restType.getTag()) {
            case 24: {
                RecordType recordType = (RecordType)restType;
                this.updateStacksWhenRecordAsRestType(elementQName, xmlParserData);
                xmlParserData.currentNode = this.updateNextValue(recordType, fieldName, restType, xmlParserData);
                this.handleAttributes(xmlStreamReader, xmlParserData);
                this.parseRecordRest(fieldName, xmlParserData);
                xmlParserData.siblings.clear();
                return Optional.ofNullable(xmlParserData.nodesStack.pop());
            }
            case 32: {
                ArrayType arrayType = (ArrayType)restType;
                Type elemType = TypeUtils.getReferredType((Type)arrayType.getElementType());
                HashMap indexes = (HashMap)xmlParserData.arrayIndexes.peek();
                if (indexes.containsKey(fieldName)) {
                    indexes.put(fieldName, (Integer)indexes.get(fieldName) + 1);
                } else {
                    indexes.put(fieldName, 0);
                }
                if (elemType.getTag() != 24) break;
                this.updateStacksWhenRecordAsRestType(elementQName, xmlParserData);
                if (!xmlParserData.currentNode.containsKey((Object)StringUtils.fromString((String)fieldName))) {
                    xmlParserData.currentNode.put((Object)StringUtils.fromString((String)fieldName), (Object)DataUtils.createArrayValue((Type)arrayType));
                }
                xmlParserData.currentNode = this.updateNextValue((RecordType)elemType, fieldName, (Type)arrayType, xmlParserData);
                this.handleAttributes(xmlStreamReader, xmlParserData);
                this.parseRecordRest(fieldName, xmlParserData);
                xmlParserData.siblings.clear();
                return Optional.ofNullable(xmlParserData.nodesStack.pop());
            }
        }
        return Optional.empty();
    }

    private void updateStacksWhenRecordAsRestType(QualifiedName elementQName, DataUtils.XmlParserData xmlParserData) {
        if (!xmlParserData.siblings.contains(elementQName)) {
            xmlParserData.siblings.put(elementQName, false);
        }
        xmlParserData.parents.push(xmlParserData.siblings);
        xmlParserData.siblings = new QualifiedNameMap(new LinkedHashMap());
    }

    private QualifiedName getElementName(XMLStreamReader xmlStreamReader, boolean useSemanticEquality) {
        QName qName = xmlStreamReader.getName();
        return QualifiedNameFactory.createQualifiedName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix(), QualifiedName.AttributeState.ELEMENT, useSemanticEquality);
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }

    static class TextValue {
        String text;
        boolean isCommentInTheMiddle = false;

        TextValue() {
        }
    }
}

