/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.jsondata.json;

import io.ballerina.lib.data.jsondata.FromString;
import io.ballerina.lib.data.jsondata.json.JsonParser;
import io.ballerina.lib.data.jsondata.utils.Constants;
import io.ballerina.lib.data.jsondata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.jsondata.utils.DiagnosticLog;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.FiniteType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.ballerinalang.langlib.value.CloneReadOnly;

public class JsonCreator {
    private static final List<Type> BASIC_TYPE_MEMBER_TYPES = List.of(PredefinedTypes.TYPE_NULL, PredefinedTypes.TYPE_BOOLEAN, PredefinedTypes.TYPE_INT, PredefinedTypes.TYPE_FLOAT, PredefinedTypes.TYPE_DECIMAL);
    private static final UnionType UNION_OF_BASIC_TYPE_WITHOUT_STRING = TypeCreator.createUnionType(BASIC_TYPE_MEMBER_TYPES);

    static BMap<BString, Object> initRootMapValue(JsonParser.StateMachine sm) {
        Type expectedType = sm.expectedTypes.peek();
        sm.parserContexts.push(JsonParser.StateMachine.ParserContext.MAP);
        switch (expectedType.getTag()) {
            case 24: {
                return ValueCreator.createRecordValue((Module)expectedType.getPackage(), (String)expectedType.getName());
            }
            case 27: {
                return ValueCreator.createMapValue((MapType)((MapType)expectedType));
            }
            case 15: {
                return ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
            }
            case 23: {
                return ValueCreator.createMapValue((MapType)Constants.ANYDATA_MAP_TYPE);
            }
            case 33: {
                sm.parserContexts.push(JsonParser.StateMachine.ParserContext.MAP);
                ++sm.unionDepth;
                sm.fieldNameHierarchy.push(new Stack());
                return ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
            }
        }
        throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, expectedType, "map type");
    }

    static BArray initArrayValue(JsonParser.StateMachine sm, Type expectedType) {
        switch (expectedType.getTag()) {
            case 44: {
                return ValueCreator.createTupleValue((TupleType)((TupleType)expectedType));
            }
            case 32: {
                return ValueCreator.createArrayValue((ArrayType)((ArrayType)expectedType));
            }
            case 15: {
                return ValueCreator.createArrayValue((ArrayType)PredefinedTypes.TYPE_JSON_ARRAY);
            }
            case 23: {
                return ValueCreator.createArrayValue((ArrayType)PredefinedTypes.TYPE_ANYDATA_ARRAY);
            }
            case 33: {
                ++sm.unionDepth;
                sm.arrayIndexes.push(0);
                return ValueCreator.createArrayValue((ArrayType)PredefinedTypes.TYPE_JSON_ARRAY);
            }
        }
        throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, expectedType, "list type");
    }

    static Optional<BMap<BString, Object>> initNewMapValue(JsonParser.StateMachine sm) {
        JsonParser.StateMachine.ParserContext parentContext = sm.parserContexts.peek();
        sm.parserContexts.push(JsonParser.StateMachine.ParserContext.MAP);
        Type expType = sm.expectedTypes.peek();
        if (expType == null) {
            sm.fieldNameHierarchy.push(new Stack());
            return Optional.empty();
        }
        if (sm.currentJsonNode != null) {
            sm.nodesStack.push(sm.currentJsonNode);
        }
        BMap<BString, Object> nextMapValue = JsonCreator.checkTypeAndCreateMappingValue(sm, expType, parentContext);
        return Optional.of(nextMapValue);
    }

    static BMap<BString, Object> checkTypeAndCreateMappingValue(JsonParser.StateMachine sm, Type expType, JsonParser.StateMachine.ParserContext parentContext) {
        BMap nextMapValue;
        Type currentType = TypeUtils.getReferredType((Type)expType);
        switch (currentType.getTag()) {
            case 24: {
                RecordType recordType = (RecordType)currentType;
                nextMapValue = ValueCreator.createRecordValue((Module)expType.getPackage(), (String)expType.getName());
                sm.updateExpectedType(JsonCreator.getAllFieldsInRecord(recordType), recordType.getRestFieldType());
                break;
            }
            case 27: {
                nextMapValue = ValueCreator.createMapValue((MapType)((MapType)currentType));
                sm.updateExpectedType(new HashMap<String, Field>(), ((MapType)currentType).getConstrainedType());
                break;
            }
            case 15: {
                nextMapValue = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
                sm.updateExpectedType(new HashMap<String, Field>(), currentType);
                break;
            }
            case 23: {
                nextMapValue = ValueCreator.createMapValue((MapType)Constants.ANYDATA_MAP_TYPE);
                sm.updateExpectedType(new HashMap<String, Field>(), currentType);
                break;
            }
            case 34: {
                Optional<Type> mutableType = JsonCreator.getMutableType((IntersectionType)currentType);
                if (mutableType.isEmpty()) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, currentType, "map type");
                }
                return JsonCreator.checkTypeAndCreateMappingValue(sm, mutableType.get(), parentContext);
            }
            case 33: {
                nextMapValue = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
                sm.parserContexts.push(JsonParser.StateMachine.ParserContext.MAP);
                ++sm.unionDepth;
                sm.fieldNameHierarchy.push(new Stack());
                break;
            }
            default: {
                if (parentContext == JsonParser.StateMachine.ParserContext.ARRAY) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, currentType, "map type");
                }
                throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE_FOR_FIELD, JsonCreator.getCurrentFieldPath(sm));
            }
        }
        return nextMapValue;
    }

    static void updateNextMapValue(JsonParser.StateMachine sm) {
        Optional<BMap<BString, Object>> nextMap = JsonCreator.initNewMapValue(sm);
        if (nextMap.isPresent()) {
            sm.currentJsonNode = nextMap.get();
        } else {
            ++sm.jsonFieldDepth;
        }
    }

    static Optional<BArray> initNewArrayValue(JsonParser.StateMachine sm) {
        sm.parserContexts.push(JsonParser.StateMachine.ParserContext.ARRAY);
        if (sm.expectedTypes.peek() == null) {
            return Optional.empty();
        }
        Object currentJsonNode = sm.currentJsonNode;
        Type expType = TypeUtils.getReferredType((Type)sm.expectedTypes.peek());
        if (expType.getTag() == 34) {
            Optional<Type> type = JsonCreator.getMutableType((IntersectionType)expType);
            if (type.isEmpty()) {
                throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, expType, "array type");
            }
            expType = type.get();
        }
        BArray nextArrValue = JsonCreator.initArrayValue(sm, expType);
        if (currentJsonNode == null) {
            return Optional.ofNullable(nextArrValue);
        }
        sm.nodesStack.push(currentJsonNode);
        return Optional.ofNullable(nextArrValue);
    }

    static Optional<Type> getMutableType(IntersectionType intersectionType) {
        for (Type constituentType : intersectionType.getConstituentTypes()) {
            if (constituentType.getTag() == 51) continue;
            return Optional.of(constituentType);
        }
        return Optional.empty();
    }

    private static String getCurrentFieldPath(JsonParser.StateMachine sm) {
        Iterator itr = sm.fieldNameHierarchy.iterator();
        StringBuilder result = new StringBuilder(itr.hasNext() ? (String)((Stack)itr.next()).peek() : "");
        while (itr.hasNext()) {
            result.append(".").append((String)((Stack)itr.next()).peek());
        }
        return result.toString();
    }

    static Object convertAndUpdateCurrentJsonNode(JsonParser.StateMachine sm, String value, Type type, boolean isStringElement) {
        Object convertedValue;
        Object currentJson = sm.currentJsonNode;
        if (sm.nilAsOptionalField && !type.isNilable() && value.equals("null") && sm.currentField != null && SymbolFlags.isFlagOn((long)sm.currentField.getFlags(), (long)4096L)) {
            return null;
        }
        Object object = convertedValue = isStringElement ? JsonCreator.convertStringToExpectedType(StringUtils.fromString((String)value), type) : JsonCreator.validateNonStringValueAndConvertToExpectedType(value, type);
        if (convertedValue instanceof BError) {
            if (sm.currentField != null) {
                throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_VALUE_FOR_FIELD, value, type, JsonCreator.getCurrentFieldPath(sm));
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, type, value);
        }
        Type currentJsonNodeType = TypeUtils.getType((Object)currentJson);
        switch (currentJsonNodeType.getTag()) {
            case 24: 
            case 27: {
                ((BMap)currentJson).put((Object)StringUtils.fromString((String)sm.fieldNameHierarchy.peek().pop()), convertedValue);
                break;
            }
            case 32: {
                ArrayType arrayType = (ArrayType)currentJsonNodeType;
                if (arrayType.getState() == ArrayType.ArrayState.CLOSED && arrayType.getSize() <= sm.arrayIndexes.peek()) break;
                ((BArray)currentJson).add((long)sm.arrayIndexes.peek().intValue(), convertedValue);
                break;
            }
            case 44: {
                ((BArray)currentJson).add((long)sm.arrayIndexes.peek().intValue(), convertedValue);
                break;
            }
            default: {
                return convertedValue;
            }
        }
        return currentJson;
    }

    static void checkNullAndUpdateCurrentJson(JsonParser.StateMachine sm, Object value) {
        if (value == null) {
            return;
        }
        sm.currentJsonNode = value;
    }

    private static Object convertStringToExpectedType(BString value, Type type) {
        switch (type.getTag()) {
            case 5: 
            case 15: 
            case 23: {
                return value;
            }
            case 13: {
                if (value.length() != 1) {
                    return DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, type, value);
                }
                return value;
            }
            case 46: {
                return ((FiniteType)type).getValueSpace().stream().filter(finiteValue -> !(JsonCreator.convertToSingletonValue(value.getValue(), finiteValue, true) instanceof BError)).findFirst().orElseGet(() -> DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, type, value));
            }
            case 33: {
                for (Type memberType : ((UnionType)type).getMemberTypes()) {
                    Object convertedValue = JsonCreator.convertStringToExpectedType(value, memberType);
                    if (convertedValue instanceof BError) continue;
                    return convertedValue;
                }
                return DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, type, value);
            }
            case 53: {
                return JsonCreator.convertStringToExpectedType(value, TypeUtils.getReferredType((Type)type));
            }
        }
        return DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, type, value);
    }

    private static Object validateNonStringValueAndConvertToExpectedType(String value, Type type) {
        char ch = value.charAt(0);
        if (ch == 't' ? !"true".equals(value) : (ch == 'f' ? !"false".equals(value) : (ch == 'n' ? !"null".equals(value) : !Character.isDigit(ch) && ch != '-' && ch != '+'))) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, type, value);
        }
        return JsonCreator.convertNonStringToExpectedType(StringUtils.fromString((String)value), type);
    }

    private static Object convertNonStringToExpectedType(BString value, Type type) {
        switch (type.getTag()) {
            case 15: 
            case 23: {
                return FromString.fromStringWithType(value, (Type)UNION_OF_BASIC_TYPE_WITHOUT_STRING);
            }
            case 5: 
            case 13: {
                return DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, type, value);
            }
            case 46: {
                return ((FiniteType)type).getValueSpace().stream().filter(finiteValue -> !(JsonCreator.convertToSingletonValue(value.getValue(), finiteValue, false) instanceof BError)).findFirst().orElseGet(() -> DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, type, value));
            }
            case 33: {
                ArrayList<Object> newMembers = new ArrayList<Object>();
                for (Type memberType : ((UnionType)type).getMemberTypes()) {
                    int typeTag = memberType.getTag();
                    if (typeTag == 5) continue;
                    if (typeTag == 15 || typeTag == 23) {
                        newMembers.add(UNION_OF_BASIC_TYPE_WITHOUT_STRING);
                        continue;
                    }
                    newMembers.add(memberType);
                }
                return FromString.fromStringWithType(value, (Type)TypeCreator.createUnionType(newMembers));
            }
            case 53: {
                return JsonCreator.convertNonStringToExpectedType(value, TypeUtils.getReferredType((Type)type));
            }
        }
        return FromString.fromStringWithType(value, type);
    }

    private static Object convertToSingletonValue(String str, Object singletonValue, boolean isStringElement) {
        String singletonStr = String.valueOf(singletonValue);
        if (str.equals(singletonStr)) {
            BString value = StringUtils.fromString((String)str);
            Type expType = TypeUtils.getType((Object)singletonValue);
            return isStringElement ? JsonCreator.convertStringToExpectedType(value, expType) : JsonCreator.convertNonStringToExpectedType(value, expType);
        }
        return DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, singletonValue, str);
    }

    static Type getMemberType(Type expectedType, int index, boolean allowDataProjection) {
        if (expectedType == null) {
            return null;
        }
        Type referredType = TypeUtils.getReferredType((Type)expectedType);
        if (referredType.getTag() == 34) {
            return JsonCreator.getMemberType(((IntersectionType)referredType).getEffectiveType(), index, allowDataProjection);
        }
        if (referredType.getTag() == 32) {
            ArrayType arrayType = (ArrayType)referredType;
            if (arrayType.getState() == ArrayType.ArrayState.OPEN || arrayType.getState() == ArrayType.ArrayState.CLOSED && index < arrayType.getSize()) {
                return arrayType.getElementType();
            }
            if (!allowDataProjection) {
                throw DiagnosticLog.error(DiagnosticErrorCode.ARRAY_SIZE_MISMATCH, new Object[0]);
            }
            return null;
        }
        if (referredType.getTag() == 44) {
            TupleType tupleType = (TupleType)referredType;
            List tupleTypes = tupleType.getTupleTypes();
            if (tupleTypes.size() < index + 1) {
                Type restType = tupleType.getRestType();
                if (restType == null && !allowDataProjection) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.ARRAY_SIZE_MISMATCH, new Object[0]);
                }
                return restType;
            }
            return (Type)tupleTypes.get(index);
        }
        return expectedType;
    }

    static Map<String, Field> getAllFieldsInRecord(RecordType recordType) {
        BMap annotations = recordType.getAnnotations();
        HashMap<String, String> modifiedNames = new HashMap<String, String>();
        for (BString annotationKey : (BString[])annotations.getKeys()) {
            String keyStr = annotationKey.getValue();
            if (!keyStr.contains("$field$.")) continue;
            String fieldName = keyStr.split("\\$field\\$\\.")[1];
            Map fieldAnnotation = (Map)annotations.get((Object)annotationKey);
            modifiedNames.put(fieldName, JsonCreator.getModifiedName(fieldAnnotation, fieldName));
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Map recordFields = recordType.getFields();
        for (String key : recordFields.keySet()) {
            String fieldName = modifiedNames.getOrDefault(key, key);
            if (fields.containsKey(fieldName)) {
                throw DiagnosticLog.error(DiagnosticErrorCode.DUPLICATE_FIELD, fieldName);
            }
            fields.put(fieldName, (Field)recordFields.get(key));
        }
        return fields;
    }

    static String getModifiedName(Map<BString, Object> fieldAnnotation, String fieldName) {
        for (BString key : fieldAnnotation.keySet()) {
            if (!key.getValue().endsWith("Name")) continue;
            return ((Map)fieldAnnotation.get(key)).get(Constants.VALUE).toString();
        }
        return fieldName;
    }

    static Object constructReadOnlyValue(Object value) {
        return CloneReadOnly.cloneReadOnly((Object)value);
    }

    static Object initRootArrayValue(JsonParser.StateMachine sm) {
        sm.parserContexts.push(JsonParser.StateMachine.ParserContext.ARRAY);
        Type expType = sm.expectedTypes.peek();
        if (expType.getTag() == 15 || expType.getTag() == 23) {
            sm.arrayIndexes.push(0);
        }
        return JsonCreator.initArrayValue(sm, expType);
    }

    static void updateExpectedType(JsonParser.StateMachine sm) {
        if (sm.unionDepth > 0) {
            return;
        }
        sm.expectedTypes.push(JsonCreator.getMemberType(sm.expectedTypes.peek(), sm.arrayIndexes.peek(), sm.allowDataProjection));
    }

    static void updateNextMapValueBasedOnExpType(JsonParser.StateMachine sm) {
        JsonCreator.updateExpectedType(sm);
        JsonCreator.updateNextMapValue(sm);
    }

    static void updateNextArrayValueBasedOnExpType(JsonParser.StateMachine sm) {
        JsonCreator.updateExpectedType(sm);
        JsonCreator.updateNextArrayValue(sm);
    }

    static void updateNextArrayValue(JsonParser.StateMachine sm) {
        sm.arrayIndexes.push(0);
        Optional<BArray> nextArray = JsonCreator.initNewArrayValue(sm);
        nextArray.ifPresent(bArray -> {
            sm.currentJsonNode = bArray;
        });
    }
}

