/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.InterceptorService;
import io.ballerina.stdlib.http.uri.URIUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPInterceptorServicesRegistry {
    private static final Logger logger = LoggerFactory.getLogger(HTTPInterceptorServicesRegistry.class);
    protected Map<String, ServicesMapHolder> servicesMapByHost = new ConcurrentHashMap<String, ServicesMapHolder>();
    protected Map<String, InterceptorService> servicesByBasePath;
    protected List<String> sortedServiceURIs;
    private Runtime runtime;
    private String servicesType = "Normal";
    private boolean possibleLastInterceptor = false;

    public ServicesMapHolder getServicesMapHolder(String hostName) {
        return this.servicesMapByHost.get(hostName);
    }

    public Map<String, InterceptorService> getServicesByHost(String hostName) {
        return this.servicesMapByHost.get((Object)hostName).servicesByBasePath;
    }

    public List<String> getSortedServiceURIsByHost(String hostName) {
        return this.servicesMapByHost.get((Object)hostName).sortedServiceURIs;
    }

    public void registerInterceptorService(BObject service, String basePath, boolean fromListener) {
        InterceptorService httpInterceptorService = InterceptorService.buildHttpService(service, basePath, this.getServicesType(), fromListener);
        service.addNativeData("ABSOLUTE_RESOURCE_PATH", (Object)basePath);
        String hostName = httpInterceptorService.getHostName();
        if (this.servicesMapByHost.get(hostName) == null) {
            this.servicesByBasePath = new ConcurrentHashMap<String, InterceptorService>();
            this.sortedServiceURIs = new CopyOnWriteArrayList<String>();
            this.servicesMapByHost.put(hostName, new ServicesMapHolder(this.servicesByBasePath, this.sortedServiceURIs));
        } else {
            this.servicesByBasePath = this.getServicesByHost(hostName);
            this.sortedServiceURIs = this.getSortedServiceURIsByHost(hostName);
        }
        if (this.servicesByBasePath.containsKey(basePath)) {
            Object errorMessage = hostName.equals("b7a.default") ? "'" : "' under host name : '" + hostName + "'";
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)("Service registration failed: two services have the same basePath : '" + basePath + (String)errorMessage)));
        }
        this.servicesByBasePath.put(basePath, httpInterceptorService);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Service deployed : %s with context %s", TypeUtils.getType((Object)service).getName(), basePath));
        }
        this.sortedServiceURIs.add(basePath);
        this.sortedServiceURIs.sort((basePath1, basePath2) -> basePath2.length() - basePath1.length());
    }

    public String findTheMostSpecificBasePath(String requestURIPath, Map<String, InterceptorService> services, List<String> sortedServiceURIs) {
        for (String key : sortedServiceURIs) {
            if (!URIUtil.isPathMatch(requestURIPath, key.toString())) continue;
            return key.toString();
        }
        if (services.containsKey("/")) {
            return "/";
        }
        return null;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(Runtime runtime) {
        this.runtime = runtime;
    }

    public String getServicesType() {
        return this.servicesType;
    }

    public void setServicesType(String servicesType) {
        this.servicesType = servicesType;
    }

    public boolean isPossibleLastInterceptor() {
        return this.possibleLastInterceptor;
    }

    public void setPossibleLastInterceptor(boolean possibleLastInterceptor) {
        this.possibleLastInterceptor = possibleLastInterceptor;
    }

    protected static class ServicesMapHolder {
        private Map<String, InterceptorService> servicesByBasePath;
        private List<String> sortedServiceURIs;

        public ServicesMapHolder(Map<String, InterceptorService> servicesByBasePath, List<String> sortedServiceURIs) {
            this.servicesByBasePath = servicesByBasePath;
            this.sortedServiceURIs = sortedServiceURIs;
        }
    }
}

