/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.http.api.HttpService;
import io.ballerina.stdlib.http.api.HttpServiceFromContract;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.uri.URIUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPServicesRegistry {
    private static final Logger logger = LoggerFactory.getLogger(HTTPServicesRegistry.class);
    private static final BString SERVICE_TYPE = StringUtils.fromString((String)"serviceType");
    protected Map<String, ServicesMapHolder> servicesMapByHost = new ConcurrentHashMap<String, ServicesMapHolder>();
    protected Map<String, HttpService> servicesByBasePath;
    protected List<String> sortedServiceURIs;
    private Runtime runtime;
    private boolean possibleLastService = true;
    private List<BObject> serviceContractImpls = new ArrayList<BObject>();

    public HttpService getServiceInfo(String basepath) {
        return this.servicesByBasePath.get(basepath);
    }

    public ServicesMapHolder getServicesMapHolder(String hostName) {
        return this.servicesMapByHost.get(hostName);
    }

    public Map<String, HttpService> getServicesByHost(String hostName) {
        return this.servicesMapByHost.get((Object)hostName).servicesByBasePath;
    }

    public List<String> getSortedServiceURIsByHost(String hostName) {
        return this.servicesMapByHost.get((Object)hostName).sortedServiceURIs;
    }

    public void registerService(BObject service, String basePathFromDeclaration) {
        Optional<ReferenceType> serviceContractType = HTTPServicesRegistry.getServiceContractType(service);
        if (serviceContractType.isPresent()) {
            this.serviceContractImpls.add(service);
            return;
        }
        HttpService httpService = serviceContractType.map(referenceType -> HttpServiceFromContract.buildHttpService(service, basePathFromDeclaration, referenceType)).orElseGet(() -> HttpService.buildHttpService(service, basePathFromDeclaration));
        this.registerBallerinaService(service, httpService);
    }

    public void registerServiceImplementedByContract(BObject service) {
        Optional<ReferenceType> serviceContractType = HTTPServicesRegistry.getServiceContractType(service);
        if (serviceContractType.isEmpty()) {
            return;
        }
        HttpService httpService = HttpServiceFromContract.buildHttpService(service, "/", serviceContractType.get());
        this.registerBallerinaService(service, httpService);
    }

    private void registerBallerinaService(BObject service, HttpService httpService) {
        String basePath = httpService.getBasePath();
        service.addNativeData("ABSOLUTE_RESOURCE_PATH", (Object)basePath);
        String hostName = httpService.getHostName();
        if (this.servicesMapByHost.get(hostName) == null) {
            this.servicesByBasePath = new ConcurrentHashMap<String, HttpService>();
            this.sortedServiceURIs = new CopyOnWriteArrayList<String>();
            this.servicesMapByHost.put(hostName, new ServicesMapHolder(this.servicesByBasePath, this.sortedServiceURIs));
        } else {
            this.servicesByBasePath = this.getServicesByHost(hostName);
            this.sortedServiceURIs = this.getSortedServiceURIsByHost(hostName);
        }
        if (this.servicesByBasePath.containsKey(basePath)) {
            Object errorMessage = hostName.equals("b7a.default") ? "'" : "' under host name : '" + hostName + "'";
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)("Service registration failed: two services have the same basePath : '" + basePath + (String)errorMessage)));
        }
        this.servicesByBasePath.put(basePath, httpService);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Service deployed : %s with context %s", TypeUtils.getType((Object)service).getName(), basePath));
        }
        this.sortedServiceURIs.add(basePath);
        this.sortedServiceURIs.sort((basePath1, basePath2) -> basePath2.length() - basePath1.length());
    }

    public List<BObject> getServiceContractImpls() {
        return this.serviceContractImpls;
    }

    private static Optional<ReferenceType> getServiceContractType(BObject service) {
        BMap serviceConfig = HttpService.getHttpServiceConfigAnnotation(service);
        if (!HttpUtil.checkConfigAnnotationAvailability(serviceConfig)) {
            return Optional.empty();
        }
        Object serviceType = serviceConfig.get((Object)SERVICE_TYPE);
        if (Objects.isNull(serviceType) || !(serviceType instanceof BTypedesc)) {
            return Optional.empty();
        }
        BTypedesc serviceTypeDesc = (BTypedesc)serviceType;
        Type serviceContractType = serviceTypeDesc.getDescribingType();
        if (Objects.isNull(serviceContractType) || !(serviceContractType instanceof ReferenceType)) {
            return Optional.empty();
        }
        ReferenceType serviceContractRefType = (ReferenceType)serviceContractType;
        return Optional.of(serviceContractRefType);
    }

    public String findTheMostSpecificBasePath(String requestURIPath, Map<String, HttpService> services, List<String> sortedServiceURIs) {
        for (String key : sortedServiceURIs) {
            if (!URIUtil.isPathMatch(requestURIPath, key.toString())) continue;
            return key.toString();
        }
        if (services.containsKey("/")) {
            return "/";
        }
        return null;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(Runtime runtime) {
        this.runtime = runtime;
    }

    public Map<String, ServicesMapHolder> getServicesMapByHost() {
        return this.servicesMapByHost;
    }

    public boolean isPossibleLastService() {
        return this.possibleLastService;
    }

    public void setPossibleLastService(boolean possibleLastService) {
        this.possibleLastService = possibleLastService;
    }

    public void unRegisterService(BObject service) {
        String basePath = (String)service.getNativeData("ABSOLUTE_RESOURCE_PATH");
        if (basePath == null) {
            logger.error("service is not attached to the listener");
            return;
        }
        HttpService httpService = HttpService.buildHttpService(service, basePath);
        String hostName = httpService.getHostName();
        ServicesMapHolder servicesMapHolder = this.servicesMapByHost.get(hostName);
        if (servicesMapHolder == null) {
            logger.error(basePath + " service is not attached to the listener");
            return;
        }
        this.servicesByBasePath = this.getServicesByHost(hostName);
        this.sortedServiceURIs = this.getSortedServiceURIsByHost(hostName);
        if (!this.servicesByBasePath.containsKey(basePath)) {
            logger.error(basePath + " service is not attached to the listener");
            return;
        }
        this.servicesByBasePath.remove(basePath);
        this.sortedServiceURIs.remove(basePath);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Service detached : %s with context %s", TypeUtils.getType((Object)service).getName(), basePath));
        }
        this.sortedServiceURIs.sort((basePath1, basePath2) -> basePath2.length() - basePath1.length());
    }

    protected static class ServicesMapHolder {
        private Map<String, HttpService> servicesByBasePath;
        private List<String> sortedServiceURIs;

        public ServicesMapHolder(Map<String, HttpService> servicesByBasePath, List<String> sortedServiceURIs) {
            this.servicesByBasePath = servicesByBasePath;
            this.sortedServiceURIs = sortedServiceURIs;
        }

        public Map<String, HttpService> getServicesByBasePath() {
            return this.servicesByBasePath;
        }
    }
}

