/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.client.actions;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.runtime.transactions.TransactionConstants;
import io.ballerina.runtime.transactions.TransactionLocalContext;
import io.ballerina.runtime.transactions.TransactionResourceManager;
import io.ballerina.stdlib.http.api.BallerinaConnectorException;
import io.ballerina.stdlib.http.api.CompressionConfigState;
import io.ballerina.stdlib.http.api.DataContext;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnector;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnectorListener;
import io.ballerina.stdlib.http.transport.contract.HttpResponseFuture;
import io.ballerina.stdlib.http.transport.contract.exceptions.ClientConnectorException;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.transport.message.HttpMessageDataStreamer;
import io.ballerina.stdlib.http.transport.message.PooledDataStreamerFactory;
import io.ballerina.stdlib.http.transport.message.ResponseHandle;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;
import io.ballerina.stdlib.mime.util.HeaderUtil;
import io.ballerina.stdlib.mime.util.MultipartDataSource;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHTTPAction {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHTTPAction.class);
    private static final String CACHE_BALLERINA_VERSION = System.getProperty("ballerina.version");
    private static final String WHITESPACE = " ";

    protected static HttpCarbonMessage createOutboundRequestMsg(String serviceUri, BMap config, String path, BObject request) {
        HttpCarbonMessage requestMsg = HttpUtil.getCarbonMsg(request, HttpUtil.createHttpCarbonMessage(true));
        HttpUtil.checkEntityAvailability(request);
        HttpUtil.enrichOutboundMessage(requestMsg, request);
        AbstractHTTPAction.prepareOutboundRequest(serviceUri, path, requestMsg, AbstractHTTPAction.isNoEntityBodyRequest(request), AbstractHTTPAction.isHostHeaderSet(request));
        AbstractHTTPAction.handleAcceptEncodingHeader(requestMsg, AbstractHTTPAction.getCompressionConfigFromEndpointConfig(config));
        return requestMsg;
    }

    static String getCompressionConfigFromEndpointConfig(BMap clientEndpointConfig) {
        return clientEndpointConfig.get((Object)HttpConstants.ANN_CONFIG_ATTR_COMPRESSION).toString();
    }

    static void handleAcceptEncodingHeader(HttpCarbonMessage outboundRequest, String compressionConfigValue) {
        CompressionConfigState compressionState = HttpUtil.getCompressionState(compressionConfigValue);
        if (compressionState == CompressionConfigState.ALWAYS && outboundRequest.getHeader(HttpHeaderNames.ACCEPT_ENCODING.toString()) == null) {
            outboundRequest.setHeader(HttpHeaderNames.ACCEPT_ENCODING.toString(), "deflate, gzip");
        } else if (compressionState == CompressionConfigState.NEVER && outboundRequest.getHeader(HttpHeaderNames.ACCEPT_ENCODING.toString()) != null) {
            outboundRequest.removeHeader(HttpHeaderNames.ACCEPT_ENCODING.toString());
        }
    }

    static void prepareOutboundRequest(String serviceUri, String path, HttpCarbonMessage outboundRequest, Boolean nonEntityBodyReq, Boolean isHostHeaderSet) {
        TransactionResourceManager trxResourceManager = TransactionResourceManager.getInstance();
        if (trxResourceManager.isInTransaction()) {
            TransactionLocalContext transactionLocalContext = trxResourceManager.getCurrentTransactionContext();
            outboundRequest.setHeader("x-b7a-xid", transactionLocalContext.getGlobalTransactionId());
            outboundRequest.setHeader("x-b7a-register-at", transactionLocalContext.getURL());
            outboundRequest.setHeader("x-b7a-info-record", AbstractHTTPAction.getTrxInfoRecordJson(transactionLocalContext.getInfoRecord()));
        }
        try {
            String uri = AbstractHTTPAction.getServiceUri(serviceUri) + path;
            URL url = new URL(AbstractHTTPAction.encodeWhitespacesInUri(uri));
            int port = AbstractHTTPAction.getOutboundReqPort(url);
            String host = url.getHost();
            AbstractHTTPAction.setOutboundReqProperties(outboundRequest, url, port, host, nonEntityBodyReq);
            AbstractHTTPAction.setOutboundReqHeaders(outboundRequest, port, host, isHostHeaderSet);
        }
        catch (MalformedURLException e) {
            throw HttpUtil.createHttpError("malformed URL specified. " + e.getMessage(), HttpErrorType.GENERIC_CLIENT_ERROR);
        }
        catch (Exception e) {
            throw HttpUtil.createHttpError("failed to prepare request. " + e.getMessage(), HttpErrorType.GENERIC_CLIENT_ERROR);
        }
    }

    private static String getServiceUri(String serviceUri) {
        if (serviceUri.isEmpty()) {
            throw HttpUtil.createHttpError("service URI is not defined correctly.", HttpErrorType.GENERIC_CLIENT_ERROR);
        }
        return serviceUri;
    }

    private static String encodeWhitespacesInUri(String uri) {
        if (!uri.contains(WHITESPACE)) {
            return uri;
        }
        return uri.trim().replaceAll(WHITESPACE, "%20");
    }

    private static void setOutboundReqHeaders(HttpCarbonMessage outboundRequest, int port, String host, Boolean isHostHeaderSet) {
        HttpHeaders headers = outboundRequest.getHeaders();
        AbstractHTTPAction.setHostHeader(host, port, headers, isHostHeaderSet);
        AbstractHTTPAction.setOutboundUserAgent(headers);
        AbstractHTTPAction.removeConnectionHeader(headers);
    }

    private static void setOutboundReqProperties(HttpCarbonMessage outboundRequest, URL url, int port, String host, Boolean nonEntityBodyReq) {
        outboundRequest.setProperty("host", host);
        outboundRequest.setProperty("port", port);
        String outboundReqPath = AbstractHTTPAction.getOutboundReqPath(url);
        outboundRequest.setProperty("TO", outboundReqPath);
        outboundRequest.setProperty("PROTOCOL", url.getProtocol());
        outboundRequest.setProperty("NO_ENTITY_BODY", nonEntityBodyReq);
    }

    private static String getTrxInfoRecordJson(Object infoRecord) {
        if (infoRecord != null) {
            ArrayType mapArrType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_MAP);
            BArray mapArr = ValueCreator.createArrayValue((ArrayType)mapArrType);
            return AbstractHTTPAction.populateTrxInfoJson((BMap<String, Object>)((BMap)infoRecord), mapArr, 0);
        }
        return "";
    }

    private static String populateTrxInfoJson(BMap<String, Object> infoMap, BArray jsonArray, int i) {
        Object prevInfoRecord;
        BMap subMap = ValueCreator.createMapValue();
        byte[] globalTransactionId = ((BArray)infoMap.get((Object)TransactionConstants.GLOBAL_TRX_ID)).getByteArray();
        int retryNumber = ((Number)infoMap.get((Object)TransactionConstants.RETRY_NUMBER)).intValue();
        int startTime = AbstractHTTPAction.getStartTime((BObject)infoMap.get((Object)TransactionConstants.START_TIME));
        subMap.put((Object)TransactionConstants.GLOBAL_TRX_ID, (Object)StringUtils.fromString((String)new String(globalTransactionId, StandardCharsets.UTF_8)));
        subMap.put((Object)TransactionConstants.RETRY_NUMBER, (Object)StringUtils.fromString((String)String.valueOf(retryNumber)));
        subMap.put((Object)TransactionConstants.START_TIME, (Object)StringUtils.fromString((String)String.valueOf(startTime)));
        jsonArray.add((long)i++, (Object)subMap);
        if (retryNumber > 0 && (prevInfoRecord = infoMap.get((Object)TransactionConstants.PREVIOUS_ATTEMPT)) != null) {
            AbstractHTTPAction.populateTrxInfoJson((BMap<String, Object>)((BMap)prevInfoRecord), jsonArray, i);
        }
        return StringUtils.getJsonString((Object)jsonArray);
    }

    private static int getStartTime(BObject timestamp) {
        if (timestamp != null) {
            return ((Number)timestamp.getNativeData("timeValue")).intValue();
        }
        return 0;
    }

    private static void setHostHeader(String host, int port, HttpHeaders headers, Boolean isHostHeaderSet) {
        if (isHostHeaderSet.booleanValue() && headers.contains((CharSequence)HttpHeaderNames.HOST)) {
            return;
        }
        if (port == 80 || port == 443) {
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)host);
        } else {
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)(host + ":" + port));
        }
    }

    private static void removeConnectionHeader(HttpHeaders headers) {
        if (headers.contains((CharSequence)HttpHeaderNames.CONNECTION)) {
            headers.remove((CharSequence)HttpHeaderNames.CONNECTION);
        }
    }

    private static void setOutboundUserAgent(HttpHeaders headers) {
        Object userAgent = CACHE_BALLERINA_VERSION != null ? "ballerina/" + CACHE_BALLERINA_VERSION : "ballerina";
        if (!headers.contains((CharSequence)HttpHeaderNames.USER_AGENT)) {
            headers.set((CharSequence)HttpHeaderNames.USER_AGENT, userAgent);
        }
    }

    private static String getOutboundReqPath(URL url) {
        Object toPath = url.getPath();
        String query = url.getQuery();
        if (query != null) {
            toPath = (String)toPath + "?" + query;
        }
        return toPath;
    }

    private static int getOutboundReqPort(URL url) {
        int port = 80;
        if (url.getPort() != -1) {
            port = url.getPort();
        } else if (url.getProtocol().equalsIgnoreCase("https")) {
            port = 443;
        }
        return port;
    }

    protected static void executeNonBlockingAction(DataContext dataContext, boolean async) {
        Object remoteAddress;
        Object poolableByteBufferFactory;
        HttpCarbonMessage outboundRequestMsg = dataContext.getOutboundRequest();
        AbstractHTTPAction.checkDirtiness(dataContext, outboundRequestMsg);
        Object sourceHandler = outboundRequestMsg.getProperty("SRC_HANDLER");
        if (sourceHandler == null) {
            outboundRequestMsg.setProperty("SRC_HANDLER", dataContext.getEnvironment().getStrandLocal("SRC_HANDLER"));
        }
        if ((poolableByteBufferFactory = outboundRequestMsg.getProperty("POOLED_BYTE_BUFFER_FACTORY")) == null) {
            outboundRequestMsg.setProperty("POOLED_BYTE_BUFFER_FACTORY", dataContext.getEnvironment().getStrandLocal("POOLED_BYTE_BUFFER_FACTORY"));
        }
        if ((remoteAddress = outboundRequestMsg.getProperty("REMOTE_ADDRESS")) == null) {
            outboundRequestMsg.setProperty("REMOTE_ADDRESS", dataContext.getEnvironment().getStrandLocal("REMOTE_ADDRESS"));
        }
        outboundRequestMsg.setProperty("ORIGIN_HOST", dataContext.getEnvironment().getStrandLocal("ORIGIN_HOST"));
        outboundRequestMsg.setProperty("INBOUND_MESSAGE", dataContext.getEnvironment().getStrandLocal("INBOUND_MESSAGE"));
        AbstractHTTPAction.sendOutboundRequest(dataContext, outboundRequestMsg, async);
    }

    private static void checkDirtiness(DataContext dataContext, HttpCarbonMessage outboundRequestMsg) {
        BObject requestObj = dataContext.getRequestObj();
        String contentType = HttpUtil.getContentTypeFromTransportMessage(outboundRequestMsg);
        outboundRequestMsg.setIoException(null);
        if (requestObj != null) {
            if (AbstractHTTPAction.dirty(requestObj)) {
                AbstractHTTPAction.cleanOutboundReq(outboundRequestMsg, requestObj, contentType);
            } else {
                requestObj.set(HttpConstants.REQUEST_REUSE_STATUS_FIELD, (Object)true);
            }
        }
    }

    private static void cleanOutboundReq(HttpCarbonMessage outboundRequestMsg, BObject request, String contentType) {
        BObject entity = HttpUtil.extractEntity(request);
        if (entity != null) {
            Object messageDataSource = EntityBodyHandler.getMessageDataSource((BObject)entity);
            if (messageDataSource == null && EntityBodyHandler.getByteChannel((BObject)entity) == null && !HeaderUtil.isMultipart((String)contentType)) {
                outboundRequestMsg.addHttpContent((HttpContent)new DefaultLastHttpContent());
            } else {
                outboundRequestMsg.waitAndReleaseAllEntities();
            }
        } else {
            outboundRequestMsg.addHttpContent((HttpContent)new DefaultLastHttpContent());
        }
    }

    static boolean isNoEntityBodyRequest(BObject request) {
        return (Boolean)request.get(HttpConstants.REQUEST_NO_ENTITY_BODY_FIELD);
    }

    static boolean isHostHeaderSet(BObject request) {
        return Objects.nonNull(request.getNativeData("set_host_header"));
    }

    private static boolean dirty(BObject request) {
        return (Boolean)request.get(HttpConstants.REQUEST_REUSE_STATUS_FIELD);
    }

    private static void sendOutboundRequest(DataContext dataContext, HttpCarbonMessage outboundRequestMsg, boolean async) {
        try {
            AbstractHTTPAction.send(dataContext, outboundRequestMsg, async);
        }
        catch (BallerinaConnectorException e) {
            dataContext.notifyInboundResponseStatus(null, HttpUtil.createHttpError(e.getMessage()));
        }
        catch (Exception e) {
            BallerinaConnectorException exception = new BallerinaConnectorException("Failed to send outboundRequestMsg to the backend", e);
            dataContext.notifyInboundResponseStatus(null, HttpUtil.getError(exception));
        }
    }

    private static void send(DataContext dataContext, HttpCarbonMessage outboundRequestMsg, boolean async) {
        HttpClientConnector clientConnector = dataContext.getClientConnector();
        String contentType = HttpUtil.getContentTypeFromTransportMessage(outboundRequestMsg);
        String boundaryString = null;
        if (HeaderUtil.isMultipart((String)contentType)) {
            boundaryString = HttpUtil.addBoundaryIfNotExist(outboundRequestMsg, contentType);
        }
        HttpUtil.checkAndObserveHttpRequest(dataContext.getEnvironment(), outboundRequestMsg);
        HTTPClientConnectorListener httpClientConnectorLister = ObserveUtils.isObservabilityEnabled() ? new ObservableHttpClientConnectorListener(dataContext) : new HTTPClientConnectorListener(dataContext);
        HttpMessageDataStreamer outboundMsgDataStreamer = AbstractHTTPAction.getHttpMessageDataStreamer(outboundRequestMsg);
        OutputStream messageOutputStream = outboundMsgDataStreamer.getOutputStream();
        BObject requestObj = dataContext.getRequestObj();
        BObject entityObj = null;
        if (requestObj != null && (entityObj = HttpUtil.extractEntity(requestObj)) == null) {
            outboundRequestMsg.setPassthrough(true);
        }
        HttpResponseFuture future = clientConnector.send(outboundRequestMsg);
        if (async) {
            future.setResponseHandleListener(httpClientConnectorLister);
        } else {
            future.setHttpConnectorListener(httpClientConnectorLister);
        }
        try {
            if (entityObj != null) {
                if (boundaryString != null) {
                    AbstractHTTPAction.serializeMultiparts(dataContext.getEnvironment(), entityObj, messageOutputStream, boundaryString);
                } else {
                    AbstractHTTPAction.serializeDataSource(dataContext.getEnvironment(), entityObj, messageOutputStream);
                }
            }
        }
        catch (EncoderException | IOException serializerException) {
            logger.warn("couldn't serialize the message", serializerException);
        }
        catch (RuntimeException exception) {
            if (exception.getMessage() != null && exception.getMessage().contains("Inbound response message already received")) {
                logger.warn("Response already received before completing the outbound request", (Throwable)exception);
            }
            throw HttpUtil.createHttpError(exception.getMessage(), HttpErrorType.GENERIC_CLIENT_ERROR);
        }
    }

    private static HttpMessageDataStreamer getHttpMessageDataStreamer(HttpCarbonMessage outboundRequestMsg) {
        PooledDataStreamerFactory pooledDataStreamerFactory = (PooledDataStreamerFactory)outboundRequestMsg.getProperty("POOLED_BYTE_BUFFER_FACTORY");
        HttpMessageDataStreamer outboundMsgDataStreamer = pooledDataStreamerFactory != null ? pooledDataStreamerFactory.createHttpDataStreamer(outboundRequestMsg) : new HttpMessageDataStreamer(outboundRequestMsg);
        return outboundMsgDataStreamer;
    }

    private static void serializeMultiparts(Environment env, BObject entityObj, OutputStream messageOutputStream, String boundaryString) throws IOException {
        BArray bodyParts = EntityBodyHandler.getBodyPartArray((BObject)entityObj);
        if (bodyParts != null && bodyParts.size() > 0) {
            AbstractHTTPAction.serializeMultipartDataSource(env, messageOutputStream, boundaryString, entityObj);
        } else {
            AbstractHTTPAction.serializeDataSource(env, entityObj, messageOutputStream);
        }
    }

    private static void serializeMultipartDataSource(Environment env, OutputStream messageOutputStream, String boundaryString, BObject entityObj) {
        MultipartDataSource multipartDataSource = new MultipartDataSource(env, entityObj, boundaryString);
        multipartDataSource.serialize(messageOutputStream);
        HttpUtil.closeMessageOutputStream(messageOutputStream);
    }

    private static void serializeDataSource(Environment env, BObject entityObj, OutputStream messageOutputStream) throws IOException {
        Object messageDataSource = EntityBodyHandler.getMessageDataSource((BObject)entityObj);
        if (messageDataSource != null) {
            HttpUtil.serializeDataSource(messageDataSource, entityObj, messageOutputStream);
            HttpUtil.closeMessageOutputStream(messageOutputStream);
        } else if (EntityBodyHandler.getByteStream((BObject)entityObj) != null) {
            EntityBodyHandler.writeByteStreamToOutputStream((Environment)env, (BObject)entityObj, (OutputStream)messageOutputStream);
            HttpUtil.closeMessageOutputStream(messageOutputStream);
        } else if (EntityBodyHandler.getByteChannel((BObject)entityObj) != null) {
            EntityBodyHandler.writeByteChannelToOutputStream((BObject)entityObj, (OutputStream)messageOutputStream);
            HttpUtil.closeMessageOutputStream(messageOutputStream);
        } else {
            logger.debug("Entity does not have a serializable payload");
        }
    }

    private static class ObservableHttpClientConnectorListener
    extends HTTPClientConnectorListener {
        private final DataContext context;

        private ObservableHttpClientConnectorListener(DataContext dataContext) {
            super(dataContext);
            this.context = dataContext;
        }

        @Override
        public void onMessage(HttpCarbonMessage httpCarbonMessage) {
            int statusCode = httpCarbonMessage.getHttpStatusCode();
            this.addHttpStatusCode(statusCode);
            super.onMessage(httpCarbonMessage);
        }

        @Override
        public void onError(Throwable throwable) {
            if (throwable instanceof ClientConnectorException) {
                ClientConnectorException clientConnectorException = (ClientConnectorException)throwable;
                this.addHttpStatusCode(clientConnectorException.getHttpStatusCode());
                ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Environment)this.context.getEnvironment());
                if (observerContext != null) {
                    observerContext.addTag("error", "true");
                }
            }
            super.onError(throwable);
        }

        private void addHttpStatusCode(int statusCode) {
            ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Environment)this.context.getEnvironment());
            if (observerContext != null) {
                observerContext.addProperty("_http_status_code_", (Object)statusCode);
            }
        }
    }

    private static class HTTPClientConnectorListener
    implements HttpClientConnectorListener {
        private final DataContext dataContext;

        private HTTPClientConnectorListener(DataContext dataContext) {
            this.dataContext = dataContext;
        }

        @Override
        public void onMessage(HttpCarbonMessage inboundResponseMessage) {
            this.dataContext.notifyInboundResponseStatus(HttpUtil.createResponseStruct(inboundResponseMessage), null);
        }

        @Override
        public void onResponseHandle(ResponseHandle responseHandle) {
            BObject httpFuture = ValueCreator.createObjectValue((Module)ModuleUtils.getHttpPackage(), (String)"HttpFuture", (Object[])new Object[0]);
            httpFuture.addNativeData("transport_handle", (Object)responseHandle);
            this.dataContext.notifyInboundResponseStatus(httpFuture, null);
        }

        @Override
        public void onError(Throwable throwable) {
            BError httpConnectorError;
            if (throwable instanceof ClientConnectorException) {
                httpConnectorError = HttpUtil.createHttpError(throwable);
            } else if (throwable instanceof IOException) {
                this.dataContext.getOutboundRequest().setIoException((IOException)throwable);
                httpConnectorError = HttpUtil.createHttpError(throwable);
            } else {
                this.dataContext.getOutboundRequest().setIoException(new IOException(throwable.getMessage(), throwable));
                httpConnectorError = HttpUtil.createHttpError(throwable);
            }
            this.dataContext.notifyInboundResponseStatus(null, httpConnectorError);
        }
    }
}

