/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.client.actions;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.DataContext;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.client.actions.AbstractHTTPAction;
import io.ballerina.stdlib.http.api.nativeimpl.ExternUtils;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnector;
import io.ballerina.stdlib.http.transport.contract.HttpConnectorListener;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.transport.message.ResponseHandle;
import java.util.concurrent.CompletableFuture;

public class GetResponse
extends AbstractHTTPAction {
    public static Object getResponse(Environment env, BObject clientObj, BObject handleObj) {
        HttpClientConnector clientConnector = (HttpClientConnector)clientObj.getNativeData("Client");
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            DataContext dataContext = new DataContext(env, balFuture, clientConnector, handleObj, null);
            ResponseHandle responseHandle = (ResponseHandle)handleObj.getNativeData("transport_handle");
            if (responseHandle == null) {
                throw HttpUtil.createHttpError("invalid http handle");
            }
            clientConnector.getResponse(responseHandle).setHttpConnectorListener(new ResponseListener(dataContext));
            return ExternUtils.getResult(balFuture);
        });
    }

    private GetResponse() {
    }

    private static class ResponseListener
    implements HttpConnectorListener {
        private DataContext dataContext;

        ResponseListener(DataContext dataContext) {
            this.dataContext = dataContext;
        }

        @Override
        public void onMessage(HttpCarbonMessage httpCarbonMessage) {
            this.dataContext.notifyInboundResponseStatus(HttpUtil.createResponseStruct(httpCarbonMessage), null);
        }

        @Override
        public void onError(Throwable throwable) {
            BError httpConnectorError = HttpUtil.createHttpError(throwable.getMessage());
            this.dataContext.notifyInboundResponseStatus(null, httpConnectorError);
        }
    }
}

