/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.client.caching;

import java.util.Locale;

public enum CacheControlDirective {
    MUST_REVALIDATE("must-revalidate"),
    NO_CACHE("no-cache"),
    NO_STORE("no-store"),
    NO_TRANSFORM("no-transform"),
    PRIVATE("private"),
    PUBLIC("public"),
    PROXY_REVALIDATE("proxy-revalidate"),
    MAX_AGE("max-age"),
    S_MAXAGE("s-maxage"),
    INVALID("invalid"),
    ONLY_IF_CACHED("only-if-cached"),
    MAX_STALE("max-stale"),
    MIN_FRESH("min-fresh");

    private String directiveValue;

    private CacheControlDirective(String directiveValue) {
        this.directiveValue = directiveValue;
    }

    public String value() {
        return this.directiveValue;
    }

    public static CacheControlDirective parseValue(String directive) {
        try {
            return CacheControlDirective.valueOf(directive.toUpperCase(Locale.ENGLISH).replace('-', '_'));
        }
        catch (Exception e) {
            return INVALID;
        }
    }
}

