/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.nativeimpl;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;

public class ExternFormatter {
    private static final String RFC_1123_DATE_TIME = "RFC_1123_DATE_TIME";

    public static Object utcFromString(BString inputString, BString pattern) {
        try {
            Instant instant;
            if (RFC_1123_DATE_TIME.equals(pattern.getValue())) {
                instant = Instant.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(inputString.getValue()));
            } else {
                Date formatter = new SimpleDateFormat(pattern.getValue()).parse(inputString.getValue());
                instant = formatter.toInstant();
            }
            long secondsFromEpoc = instant.getEpochSecond();
            BigDecimal lastSecondFraction = new BigDecimal(instant.getNano()).divide(new BigDecimal(1000000000), MathContext.DECIMAL128).setScale(9, RoundingMode.HALF_UP);
            BArray utcTuple = ValueCreator.createTupleValue((TupleType)TypeCreator.createTupleType(Arrays.asList(PredefinedTypes.TYPE_INT, PredefinedTypes.TYPE_DECIMAL)));
            utcTuple.add(0L, secondsFromEpoc);
            utcTuple.add(1L, (Object)ValueCreator.createDecimalValue((BigDecimal)lastSecondFraction));
            utcTuple.freezeDirect();
            return utcTuple;
        }
        catch (Exception e) {
            return HttpUtil.createHttpError("failed parsing: " + e.getMessage(), HttpErrorType.GENERIC_LISTENER_ERROR);
        }
    }

    public static Object utcToString(BArray utc, BString pattern) {
        try {
            long secondsFromEpoc = 0L;
            BigDecimal lastSecondFraction = new BigDecimal(0);
            if (utc.getLength() == 2L) {
                secondsFromEpoc = utc.getInt(0L);
                lastSecondFraction = new BigDecimal(utc.getValues()[1].toString()).multiply(new BigDecimal(1000000000));
            } else if (utc.getLength() == 1L) {
                secondsFromEpoc = utc.getInt(0L);
            }
            Instant instant = Instant.ofEpochSecond(secondsFromEpoc, lastSecondFraction.intValue());
            ZonedDateTime zonedDateTime = instant.atZone(ZoneId.of("Z"));
            DateTimeFormatter dateTimeFormatter = RFC_1123_DATE_TIME.equals(pattern.getValue()) ? DateTimeFormatter.RFC_1123_DATE_TIME : DateTimeFormatter.ofPattern(pattern.getValue());
            return StringUtils.fromString((String)zonedDateTime.format(dateTimeFormatter));
        }
        catch (Exception e) {
            return HttpUtil.createHttpError("failed formatting: " + e.getMessage(), HttpErrorType.GENERIC_LISTENER_ERROR);
        }
    }

    private ExternFormatter() {
    }
}

