/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature.builder;

import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.service.signature.builder.AbstractPayloadBuilder;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;
import java.util.Arrays;
import java.util.List;

public class XmlPayloadBuilder
extends AbstractPayloadBuilder {
    private final Type payloadType;
    private static final List<Integer> allowedList = Arrays.asList(16, 18, 20, 19, 21);

    public XmlPayloadBuilder(Type payloadType) {
        this.payloadType = payloadType;
    }

    @Override
    public Object getValue(BObject entity, boolean readonly) {
        if (allowedList.stream().anyMatch(allowedTag -> XmlPayloadBuilder.isSubtypeOfAllowedType(this.payloadType, allowedTag))) {
            BXml bxml = EntityBodyHandler.constructXmlDataSource((BObject)entity);
            EntityBodyHandler.addMessageDataSource((BObject)entity, (Object)bxml);
            if (readonly) {
                bxml.freezeDirect();
            }
            return bxml;
        }
        String message = "incompatible type found: '" + this.payloadType.toString() + "'";
        throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_PAYLOAD_BINDING_LISTENER_ERROR, message);
    }
}

