/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.crl;

import io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.CertificateVerificationException;
import io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.RevocationStatus;
import io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.RevocationVerifier;
import io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.crl.CRLCache;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLVerifier
implements RevocationVerifier {
    private CRLCache cache;
    private static final Logger LOG = LoggerFactory.getLogger(CRLVerifier.class);

    public CRLVerifier(CRLCache cache) {
        this.cache = cache;
    }

    @Override
    public RevocationStatus checkRevocationStatus(X509Certificate peerCert, X509Certificate issuerCert) throws CertificateVerificationException {
        List<String> list = this.getCrlDistributionPoints(peerCert);
        for (String crlUrl : list) {
            X509CRL x509CRL;
            if (LOG.isInfoEnabled()) {
                LOG.info("Trying to get CRL for URL: {}", (Object)crlUrl);
            }
            if (this.cache != null && (x509CRL = this.cache.getCacheValue(crlUrl)) != null) {
                RevocationStatus status = this.getRevocationStatus(x509CRL, peerCert);
                if (LOG.isInfoEnabled()) {
                    LOG.info("CRL taken from cache.");
                }
                return status;
            }
            try {
                x509CRL = this.downloadCRLFromWeb(crlUrl);
                if (x509CRL == null) continue;
                if (this.cache != null) {
                    this.cache.setCacheValue(crlUrl, x509CRL);
                }
                return this.getRevocationStatus(x509CRL, peerCert);
            }
            catch (IOException e) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("Either URL is bad or can't build X509CRL. So check with the next url in the list.", (Throwable)e);
            }
        }
        throw new CertificateVerificationException("Cannot check revocation status with the certificate");
    }

    private RevocationStatus getRevocationStatus(X509CRL x509CRL, X509Certificate peerCert) {
        if (x509CRL.isRevoked(peerCert)) {
            return RevocationStatus.REVOKED;
        }
        return RevocationStatus.GOOD;
    }

    protected X509CRL downloadCRLFromWeb(String crlURL) throws IOException, CertificateVerificationException {
        X509CRL x509CRL;
        block11: {
            URL url = new URL(crlURL);
            InputStream crlStream = url.openStream();
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                x509CRL = (X509CRL)cf.generateCRL(crlStream);
                if (crlStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (crlStream != null) {
                        try {
                            crlStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedURLException e) {
                    throw new CertificateVerificationException("CRL URL is malformed", e);
                }
                catch (IOException e) {
                    throw new CertificateVerificationException("Cant reach URI: " + crlURL + " - only support HTTP", e);
                }
                catch (CertificateException e) {
                    throw new CertificateVerificationException(e);
                }
                catch (CRLException e) {
                    throw new CertificateVerificationException("Cannot generate X509CRL from the stream data", e);
                }
            }
            crlStream.close();
        }
        return x509CRL;
    }

    private List<String> getCrlDistributionPoints(X509Certificate cert) throws CertificateVerificationException {
        CRLDistPoint distPoint;
        byte[] crlDPExtensionValue = cert.getExtensionValue(Extension.cRLDistributionPoints.getId());
        if (crlDPExtensionValue == null) {
            throw new CertificateVerificationException("Certificate doesn't have CRL distribution points");
        }
        ASN1InputStream asn1In = new ASN1InputStream(crlDPExtensionValue);
        try {
            DEROctetString crlDEROctetString = (DEROctetString)asn1In.readObject();
            distPoint = this.getOctetInputStream(crlDEROctetString);
        }
        catch (IOException e) {
            throw new CertificateVerificationException("Cannot read certificate to get CRL URLs", e);
        }
        finally {
            try {
                asn1In.close();
            }
            catch (IOException e) {
                LOG.error("Cannot close input stream", (Throwable)e);
            }
        }
        ArrayList<String> crlUrls = new ArrayList<String>();
        for (DistributionPoint dp : distPoint.getDistributionPoints()) {
            GeneralName[] genNames;
            DistributionPointName dpn = dp.getDistributionPoint();
            if (dpn == null || dpn.getType() != 0) continue;
            for (GeneralName genName : genNames = GeneralNames.getInstance((Object)dpn.getName()).getNames()) {
                if (genName.getTagNo() != 6) continue;
                String url = DERIA5String.getInstance((Object)genName.getName()).getString().trim();
                crlUrls.add(url);
            }
        }
        if (crlUrls.isEmpty()) {
            throw new CertificateVerificationException("Cant get CRL urls from certificate");
        }
        return crlUrls;
    }

    private CRLDistPoint getOctetInputStream(DEROctetString crlDEROctetString) throws CertificateVerificationException {
        CRLDistPoint cRLDistPoint;
        ASN1InputStream asn1InOctets = new ASN1InputStream(crlDEROctetString.getOctets());
        try {
            ASN1Primitive crlDERObject = asn1InOctets.readObject();
            cRLDistPoint = CRLDistPoint.getInstance((Object)crlDERObject);
        }
        catch (Throwable throwable) {
            try {
                try {
                    asn1InOctets.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new CertificateVerificationException("Cannot read certificate to get CRL URLs", e);
            }
        }
        asn1InOctets.close();
        return cRLDistPoint;
    }
}

