/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener;

import io.ballerina.stdlib.http.transport.contract.ServerConnector;
import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.config.ChunkConfig;
import io.ballerina.stdlib.http.transport.contract.config.InboundMsgSizeValidationConfig;
import io.ballerina.stdlib.http.transport.contract.config.KeepAliveConfig;
import io.ballerina.stdlib.http.transport.contract.config.ServerBootstrapConfiguration;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.HttpWsServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.ssl.SSLConfig;
import io.ballerina.stdlib.http.transport.contractimpl.common.ssl.SSLHandlerFactory;
import io.ballerina.stdlib.http.transport.contractimpl.listener.HttpServerChannelInitializer;
import io.ballerina.stdlib.http.transport.internal.HandlerExecutor;
import io.ballerina.stdlib.http.transport.internal.HttpTransportContextHolder;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnectorBootstrap {
    private static final Logger LOG = LoggerFactory.getLogger(ServerConnectorBootstrap.class);
    private ServerBootstrap serverBootstrap;
    private HttpServerChannelInitializer httpServerChannelInitializer;
    private boolean initialized;
    private boolean isHttps = false;
    private ChannelGroup allChannels;
    private final ChannelGroup listenerChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private int gracefulStopTimeout = 0;

    public ServerConnectorBootstrap(ChannelGroup allChannels) {
        this.serverBootstrap = new ServerBootstrap();
        this.httpServerChannelInitializer = new HttpServerChannelInitializer();
        this.httpServerChannelInitializer.setAllChannels(allChannels, this.listenerChannels);
        this.serverBootstrap.childHandler((ChannelHandler)this.httpServerChannelInitializer);
        HttpTransportContextHolder.getInstance().setHandlerExecutor(new HandlerExecutor());
        this.initialized = true;
        this.allChannels = allChannels;
    }

    public ServerConnector getServerConnector(String host, int port) {
        String serverConnectorId = Util.createServerConnectorID(host, port);
        return new HttpServerConnector(serverConnectorId, host, port);
    }

    public void addSocketConfiguration(ServerBootstrapConfiguration serverBootstrapConfiguration) {
        this.serverBootstrap.option(ChannelOption.SO_BACKLOG, (Object)serverBootstrapConfiguration.getSoBackLog());
        this.serverBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)serverBootstrapConfiguration.getConnectTimeOut());
        this.serverBootstrap.option(ChannelOption.SO_RCVBUF, (Object)serverBootstrapConfiguration.getReceiveBufferSize());
        this.serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)serverBootstrapConfiguration.isTcpNoDelay());
        this.serverBootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)serverBootstrapConfiguration.getReceiveBufferSize());
        this.serverBootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)serverBootstrapConfiguration.getSendBufferSize());
        this.serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)serverBootstrapConfiguration.isKeepAlive());
        this.serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)serverBootstrapConfiguration.isSocketReuse());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Netty Server Socket BACKLOG %d", serverBootstrapConfiguration.getSoBackLog()));
            LOG.debug(String.format("Netty Server Socket TCP_NODELAY %s", serverBootstrapConfiguration.isTcpNoDelay()));
            LOG.debug(String.format("Netty Server Socket CONNECT_TIMEOUT_MILLIS %d", serverBootstrapConfiguration.getConnectTimeOut()));
            LOG.debug(String.format("Netty Server Socket SO_RCVBUF %d", serverBootstrapConfiguration.getReceiveBufferSize()));
            LOG.debug(String.format("Netty Server Socket SO_SNDBUF %d", serverBootstrapConfiguration.getSendBufferSize()));
        }
    }

    public void addSecurity(SSLConfig sslConfig) {
        if (sslConfig != null) {
            this.httpServerChannelInitializer.setSslConfig(sslConfig);
            this.isHttps = true;
        }
    }

    public void addIdleTimeout(long socketIdleTimeout) {
        this.httpServerChannelInitializer.setIdleTimeout(socketIdleTimeout);
    }

    public void setHttp2Enabled(boolean isHttp2Enabled) {
        this.httpServerChannelInitializer.setHttp2Enabled(isHttp2Enabled);
    }

    public void addThreadPools(EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        this.serverBootstrap.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class);
    }

    public void addHttpTraceLogHandler(Boolean isHttpTraceLogEnabled) {
        this.httpServerChannelInitializer.setHttpTraceLogEnabled(isHttpTraceLogEnabled);
    }

    public void addHttpAccessLogHandler(Boolean isHttpAccessLogEnabled) {
        this.httpServerChannelInitializer.setHttpAccessLogEnabled(isHttpAccessLogEnabled);
    }

    public void addSslHandlerFactory(SSLHandlerFactory sslHandlerFactory) {
        this.httpServerChannelInitializer.setSslHandlerFactory(sslHandlerFactory);
    }

    public void addKeystoreSslContext(SSLContext sslContext) {
        this.httpServerChannelInitializer.setKeystoreSslContext(sslContext);
    }

    public void addHttp2SslContext(SslContext sslContext) {
        this.httpServerChannelInitializer.setHttp2SslContext(sslContext);
    }

    public void addCertAndKeySslContext(SslContext sslContext) {
        this.httpServerChannelInitializer.setCertandKeySslContext(sslContext);
    }

    public void addHeaderAndEntitySizeValidation(InboundMsgSizeValidationConfig requestSizeValidationConfig) {
        this.httpServerChannelInitializer.setReqSizeValidationConfig(requestSizeValidationConfig);
    }

    public void addcertificateRevocationVerifier(Boolean validateCertEnabled) {
        this.httpServerChannelInitializer.setValidateCertEnabled(validateCertEnabled);
    }

    public void addCacheDelay(int cacheDelay) {
        this.httpServerChannelInitializer.setCacheDelay(cacheDelay);
    }

    public void addCacheSize(int cacheSize) {
        this.httpServerChannelInitializer.setCacheSize(cacheSize);
    }

    public void addOcspStapling(boolean ocspStapling) {
        this.httpServerChannelInitializer.setOcspStaplingEnabled(ocspStapling);
    }

    public void addChunkingBehaviour(ChunkConfig chunkConfig) {
        this.httpServerChannelInitializer.setChunkingConfig(chunkConfig);
    }

    public void addKeepAliveBehaviour(KeepAliveConfig keepAliveConfig) {
        this.httpServerChannelInitializer.setKeepAliveConfig(keepAliveConfig);
    }

    public void addServerHeader(String serverName) {
        this.httpServerChannelInitializer.setServerName(serverName);
    }

    public void setPipeliningEnabled(boolean pipeliningEnabled) {
        this.httpServerChannelInitializer.setPipeliningEnabled(pipeliningEnabled);
    }

    public void setPipeliningLimit(long pipeliningLimit) {
        this.httpServerChannelInitializer.setPipeliningLimit(pipeliningLimit);
    }

    public void setPipeliningThreadGroup(EventExecutorGroup pipeliningGroup) {
        this.httpServerChannelInitializer.setPipeliningThreadGroup(pipeliningGroup);
    }

    public void setWebSocketCompressionEnabled(boolean webSocketCompressionEnabled) {
        this.httpServerChannelInitializer.setWebSocketCompressionEnabled(webSocketCompressionEnabled);
    }

    public void setHttp2InitialWindowSize(int http2InitialWindowSize) {
        this.httpServerChannelInitializer.setHttp2InitialWindowSize(http2InitialWindowSize);
    }

    public void setTimeBetweenStaleEviction(long timeBetweenStaleEviction) {
        this.httpServerChannelInitializer.setTimeBetweenStaleEviction(timeBetweenStaleEviction);
    }

    public void setMinIdleTimeInStaleState(long minIdleTimeInStaleState) {
        this.httpServerChannelInitializer.setMinIdleTimeInStaleState(minIdleTimeInStaleState);
    }

    public ChannelGroup getListenerChannels() {
        return this.listenerChannels;
    }

    public void setGracefulStopTimeout(int gracefulStopTimeout) {
        this.gracefulStopTimeout = gracefulStopTimeout;
    }

    class HttpServerConnector
    implements ServerConnector {
        private final Logger log = LoggerFactory.getLogger(HttpServerConnector.class);
        private ServerConnectorFuture serverConnectorFuture;
        private String host;
        private int port;
        private String connectorID;
        private Channel serverChannel;

        HttpServerConnector(String id, String host, int port) {
            this.host = host;
            this.port = port;
            this.connectorID = id;
            ServerConnectorBootstrap.this.httpServerChannelInitializer.setInterfaceId(id);
        }

        @Override
        public ServerConnectorFuture start() {
            ChannelFuture channelFuture = this.bindInterface();
            if (Objects.nonNull(channelFuture)) {
                this.serverChannel = channelFuture.channel();
            }
            this.serverConnectorFuture = new HttpWsServerConnectorFuture(channelFuture, ServerConnectorBootstrap.this.allChannels);
            channelFuture.addListener(future -> {
                if (future.isSuccess()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("HTTP(S) Interface starting on host {} and port {}", (Object)this.getHost(), (Object)this.getPort());
                    }
                    this.serverConnectorFuture.notifyPortBindingEvent(this.connectorID, ServerConnectorBootstrap.this.isHttps);
                } else {
                    this.serverConnectorFuture.notifyPortBindingError(future.cause());
                }
            });
            ServerConnectorBootstrap.this.httpServerChannelInitializer.setServerConnectorFuture(this.serverConnectorFuture);
            return this.serverConnectorFuture;
        }

        @Override
        public boolean stop() {
            boolean connectorStopped = false;
            try {
                connectorStopped = this.unBindInterface();
                if (connectorStopped) {
                    this.serverConnectorFuture.notifyPortUnbindingEvent(this.connectorID, ServerConnectorBootstrap.this.isHttps);
                }
            }
            catch (InterruptedException e) {
                this.log.error("Couldn't close the port", (Throwable)e);
                return false;
            }
            catch (ServerConnectorException e) {
                this.log.error("Error in notifying life cycle event listener", (Throwable)e);
            }
            return connectorStopped;
        }

        @Override
        public boolean immediateStop() {
            ServerConnectorBootstrap.this.setGracefulStopTimeout(0);
            return this.stop();
        }

        @Override
        public String getConnectorID() {
            return this.connectorID;
        }

        private Channel getServerChannel() {
            return this.serverChannel;
        }

        public String toString() {
            return this.host + "-" + this.port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        private ChannelFuture bindInterface() {
            if (!ServerConnectorBootstrap.this.initialized) {
                this.log.error("ServerConnectorBootstrap is not initialized");
                return null;
            }
            return ServerConnectorBootstrap.this.serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.getHost(), this.getPort()));
        }

        private boolean unBindInterface() throws InterruptedException {
            if (!ServerConnectorBootstrap.this.initialized) {
                this.log.error("ServerConnectorBootstrap is not initialized");
                return false;
            }
            Channel listenerChannel = this.getServerChannel();
            if (listenerChannel != null) {
                try {
                    listenerChannel.close().sync();
                    try {
                        Thread.sleep(ServerConnectorBootstrap.this.gracefulStopTimeout);
                    }
                    catch (InterruptedException e) {
                        this.log.warn("Couldn't complete the graceful time period");
                    }
                    ServerConnectorBootstrap.this.getListenerChannels().close().sync();
                }
                catch (InterruptedException e) {
                    this.log.error("Failed to shutdown the listener", (Throwable)e);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("HttpConnectorListener stopped listening on host {} and port {}", (Object)this.getHost(), (Object)this.getPort());
                }
                return true;
            }
            return false;
        }
    }
}

