/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender.states;

import io.ballerina.stdlib.http.api.logging.accesslog.SenderHttpAccessLogger;
import io.ballerina.stdlib.http.transport.contract.HttpResponseFuture;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.SenderReqRespStateManager;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.sender.TargetHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.EntityBodyReceived;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.SenderState;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingEntityBody
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(ReceivingEntityBody.class);
    private final SenderReqRespStateManager senderReqRespStateManager;
    private final TargetHandler targetHandler;
    private SenderHttpAccessLogger accessLogger;

    ReceivingEntityBody(SenderReqRespStateManager senderReqRespStateManager, TargetHandler targetHandler) {
        this.senderReqRespStateManager = senderReqRespStateManager;
        this.targetHandler = targetHandler;
        if (targetHandler.getHttpClientChannelInitializer().isHttpAccessLogEnabled()) {
            this.accessLogger = new SenderHttpAccessLogger(targetHandler.getTargetChannel().getChannel().remoteAddress());
        }
    }

    @Override
    public void writeOutboundRequestHeaders(HttpCarbonMessage httpOutboundRequest) {
        LOG.warn("writeOutboundRequestHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void writeOutboundRequestEntity(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) {
        LOG.warn("writeOutboundRequestEntity {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void readInboundResponseHeaders(TargetHandler targetHandler, HttpResponse httpInboundResponse) {
        LOG.warn("readInboundResponseHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void readInboundResponseEntityBody(ChannelHandlerContext ctx, HttpContent httpContent, HttpCarbonMessage inboundResponseMsg) throws Exception {
        if (httpContent instanceof LastHttpContent) {
            StateUtil.setInboundTrailersToNewMessage(((LastHttpContent)httpContent).trailingHeaders(), inboundResponseMsg);
            this.addHttpContent(inboundResponseMsg, httpContent);
            inboundResponseMsg.setLastHttpContentArrived();
            this.targetHandler.resetInboundMsg();
            Util.safelyRemoveHandlers(this.targetHandler.getTargetChannel().getChannel().pipeline(), "idleStateHandler");
            if (this.accessLogger != null) {
                this.accessLogger.updateAccessLogInfo(this.targetHandler.getOutboundRequestMsg(), inboundResponseMsg);
            }
            this.senderReqRespStateManager.state = new EntityBodyReceived(this.senderReqRespStateManager);
            if (!Util.isKeepAlive(this.targetHandler.getKeepAliveConfig(), this.targetHandler.getOutboundRequestMsg(), inboundResponseMsg)) {
                this.targetHandler.closeChannel(ctx);
            }
            this.targetHandler.getConnectionManager().returnChannel(this.targetHandler.getTargetChannel());
        } else {
            this.addHttpContent(inboundResponseMsg, httpContent);
        }
    }

    @Override
    public void handleAbruptChannelClosure(TargetHandler targetHandler, HttpResponseFuture httpResponseFuture) {
        StateUtil.handleIncompleteInboundMessage(targetHandler.getInboundResponseMsg(), "Remote host closed the connection while reading inbound response body");
    }

    @Override
    public void handleIdleTimeoutConnectionClosure(TargetHandler targetHandler, HttpResponseFuture httpResponseFuture, String channelID) {
        this.senderReqRespStateManager.nettyTargetChannel.pipeline().remove("idleStateHandler");
        this.senderReqRespStateManager.nettyTargetChannel.close();
        StateUtil.handleIncompleteInboundMessage(targetHandler.getInboundResponseMsg(), "Idle timeout triggered while reading inbound response entity body");
    }

    private void addHttpContent(HttpCarbonMessage inboundResponseMsg, HttpContent httpContent) {
        inboundResponseMsg.addHttpContent(httpContent);
        if (this.accessLogger != null) {
            this.accessLogger.updateContentLength(httpContent.content());
        }
    }
}

