/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.uri.parser;

import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpResourceArguments;
import io.ballerina.stdlib.http.uri.URITemplateException;
import io.ballerina.stdlib.http.uri.URIUtil;
import io.ballerina.stdlib.http.uri.parser.DataElement;
import io.ballerina.stdlib.http.uri.parser.DataReturnAgent;
import io.ballerina.stdlib.http.uri.parser.Expression;
import io.ballerina.stdlib.http.uri.parser.Literal;
import io.ballerina.stdlib.http.uri.parser.SimpleStringExpression;
import io.ballerina.stdlib.http.uri.parser.Variable;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class Node<DataType, InboundMsgType> {
    protected String token;
    DataElement<DataType, InboundMsgType> dataElement;
    List<Node<DataType, InboundMsgType>> childNodesList = new LinkedList<Node<DataType, InboundMsgType>>();

    protected Node(DataElement<DataType, InboundMsgType> dataElement, String token) {
        this.dataElement = dataElement;
        this.token = token;
    }

    DataElement<DataType, InboundMsgType> getDataElement() {
        return this.dataElement;
    }

    Node<DataType, InboundMsgType> addChild(Node<DataType, InboundMsgType> childNode) throws URITemplateException {
        Node<DataType, InboundMsgType> node = childNode;
        Node<DataType, InboundMsgType> matchingChildNode = this.getMatchingChildNode(childNode, this.childNodesList);
        if (matchingChildNode != null) {
            node = matchingChildNode;
        } else {
            this.childNodesList.add(node);
        }
        this.childNodesList.sort((o1, o2) -> this.getIntValue((Node)o2) - this.getIntValue((Node)o1));
        return node;
    }

    public boolean matchAll(String uriFragment, HttpResourceArguments variables, int start, InboundMsgType inboundMsg, DataReturnAgent<DataType> dataReturnAgent) {
        String subUriFragment;
        int matchLength = this.match(uriFragment, variables);
        if (matchLength < 0) {
            return false;
        }
        if (matchLength == uriFragment.length()) {
            return this.dataElement.getData(inboundMsg, dataReturnAgent);
        }
        if (matchLength >= uriFragment.length()) {
            return false;
        }
        if (uriFragment.startsWith("/")) {
            subUriFragment = uriFragment.substring(matchLength);
        } else if (uriFragment.contains("/")) {
            if (uriFragment.charAt(matchLength) != '/') {
                return false;
            }
            subUriFragment = uriFragment.substring(matchLength + 1);
        } else {
            return false;
        }
        String subPath = this.nextSubPath(subUriFragment);
        for (Node<DataType, InboundMsgType> childNode : this.childNodesList) {
            boolean isFound;
            if (childNode instanceof Literal) {
                Object regex = childNode.getToken();
                if (((String)regex).equals("*")) {
                    if (!subPath.matches((String)(regex = "." + (String)regex)) || !(isFound = childNode.matchAll(subUriFragment, variables, start + matchLength, inboundMsg, dataReturnAgent))) continue;
                    this.setUriPostFix(variables, subUriFragment);
                    return true;
                }
                if (!URIUtil.containsPathSegment(subPath, (String)regex) || !(isFound = childNode.matchAll(subUriFragment, variables, start + matchLength, inboundMsg, dataReturnAgent))) continue;
                return true;
            }
            isFound = childNode.matchAll(subUriFragment, variables, start + matchLength, inboundMsg, dataReturnAgent);
            if (!isFound) continue;
            return true;
        }
        return false;
    }

    private void setUriPostFix(HttpResourceArguments variables, String subUriFragment) {
        Map<Integer, CallSite> indexValueMap = Collections.singletonMap(HttpConstants.EXTRA_PATH_INDEX, "/" + subUriFragment);
        variables.getMap().putIfAbsent("EXTRA_PATH_INFO", indexValueMap);
    }

    abstract String expand(Map<String, String> var1);

    abstract int match(String var1, HttpResourceArguments var2);

    abstract String getToken();

    abstract char getFirstCharacter();

    private Node<DataType, InboundMsgType> getMatchingChildNode(Node<DataType, InboundMsgType> prospectiveChild, List<Node<DataType, InboundMsgType>> existingChildren) throws URITemplateException {
        boolean simpleStringExpression = prospectiveChild instanceof SimpleStringExpression;
        String prospectiveChildToken = prospectiveChild.getToken();
        for (Node<DataType, InboundMsgType> existingChild : existingChildren) {
            if (simpleStringExpression && existingChild instanceof Expression) {
                return this.getExistingChildNode(prospectiveChild, existingChild);
            }
            if (!existingChild.getToken().equals(prospectiveChildToken)) continue;
            return existingChild;
        }
        return null;
    }

    private Node<DataType, InboundMsgType> getExistingChildNode(Node<DataType, InboundMsgType> prospectiveChild, Node<DataType, InboundMsgType> existingChild) throws URITemplateException {
        ((Expression)existingChild).variableList.add(new Variable(prospectiveChild.token));
        existingChild.token = existingChild.token + "+" + prospectiveChild.token;
        return existingChild;
    }

    private int getIntValue(Node node) {
        if (node instanceof Literal) {
            if (node.getToken().equals("*")) {
                return 0;
            }
            return node.getToken().length() + 5;
        }
        return 1;
    }

    private String nextSubPath(String uriFragment) {
        String subPath = uriFragment.contains("/") ? uriFragment.substring(0, uriFragment.indexOf("/")) : uriFragment;
        return subPath;
    }
}

