/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.avro.serialize.visitor.array;

import io.ballerina.lib.avro.serialize.visitor.array.ArrayVisitor;
import io.ballerina.lib.avro.serialize.visitor.array.FixedArrayVisitor;
import io.ballerina.lib.avro.serialize.visitor.array.IArrayVisitor;
import io.ballerina.lib.avro.serialize.visitor.array.MapArrayVisitor;
import io.ballerina.lib.avro.serialize.visitor.array.PrimitiveArrayVisitor;
import io.ballerina.lib.avro.serialize.visitor.array.RecordArrayVisitor;
import io.ballerina.runtime.api.values.BArray;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;

public class UnionArrayVisitor
implements IArrayVisitor {
    @Override
    public GenericData.Array<Object> visit(BArray data, Schema schema, GenericData.Array<Object> array) {
        Map visitorMap = Map.ofEntries(Map.entry(Schema.Type.ARRAY, new ArrayVisitor()), Map.entry(Schema.Type.MAP, new MapArrayVisitor()), Map.entry(Schema.Type.RECORD, new RecordArrayVisitor()), Map.entry(Schema.Type.FIXED, new FixedArrayVisitor()), Map.entry(Schema.Type.BOOLEAN, new PrimitiveArrayVisitor()), Map.entry(Schema.Type.STRING, new PrimitiveArrayVisitor()), Map.entry(Schema.Type.INT, new PrimitiveArrayVisitor()), Map.entry(Schema.Type.LONG, new PrimitiveArrayVisitor()), Map.entry(Schema.Type.DOUBLE, new PrimitiveArrayVisitor()), Map.entry(Schema.Type.BYTES, new PrimitiveArrayVisitor()), Map.entry(Schema.Type.FLOAT, new PrimitiveArrayVisitor()));
        Schema elementType = schema.getElementType();
        for (Schema schema1 : elementType.getTypes()) {
            IArrayVisitor visitor = (IArrayVisitor)visitorMap.get(schema1.getType());
            if (visitor == null) continue;
            return visitor.visit(data, schema1, array);
        }
        return null;
    }
}

