/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.central.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PackageResolutionRequest {
    List<Package> packages = new ArrayList<Package>();

    public void addPackage(String orgName, String name, String version, Mode mode) {
        this.packages.add(new Package(orgName, name, URLEncoder.encode(version, StandardCharsets.UTF_8), mode));
    }

    static class Package {
        private String org;
        private String name;
        @JsonAdapter(value=EmptyStringTypeAdapter.class)
        private String version;
        Mode mode;

        public Package(String org, String name, String version, Mode mode) {
            this.org = org;
            this.name = name;
            this.version = version;
            this.mode = mode;
        }

        public String org() {
            return this.org;
        }

        public void setOrg(String org) {
            this.org = org;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Mode getMode() {
            return this.mode;
        }

        public void setMode(Mode mode) {
            this.mode = mode;
        }
    }

    public static enum Mode {
        SOFT("soft"),
        MEDIUM("medium"),
        HARD("hard"),
        LOCKED("locked");

        private final String text;

        private Mode(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    static class EmptyStringTypeAdapter
    extends TypeAdapter<String> {
        private EmptyStringTypeAdapter() {
        }

        public void write(JsonWriter jsonWriter, @Nullable String s) throws IOException {
            if (s == null || s.isEmpty()) {
                jsonWriter.nullValue();
            } else {
                jsonWriter.value(s);
            }
        }

        @Nonnull
        public String read(JsonReader jsonReader) throws IOException {
            JsonToken token = jsonReader.peek();
            return switch (token) {
                case JsonToken.NULL -> "";
                case JsonToken.STRING -> jsonReader.nextString();
                default -> throw new IllegalStateException("Unexpected token: " + String.valueOf(token));
            };
        }
    }
}

