/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.central.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ToolResolutionCentralRequest {
    List<Tool> tools = new ArrayList<Tool>();

    public void addTool(String id, String version, Mode mode) {
        this.tools.add(new Tool(id, URLEncoder.encode(version, StandardCharsets.UTF_8), mode));
    }

    static class Tool {
        private String id;
        @JsonAdapter(value=EmptyStringTypeAdapter.class)
        private String version;
        Mode mode;

        public Tool(String id, String version, Mode mode) {
            this.id = id;
            this.version = version;
            this.mode = mode;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Mode getMode() {
            return this.mode;
        }

        public void setMode(Mode mode) {
            this.mode = mode;
        }
    }

    public static enum Mode {
        SOFT("soft"),
        MEDIUM("medium"),
        HARD("hard"),
        LOCKED("locked");

        private final String text;

        private Mode(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    static class EmptyStringTypeAdapter
    extends TypeAdapter<String> {
        private EmptyStringTypeAdapter() {
        }

        public void write(JsonWriter jsonWriter, @Nullable String s) throws IOException {
            if (s == null || s.isEmpty()) {
                jsonWriter.nullValue();
            } else {
                jsonWriter.value(s);
            }
        }

        @Nonnull
        public String read(JsonReader jsonReader) throws IOException {
            JsonToken token = jsonReader.peek();
            return switch (token) {
                case JsonToken.NULL -> "";
                case JsonToken.STRING -> jsonReader.nextString();
                default -> throw new IllegalStateException("Unexpected token: " + String.valueOf(token));
            };
        }
    }
}

