/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.jwt.compiler.staticcodeanalyzer;

import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ListBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.scan.Reporter;
import io.ballerina.stdlib.jwt.compiler.staticcodeanalyzer.JwtRule;
import io.ballerina.tools.diagnostics.Location;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class JwtCipherAlgorithmAnalyzer
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final Reporter reporter;
    private static final String JWT = "jwt";
    private static final String ISSUE = "issue";
    private static final String SIGNATURE_CONFIG = "signatureConfig";
    private static final String ALGORITHM = "algorithm";
    private static final String NONE = "NONE";
    private static final String BALLERINA_ORG = "ballerina";
    private final Set<String> jwtPrefixes = new HashSet<String>();

    public JwtCipherAlgorithmAnalyzer(Reporter reporter) {
        this.reporter = reporter;
        this.jwtPrefixes.add(JWT);
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        this.analyzeImports(context);
        FunctionCallExpressionNode functionCall = (FunctionCallExpressionNode)context.node();
        NameReferenceNode nameReferenceNode = functionCall.functionName();
        if (!(nameReferenceNode instanceof QualifiedNameReferenceNode)) {
            return;
        }
        QualifiedNameReferenceNode qualifiedName = (QualifiedNameReferenceNode)nameReferenceNode;
        String modulePrefix = qualifiedName.modulePrefix().text();
        String qualifiedNameText = qualifiedName.identifier().text();
        if (!this.jwtPrefixes.contains(modulePrefix) || !ISSUE.equals(qualifiedNameText)) {
            return;
        }
        block4: for (FunctionArgumentNode arg : functionCall.arguments()) {
            SimpleNameReferenceNode varRef;
            MappingConstructorExpressionNode mappingConstructor;
            ExpressionNode expr;
            FunctionArgumentNode functionArgumentNode;
            Objects.requireNonNull(arg);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PositionalArgumentNode.class, NamedArgumentNode.class}, (Object)functionArgumentNode, n)) {
                case 0: {
                    PositionalArgumentNode posArg = (PositionalArgumentNode)functionArgumentNode;
                    expr = posArg.expression();
                    break;
                }
                case 1: {
                    NamedArgumentNode namedArg = (NamedArgumentNode)functionArgumentNode;
                    expr = namedArg.expression();
                    break;
                }
                default: {
                    continue block4;
                }
            }
            if ((!(expr instanceof MappingConstructorExpressionNode) || !this.hasNoneAlgorithmInMappingLiteral(mappingConstructor = (MappingConstructorExpressionNode)expr)) && (!(expr instanceof SimpleNameReferenceNode) || !this.hasNoneAlgorithmInVariableReference(varRef = (SimpleNameReferenceNode)expr))) continue;
            this.reporter.reportIssue(JwtCipherAlgorithmAnalyzer.getDocument(context.currentPackage().module(context.moduleId()), context.documentId()), (Location)context.node().location(), JwtRule.AVOID_WEAK_CIPHER_ALGORITHMS.getId());
        }
    }

    private boolean hasNoneAlgorithmInVariableReference(SimpleNameReferenceNode varRef) {
        String varName = varRef.name().text();
        for (NonTerminalNode currentNode = varRef.parent(); currentNode != null; currentNode = currentNode.parent()) {
            ModulePartNode module;
            FunctionBodyBlockNode body;
            if (currentNode instanceof FunctionBodyBlockNode && this.hasWeakAlgorithmInStatements((NodeList<StatementNode>)(body = (FunctionBodyBlockNode)currentNode).statements(), varName)) {
                return true;
            }
            if (!(currentNode instanceof ModulePartNode) || !this.hasWeakAlgorithmInModuleMembers((NodeList<ModuleMemberDeclarationNode>)(module = (ModulePartNode)currentNode).members(), varName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasWeakAlgorithmInStatements(NodeList<StatementNode> statements, String varName) {
        for (StatementNode stmt : statements) {
            VariableDeclarationNode varDecl;
            if (!(stmt instanceof VariableDeclarationNode) || !this.isWeakAlgorithmInVarDecl(varDecl = (VariableDeclarationNode)stmt, varName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasWeakAlgorithmInModuleMembers(NodeList<ModuleMemberDeclarationNode> members, String varName) {
        for (ModuleMemberDeclarationNode member : members) {
            ModuleVariableDeclarationNode varDecl;
            if (!(member instanceof ModuleVariableDeclarationNode) || !this.isWeakAlgorithmInVarDecl(varDecl = (ModuleVariableDeclarationNode)member, varName)) continue;
            return true;
        }
        return false;
    }

    private boolean isWeakAlgorithmInVarDecl(VariableDeclarationNode varDecl, String varName) {
        MappingConstructorExpressionNode mapping;
        ListConstructorExpressionNode listConstructor;
        CaptureBindingPatternNode capture;
        ListBindingPatternNode listBinding;
        MappingConstructorExpressionNode mapping2;
        CaptureBindingPatternNode capture2;
        Object object = varDecl.typedBindingPattern().bindingPattern();
        if (object instanceof CaptureBindingPatternNode && (capture2 = (CaptureBindingPatternNode)object).variableName().text().equals(varName) && varDecl.initializer().isPresent() && (object = varDecl.initializer().get()) instanceof MappingConstructorExpressionNode && this.hasNoneAlgorithmInMappingLiteral(mapping2 = (MappingConstructorExpressionNode)object)) {
            return true;
        }
        Object object2 = varDecl.typedBindingPattern().bindingPattern();
        return object2 instanceof ListBindingPatternNode && (object2 = (listBinding = (ListBindingPatternNode)object2).bindingPatterns().get(0)) instanceof CaptureBindingPatternNode && (capture = (CaptureBindingPatternNode)object2).variableName().text().equals(varName) && varDecl.initializer().isPresent() && (object2 = varDecl.initializer().get()) instanceof ListConstructorExpressionNode && (object2 = (listConstructor = (ListConstructorExpressionNode)object2).expressions().get(0)) instanceof MappingConstructorExpressionNode && this.hasNoneAlgorithmInMappingLiteral(mapping = (MappingConstructorExpressionNode)object2);
    }

    private boolean isWeakAlgorithmInVarDecl(ModuleVariableDeclarationNode varDecl, String varName) {
        MappingConstructorExpressionNode mapping;
        ListConstructorExpressionNode listConstructor;
        CaptureBindingPatternNode capture;
        ListBindingPatternNode listBinding;
        MappingConstructorExpressionNode mapping2;
        CaptureBindingPatternNode capture2;
        Object object = varDecl.typedBindingPattern().bindingPattern();
        if (object instanceof CaptureBindingPatternNode && (capture2 = (CaptureBindingPatternNode)object).variableName().text().equals(varName) && varDecl.initializer().isPresent() && (object = varDecl.initializer().get()) instanceof MappingConstructorExpressionNode && this.hasNoneAlgorithmInMappingLiteral(mapping2 = (MappingConstructorExpressionNode)object)) {
            return true;
        }
        Object object2 = varDecl.typedBindingPattern().bindingPattern();
        return object2 instanceof ListBindingPatternNode && (object2 = (listBinding = (ListBindingPatternNode)object2).bindingPatterns().get(0)) instanceof CaptureBindingPatternNode && (capture = (CaptureBindingPatternNode)object2).variableName().text().equals(varName) && varDecl.initializer().isPresent() && (object2 = varDecl.initializer().get()) instanceof ListConstructorExpressionNode && (object2 = (listConstructor = (ListConstructorExpressionNode)object2).expressions().get(0)) instanceof MappingConstructorExpressionNode && this.hasNoneAlgorithmInMappingLiteral(mapping = (MappingConstructorExpressionNode)object2);
    }

    private boolean hasNoneAlgorithmInMappingLiteral(MappingConstructorExpressionNode mappingConstructor) {
        for (MappingFieldNode field : mappingConstructor.fields()) {
            Object object;
            SpecificFieldNode spec;
            if (!(field instanceof SpecificFieldNode) || !(spec = (SpecificFieldNode)field).fieldName().toString().contains(SIGNATURE_CONFIG) || !spec.valueExpr().isPresent() || !((object = spec.valueExpr().get()) instanceof MappingConstructorExpressionNode)) continue;
            MappingConstructorExpressionNode mappingConstructorExpression = (MappingConstructorExpressionNode)object;
            object = mappingConstructorExpression.fields().iterator();
            while (object.hasNext()) {
                SpecificFieldNode algField;
                MappingFieldNode nestedField = (MappingFieldNode)object.next();
                if (!(nestedField instanceof SpecificFieldNode) || !(algField = (SpecificFieldNode)nestedField).fieldName().toString().contains(ALGORITHM) || !algField.valueExpr().isPresent() || !((ExpressionNode)algField.valueExpr().get()).toString().contains(NONE)) continue;
                return true;
            }
        }
        return false;
    }

    private static Document getDocument(Module module, DocumentId documentId) {
        return module.document(documentId);
    }

    private void analyzeImports(SyntaxNodeAnalysisContext context) {
        Document document = JwtCipherAlgorithmAnalyzer.getDocument(context.currentPackage().module(context.moduleId()), context.documentId());
        Node node = document.syntaxTree().rootNode();
        if (node instanceof ModulePartNode) {
            ModulePartNode modulePartNode = (ModulePartNode)node;
            modulePartNode.imports().forEach(importDeclarationNode -> {
                ImportOrgNameNode importOrgNameNode = importDeclarationNode.orgName().orElse(null);
                if (importOrgNameNode != null && BALLERINA_ORG.equals(importOrgNameNode.orgName().text()) && importDeclarationNode.moduleName().stream().anyMatch(moduleNameNode -> JWT.equals(moduleNameNode.text()))) {
                    ImportPrefixNode importPrefixNode = importDeclarationNode.prefix().orElse(null);
                    String prefix = importPrefixNode != null ? importPrefixNode.prefix().text() : JWT;
                    this.jwtPrefixes.add(prefix);
                }
            });
        }
    }
}

