/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.projects.Project;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.compiler.FinderContext;
import io.ballerina.stdlib.graphql.compiler.ModuleLevelVariableDeclarationAnalysisTask;
import io.ballerina.stdlib.graphql.compiler.schema.generator.GeneratorUtils;
import io.ballerina.stdlib.graphql.compiler.schema.generator.SchemaGenerator;
import io.ballerina.stdlib.graphql.compiler.service.InterfaceEntityFinder;
import io.ballerina.stdlib.graphql.compiler.service.validator.DefaultableParameterNodeFinder;
import io.ballerina.stdlib.graphql.compiler.service.validator.EntityAnnotationFinder;
import io.ballerina.stdlib.graphql.compiler.service.validator.RecordFieldWithDefaultValueVisitor;
import io.ballerina.stdlib.graphql.compiler.service.validator.RecordTypeDefinitionNodeFinder;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class Utils {
    public static final String LISTENER_IDENTIFIER = "Listener";
    public static final String CONTEXT_IDENTIFIER = "Context";
    public static final String FIELD_IDENTIFIER = "Field";
    public static final String FILE_UPLOAD_IDENTIFIER = "Upload";
    public static final String SERVICE_CONFIG_IDENTIFIER = "ServiceConfig";
    public static final String SUBGRAPH_ANNOTATION_NAME = "Subgraph";
    public static final String UUID_RECORD_NAME = "Uuid";
    private static final String ORG_NAME = "ballerina";
    private static final String UUID_MODULE_NAME = "uuid";
    private static final String RESOURCE_CONFIG_ANNOTATION = "ResourceConfig";
    private static final String ENTITY_ANNOTATION = "Entity";
    private static final String CACHE_CONFIG_ENABLE_FIELD = "enabled";
    private static final String CACHE_CONFIG_MAX_SIZE_FIELD = "maxSize";
    private static final int DEFAULT_MAX_SIZE = 120;
    public static final String IS_ANALYSIS_COMPLETED = "isAnalysisCompleted";
    public static final String MODIFIER_CONTEXT_MAP = "modifierContextMap";

    private Utils() {
    }

    public static boolean isValidUuidModule(ModuleSymbol module) {
        return module.id().orgName().equals(ORG_NAME) && module.id().moduleName().equals(UUID_MODULE_NAME);
    }

    public static boolean isRemoteMethod(MethodSymbol methodSymbol) {
        return methodSymbol.qualifiers().contains(Qualifier.REMOTE);
    }

    public static boolean isResourceMethod(MethodSymbol methodSymbol) {
        return methodSymbol.qualifiers().contains(Qualifier.RESOURCE);
    }

    public static boolean isGraphqlListener(Symbol listenerSymbol) {
        if (listenerSymbol.kind() != SymbolKind.TYPE) {
            return false;
        }
        TypeSymbol typeSymbol = ((TypeReferenceTypeSymbol)listenerSymbol).typeDescriptor();
        if (typeSymbol.typeKind() != TypeDescKind.OBJECT) {
            return false;
        }
        if (!io.ballerina.stdlib.graphql.commons.utils.Utils.isGraphqlModuleSymbol((Symbol)typeSymbol)) {
            return false;
        }
        if (typeSymbol.getName().isEmpty()) {
            return false;
        }
        return LISTENER_IDENTIFIER.equals(typeSymbol.getName().get());
    }

    public static boolean isIgnoreType(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.NIL || typeSymbol.typeKind() == TypeDescKind.ERROR) {
            return true;
        }
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return Utils.isIgnoreType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor());
        }
        return false;
    }

    public static List<TypeSymbol> getEffectiveTypes(UnionTypeSymbol unionTypeSymbol) {
        ArrayList<TypeSymbol> effectiveTypes = new ArrayList<TypeSymbol>();
        for (TypeSymbol typeSymbol : unionTypeSymbol.userSpecifiedMemberTypes()) {
            if (typeSymbol.typeKind() == TypeDescKind.UNION) {
                effectiveTypes.addAll(Utils.getEffectiveTypes((UnionTypeSymbol)typeSymbol));
                continue;
            }
            if (Utils.isIgnoreType(typeSymbol)) continue;
            effectiveTypes.add(typeSymbol);
        }
        return effectiveTypes;
    }

    public static TypeSymbol getEffectiveType(IntersectionTypeSymbol intersectionTypeSymbol) {
        ArrayList<TypeSymbol> effectiveTypes = new ArrayList<TypeSymbol>();
        for (TypeSymbol typeSymbol : intersectionTypeSymbol.memberTypeDescriptors()) {
            if (typeSymbol.typeKind() == TypeDescKind.READONLY) continue;
            effectiveTypes.add(typeSymbol);
        }
        if (effectiveTypes.size() == 1) {
            return (TypeSymbol)effectiveTypes.get(0);
        }
        return intersectionTypeSymbol;
    }

    public static ObjectTypeSymbol getObjectTypeSymbol(Symbol serviceObjectTypeOrClass) {
        if (serviceObjectTypeOrClass.kind() == SymbolKind.TYPE_DEFINITION) {
            TypeDefinitionSymbol serviceObjectTypeSymbol = (TypeDefinitionSymbol)serviceObjectTypeOrClass;
            TypeSymbol typeSymbol = serviceObjectTypeSymbol.typeDescriptor();
            if (typeSymbol.typeKind() == TypeDescKind.OBJECT) {
                return (ObjectTypeSymbol)typeSymbol;
            }
        } else if (serviceObjectTypeOrClass.kind() == SymbolKind.CLASS) {
            return (ObjectTypeSymbol)serviceObjectTypeOrClass;
        }
        String symbolName = "Provided symbol";
        if (serviceObjectTypeOrClass.getName().isPresent()) {
            symbolName = (String)serviceObjectTypeOrClass.getName().get();
        }
        throw new UnsupportedOperationException(symbolName + " is not ClassSymbol or TypeDefinitionSymbol of an object");
    }

    public static boolean isDistinctServiceReference(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() != TypeDescKind.TYPE_REFERENCE) {
            return false;
        }
        TypeSymbol typeDescriptor = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor();
        return Utils.isDistinctServiceClass((Symbol)typeDescriptor);
    }

    public static boolean isDistinctServiceClass(Symbol symbol) {
        if (!Utils.isServiceClass(symbol)) {
            return false;
        }
        return ((ClassSymbol)symbol).qualifiers().contains(Qualifier.DISTINCT);
    }

    public static boolean isServiceClass(Symbol symbol) {
        if (symbol.kind() != SymbolKind.CLASS) {
            return false;
        }
        return ((ClassSymbol)symbol).qualifiers().contains(Qualifier.SERVICE);
    }

    public static boolean isServiceObjectDefinition(Symbol symbol) {
        if (symbol.kind() != SymbolKind.TYPE_DEFINITION) {
            return false;
        }
        TypeSymbol typeDescriptor = ((TypeDefinitionSymbol)symbol).typeDescriptor();
        return Utils.isServiceObjectType(typeDescriptor);
    }

    public static boolean isServiceObjectReference(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() != TypeDescKind.TYPE_REFERENCE) {
            return false;
        }
        TypeSymbol typeDescriptor = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor();
        return Utils.isServiceObjectType(typeDescriptor);
    }

    private static boolean isServiceObjectType(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() != TypeDescKind.OBJECT || typeSymbol.kind() != SymbolKind.TYPE) {
            return false;
        }
        return ((ObjectTypeSymbol)typeSymbol).qualifiers().contains(Qualifier.SERVICE);
    }

    public static boolean hasCompilationErrors(SyntaxNodeAnalysisContext context) {
        for (Diagnostic diagnostic : context.semanticModel().diagnostics()) {
            if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
            return true;
        }
        return false;
    }

    public static boolean isFileUploadParameter(TypeSymbol typeSymbol) {
        if (typeSymbol.getName().isEmpty()) {
            return false;
        }
        if (!io.ballerina.stdlib.graphql.commons.utils.Utils.isGraphqlModuleSymbol((Symbol)typeSymbol)) {
            return false;
        }
        return FILE_UPLOAD_IDENTIFIER.equals(typeSymbol.getName().get());
    }

    public static boolean isValidGraphqlParameter(TypeSymbol typeSymbol) {
        if (typeSymbol.getName().isEmpty()) {
            return false;
        }
        if (!io.ballerina.stdlib.graphql.commons.utils.Utils.isGraphqlModuleSymbol((Symbol)typeSymbol)) {
            return false;
        }
        if (Utils.isContextParameter(typeSymbol)) {
            return true;
        }
        return FIELD_IDENTIFIER.equals(typeSymbol.getName().get());
    }

    public static boolean isContextParameter(TypeSymbol typeSymbol) {
        if (typeSymbol.getName().isEmpty()) {
            return false;
        }
        return io.ballerina.stdlib.graphql.commons.utils.Utils.isGraphqlModuleSymbol((Symbol)typeSymbol) && CONTEXT_IDENTIFIER.equals(typeSymbol.getName().get());
    }

    public static String getAccessor(ResourceMethodSymbol resourceMethodSymbol) {
        return resourceMethodSymbol.getName().orElse(null);
    }

    public static boolean isFunctionDefinition(Node node) {
        return node.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION || node.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION;
    }

    public static boolean isRecordTypeDefinition(Symbol symbol) {
        if (symbol.kind() != SymbolKind.TYPE_DEFINITION) {
            return false;
        }
        TypeDefinitionSymbol typeDefinitionSymbol = (TypeDefinitionSymbol)symbol;
        return typeDefinitionSymbol.typeDescriptor().typeKind() == TypeDescKind.RECORD;
    }

    public static boolean hasSubgraphAnnotation(List<AnnotationSymbol> annotations) {
        for (AnnotationSymbol annotation : annotations) {
            String annotationName;
            if (annotation.getName().isEmpty() || !io.ballerina.stdlib.graphql.commons.utils.Utils.isSubgraphModuleSymbol((Symbol)annotation) || !(annotationName = (String)annotation.getName().get()).equals(SUBGRAPH_ANNOTATION_NAME)) continue;
            return true;
        }
        return false;
    }

    public static Schema getSchemaObject(Node node, SemanticModel semanticModel, Project project) {
        Node serviceNode;
        String description;
        boolean isSubgraph;
        if (node.kind() == SyntaxKind.SERVICE_DECLARATION) {
            if (semanticModel.symbol(node).isEmpty()) {
                return null;
            }
            ServiceDeclarationSymbol symbol = (ServiceDeclarationSymbol)semanticModel.symbol(node).get();
            if (!io.ballerina.stdlib.graphql.commons.utils.Utils.hasGraphqlListener((ServiceDeclarationSymbol)symbol)) {
                return null;
            }
            isSubgraph = Utils.hasSubgraphAnnotation(symbol.annotations());
            description = GeneratorUtils.getDescription((Documentable)symbol);
            serviceNode = node;
        } else if (node.kind() == SyntaxKind.MODULE_VAR_DECL) {
            ModuleVariableDeclarationNode moduleVarDclNode = (ModuleVariableDeclarationNode)node;
            if (!io.ballerina.stdlib.graphql.commons.utils.Utils.isGraphQLServiceObjectDeclaration((ModuleVariableDeclarationNode)moduleVarDclNode)) {
                return null;
            }
            if (moduleVarDclNode.initializer().isEmpty()) {
                return null;
            }
            ExpressionNode expressionNode = (ExpressionNode)moduleVarDclNode.initializer().get();
            if (expressionNode.kind() != SyntaxKind.OBJECT_CONSTRUCTOR) {
                return null;
            }
            ObjectConstructorExpressionNode objectNode = (ObjectConstructorExpressionNode)expressionNode;
            List<AnnotationSymbol> annotations = objectNode.annotations().stream().map(annotationNode -> (AnnotationSymbol)semanticModel.symbol((Node)annotationNode).get()).collect(Collectors.toList());
            isSubgraph = Utils.hasSubgraphAnnotation(annotations);
            serviceNode = expressionNode;
            description = ModuleLevelVariableDeclarationAnalysisTask.getDescription(semanticModel, moduleVarDclNode);
        } else {
            return null;
        }
        InterfaceEntityFinder interfaceFinder = new InterfaceEntityFinder();
        interfaceFinder.populateInterfacesAndEntities(semanticModel);
        FinderContext finderContext = new FinderContext(semanticModel, project, project.currentPackage().getDefaultModule().moduleId());
        SchemaGenerator schemaGenerator = new SchemaGenerator(serviceNode, interfaceFinder, finderContext, description, isSubgraph);
        return schemaGenerator.generate();
    }

    public static boolean isPrimitiveTypeSymbol(TypeSymbol typeSymbol) {
        switch (typeSymbol.typeKind()) {
            case INT: 
            case INT_SIGNED8: 
            case INT_UNSIGNED8: 
            case INT_SIGNED16: 
            case INT_UNSIGNED16: 
            case INT_SIGNED32: 
            case INT_UNSIGNED32: 
            case STRING: 
            case STRING_CHAR: 
            case BOOLEAN: 
            case DECIMAL: 
            case FLOAT: {
                return true;
            }
        }
        return false;
    }

    public static boolean hasResourceConfigAnnotation(MethodSymbol resourceMethodSymbol) {
        return resourceMethodSymbol.annotations().stream().anyMatch(annotationSymbol -> io.ballerina.stdlib.graphql.commons.utils.Utils.isGraphqlModuleSymbol((Symbol)annotationSymbol) && annotationSymbol.getName().isPresent() && ((String)annotationSymbol.getName().get()).equals(RESOURCE_CONFIG_ANNOTATION));
    }

    public static AnnotationSymbol getEntityAnnotationSymbol(Symbol symbol) {
        TypeDefinitionSymbol annotatable;
        if (symbol.kind() == SymbolKind.TYPE_DEFINITION) {
            annotatable = (TypeDefinitionSymbol)symbol;
        } else if (symbol.kind() == SymbolKind.CLASS) {
            annotatable = (ClassSymbol)symbol;
        } else {
            return null;
        }
        return annotatable.annotations().stream().filter(annotationSymbol -> annotationSymbol.getName().orElse("").equals(ENTITY_ANNOTATION)).findFirst().orElse(null);
    }

    public static String getStringValue(SpecificFieldNode specificFieldNode) {
        if (specificFieldNode.valueExpr().isEmpty()) {
            return null;
        }
        ExpressionNode valueExpression = (ExpressionNode)specificFieldNode.valueExpr().get();
        if (valueExpression.kind() == SyntaxKind.STRING_LITERAL) {
            BasicLiteralNode stringLiteralNode = (BasicLiteralNode)valueExpression;
            String stringLiteral = stringLiteralNode.toSourceCode().trim();
            return stringLiteral.substring(1, stringLiteral.length() - 1);
        }
        return null;
    }

    public static boolean getBooleanValue(MappingConstructorExpressionNode mappingConstructorNode) {
        if (mappingConstructorNode.fields().isEmpty()) {
            return true;
        }
        for (MappingFieldNode field : mappingConstructorNode.fields()) {
            ExpressionNode valueExpression;
            IdentifierToken identifierToken;
            String identifierName;
            SpecificFieldNode specificFieldNode;
            Node fieldName;
            if (field.kind() != SyntaxKind.SPECIFIC_FIELD || (fieldName = (specificFieldNode = (SpecificFieldNode)field).fieldName()).kind() != SyntaxKind.IDENTIFIER_TOKEN || !CACHE_CONFIG_ENABLE_FIELD.equals(identifierName = (identifierToken = (IdentifierToken)fieldName).text()) || !specificFieldNode.valueExpr().isPresent() || (valueExpression = (ExpressionNode)specificFieldNode.valueExpr().get()).kind() != SyntaxKind.BOOLEAN_LITERAL) continue;
            BasicLiteralNode stringLiteralNode = (BasicLiteralNode)valueExpression;
            return Boolean.parseBoolean(stringLiteralNode.toSourceCode().trim());
        }
        return true;
    }

    public static int getMaxSize(MappingConstructorExpressionNode mappingConstructorNode) {
        if (mappingConstructorNode.fields().isEmpty()) {
            return 120;
        }
        for (MappingFieldNode field : mappingConstructorNode.fields()) {
            ExpressionNode valueExpression;
            IdentifierToken identifierToken;
            String identifierName;
            SpecificFieldNode specificFieldNode;
            Node fieldName;
            if (field.kind() != SyntaxKind.SPECIFIC_FIELD || (fieldName = (specificFieldNode = (SpecificFieldNode)field).fieldName()).kind() != SyntaxKind.IDENTIFIER_TOKEN || !CACHE_CONFIG_MAX_SIZE_FIELD.equals(identifierName = (identifierToken = (IdentifierToken)fieldName).text()) || !specificFieldNode.valueExpr().isPresent() || (valueExpression = (ExpressionNode)specificFieldNode.valueExpr().get()).kind() != SyntaxKind.NUMERIC_LITERAL) continue;
            BasicLiteralNode integerLiteralNode = (BasicLiteralNode)valueExpression;
            return Integer.parseInt(integerLiteralNode.toSourceCode().trim());
        }
        return 120;
    }

    public static String getStringValue(BasicLiteralNode expression) {
        String literalToken = expression.literalToken().text().trim();
        return literalToken.substring(1, literalToken.length() - 1);
    }

    public static DefaultableParameterNode getDefaultableParameterNode(MethodSymbol methodSymbol, ParameterSymbol parameterSymbol, FinderContext context) {
        DefaultableParameterNodeFinder finder = new DefaultableParameterNodeFinder(context, methodSymbol, parameterSymbol);
        return finder.getDeflatableParameterNode().orElse(null);
    }

    public static TypeDefinitionNode getRecordTypeDefinitionNode(RecordTypeSymbol recordTypeSymbol, String recordTypeName, FinderContext context) {
        RecordTypeDefinitionNodeFinder recordTypeDefFinder = new RecordTypeDefinitionNodeFinder(context, recordTypeSymbol, recordTypeName);
        return recordTypeDefFinder.find().orElse(null);
    }

    public static AnnotationNode getEntityAnnotationNode(AnnotationSymbol annotationSymbol, String entityName, FinderContext context) {
        EntityAnnotationFinder entityAnnotationFinder = new EntityAnnotationFinder(context, annotationSymbol, entityName);
        return entityAnnotationFinder.find().orElse(null);
    }

    public static RecordFieldWithDefaultValueNode getRecordFieldWithDefaultValueNode(String recordFieldName, TypeDefinitionNode typeDefNode, SemanticModel semanticModel) {
        RecordFieldWithDefaultValueVisitor visitor = new RecordFieldWithDefaultValueVisitor(semanticModel, recordFieldName);
        typeDefNode.accept((NodeVisitor)visitor);
        return visitor.getRecordFieldNode().orElse(null);
    }

    public static List<TypeSymbol> getTypeInclusions(TypeSymbol typeSymbol) {
        TypeSymbol typeDescriptor;
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE && (typeDescriptor = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor()).typeKind() == TypeDescKind.RECORD) {
            return ((RecordTypeSymbol)typeDescriptor).typeInclusions();
        }
        if (typeSymbol.typeKind() == TypeDescKind.RECORD) {
            return ((RecordTypeSymbol)typeSymbol).typeInclusions();
        }
        return new ArrayList<TypeSymbol>();
    }

    public static boolean isGraphqlServiceConfig(AnnotationNode annotationNode, String modulePrefix) {
        if (annotationNode.annotReference().kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return false;
        }
        QualifiedNameReferenceNode referenceNode = (QualifiedNameReferenceNode)annotationNode.annotReference();
        if (!modulePrefix.equals(referenceNode.modulePrefix().text())) {
            return false;
        }
        return SERVICE_CONFIG_IDENTIFIER.equals(referenceNode.identifier().text());
    }
}

