/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.analyzer;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.CodeAnalysisContext;
import io.ballerina.projects.plugins.CodeAnalyzer;
import io.ballerina.stdlib.graphql.compiler.InterceptorAnalysisTask;
import io.ballerina.stdlib.graphql.compiler.ModuleLevelVariableDeclarationAnalysisTask;
import io.ballerina.stdlib.graphql.compiler.ObjectConstructorAnalysisTask;
import io.ballerina.stdlib.graphql.compiler.ServiceDeclarationAnalysisTask;
import io.ballerina.stdlib.graphql.compiler.service.validator.ListenerValidator;
import java.util.Arrays;
import java.util.Map;

public class GraphqlCodeAnalyzer
extends CodeAnalyzer {
    private final Map<String, Object> userData;

    public GraphqlCodeAnalyzer(Map<String, Object> userData) {
        this.userData = userData;
    }

    public void init(CodeAnalysisContext codeAnalysisContext) {
        if (this.userData == null) {
            return;
        }
        if (this.userData.containsKey("isAnalysisCompleted") && ((Boolean)this.userData.get("isAnalysisCompleted")).booleanValue()) {
            return;
        }
        this.analyze(codeAnalysisContext);
    }

    private void analyze(CodeAnalysisContext codeAnalysisContext) {
        codeAnalysisContext.addSyntaxNodeAnalysisTask((AnalysisTask)new ServiceDeclarationAnalysisTask(this.userData), SyntaxKind.SERVICE_DECLARATION);
        codeAnalysisContext.addSyntaxNodeAnalysisTask((AnalysisTask)new ObjectConstructorAnalysisTask(this.userData), SyntaxKind.OBJECT_CONSTRUCTOR);
        codeAnalysisContext.addSyntaxNodeAnalysisTask((AnalysisTask)new InterceptorAnalysisTask(), SyntaxKind.CLASS_DEFINITION);
        codeAnalysisContext.addSyntaxNodeAnalysisTask((AnalysisTask)new ListenerValidator(), Arrays.asList(SyntaxKind.IMPLICIT_NEW_EXPRESSION, SyntaxKind.EXPLICIT_NEW_EXPRESSION));
        codeAnalysisContext.addSyntaxNodeAnalysisTask((AnalysisTask)new ModuleLevelVariableDeclarationAnalysisTask(this.userData), SyntaxKind.MODULE_VAR_DECL);
    }
}

