/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.service.validator;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import java.util.Optional;

public class EntityAnnotationNodeVisitor
extends NodeVisitor {
    private final AnnotationSymbol annotationSymbol;
    private final SemanticModel semanticModel;
    private final String entityName;
    private AnnotationNode annotationNode;

    public EntityAnnotationNodeVisitor(SemanticModel semanticModel, AnnotationSymbol annotationSymbol, String entityName) {
        this.semanticModel = semanticModel;
        this.annotationSymbol = annotationSymbol;
        this.entityName = entityName;
    }

    public void visit(AnnotationNode annotationNode) {
        if (this.annotationNode != null) {
            return;
        }
        Optional annotationSymbol = this.semanticModel.symbol((Node)annotationNode);
        if (annotationSymbol.isPresent() && ((Symbol)annotationSymbol.get()).equals((Object)this.annotationSymbol)) {
            ClassDefinitionNode classDefinitionNode;
            if (annotationNode.parent().parent().kind() == SyntaxKind.TYPE_DEFINITION) {
                TypeDefinitionNode typeDefinitionNode = (TypeDefinitionNode)annotationNode.parent().parent();
                if (typeDefinitionNode.typeName().text().trim().equals(this.entityName)) {
                    this.annotationNode = annotationNode;
                }
            } else if (annotationNode.parent().parent().kind() == SyntaxKind.CLASS_DEFINITION && (classDefinitionNode = (ClassDefinitionNode)annotationNode.parent().parent()).className().text().trim().equals(this.entityName)) {
                this.annotationNode = annotationNode;
            }
        }
    }

    public Optional<AnnotationNode> getNode() {
        return Optional.ofNullable(this.annotationNode);
    }
}

