/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnector;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.config.ChunkConfig;
import org.wso2.transport.http.netty.contract.config.KeepAliveConfig;
import org.wso2.transport.http.netty.contract.config.RequestSizeValidationConfig;
import org.wso2.transport.http.netty.contract.config.ServerBootstrapConfiguration;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.contractimpl.HttpWsServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.contractimpl.common.ssl.SSLHandlerFactory;
import org.wso2.transport.http.netty.contractimpl.listener.HttpServerChannelInitializer;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.internal.HttpTransportContextHolder;

public class ServerConnectorBootstrap {
    private static final Logger LOG = LoggerFactory.getLogger(ServerConnectorBootstrap.class);
    private ServerBootstrap serverBootstrap = new ServerBootstrap();
    private HttpServerChannelInitializer httpServerChannelInitializer = new HttpServerChannelInitializer();
    private boolean initialized;
    private boolean isHttps = false;
    private ChannelGroup allChannels;

    public ServerConnectorBootstrap(ChannelGroup allChannels) {
        this.httpServerChannelInitializer.setAllChannels(allChannels);
        this.serverBootstrap.childHandler((ChannelHandler)this.httpServerChannelInitializer);
        HttpTransportContextHolder.getInstance().setHandlerExecutor(new HandlerExecutor());
        this.initialized = true;
        this.allChannels = allChannels;
    }

    public ServerConnector getServerConnector(String host, int port) {
        String serverConnectorId = Util.createServerConnectorID(host, port);
        return new HttpServerConnector(serverConnectorId, host, port);
    }

    public void addSocketConfiguration(ServerBootstrapConfiguration serverBootstrapConfiguration) {
        this.serverBootstrap.option(ChannelOption.SO_BACKLOG, (Object)serverBootstrapConfiguration.getSoBackLog());
        this.serverBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)serverBootstrapConfiguration.getConnectTimeOut());
        this.serverBootstrap.option(ChannelOption.SO_RCVBUF, (Object)serverBootstrapConfiguration.getReceiveBufferSize());
        this.serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)serverBootstrapConfiguration.isTcpNoDelay());
        this.serverBootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)serverBootstrapConfiguration.getReceiveBufferSize());
        this.serverBootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)serverBootstrapConfiguration.getSendBufferSize());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Netty Server Socket BACKLOG %d", serverBootstrapConfiguration.getSoBackLog()));
            LOG.debug(String.format("Netty Server Socket TCP_NODELAY %s", serverBootstrapConfiguration.isTcpNoDelay()));
            LOG.debug(String.format("Netty Server Socket CONNECT_TIMEOUT_MILLIS %d", serverBootstrapConfiguration.getConnectTimeOut()));
            LOG.debug(String.format("Netty Server Socket SO_RCVBUF %d", serverBootstrapConfiguration.getReceiveBufferSize()));
            LOG.debug(String.format("Netty Server Socket SO_SNDBUF %d", serverBootstrapConfiguration.getSendBufferSize()));
        }
    }

    public void addSecurity(SSLConfig sslConfig) {
        if (sslConfig != null) {
            this.httpServerChannelInitializer.setSslConfig(sslConfig);
            this.isHttps = true;
        }
    }

    public void addIdleTimeout(long socketIdleTimeout) {
        this.httpServerChannelInitializer.setIdleTimeout(socketIdleTimeout);
    }

    public void setHttp2Enabled(boolean isHttp2Enabled) {
        this.httpServerChannelInitializer.setHttp2Enabled(isHttp2Enabled);
    }

    public void addThreadPools(EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        this.serverBootstrap.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class);
    }

    public void addHttpTraceLogHandler(Boolean isHttpTraceLogEnabled) {
        this.httpServerChannelInitializer.setHttpTraceLogEnabled(isHttpTraceLogEnabled);
    }

    public void addHttpAccessLogHandler(Boolean isHttpAccessLogEnabled) {
        this.httpServerChannelInitializer.setHttpAccessLogEnabled(isHttpAccessLogEnabled);
    }

    public void addSslHandlerFactory(SSLHandlerFactory sslHandlerFactory) {
        this.httpServerChannelInitializer.setSslHandlerFactory(sslHandlerFactory);
    }

    public void addKeystoreSslContext(SSLContext sslContext) {
        this.httpServerChannelInitializer.setKeystoreSslContext(sslContext);
    }

    public void addHttp2SslContext(SslContext sslContext) {
        this.httpServerChannelInitializer.setHttp2SslContext(sslContext);
    }

    public void addCertAndKeySslContext(SslContext sslContext) {
        this.httpServerChannelInitializer.setCertandKeySslContext(sslContext);
    }

    public void addHeaderAndEntitySizeValidation(RequestSizeValidationConfig requestSizeValidationConfig) {
        this.httpServerChannelInitializer.setReqSizeValidationConfig(requestSizeValidationConfig);
    }

    public void addcertificateRevocationVerifier(Boolean validateCertEnabled) {
        this.httpServerChannelInitializer.setValidateCertEnabled(validateCertEnabled);
    }

    public void addCacheDelay(int cacheDelay) {
        this.httpServerChannelInitializer.setCacheDelay(cacheDelay);
    }

    public void addCacheSize(int cacheSize) {
        this.httpServerChannelInitializer.setCacheSize(cacheSize);
    }

    public void addOcspStapling(boolean ocspStapling) {
        this.httpServerChannelInitializer.setOcspStaplingEnabled(ocspStapling);
    }

    public void addChunkingBehaviour(ChunkConfig chunkConfig) {
        this.httpServerChannelInitializer.setChunkingConfig(chunkConfig);
    }

    public void addKeepAliveBehaviour(KeepAliveConfig keepAliveConfig) {
        this.httpServerChannelInitializer.setKeepAliveConfig(keepAliveConfig);
    }

    public void addServerHeader(String serverName) {
        this.httpServerChannelInitializer.setServerName(serverName);
    }

    public void setPipeliningEnabled(boolean pipeliningEnabled) {
        this.httpServerChannelInitializer.setPipeliningEnabled(pipeliningEnabled);
    }

    public void setPipeliningLimit(long pipeliningLimit) {
        this.httpServerChannelInitializer.setPipeliningLimit(pipeliningLimit);
    }

    public void setPipeliningThreadGroup(EventExecutorGroup pipeliningGroup) {
        this.httpServerChannelInitializer.setPipeliningThreadGroup(pipeliningGroup);
    }

    public void setWebSocketCompressionEnabled(boolean webSocketCompressionEnabled) {
        this.httpServerChannelInitializer.setWebSocketCompressionEnabled(webSocketCompressionEnabled);
    }

    class HttpServerConnector
    implements ServerConnector {
        private final Logger log = LoggerFactory.getLogger(HttpServerConnector.class);
        private ChannelFuture channelFuture;
        private ServerConnectorFuture serverConnectorFuture;
        private String host;
        private int port;
        private String connectorID;

        HttpServerConnector(String id, String host, int port) {
            this.host = host;
            this.port = port;
            this.connectorID = id;
            ServerConnectorBootstrap.this.httpServerChannelInitializer.setInterfaceId(id);
        }

        @Override
        public ServerConnectorFuture start() {
            this.channelFuture = this.bindInterface();
            this.serverConnectorFuture = new HttpWsServerConnectorFuture(this.channelFuture, ServerConnectorBootstrap.this.allChannels);
            this.channelFuture.addListener(future -> {
                if (future.isSuccess()) {
                    this.log.info("HTTP(S) Interface starting on host {} and port {}", (Object)this.getHost(), (Object)this.getPort());
                    this.serverConnectorFuture.notifyPortBindingEvent(this.connectorID, ServerConnectorBootstrap.this.isHttps);
                } else {
                    this.serverConnectorFuture.notifyPortBindingError(future.cause());
                }
            });
            ServerConnectorBootstrap.this.httpServerChannelInitializer.setServerConnectorFuture(this.serverConnectorFuture);
            return this.serverConnectorFuture;
        }

        @Override
        public boolean stop() {
            boolean connectorStopped = false;
            try {
                connectorStopped = this.unBindInterface();
                if (connectorStopped) {
                    this.serverConnectorFuture.notifyPortUnbindingEvent(this.connectorID, ServerConnectorBootstrap.this.isHttps);
                }
            }
            catch (InterruptedException e) {
                this.log.error("Couldn't close the port", (Throwable)e);
                return false;
            }
            catch (ServerConnectorException e) {
                this.log.error("Error in notifying life cycle event listener", (Throwable)e);
            }
            return connectorStopped;
        }

        @Override
        public String getConnectorID() {
            return this.connectorID;
        }

        private ChannelFuture getChannelFuture() {
            return this.channelFuture;
        }

        public String toString() {
            return this.host + "-" + this.port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        private ChannelFuture bindInterface() {
            if (!ServerConnectorBootstrap.this.initialized) {
                this.log.error("ServerConnectorBootstrap is not initialized");
                return null;
            }
            return ServerConnectorBootstrap.this.serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.getHost(), this.getPort()));
        }

        private boolean unBindInterface() throws InterruptedException {
            if (!ServerConnectorBootstrap.this.initialized) {
                this.log.error("ServerConnectorBootstrap is not initialized");
                return false;
            }
            ChannelFuture future = this.getChannelFuture();
            if (future != null) {
                future.channel().close().sync();
                this.log.info("HttpConnectorListener stopped listening on host {} and port {}", (Object)this.getHost(), (Object)this.getPort());
                return true;
            }
            return false;
        }
    }
}

