/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.syntaxapicallsgen.formatter;

import io.ballerina.syntaxapicallsgen.config.SyntaxApiCallsGenConfig;
import io.ballerina.syntaxapicallsgen.formatter.DefaultFormatter;
import io.ballerina.syntaxapicallsgen.formatter.NoFormatter;
import io.ballerina.syntaxapicallsgen.formatter.TemplateFormatter;
import io.ballerina.syntaxapicallsgen.formatter.VariableFormatter;
import io.ballerina.syntaxapicallsgen.segment.Segment;
import java.io.IOException;

public abstract class SegmentFormatter {
    public static SegmentFormatter getFormatter(SyntaxApiCallsGenConfig config) throws IOException {
        if (config.useTemplate()) {
            return TemplateFormatter.fromConfig(config);
        }
        return SegmentFormatter.getInternalFormatter(config);
    }

    protected static SegmentFormatter getInternalFormatter(SyntaxApiCallsGenConfig config) {
        return switch (config.formatter()) {
            case SyntaxApiCallsGenConfig.Formatter.NONE -> new NoFormatter();
            case SyntaxApiCallsGenConfig.Formatter.VARIABLE -> new VariableFormatter();
            default -> new DefaultFormatter();
        };
    }

    public abstract String format(Segment var1);
}

