/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.syntaxapicallsgen.formatter;

import io.ballerina.syntaxapicallsgen.config.SyntaxApiCallsGenConfig;
import io.ballerina.syntaxapicallsgen.formatter.SegmentFormatter;
import io.ballerina.syntaxapicallsgen.segment.Segment;
import java.io.IOException;

public class TemplateFormatter
extends SegmentFormatter {
    private static final String TAB_CHAR = "    ";
    private final SegmentFormatter baseFormatter;
    private final String baseTemplate;
    private final int indent;

    public TemplateFormatter(SegmentFormatter baseFormatter, String baseTemplate, int indent) {
        this.baseFormatter = baseFormatter;
        this.baseTemplate = baseTemplate;
        this.indent = indent;
    }

    public static TemplateFormatter fromConfig(SyntaxApiCallsGenConfig config) throws IOException {
        String template = config.readTemplateFile();
        int indent = config.formatterTabStart();
        return new TemplateFormatter(SegmentFormatter.getInternalFormatter(config), template, indent);
    }

    @Override
    public String format(Segment segment) {
        String nodeString = this.baseFormatter.format(segment);
        CharSequence[] lines = nodeString.split(System.lineSeparator());
        String indentedLines = String.join((CharSequence)(System.lineSeparator() + TAB_CHAR.repeat(this.indent)), lines);
        return String.format(this.baseTemplate, indentedLines);
    }
}

