/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.syntaxapicallsgen.segment;

import io.ballerina.syntaxapicallsgen.segment.Segment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class NodeFactorySegment
extends Segment
implements Iterable<Segment> {
    private static final int CREATE_PREFIX_LENGTH = 6;
    private static final String NODE_FACTORY_PREFIX = "NodeFactory.";
    private static final String GENERIC_OPEN_SIGN = "<";
    private static final String GENERIC_CLOSE_SIGN = ">";
    private static final String PARAM_OPEN_SIGN = "(";
    private static final String PARAM_SEP_SIGN = ",";
    private static final String PARAM_CLOSE_SIGN = ")";
    private final boolean isMinutiae;
    private final String methodName;
    protected final String genericType;
    private final List<Segment> parameters;

    public NodeFactorySegment(String methodName, String genericType) {
        this.methodName = methodName;
        this.parameters = new ArrayList<Segment>();
        this.genericType = genericType;
        this.isMinutiae = false;
    }

    public NodeFactorySegment(String methodName) {
        this.methodName = methodName;
        this.parameters = new ArrayList<Segment>();
        this.genericType = null;
        this.isMinutiae = false;
    }

    public NodeFactorySegment(String methodName, boolean isMinutiae) {
        this.methodName = methodName;
        this.parameters = new ArrayList<Segment>();
        this.genericType = null;
        this.isMinutiae = isMinutiae;
    }

    public void addParameter(Segment parameter) {
        this.parameters.add(parameter);
    }

    @Override
    public StringBuilder stringBuilder() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(NODE_FACTORY_PREFIX).append(this.getMethodName()).append(PARAM_OPEN_SIGN);
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(PARAM_SEP_SIGN);
            }
            stringBuilder.append((CharSequence)this.parameters.get(i).stringBuilder());
        }
        stringBuilder.append(PARAM_CLOSE_SIGN);
        return stringBuilder;
    }

    @Override
    public Iterator<Segment> iterator() {
        return Objects.requireNonNull(this.parameters.iterator());
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getType() {
        return this.methodName.substring(6);
    }

    public boolean isMinutiae() {
        return this.isMinutiae;
    }

    public String getGenericType() {
        if (this.genericType == null) {
            return "";
        }
        return GENERIC_OPEN_SIGN + this.genericType + GENERIC_CLOSE_SIGN;
    }

    public NodeFactorySegment createCopy() {
        return new NodeFactorySegment(this.methodName, this.genericType);
    }
}

