/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.syntaxapicallsgen.segment.factories;

import io.ballerina.compiler.syntax.tree.ChildNodeEntry;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.syntaxapicallsgen.segment.NodeFactorySegment;
import io.ballerina.syntaxapicallsgen.segment.Segment;
import io.ballerina.syntaxapicallsgen.segment.factories.NodeSegmentFactory;
import io.ballerina.syntaxapicallsgen.segment.factories.SegmentFactory;
import io.ballerina.syntaxapicallsgen.segment.factories.cache.ChildNamesCache;
import io.ballerina.syntaxapicallsgen.segment.factories.cache.NodeFactoryMethodCache;
import io.ballerina.syntaxapicallsgen.segment.factories.cache.NodeFactoryMethodReference;
import java.util.ArrayList;
import java.util.List;

public class NonTerminalSegmentFactory {
    private static final String CREATE_SEP_NODE_LIST_METHOD_NAME = "createSeparatedNodeList";
    private static final String CREATE_NODE_LIST_METHOD_NAME = "createNodeList";
    private static final String CREATE_METHOD_PREFIX = "create";
    private final ChildNamesCache childNamesCache;
    private final NodeFactoryMethodCache methodCache;
    private final NodeSegmentFactory nodeSegmentFactory;

    public NonTerminalSegmentFactory(NodeSegmentFactory nodeSegmentFactory, ChildNamesCache childNamesCache, NodeFactoryMethodCache methodCache) {
        this.nodeSegmentFactory = nodeSegmentFactory;
        this.childNamesCache = childNamesCache;
        this.methodCache = methodCache;
    }

    public Segment createNonTerminalSegment(NonTerminalNode node) {
        NodeFactoryMethodReference method = this.getNonTerminalNodeProcessMethod(node);
        NodeFactorySegment root = method.toSegment();
        List<String> parameterName = this.childNamesCache.getChildNames(node.getClass().getSimpleName());
        if (method.requiresSyntaxKind()) {
            root.addParameter(SegmentFactory.createSyntaxKindSegment(node.kind()));
        }
        ArrayList childNodeEntries = new ArrayList(node.childEntries());
        int childNodeEntriesIndex = 0;
        for (int i = 0; i < parameterName.size(); ++i) {
            ChildNodeEntry childNodeEntry;
            String childName = parameterName.get(i);
            if (childNodeEntriesIndex < childNodeEntries.size() && (childNodeEntry = (ChildNodeEntry)childNodeEntries.get(childNodeEntriesIndex)).name().equals(childName)) {
                ++childNodeEntriesIndex;
                root.addParameter(this.createNodeOrNodeListSegment(childNodeEntry, method, i));
                continue;
            }
            root.addParameter(SegmentFactory.createNullSegment());
        }
        return root;
    }

    private Segment createNodeOrNodeListSegment(ChildNodeEntry nodeEntry, NodeFactoryMethodReference method, int paramIndex) {
        if (nodeEntry.isList()) {
            return this.createNodeListSegment((NodeList<Node>)nodeEntry.nodeList(), method, paramIndex);
        }
        if (nodeEntry.node().isPresent()) {
            Node childNode = (Node)nodeEntry.node().get();
            return this.nodeSegmentFactory.createNodeSegment(childNode);
        }
        return SegmentFactory.createNullSegment();
    }

    private Segment createNodeListSegment(NodeList<Node> nodes, NodeFactoryMethodReference method, int paramIndex) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        nodes.stream().filter(node -> !node.isMissing()).forEach(node -> segments.add(this.nodeSegmentFactory.createNodeSegment((Node)node)));
        String genericType = method.getParameterGeneric(paramIndex);
        String nodeListMethodName = method.getParameterType(paramIndex) == SeparatedNodeList.class ? CREATE_SEP_NODE_LIST_METHOD_NAME : CREATE_NODE_LIST_METHOD_NAME;
        NodeFactorySegment root = SegmentFactory.createNodeFactorySegment(nodeListMethodName, genericType);
        segments.forEach(root::addParameter);
        return root;
    }

    private NodeFactoryMethodReference getNonTerminalNodeProcessMethod(NonTerminalNode node) {
        return this.methodCache.getMethod(CREATE_METHOD_PREFIX + node.getClass().getSimpleName());
    }
}

