/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.parser;

import io.ballerina.lib.data.yaml.common.Types;
import io.ballerina.lib.data.yaml.parser.ParserUtils;
import io.ballerina.lib.data.yaml.parser.YamlParser;
import io.ballerina.lib.data.yaml.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.yaml.utils.DiagnosticLog;
import io.ballerina.lib.data.yaml.utils.TagResolutionUtils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.FiniteType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import org.ballerinalang.langlib.value.CloneReadOnly;

public class Values {
    private static final List<Integer> TYPE_PRIORITY_ORDER = List.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(14), Integer.valueOf(6), Integer.valueOf(15), Integer.valueOf(5));
    private static final List<Type> BASIC_JSON_MEMBER_TYPES = List.of(PredefinedTypes.TYPE_NULL, PredefinedTypes.TYPE_BOOLEAN, PredefinedTypes.TYPE_INT, PredefinedTypes.TYPE_FLOAT, PredefinedTypes.TYPE_DECIMAL, PredefinedTypes.TYPE_STRING);
    private static final UnionType JSON_TYPE_WITH_BASIC_TYPES = TypeCreator.createUnionType(BASIC_JSON_MEMBER_TYPES);
    public static final MapType JSON_MAP_TYPE = TypeCreator.createMapType((Type)PredefinedTypes.TYPE_JSON);
    public static final MapType ANYDATA_MAP_TYPE = TypeCreator.createMapType((Type)PredefinedTypes.TYPE_ANYDATA);
    public static final String NULL_VALUE = "null";
    public static final Integer BBYTE_MIN_VALUE = 0;
    public static final Integer BBYTE_MAX_VALUE = 255;
    public static final Integer SIGNED32_MAX_VALUE = Integer.MAX_VALUE;
    public static final Integer SIGNED32_MIN_VALUE = Integer.MIN_VALUE;
    public static final Integer SIGNED16_MAX_VALUE = Short.MAX_VALUE;
    public static final Integer SIGNED16_MIN_VALUE = Short.MIN_VALUE;
    public static final Integer SIGNED8_MAX_VALUE = 127;
    public static final Integer SIGNED8_MIN_VALUE = -128;
    public static final Long UNSIGNED32_MAX_VALUE = 0xFFFFFFFFL;
    public static final Integer UNSIGNED16_MAX_VALUE = 65535;
    public static final Integer UNSIGNED8_MAX_VALUE = 255;

    private Values() {
    }

    static BMap<BString, Object> initRootMapValue(YamlParser.ComposerState state) {
        state.rootValueInitialized = true;
        Type expectedType = state.expectedTypes.peek();
        state.parserContexts.push(YamlParser.ParserContext.MAP);
        switch (expectedType.getTag()) {
            case 24: {
                return ValueCreator.createRecordValue((Module)expectedType.getPackage(), (String)expectedType.getName());
            }
            case 27: {
                return ValueCreator.createMapValue((MapType)((MapType)expectedType));
            }
            case 15: {
                return ValueCreator.createMapValue((MapType)JSON_MAP_TYPE);
            }
            case 23: {
                return ValueCreator.createMapValue((MapType)ANYDATA_MAP_TYPE);
            }
            case 33: {
                state.parserContexts.push(YamlParser.ParserContext.MAP);
                ++state.unionDepth;
                state.fieldNameHierarchy.push(new Stack());
                return ValueCreator.createMapValue((MapType)JSON_MAP_TYPE);
            }
        }
        throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, expectedType, "map type");
    }

    static Object initRootArrayValue(YamlParser.ComposerState state) {
        state.rootValueInitialized = true;
        state.parserContexts.push(YamlParser.ParserContext.ARRAY);
        Type expType = state.expectedTypes.peek();
        if (expType.getTag() == 15 || expType.getTag() == 23 || expType.getTag() == 33) {
            state.arrayIndexes.push(0);
        }
        return Values.initArrayValue(state, expType);
    }

    static BArray initArrayValue(YamlParser.ComposerState state, Type expectedType) {
        switch (expectedType.getTag()) {
            case 44: {
                return ValueCreator.createTupleValue((TupleType)((TupleType)expectedType));
            }
            case 32: {
                return ValueCreator.createArrayValue((ArrayType)((ArrayType)expectedType));
            }
            case 15: {
                return ValueCreator.createArrayValue((ArrayType)PredefinedTypes.TYPE_JSON_ARRAY);
            }
            case 23: {
                return ValueCreator.createArrayValue((ArrayType)PredefinedTypes.TYPE_ANYDATA_ARRAY);
            }
            case 33: {
                ++state.unionDepth;
                return ValueCreator.createArrayValue((ArrayType)PredefinedTypes.TYPE_JSON_ARRAY);
            }
        }
        throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, expectedType, "list type");
    }

    static void handleFieldName(String jsonFieldName, YamlParser.ComposerState state) {
        if (state.jsonFieldDepth == 0 && state.unionDepth == 0) {
            Type fieldType;
            Field currentField = state.visitedFieldHierarchy.peek().get(jsonFieldName);
            if (currentField == null) {
                currentField = state.fieldHierarchy.peek().remove(jsonFieldName);
            }
            state.currentField = currentField;
            if (currentField == null) {
                fieldType = state.restType.peek();
            } else {
                jsonFieldName = currentField.getFieldName();
                fieldType = currentField.getFieldType();
                state.visitedFieldHierarchy.peek().put(jsonFieldName, currentField);
            }
            state.expectedTypes.push(fieldType);
            if (!state.allowDataProjection && fieldType == null) {
                throw DiagnosticLog.error(DiagnosticErrorCode.UNDEFINED_FIELD, jsonFieldName);
            }
        } else if (state.expectedTypes.peek() == null) {
            state.currentField = null;
            state.expectedTypes.push(null);
        }
        state.fieldNameHierarchy.peek().push(jsonFieldName);
    }

    static Object convertAndUpdateCurrentValueNode(YamlParser.ComposerState sm, String value, Type type) {
        if (sm.nilAsOptionalField && !sm.expectedTypes.peek().isNilable() && value.equals(NULL_VALUE) && sm.currentField != null && SymbolFlags.isFlagOn((long)sm.currentField.getFlags(), (long)4096L)) {
            return sm.currentYamlNode;
        }
        Object currentYaml = sm.currentYamlNode;
        Object convertedValue = Values.convertToExpectedType(StringUtils.fromString((String)value), type, sm.schema);
        if (convertedValue instanceof BError) {
            if (sm.currentField != null) {
                throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_VALUE_FOR_FIELD, value, type, Values.getCurrentFieldPath(sm));
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, type, value);
        }
        return Values.updateCurrentValueNode(sm, currentYaml, convertedValue);
    }

    static Object updateCurrentValueNode(YamlParser.ComposerState sm, Object currentYaml, Object convertedValue) {
        Type currentJsonNodeType = TypeUtils.getType((Object)currentYaml);
        switch (currentJsonNodeType.getTag()) {
            case 24: 
            case 27: {
                BString fieldName = StringUtils.fromString((String)sm.fieldNameHierarchy.peek().pop());
                if (fieldName == null) {
                    fieldName = StringUtils.fromString((String)NULL_VALUE);
                }
                ((BMap)currentYaml).put((Object)fieldName, convertedValue);
                return currentYaml;
            }
            case 32: {
                ArrayType arrayType = (ArrayType)currentJsonNodeType;
                if (arrayType.getState() == ArrayType.ArrayState.CLOSED && arrayType.getSize() <= sm.arrayIndexes.peek()) {
                    return currentYaml;
                }
                ((BArray)currentYaml).add((long)sm.arrayIndexes.peek().intValue(), convertedValue);
                return currentYaml;
            }
            case 44: {
                ((BArray)currentYaml).add((long)sm.arrayIndexes.peek().intValue(), convertedValue);
                return currentYaml;
            }
        }
        return convertedValue;
    }

    private static String getCurrentFieldPath(YamlParser.ComposerState sm) {
        Iterator itr = sm.fieldNameHierarchy.iterator();
        StringBuilder result = new StringBuilder(itr.hasNext() ? (String)((Stack)itr.next()).peek() : "");
        while (itr.hasNext()) {
            result.append(".").append((String)((Stack)itr.next()).peek());
        }
        return result.toString();
    }

    private static Object convertToExpectedType(BString value, Type type, Types.YAMLSchema schema) {
        switch (type.getTag()) {
            case 13: {
                if (value.length() != 1) {
                    return DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, type, value);
                }
                return value;
            }
            case 46: {
                return ((FiniteType)type).getValueSpace().stream().filter(finiteValue -> !(Values.convertToSingletonValue(value.getValue(), finiteValue, schema) instanceof BError)).findFirst().orElseGet(() -> DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, type, value));
            }
            case 53: {
                return Values.convertToExpectedType(value, TypeUtils.getReferredType((Type)type), schema);
            }
        }
        return Values.fromStringWithType(value, type, schema);
    }

    private static Optional<BMap<BString, Object>> initNewMapValue(YamlParser.ComposerState state, Type expType) {
        YamlParser.ParserContext parentContext = state.parserContexts.peek();
        state.parserContexts.push(YamlParser.ParserContext.MAP);
        if (expType == null) {
            state.fieldNameHierarchy.push(new Stack());
            return Optional.empty();
        }
        if (state.currentYamlNode != null) {
            state.nodesStack.push(state.currentYamlNode);
        }
        BMap<BString, Object> nextMapValue = Values.checkTypeAndCreateMappingValue(state, expType, parentContext);
        return Optional.of(nextMapValue);
    }

    static BMap<BString, Object> checkTypeAndCreateMappingValue(YamlParser.ComposerState state, Type expType, YamlParser.ParserContext parentContext) {
        BMap nextMapValue;
        Type currentType = TypeUtils.getReferredType((Type)expType);
        switch (currentType.getTag()) {
            case 24: {
                RecordType recordType = (RecordType)currentType;
                nextMapValue = ValueCreator.createRecordValue((Module)expType.getPackage(), (String)expType.getName());
                state.updateFieldHierarchiesAndRestType(ParserUtils.getAllFieldsInRecord(recordType), recordType.getRestFieldType());
                break;
            }
            case 27: {
                nextMapValue = ValueCreator.createMapValue((MapType)((MapType)currentType));
                state.updateFieldHierarchiesAndRestType(new HashMap<String, Field>(), ((MapType)currentType).getConstrainedType());
                break;
            }
            case 15: {
                nextMapValue = ValueCreator.createMapValue((MapType)JSON_MAP_TYPE);
                state.updateFieldHierarchiesAndRestType(new HashMap<String, Field>(), currentType);
                break;
            }
            case 23: {
                nextMapValue = ValueCreator.createMapValue((MapType)ANYDATA_MAP_TYPE);
                state.updateFieldHierarchiesAndRestType(new HashMap<String, Field>(), currentType);
                break;
            }
            case 34: {
                Optional<Type> mutableType = Values.getMutableType((IntersectionType)currentType);
                if (mutableType.isEmpty()) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, currentType, "map type");
                }
                return Values.checkTypeAndCreateMappingValue(state, mutableType.get(), parentContext);
            }
            case 33: {
                nextMapValue = ValueCreator.createMapValue((MapType)JSON_MAP_TYPE);
                state.parserContexts.push(YamlParser.ParserContext.MAP);
                ++state.unionDepth;
                state.fieldNameHierarchy.push(new Stack());
                break;
            }
            default: {
                if (parentContext == YamlParser.ParserContext.ARRAY) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, currentType, "map type");
                }
                throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE_FOR_FIELD, Values.getCurrentFieldPath(state));
            }
        }
        return nextMapValue;
    }

    static Optional<Type> getMutableType(IntersectionType intersectionType) {
        for (Type constituentType : intersectionType.getConstituentTypes()) {
            if (constituentType.getTag() == 51) continue;
            return Optional.of(constituentType);
        }
        return Optional.empty();
    }

    static Type getMemberType(Type expectedType, int index, boolean allowDataProjection) {
        if (expectedType == null) {
            return null;
        }
        if ((expectedType = TypeUtils.getReferredType((Type)expectedType)).getTag() == 32) {
            ArrayType arrayType = (ArrayType)expectedType;
            if (arrayType.getState() == ArrayType.ArrayState.OPEN || arrayType.getState() == ArrayType.ArrayState.CLOSED && index < arrayType.getSize()) {
                return arrayType.getElementType();
            }
            if (!allowDataProjection) {
                throw DiagnosticLog.error(DiagnosticErrorCode.ARRAY_SIZE_MISMATCH, new Object[0]);
            }
            return null;
        }
        if (expectedType.getTag() == 44) {
            TupleType tupleType = (TupleType)expectedType;
            List tupleTypes = tupleType.getTupleTypes();
            if (tupleTypes.size() < index + 1) {
                Type restType = tupleType.getRestType();
                if (restType == null && !allowDataProjection) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.ARRAY_SIZE_MISMATCH, new Object[0]);
                }
                return restType;
            }
            return (Type)tupleTypes.get(index);
        }
        return expectedType;
    }

    public static Object fromStringWithType(BString string, Type expType, Types.YAMLSchema schema) {
        String value = string.getValue();
        return switch (expType.getTag()) {
            case 1 -> Values.stringToInt(value);
            case 2 -> Values.stringToByte(value);
            case 7 -> Values.stringToSigned8Int(value);
            case 9 -> Values.stringToSigned16Int(value);
            case 11 -> Values.stringToSigned32Int(value);
            case 8 -> Values.stringToUnsigned8Int(value);
            case 10 -> Values.stringToUnsigned16Int(value);
            case 12 -> Values.stringToUnsigned32Int(value);
            case 3 -> Values.stringToFloat(value);
            case 4 -> Values.stringToDecimal(value);
            case 13 -> Values.stringToChar(value);
            case 5 -> Values.stringToString(string, schema);
            case 6 -> Values.stringToBoolean(value);
            case 14 -> Values.stringToNull(value);
            case 46 -> Values.stringToFiniteType(value, (FiniteType)expType, schema);
            case 33 -> Values.stringToUnion(string, (UnionType)expType, schema);
            case 15, 23 -> Values.stringToUnion(string, JSON_TYPE_WITH_BASIC_TYPES, schema);
            case 53 -> Values.fromStringWithType(string, ((ReferenceType)expType).getReferredType(), schema);
            case 34 -> Values.fromStringWithType(string, ((IntersectionType)expType).getEffectiveType(), schema);
            default -> Values.returnError(value, expType.toString());
        };
    }

    private static Object stringToString(BString string, Types.YAMLSchema schema) {
        String value = string.getValue();
        if (schema == Types.YAMLSchema.JSON_SCHEMA ? value.equals(NULL_VALUE) || value.equals("true") || value.equals("false") : schema == Types.YAMLSchema.CORE_SCHEMA && (TagResolutionUtils.isCoreSchemaNull(value) || TagResolutionUtils.isCoreSchemaBoolean(value))) {
            return Values.returnError(value, PredefinedTypes.TYPE_STRING.toString());
        }
        return string;
    }

    private static Object stringToFiniteType(String value, FiniteType finiteType, Types.YAMLSchema schema) {
        return finiteType.getValueSpace().stream().filter(finiteValue -> !(Values.convertToSingletonValue(value, finiteValue, schema) instanceof BError)).findFirst().orElseGet(() -> Values.returnError(value, finiteType.toString()));
    }

    private static Object convertToSingletonValue(String str, Object singletonValue, Types.YAMLSchema schema) {
        String singletonStr = String.valueOf(singletonValue);
        if (str.equals(singletonStr)) {
            BString value = StringUtils.fromString((String)str);
            Type expType = TypeUtils.getType((Object)singletonValue);
            return Values.fromStringWithType(value, expType, schema);
        }
        return Values.returnError(str, singletonStr);
    }

    public static BString convertValueToBString(Object value) {
        if (value == null) {
            return StringUtils.fromString((String)NULL_VALUE);
        }
        if (value instanceof BString) {
            return (BString)value;
        }
        if (value instanceof Long || value instanceof String || value instanceof Integer || value instanceof BDecimal || value instanceof Double || value instanceof Boolean) {
            return StringUtils.fromString((String)String.valueOf(value));
        }
        throw new RuntimeException("cannot convert to BString");
    }

    private static int stringToByte(String value) throws NumberFormatException {
        int intValue = Integer.parseInt(value);
        if (!Values.isByteLiteral(intValue)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_BYTE, value);
        }
        return intValue;
    }

    private static Long stringToInt(String value) throws NumberFormatException {
        return Long.parseLong(value);
    }

    private static Double stringToFloat(String value) throws NumberFormatException {
        if (Values.hasFloatOrDecimalLiteralSuffix(value)) {
            throw new NumberFormatException();
        }
        return Double.parseDouble(value);
    }

    private static BDecimal stringToDecimal(String value) throws NumberFormatException {
        return ValueCreator.createDecimalValue((String)value);
    }

    private static long stringToSigned8Int(String value) throws NumberFormatException {
        long intValue = Long.parseLong(value);
        if (!Values.isSigned8LiteralValue(intValue)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_INT_SIGNED_8, value);
        }
        return intValue;
    }

    private static long stringToSigned16Int(String value) throws NumberFormatException {
        long intValue = Long.parseLong(value);
        if (!Values.isSigned16LiteralValue(intValue)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_INT_SIGNED_16, value);
        }
        return intValue;
    }

    private static long stringToSigned32Int(String value) throws NumberFormatException {
        long intValue = Long.parseLong(value);
        if (!Values.isSigned32LiteralValue(intValue)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_INT_SIGNED_32, value);
        }
        return intValue;
    }

    private static long stringToUnsigned8Int(String value) throws NumberFormatException {
        long intValue = Long.parseLong(value);
        if (!Values.isUnsigned8LiteralValue(intValue)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_INT_UNSIGNED_8, value);
        }
        return intValue;
    }

    private static long stringToUnsigned16Int(String value) throws NumberFormatException {
        long intValue = Long.parseLong(value);
        if (!Values.isUnsigned16LiteralValue(intValue)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_INT_UNSIGNED_16, value);
        }
        return intValue;
    }

    private static long stringToUnsigned32Int(String value) throws NumberFormatException {
        long intValue = Long.parseLong(value);
        if (!Values.isUnsigned32LiteralValue(intValue)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_INT_UNSIGNED_32, value);
        }
        return intValue;
    }

    private static Object stringToBoolean(String value) throws NumberFormatException {
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        return Values.returnError(value, "boolean");
    }

    private static Object stringToNull(String value) throws NumberFormatException {
        if (value.equals(NULL_VALUE)) {
            return null;
        }
        return Values.returnError(value, "()");
    }

    private static BString stringToChar(String value) throws NumberFormatException {
        if (!Values.isCharLiteralValue(value)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_STRING_CHAR, value);
        }
        return StringUtils.fromString((String)value);
    }

    private static Exception returnError(String string, String expType) {
        return DiagnosticLog.error(DiagnosticErrorCode.CANNOT_CONVERT_TO_EXPECTED_TYPE, PredefinedTypes.TYPE_STRING.getName(), string, expType);
    }

    static void updateNextMapValue(YamlParser.ComposerState state) {
        Type expType = state.expectedTypes.peek();
        Optional<BMap<BString, Object>> nextMap = Values.initNewMapValue(state, expType);
        if (nextMap.isPresent()) {
            state.currentYamlNode = nextMap.get();
        } else {
            ++state.jsonFieldDepth;
        }
    }

    static void updateExpectedType(YamlParser.ComposerState state) {
        if (state.unionDepth > 0) {
            return;
        }
        state.expectedTypes.push(Values.getMemberType(state.expectedTypes.peek(), state.arrayIndexes.peek(), state.allowDataProjection));
    }

    static void updateNextMapValueBasedOnExpType(YamlParser.ComposerState state) {
        Values.updateNextMapValue(state);
    }

    static void updateNextArrayValueBasedOnExpType(YamlParser.ComposerState state) {
        Values.updateNextArrayValue(state);
    }

    static void updateNextArrayValue(YamlParser.ComposerState state) {
        state.arrayIndexes.push(0);
        Optional<BArray> nextArray = Values.initNewArrayValue(state);
        nextArray.ifPresent(array -> {
            state.currentYamlNode = array;
        });
    }

    static Optional<BArray> initNewArrayValue(YamlParser.ComposerState state) {
        state.parserContexts.push(YamlParser.ParserContext.ARRAY);
        if (state.expectedTypes.peek() == null) {
            return Optional.empty();
        }
        Object currentYamlNode = state.currentYamlNode;
        Type expType = TypeUtils.getReferredType((Type)state.expectedTypes.peek());
        if (expType.getTag() == 34) {
            Optional<Type> type = Values.getMutableType((IntersectionType)expType);
            if (type.isEmpty()) {
                throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, expType, "array type");
            }
            expType = type.get();
        }
        BArray nextArrValue = Values.initArrayValue(state, expType);
        if (currentYamlNode == null) {
            return Optional.ofNullable(nextArrValue);
        }
        state.nodesStack.push(currentYamlNode);
        return Optional.ofNullable(nextArrValue);
    }

    private static Object stringToUnion(BString string, UnionType expType, Types.YAMLSchema schema) throws NumberFormatException {
        ArrayList<Type> memberTypes = new ArrayList<Type>(expType.getMemberTypes());
        memberTypes.sort(Comparator.comparingInt(t -> {
            int index = TYPE_PRIORITY_ORDER.indexOf(TypeUtils.getReferredType((Type)t).getTag());
            return index == -1 ? Integer.MAX_VALUE : index;
        }));
        for (Type memberType : memberTypes) {
            try {
                Object result = Values.fromStringWithType(string, memberType, schema);
                if (result instanceof BError) continue;
                return result;
            }
            catch (Exception exception) {
            }
        }
        return Values.returnError(string.getValue(), expType.toString());
    }

    public static Object constructReadOnlyValue(Object value) {
        return CloneReadOnly.cloneReadOnly((Object)value);
    }

    private static boolean hasFloatOrDecimalLiteralSuffix(String value) {
        int length = value.length();
        if (length == 0) {
            return false;
        }
        switch (value.charAt(length - 1)) {
            case 'D': 
            case 'F': 
            case 'd': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    private static boolean isByteLiteral(long longValue) {
        return longValue >= (long)BBYTE_MIN_VALUE.intValue() && longValue <= (long)BBYTE_MAX_VALUE.intValue();
    }

    private static boolean isSigned32LiteralValue(Long longObject) {
        return longObject >= (long)SIGNED32_MIN_VALUE.intValue() && longObject <= (long)SIGNED32_MAX_VALUE.intValue();
    }

    private static boolean isSigned16LiteralValue(Long longObject) {
        return longObject.intValue() >= SIGNED16_MIN_VALUE && longObject.intValue() <= SIGNED16_MAX_VALUE;
    }

    private static boolean isSigned8LiteralValue(Long longObject) {
        return longObject.intValue() >= SIGNED8_MIN_VALUE && longObject.intValue() <= SIGNED8_MAX_VALUE;
    }

    private static boolean isUnsigned32LiteralValue(Long longObject) {
        return longObject >= 0L && longObject <= UNSIGNED32_MAX_VALUE;
    }

    private static boolean isUnsigned16LiteralValue(Long longObject) {
        return longObject.intValue() >= 0 && longObject.intValue() <= UNSIGNED16_MAX_VALUE;
    }

    private static boolean isUnsigned8LiteralValue(Long longObject) {
        return longObject.intValue() >= 0 && longObject.intValue() <= UNSIGNED8_MAX_VALUE;
    }

    private static boolean isCharLiteralValue(String value) {
        return value.codePoints().count() == 1L;
    }
}

