/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.parser;

import io.ballerina.lib.data.yaml.common.Types;
import io.ballerina.lib.data.yaml.common.YamlEvent;
import io.ballerina.lib.data.yaml.lexer.IndentUtils;
import io.ballerina.lib.data.yaml.lexer.LexerState;
import io.ballerina.lib.data.yaml.lexer.Token;
import io.ballerina.lib.data.yaml.lexer.YamlLexer;
import io.ballerina.lib.data.yaml.parser.Directive;
import io.ballerina.lib.data.yaml.parser.ParserState;
import io.ballerina.lib.data.yaml.parser.ParserUtils;
import io.ballerina.lib.data.yaml.parser.Values;
import io.ballerina.lib.data.yaml.utils.Constants;
import io.ballerina.lib.data.yaml.utils.DataUtils;
import io.ballerina.lib.data.yaml.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.yaml.utils.DiagnosticLog;
import io.ballerina.lib.data.yaml.utils.Error;
import io.ballerina.lib.data.yaml.utils.JsonTraverse;
import io.ballerina.lib.data.yaml.utils.OptionsUtils;
import io.ballerina.lib.data.yaml.utils.TagResolutionUtils;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.JsonType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.ballerinalang.langlib.value.CloneReadOnly;

public class YamlParser {
    private YamlParser() {
    }

    public static Object compose(Reader reader, BMap<BString, Object> options, BTypedesc typed) throws BError {
        OptionsUtils.ReadConfig readConfig = OptionsUtils.resolveReadConfig(options);
        ComposerState composerState = new ComposerState(new ParserState(reader), readConfig);
        composerState.handleExpectedType(typed.getDescribingType());
        try {
            Object result;
            Object object = result = composerState.isPossibleStream ? YamlParser.composeStream(composerState) : YamlParser.composeDocument(composerState);
            if (result instanceof BError) {
                return result;
            }
            return DataUtils.validateConstraints(result, typed, (Boolean)options.get((Object)Constants.ENABLE_CONSTRAINT_VALIDATION));
        }
        catch (Error.YamlParserException e) {
            return DiagnosticLog.error(DiagnosticErrorCode.YAML_PARSER_EXCEPTION, e.getMessage(), e.getLine(), e.getColumn());
        }
    }

    private static Object composeDocument(ComposerState state) throws Error.YamlParserException {
        return YamlParser.composeDocument(state, null);
    }

    private static Object composeDocument(ComposerState state, YamlEvent eventParam) throws Error.YamlParserException {
        YamlEvent event;
        YamlEvent yamlEvent = event = eventParam == null ? YamlParser.handleEvent(state, Types.DocumentType.ANY_DOCUMENT) : eventParam;
        if (event.getKind() == YamlEvent.EventKind.DOCUMENT_MARKER_EVENT && ((YamlEvent.DocumentMarkerEvent)event).isExplicit()) {
            event = YamlParser.handleEvent(state, Types.DocumentType.ANY_DOCUMENT);
        }
        Object output = YamlParser.composeNode(state, event, false);
        event = YamlParser.handleEvent(state, Types.DocumentType.BARE_DOCUMENT);
        if (ParserUtils.isStreamEndEvent(event)) {
            return YamlParser.handleOutput(state, output);
        }
        if (event.getKind() == YamlEvent.EventKind.DOCUMENT_MARKER_EVENT) {
            state.terminatedDocEvent = event;
            return YamlParser.handleOutput(state, output);
        }
        throw new Error.YamlParserException("there can only be one root event to a document", state.getLine(), state.getColumn());
    }

    private static Object composeStream(ComposerState state) throws Error.YamlParserException {
        YamlEvent event = YamlParser.handleEvent(state, Types.DocumentType.ANY_DOCUMENT);
        state.currentYamlNode = Values.initRootArrayValue(state);
        int prevUnionDepth = state.unionDepth;
        boolean isBeginWithStream = YamlParser.isBeginWithStream(state, event);
        boolean isTupleExpected = ((Type)state.expectedTypes.get(0)).getTag() == 44;
        boolean tupleOrArrayExpected = state.expectedTypes.size() == 2;
        boolean processFirstElement = false;
        if (!tupleOrArrayExpected && state.unionDepth == 1) {
            state.expectedTypes.push((Type)PredefinedTypes.TYPE_JSON);
            state.unionDepth = 0;
        }
        while (!ParserUtils.isStreamEndEvent(event)) {
            Object result;
            BArray bArray;
            Values.updateExpectedType(state);
            YamlParser.composeDocument(state, event);
            event = YamlParser.getNextYamlDocEvent(state);
            if (!isTupleExpected || !state.enableYamlStreamReorder) {
                state.updateIndexOfArrayElement();
            }
            if (!processFirstElement && state.expectedTypes.size() > 1) {
                Type elementType;
                state.expectedTypes.pop();
                BArray bArray2 = (BArray)state.currentYamlNode;
                if (ParserUtils.isStreamEndEvent(event) && !isBeginWithStream) {
                    --state.unionDepth;
                    Object result2 = state.verifyAndConvertToUnion(bArray2.getValues()[0]);
                    return YamlParser.handleOutput(state, result2);
                }
                processFirstElement = true;
                Type peekType = state.expectedTypes.peek();
                if (peekType.getTag() == 32) {
                    elementType = TypeUtils.getReferredType((Type)((ArrayType)peekType).getElementType());
                } else {
                    if (peekType.getTag() == 33) {
                        state.expectedTypes.add((Type)PredefinedTypes.TYPE_JSON);
                        continue;
                    }
                    TupleType tupleType = (TupleType)peekType;
                    if (state.enableYamlStreamReorder) {
                        state.dynamicTupleState = new DynamicTupleState(tupleType);
                    }
                    List tupleTypes = tupleType.getTupleTypes();
                    Type restType = tupleType.getRestType();
                    elementType = tupleTypes.size() > 0 ? (Type)tupleTypes.get(0) : restType;
                }
                if (isTupleExpected && state.enableYamlStreamReorder) {
                    Object result3;
                    DynamicTupleState dynamicTupleState = state.dynamicTupleState;
                    state.expectedTypes.add((Type)dynamicTupleState.tupleMembersUnion);
                    state.unionDepth = 0;
                    try {
                        result3 = state.verifyAndConvertToUnion(bArray2.getValues()[0]);
                    }
                    catch (Exception e) {
                        state.expectedTypes.pop();
                        state.currentYamlNode = Values.initRootArrayValue(state);
                        state.expectedTypes.add((Type)dynamicTupleState.tupleMembersUnion);
                        state.unionDepth = 1;
                        state.nodesStack.add(state.currentYamlNode);
                        state.currentYamlNode = bArray2;
                        continue;
                    }
                    state.expectedTypes.pop();
                    state.currentYamlNode = Values.initRootArrayValue(state);
                    dynamicTupleState.updateTupleMemberIndexTableAndAddToTuple(result3, (BArray)state.currentYamlNode);
                    dynamicTupleState.updateUnionType();
                    if (dynamicTupleState.isTupleValueCompleted() && !dynamicTupleState.canAddMoreRestMembers()) break;
                    state.expectedTypes.add((Type)dynamicTupleState.tupleMembersUnion);
                    state.unionDepth = 1;
                    state.nodesStack.add(state.currentYamlNode);
                    state.currentYamlNode = bArray2;
                    continue;
                }
                if (elementType.getTag() == 33) {
                    state.expectedTypes.add(elementType);
                    continue;
                }
                state.expectedTypes.push(elementType);
                state.unionDepth = 0;
                Object result4 = state.verifyAndConvertToUnion(bArray2.getValues()[0]);
                state.expectedTypes.pop();
                state.currentYamlNode = Values.initRootArrayValue(state);
                ((BArray)state.currentYamlNode).add(0L, result4);
                continue;
            }
            int peekTag = state.expectedTypes.peek().getTag();
            if (!(processFirstElement || peekTag != 23 && peekTag != 15)) {
                processFirstElement = true;
                bArray = (BArray)state.currentYamlNode;
                if (ParserUtils.isStreamEndEvent(event) && !isBeginWithStream) {
                    result = state.verifyAndConvertToUnion(bArray.getValues()[0]);
                    return YamlParser.handleOutput(state, result);
                }
            }
            if (!isTupleExpected || !state.enableYamlStreamReorder) continue;
            bArray = (BArray)state.currentYamlNode;
            state.expectedTypes.pop();
            state.expectedTypes.add((Type)state.dynamicTupleState.tupleMembersUnion);
            state.unionDepth = 0;
            try {
                result = state.verifyAndConvertToUnion(bArray.getValues()[0]);
            }
            catch (Exception e) {
                state.unionDepth = 1;
                continue;
            }
            state.expectedTypes.pop();
            state.currentYamlNode = state.nodesStack.pop();
            state.dynamicTupleState.updateTupleMemberIndexTableAndAddToTuple(result, (BArray)state.currentYamlNode);
            state.dynamicTupleState.updateUnionType();
            if (state.dynamicTupleState.isTupleValueCompleted() && !state.dynamicTupleState.canAddMoreRestMembers()) break;
            state.expectedTypes.add((Type)state.dynamicTupleState.tupleMembersUnion);
            state.unionDepth = 1;
            state.nodesStack.add(state.currentYamlNode);
            state.currentYamlNode = bArray;
        }
        if (state.enableYamlStreamReorder && state.dynamicTupleState != null && !state.dynamicTupleState.isTupleValueCompleted()) {
            throw DiagnosticLog.error(DiagnosticErrorCode.ARRAY_SIZE_MISMATCH, new Object[0]);
        }
        state.unionDepth = prevUnionDepth;
        if (state.unionDepth == 1) {
            --state.unionDepth;
            if (state.expectedTypes.size() > 1) {
                state.expectedTypes.pop();
            }
            if (isTupleExpected && state.dynamicTupleState != null && state.dynamicTupleState.canAddMoreRestMembers()) {
                state.currentYamlNode = state.nodesStack.pop();
            }
            return YamlParser.handleOutput(state, state.verifyAndConvertToUnion(state.currentYamlNode));
        }
        return YamlParser.handleOutput(state, state.currentYamlNode);
    }

    private static YamlEvent getNextYamlDocEvent(ComposerState state) throws Error.YamlParserException {
        YamlEvent event;
        if (state.terminatedDocEvent != null && state.terminatedDocEvent.getKind() == YamlEvent.EventKind.DOCUMENT_MARKER_EVENT) {
            if (((YamlEvent.DocumentMarkerEvent)state.terminatedDocEvent).isExplicit()) {
                event = state.terminatedDocEvent;
                state.terminatedDocEvent = null;
            } else {
                state.terminatedDocEvent = null;
                event = YamlParser.handleEvent(state, Types.DocumentType.ANY_DOCUMENT);
                while (event.getKind() == YamlEvent.EventKind.DOCUMENT_MARKER_EVENT && !((YamlEvent.DocumentMarkerEvent)event).isExplicit()) {
                    event = YamlParser.handleEvent(state, Types.DocumentType.ANY_DOCUMENT);
                }
            }
        } else {
            event = YamlParser.handleEvent(state, Types.DocumentType.ANY_DOCUMENT);
        }
        return event;
    }

    private static boolean isBeginWithStream(ComposerState state, YamlEvent event) {
        return event.getKind() == YamlEvent.EventKind.DOCUMENT_MARKER_EVENT && state.terminatedDocEvent != null && ((YamlEvent.DocumentMarkerEvent)state.terminatedDocEvent).isExplicit();
    }

    private static Object composeNode(ComposerState state, YamlEvent event, boolean mapOrSequenceScalar) throws Error.YamlParserException {
        YamlEvent.EventKind eventKind = event.getKind();
        if (eventKind == YamlEvent.EventKind.ALIAS_EVENT) {
            YamlEvent.AliasEvent aliasEvent = (YamlEvent.AliasEvent)event;
            Object alias = state.anchorBuffer.get(aliasEvent.getAlias());
            if (alias == null) {
                throw new Error.YamlParserException("anchor does not exist", state.getLine(), state.getColumn());
            }
            return alias;
        }
        if (eventKind == YamlEvent.EventKind.END_EVENT) {
            return null;
        }
        if (eventKind == YamlEvent.EventKind.DOCUMENT_MARKER_EVENT) {
            state.terminatedDocEvent = event;
            return null;
        }
        if (eventKind == YamlEvent.EventKind.START_EVENT) {
            YamlEvent.StartEvent startEvent = (YamlEvent.StartEvent)event;
            Object output = startEvent.getStartType() == Types.Collection.SEQUENCE ? YamlParser.castData(state, YamlParser.composeSequence(state, startEvent.isFlowStyle()), Types.FailSafeSchema.SEQUENCE, event.getTag()) : YamlParser.castData(state, YamlParser.composeMapping(state, startEvent.isFlowStyle(), startEvent.isImplicit()), Types.FailSafeSchema.MAPPING, event.getTag());
            YamlParser.checkAnchor(state, event, output);
            return state.currentYamlNode;
        }
        YamlEvent.ScalarEvent scalarEvent = (YamlEvent.ScalarEvent)event;
        Object output = YamlParser.castData(state, scalarEvent.getValue(), Types.FailSafeSchema.STRING, event.getTag());
        YamlParser.checkAnchor(state, event, output);
        if (mapOrSequenceScalar) {
            return output;
        }
        if (output == null || output instanceof Double || output instanceof Long || output instanceof Boolean) {
            state.currentYamlNode = Values.updateCurrentValueNode(state, state.currentYamlNode, output);
        } else {
            YamlParser.processValue(state, scalarEvent.getValue());
        }
        return state.currentYamlNode;
    }

    private static Object handleOutput(ComposerState state, Object output) {
        return state.expectedTypeIsReadonly ? Values.constructReadOnlyValue(output) : output;
    }

    private static void processValue(ComposerState state, String value) {
        JsonType expType;
        if (state.unionDepth > 0) {
            expType = PredefinedTypes.TYPE_JSON;
        } else {
            expType = state.expectedTypes.pop();
            if (expType == null) {
                return;
            }
        }
        state.currentYamlNode = Values.convertAndUpdateCurrentValueNode(state, value, (Type)expType);
    }

    public static Object composeSequence(ComposerState state, boolean flowStyle) throws Error.YamlParserException {
        boolean firstElement = true;
        Values.updateNextArrayValueBasedOnExpType(state);
        YamlEvent event = YamlParser.handleEvent(state, ParserUtils.ParserOption.EXPECT_SEQUENCE_VALUE);
        boolean terminated = false;
        while (!terminated) {
            if (event.getKind() == YamlEvent.EventKind.DOCUMENT_MARKER_EVENT) {
                state.terminatedDocEvent = event;
                if (!flowStyle) break;
                throw new Error.YamlParserException("unexpected event", state.getLine(), state.getColumn());
            }
            if (event.getKind() == YamlEvent.EventKind.END_EVENT) {
                YamlEvent.EndEvent endEvent = (YamlEvent.EndEvent)event;
                switch (endEvent.getEndType()) {
                    case MAPPING: {
                        throw new Error.YamlParserException("unexpected event", state.getLine(), state.getColumn());
                    }
                    case STREAM: {
                        if (!flowStyle) {
                            terminated = true;
                            break;
                        }
                        throw new Error.YamlParserException("unexpected event", state.getLine(), state.getColumn());
                    }
                    case SEQUENCE: {
                        terminated = true;
                    }
                }
            }
            if (terminated) continue;
            if (!firstElement) {
                state.updateIndexOfArrayElement();
            }
            firstElement = false;
            Values.updateExpectedType(state);
            Object value = YamlParser.composeNode(state, event, true);
            if (value instanceof String) {
                String scalarValue = (String)value;
                YamlParser.processValue(state, scalarValue);
            } else if (event.getKind() == YamlEvent.EventKind.ALIAS_EVENT) {
                state.nodesStack.push(state.currentYamlNode);
                state.currentYamlNode = state.verifyAndConvertToUnion(value);
                state.finalizeAnchorValueObject();
                state.expectedTypes.pop();
            } else if (value == null || value instanceof Double || value instanceof Long || value instanceof Boolean) {
                state.currentYamlNode = Values.updateCurrentValueNode(state, state.currentYamlNode, value);
            }
            event = YamlParser.handleEvent(state, ParserUtils.ParserOption.EXPECT_SEQUENCE_ENTRY);
        }
        Object tmpCurrentYaml = state.currentYamlNode;
        state.checkUnionAndFinalizeArrayObject();
        return tmpCurrentYaml;
    }

    public static Object composeMapping(ComposerState state, boolean flowStyle, boolean implicitMapping) throws Error.YamlParserException {
        if (!state.rootValueInitialized) {
            state.currentYamlNode = Values.initRootMapValue(state);
        } else {
            Values.updateNextMapValueBasedOnExpType(state);
        }
        HashSet<String> keys = new HashSet<String>();
        YamlEvent event = YamlParser.handleEvent(state, ParserUtils.ParserOption.EXPECT_MAP_KEY);
        boolean terminated = false;
        while (!terminated) {
            if (event.getKind() == YamlEvent.EventKind.DOCUMENT_MARKER_EVENT) {
                state.terminatedDocEvent = event;
                if (!flowStyle) break;
                throw new Error.YamlParserException("unexpected event", state.getLine(), state.getColumn());
            }
            if (event.getKind() == YamlEvent.EventKind.END_EVENT) {
                YamlEvent.EndEvent endEvent = (YamlEvent.EndEvent)event;
                switch (endEvent.getEndType()) {
                    case MAPPING: {
                        terminated = true;
                        break;
                    }
                    case SEQUENCE: {
                        throw new Error.YamlParserException("unexpected event", state.getLine(), state.getColumn());
                    }
                    default: {
                        if (!flowStyle) {
                            terminated = true;
                            break;
                        }
                        throw new Error.YamlParserException("unexpected event", state.getLine(), state.getColumn());
                    }
                }
                if (terminated) break;
            }
            if (event.getKind() == YamlEvent.EventKind.START_EVENT && !((YamlEvent.StartEvent)event).isFlowStyle()) {
                throw new RuntimeException("Cannot have nested mapping under a key-pair that is already assigned");
            }
            String key = (String)YamlParser.composeNode(state, event, true);
            if (!state.allowMapEntryRedefinition && !keys.add(key)) {
                throw new Error.YamlParserException("cannot have duplicate map entries for '${key.toString()}", state.getLine(), state.getColumn());
            }
            Values.handleFieldName(key, state);
            event = YamlParser.handleEvent(state, ParserUtils.ParserOption.EXPECT_MAP_VALUE);
            if (event.getKind() == YamlEvent.EventKind.END_EVENT) {
                YamlEvent.EndEvent endEvent = (YamlEvent.EndEvent)event;
                switch (endEvent.getEndType()) {
                    case MAPPING: {
                        terminated = true;
                        break;
                    }
                    case SEQUENCE: {
                        throw new Error.YamlParserException("unexpected event error", state.getLine(), state.getColumn());
                    }
                    default: {
                        if (!flowStyle) {
                            terminated = true;
                            break;
                        }
                        throw new Error.YamlParserException("unexpected event error", state.getLine(), state.getColumn());
                    }
                }
                if (terminated) {
                    break;
                }
            } else {
                Object value = YamlParser.composeNode(state, event, true);
                if (value instanceof String) {
                    String scalarValue = (String)value;
                    if (state.unionDepth > 0) {
                        expType = PredefinedTypes.TYPE_JSON;
                        state.currentYamlNode = Values.convertAndUpdateCurrentValueNode(state, scalarValue, (Type)expType);
                    } else {
                        expType = state.expectedTypes.pop();
                        if (expType == null && state.currentField == null) {
                            state.fieldNameHierarchy.peek().pop();
                        } else {
                            if (expType == null) break;
                            if (state.jsonFieldDepth > 0 || state.currentField != null) {
                                state.currentYamlNode = Values.convertAndUpdateCurrentValueNode(state, scalarValue, (Type)expType);
                            } else if (state.restType.peek() != null) {
                                try {
                                    state.currentYamlNode = Values.convertAndUpdateCurrentValueNode(state, scalarValue, (Type)expType);
                                }
                                catch (BError bError) {}
                            }
                        }
                    }
                } else if (event.getKind() == YamlEvent.EventKind.ALIAS_EVENT) {
                    state.nodesStack.push(state.currentYamlNode);
                    state.currentYamlNode = state.verifyAndConvertToUnion(value);
                    state.finalizeAnchorValueObject();
                    state.expectedTypes.pop();
                } else if (value == null || value instanceof Double || value instanceof Long || value instanceof Boolean) {
                    state.currentYamlNode = Values.updateCurrentValueNode(state, state.currentYamlNode, value);
                }
            }
            if (implicitMapping) break;
            event = YamlParser.handleEvent(state, ParserUtils.ParserOption.EXPECT_MAP_KEY);
        }
        Object tmpCurrentYaml = state.currentYamlNode;
        state.checkUnionAndFinalizeNonArrayObject();
        return tmpCurrentYaml;
    }

    public static void checkAnchor(ComposerState state, YamlEvent event, Object assignedValue) throws Error.YamlParserException {
        if (event.getAnchor() != null) {
            if (state.anchorBuffer.containsKey(event.getAnchor()) && !state.allowAnchorRedefinition) {
                throw new Error.YamlParserException("duplicate anchor definition", state.getLine(), state.getColumn());
            }
            state.anchorBuffer.put(event.getAnchor(), assignedValue);
        }
    }

    public static Object castData(ComposerState state, Object data, Types.FailSafeSchema kind, String tag) throws Error.YamlParserException {
        if (tag == null) {
            return data;
        }
        if (tag.equals("tag:yaml.org,2002:str") && kind == Types.FailSafeSchema.STRING) {
            return data.toString();
        }
        if (tag.equals("tag:yaml.org,2002:seq") && kind == Types.FailSafeSchema.SEQUENCE) {
            return data;
        }
        if (tag.equals("tag:yaml.org,2002:map") && kind == Types.FailSafeSchema.MAPPING) {
            return data;
        }
        if (tag.equals("tag:yaml.org,2002:int")) {
            if (state.schema == Types.YAMLSchema.JSON_SCHEMA) {
                return TagResolutionUtils.constructSimpleInt(data.toString(), state);
            }
            if (state.schema == Types.YAMLSchema.CORE_SCHEMA) {
                return TagResolutionUtils.constructInt(data.toString(), state);
            }
        }
        if (tag.equals("tag:yaml.org,2002:float")) {
            if (state.schema == Types.YAMLSchema.JSON_SCHEMA) {
                return TagResolutionUtils.constructSimpleFloat(data.toString(), state);
            }
            if (state.schema == Types.YAMLSchema.CORE_SCHEMA) {
                return TagResolutionUtils.constructFloat(data.toString(), state);
            }
        }
        if (tag.equals("tag:yaml.org,2002:bool")) {
            if (state.schema == Types.YAMLSchema.JSON_SCHEMA) {
                return TagResolutionUtils.constructSimpleBool(data.toString(), state);
            }
            if (state.schema == Types.YAMLSchema.CORE_SCHEMA) {
                return TagResolutionUtils.constructBool(data.toString(), state);
            }
        }
        if (tag.equals("tag:yaml.org,2002:null")) {
            if (state.schema == Types.YAMLSchema.JSON_SCHEMA) {
                return TagResolutionUtils.constructSimpleNull(data.toString(), state);
            }
            if (state.schema == Types.YAMLSchema.CORE_SCHEMA) {
                return TagResolutionUtils.constructNull(data.toString(), state);
            }
        }
        throw new Error.YamlParserException("tag schema not supported", state.getLine(), state.getColumn());
    }

    private static YamlEvent handleEvent(ComposerState state, Types.DocumentType docType) throws Error.YamlParserException {
        if (state.terminatedDocEvent != null && state.terminatedDocEvent.getKind() == YamlEvent.EventKind.DOCUMENT_MARKER_EVENT) {
            return state.terminatedDocEvent;
        }
        return YamlParser.parse(state.parserState, ParserUtils.ParserOption.DEFAULT, docType);
    }

    private static YamlEvent handleEvent(ComposerState state, ParserUtils.ParserOption option) throws Error.YamlParserException {
        if (state.terminatedDocEvent != null && state.terminatedDocEvent.getKind() == YamlEvent.EventKind.DOCUMENT_MARKER_EVENT) {
            return state.terminatedDocEvent;
        }
        return YamlParser.parse(state.parserState, option, Types.DocumentType.BARE_DOCUMENT);
    }

    private static YamlEvent parse(ParserState state, ParserUtils.ParserOption option, Types.DocumentType docType) throws Error.YamlParserException {
        Token.TokenType currentTokenType;
        List<YamlEvent> eventBuffer = state.getEventBuffer();
        if (!eventBuffer.isEmpty()) {
            return eventBuffer.remove(0);
        }
        state.updateLexerState(LexerState.LEXER_START_STATE);
        if (!state.isExplicitDoc()) {
            YamlParser.getNextToken(state);
        }
        if (state.getCurrentToken().getType() == Token.TokenType.SEPARATION_IN_LINE) {
            YamlParser.getNextToken(state);
        }
        if ((currentTokenType = state.getCurrentToken().getType()) == Token.TokenType.EOL || currentTokenType == Token.TokenType.EMPTY_LINE || currentTokenType == Token.TokenType.COMMENT) {
            LexerState lexerState = state.getLexerState();
            if (lexerState.isEndOfStream()) {
                if (docType == Types.DocumentType.DIRECTIVE_DOCUMENT) {
                    throw new Error.YamlParserException("invalid document", state.getLine(), state.getColumn());
                }
                return new YamlEvent.EndEvent(Types.Collection.STREAM);
            }
            state.initLexer();
            return YamlParser.parse(state, option, docType);
        }
        if (currentTokenType != Token.TokenType.DIRECTIVE && currentTokenType != Token.TokenType.DIRECTIVE_MARKER && docType == Types.DocumentType.DIRECTIVE_DOCUMENT) {
            throw new Error.YamlParserException("invalid directive document", state.getLine(), state.getColumn());
        }
        switch (currentTokenType) {
            case DIRECTIVE: {
                if (docType == Types.DocumentType.BARE_DOCUMENT) {
                    throw new Error.YamlParserException("directives are not allowed in a bare document", state.getLine(), state.getColumn());
                }
                switch (state.getCurrentToken().getValue()) {
                    case "YAML": {
                        Directive.yamlDirective(state);
                        break;
                    }
                    case "TAG": {
                        Directive.tagDirective(state);
                        break;
                    }
                    default: {
                        Directive.reservedDirective(state);
                    }
                }
                YamlParser.getNextToken(state, List.of(Token.TokenType.SEPARATION_IN_LINE, Token.TokenType.EOL));
                return YamlParser.parse(state, ParserUtils.ParserOption.DEFAULT, Types.DocumentType.DIRECTIVE_DOCUMENT);
            }
            case DOCUMENT_MARKER: 
            case DIRECTIVE_MARKER: {
                boolean explicit = state.getCurrentToken().getType() == Token.TokenType.DIRECTIVE_MARKER;
                state.setExplicitDoc(explicit);
                YamlParser.getNextToken(state, List.of(Token.TokenType.SEPARATION_IN_LINE, Token.TokenType.EOL, Token.TokenType.COMMENT));
                state.getLexerState().resetState();
                if (!explicit) {
                    state.setYamlVersion(null);
                    state.setCustomTagHandles(new HashMap<String, String>());
                }
                if (state.getCurrentToken().getType() == Token.TokenType.SEPARATION_IN_LINE) {
                    YamlParser.getNextToken(state, true);
                    Token bufferedToken = state.getBufferedToken();
                    Token.TokenType bufferedTokenType = bufferedToken.getType();
                    if (bufferedTokenType != Token.TokenType.EOL && bufferedTokenType != Token.TokenType.COMMENT && !explicit) {
                        throw new Error.YamlParserException("token cannot start in the same line as the document marker", state.getLine(), state.getColumn());
                    }
                    if (explicit && (bufferedTokenType == Token.TokenType.PLANAR_CHAR && bufferedToken.getIndentation() != null || bufferedTokenType == Token.TokenType.SEQUENCE_ENTRY)) {
                        throw new Error.YamlParserException("block collection token cannot start in the same line as the directive marker", state.getLine(), state.getColumn());
                    }
                }
                return new YamlEvent.DocumentMarkerEvent(explicit);
            }
            case DOUBLE_QUOTE_DELIMITER: 
            case SINGLE_QUOTE_DELIMITER: 
            case PLANAR_CHAR: 
            case ALIAS: {
                return YamlParser.appendData(state, option, true);
            }
            case TAG: 
            case TAG_HANDLE: 
            case ANCHOR: {
                return YamlParser.nodeComplete(state, option);
            }
            case MAPPING_VALUE: {
                if (state.getLexerState().isFlowCollection()) {
                    if (option == ParserUtils.ParserOption.EXPECT_SEQUENCE_ENTRY || option == ParserUtils.ParserOption.EXPECT_SEQUENCE_VALUE) {
                        state.getEventBuffer().add(new YamlEvent.ScalarEvent());
                        return new YamlEvent.StartEvent(Types.Collection.MAPPING, false, true);
                    }
                    return new YamlEvent.ScalarEvent();
                }
                IndentUtils.Indentation indentation = state.getCurrentToken().getIndentation();
                YamlParser.separate(state);
                switch (indentation.change()) {
                    case INDENT_INCREASE: {
                        state.getEventBuffer().add(new YamlEvent.ScalarEvent());
                        return new YamlEvent.StartEvent(Types.Collection.MAPPING);
                    }
                    case INDENT_NO_CHANGE: {
                        return new YamlEvent.ScalarEvent();
                    }
                    case INDENT_DECREASE: {
                        for (Types.Collection collection : indentation.collection()) {
                            state.getEventBuffer().add(new YamlEvent.EndEvent(collection));
                        }
                        if (option == ParserUtils.ParserOption.EXPECT_MAP_VALUE) {
                            state.getEventBuffer().add(new YamlEvent.ScalarEvent());
                        }
                        return state.getEventBuffer().remove(0);
                    }
                }
                break;
            }
            case SEPARATOR: {
                if (option != ParserUtils.ParserOption.EXPECT_MAP_VALUE) break;
                return new YamlEvent.ScalarEvent();
            }
            case MAPPING_KEY: {
                state.setExplicitKey(true);
                state.setLastExplicitKeyLine(state.getLineIndex());
                return YamlParser.appendData(state, option);
            }
            case SEQUENCE_ENTRY: {
                if (state.getLexerState().isFlowCollection()) {
                    throw new Error.YamlParserException("cannot have block sequence under flow collection", state.getLine(), state.getColumn());
                }
                if (state.isExpectBlockSequenceValue()) {
                    throw new Error.YamlParserException("cannot have nested sequence for a defined value", state.getLine(), state.getColumn());
                }
                switch (state.getCurrentToken().getIndentation().change()) {
                    case INDENT_INCREASE: {
                        return new YamlEvent.StartEvent(Types.Collection.SEQUENCE);
                    }
                    case INDENT_NO_CHANGE: {
                        YamlEvent event = YamlParser.parse(state, ParserUtils.ParserOption.EXPECT_SEQUENCE_VALUE, docType);
                        if (option == ParserUtils.ParserOption.EXPECT_SEQUENCE_VALUE) {
                            state.getEventBuffer().add(event);
                            return new YamlEvent.ScalarEvent();
                        }
                        return event;
                    }
                    case INDENT_DECREASE: {
                        for (Types.Collection collection : state.getCurrentToken().getIndentation().collection()) {
                            state.getEventBuffer().add(new YamlEvent.EndEvent(collection));
                        }
                        return state.getEventBuffer().remove(0);
                    }
                }
                break;
            }
            case MAPPING_START: {
                return new YamlEvent.StartEvent(Types.Collection.MAPPING, true, false);
            }
            case SEQUENCE_START: {
                return new YamlEvent.StartEvent(Types.Collection.SEQUENCE, true, false);
            }
            case SEQUENCE_END: {
                if (state.getLexerState().isFlowCollection()) {
                    YamlParser.separate(state);
                    Token.TokenType bufferedTokenType = state.getBufferedToken().getType();
                    if (bufferedTokenType == Token.TokenType.SEPARATOR) {
                        YamlParser.getNextToken(state);
                    }
                }
                return new YamlEvent.EndEvent(Types.Collection.SEQUENCE);
            }
            case MAPPING_END: {
                if (option == ParserUtils.ParserOption.EXPECT_MAP_VALUE) {
                    state.getEventBuffer().add(new YamlEvent.EndEvent(Types.Collection.MAPPING));
                    return new YamlEvent.ScalarEvent();
                }
                if (state.getLexerState().isFlowCollection()) {
                    YamlParser.separate(state);
                    Token.TokenType bufferedTokenType = state.getBufferedToken().getType();
                    if (bufferedTokenType == Token.TokenType.SEPARATOR) {
                        YamlParser.getNextToken(state);
                    }
                }
                return new YamlEvent.EndEvent(Types.Collection.MAPPING);
            }
            case LITERAL: 
            case FOLDED: {
                state.updateLexerState(LexerState.LEXER_BLOCK_SCALAR);
                return YamlParser.appendData(state, option, true);
            }
        }
        throw new Error.YamlParserException("invalid token", state.getLine(), state.getColumn());
    }

    private static void separate(ParserState state) throws Error.YamlParserException {
        state.updateLexerState(LexerState.LEXER_START_STATE);
        YamlParser.getNextToken(state, true);
        Token.TokenType bufferedTokenType = state.getBufferedToken().getType();
        if (bufferedTokenType != Token.TokenType.EOL && bufferedTokenType != Token.TokenType.SEPARATION_IN_LINE && bufferedTokenType != Token.TokenType.COMMENT) {
            return;
        }
        YamlParser.getNextToken(state);
        if (state.getCurrentToken().getType() == Token.TokenType.SEPARATION_IN_LINE) {
            YamlParser.getNextToken(state, true);
            bufferedTokenType = state.getBufferedToken().getType();
            if (bufferedTokenType != Token.TokenType.EOL && bufferedTokenType != Token.TokenType.COMMENT) {
                return;
            }
            YamlParser.getNextToken(state);
        }
        Token.TokenType currentTokenType = state.getCurrentToken().getType();
        while (currentTokenType == Token.TokenType.EOL || currentTokenType == Token.TokenType.EMPTY_LINE || currentTokenType == Token.TokenType.COMMENT) {
            try {
                state.initLexer();
            }
            catch (Exception ex) {
                return;
            }
            YamlParser.getNextToken(state, true);
            switch (state.getBufferedToken().getType()) {
                case EOL: 
                case EMPTY_LINE: 
                case COMMENT: {
                    YamlParser.getNextToken(state);
                    break;
                }
                case SEPARATION_IN_LINE: {
                    YamlParser.getNextToken(state);
                    YamlParser.getNextToken(state, true);
                    bufferedTokenType = state.getBufferedToken().getType();
                    if (bufferedTokenType != Token.TokenType.EOL && bufferedTokenType != Token.TokenType.COMMENT) {
                        return;
                    }
                    YamlParser.getNextToken(state);
                    break;
                }
                default: {
                    return;
                }
            }
            currentTokenType = state.getCurrentToken().getType();
        }
    }

    private static YamlEvent nodeComplete(ParserState state, ParserUtils.ParserOption option) throws Error.YamlParserException {
        return YamlParser.nodeComplete(state, option, new TagStructure());
    }

    private static YamlEvent nodeComplete(ParserState state, ParserUtils.ParserOption option, TagStructure definedProperties) throws Error.YamlParserException {
        TagStructure tagStructure = new TagStructure();
        state.setTagPropertiesInLine(true);
        switch (state.getCurrentToken().getType()) {
            case TAG_HANDLE: {
                String tagHandle = state.getCurrentToken().getValue();
                state.getLexerState().updateLexerState(LexerState.LEXER_NODE_PROPERTY);
                YamlParser.getNextToken(state, List.of(Token.TokenType.TAG));
                String tagPrefix = state.getCurrentToken().getValue();
                tagStructure.tag = YamlParser.generateCompleteTagName(state, tagHandle, tagPrefix);
                YamlParser.separate(state);
                tagStructure.anchor = YamlParser.nodeAnchor(state);
                break;
            }
            case TAG: {
                tagStructure.tag = state.getCurrentToken().getValue();
                YamlParser.separate(state);
                tagStructure.anchor = YamlParser.nodeAnchor(state);
                break;
            }
            case ANCHOR: {
                tagStructure.anchor = state.getCurrentToken().getValue();
                YamlParser.separate(state);
                TagDetails tagDetails = YamlParser.nodeTag(state);
                if (tagDetails.tagPrefix == null) break;
                tagStructure.tag = tagDetails.tagHandle == null ? tagDetails.tagPrefix : YamlParser.generateCompleteTagName(state, tagDetails.tagHandle, tagDetails.tagPrefix);
            }
        }
        return YamlParser.appendData(state, option, false, tagStructure, definedProperties);
    }

    private static TagDetails nodeTag(ParserState state) throws Error.YamlParserException {
        String tagPrefix = null;
        String tagHandle = null;
        switch (state.getBufferedToken().getType()) {
            case TAG: {
                YamlParser.getNextToken(state);
                tagPrefix = state.getCurrentToken().getValue();
                YamlParser.separate(state);
                break;
            }
            case TAG_HANDLE: {
                YamlParser.getNextToken(state);
                tagHandle = state.getCurrentToken().getValue();
                state.getLexerState().updateLexerState(LexerState.LEXER_NODE_PROPERTY);
                YamlParser.getNextToken(state, List.of(Token.TokenType.TAG));
                tagPrefix = state.getCurrentToken().getValue();
                YamlParser.separate(state);
            }
        }
        return new TagDetails(tagPrefix, tagHandle);
    }

    private static String nodeAnchor(ParserState state) throws Error.YamlParserException {
        String anchor = null;
        if (state.getBufferedToken().getType() == Token.TokenType.ANCHOR) {
            YamlParser.getNextToken(state);
            anchor = state.getCurrentToken().getValue();
            YamlParser.separate(state);
        }
        return anchor;
    }

    private static String generateCompleteTagName(ParserState state, String tagHandle, String tagPrefix) throws Error.YamlParserException {
        String tagHandleName;
        if (state.getCustomTagHandles().containsKey(tagHandle)) {
            tagHandleName = state.getCustomTagHandles().get(tagHandle);
        } else if (Constants.DEFAULT_TAG_HANDLES.containsKey(tagHandle)) {
            tagHandleName = Constants.DEFAULT_TAG_HANDLES.get(tagHandle);
        } else {
            throw new Error.YamlParserException("tag handle is not defined", state.getLine(), state.getColumn());
        }
        return tagHandleName + tagPrefix;
    }

    private static YamlEvent appendData(ParserState state, ParserUtils.ParserOption option) throws Error.YamlParserException {
        return YamlParser.appendData(state, option, false, new TagStructure(), null);
    }

    private static YamlEvent appendData(ParserState state, ParserUtils.ParserOption option, boolean peeked) throws Error.YamlParserException {
        return YamlParser.appendData(state, option, peeked, new TagStructure(), null);
    }

    private static YamlEvent appendData(ParserState state, ParserUtils.ParserOption option, boolean peeked, TagStructure tagStructure, TagStructure definedProperties) throws Error.YamlParserException {
        state.setExpectBlockSequenceValue(true);
        YamlEvent buffer = null;
        if (!peeked) {
            YamlParser.getNextToken(state, true);
            if (state.getBufferedToken().getType() == Token.TokenType.MAPPING_KEY) {
                state.setExplicitKey(true);
                YamlParser.getNextToken(state);
            }
        }
        boolean explicitKey = state.isExplicitKey();
        if (option == ParserUtils.ParserOption.EXPECT_MAP_VALUE && state.getCurrentToken().getType() == Token.TokenType.MAPPING_KEY) {
            buffer = new YamlEvent.ScalarEvent();
        }
        IndentUtils.Indentation indentation = null;
        if (state.isExplicitKey()) {
            indentation = state.getCurrentToken().getIndentation();
            YamlParser.separate(state);
        }
        state.updateLexerState(LexerState.LEXER_START_STATE);
        if (state.getLastExplicitKeyLine() == state.getLineIndex() && !state.getLexerState().isFlowCollection() && option == ParserUtils.ParserOption.EXPECT_MAP_KEY) {
            throw new Error.YamlParserException("cannot have a scalar next to a block key-value pair", state.getLine(), state.getColumn());
        }
        YamlEvent event = YamlParser.content(state, peeked, state.isExplicitKey(), tagStructure);
        boolean isAlias = event.getKind() == YamlEvent.EventKind.ALIAS_EVENT;
        state.setExplicitKey(false);
        if (!explicitKey) {
            indentation = state.getCurrentToken().getIndentation();
        }
        TagStructure newNodeTagStructure = new TagStructure();
        TagStructure currentNodeTagStructure = new TagStructure();
        if (indentation != null) {
            block0 : switch (indentation.tokens().size()) {
                case 0: {
                    newNodeTagStructure = tagStructure;
                    break;
                }
                case 1: {
                    switch (indentation.tokens().get(0)) {
                        case ANCHOR: {
                            if (isAlias && tagStructure.anchor != null) {
                                throw new Error.YamlParserException("an alias node cannot have an anchor", state.getLine(), state.getColumn());
                            }
                            newNodeTagStructure.tag = tagStructure.tag;
                            currentNodeTagStructure.anchor = tagStructure.anchor;
                            break block0;
                        }
                        case TAG: {
                            if (isAlias && tagStructure.tag != null) {
                                throw new Error.YamlParserException("an alias node cannot have a tag", state.getLine(), state.getColumn());
                            }
                            newNodeTagStructure.anchor = tagStructure.anchor;
                            currentNodeTagStructure.tag = tagStructure.tag;
                        }
                    }
                    break;
                }
                case 2: {
                    if (isAlias && (tagStructure.anchor != null || tagStructure.tag != null)) {
                        throw new Error.YamlParserException("an alias node cannot have tag properties", state.getLine(), state.getColumn());
                    }
                    currentNodeTagStructure = tagStructure;
                }
            }
        } else {
            if (isAlias && (tagStructure.anchor != null || tagStructure.tag != null)) {
                throw new Error.YamlParserException("an alias node cannot have tag properties", state.getLine(), state.getColumn());
            }
            currentNodeTagStructure = tagStructure;
        }
        boolean isJsonKey = state.getLexerState().isJsonKey();
        Token.TokenType currentTokenType = state.getCurrentToken().getType();
        if (currentTokenType != Token.TokenType.MAPPING_VALUE && currentTokenType != Token.TokenType.SEPARATOR) {
            YamlParser.separate(state);
        }
        YamlParser.getNextToken(state, true);
        Token.TokenType bufferedTokenType = state.getBufferedToken().getType();
        if (bufferedTokenType == Token.TokenType.MAPPING_VALUE || bufferedTokenType == Token.TokenType.SEPARATOR) {
            YamlParser.getNextToken(state);
        }
        state.getLexerState().setJsonKey(false);
        if (state.getCurrentToken().getType() == Token.TokenType.SEPARATOR) {
            if (!state.getLexerState().isFlowCollection()) {
                throw new Error.YamlParserException("',' are only allowed in flow collections", state.getLine(), state.getColumn());
            }
            YamlParser.separate(state);
            if (option == ParserUtils.ParserOption.EXPECT_MAP_KEY) {
                state.getEventBuffer().add(new YamlEvent.ScalarEvent());
            }
        } else if (state.getCurrentToken().getType() == Token.TokenType.MAPPING_VALUE) {
            if (state.getLastKeyLine() == state.getLineIndex() && !state.getLexerState().isFlowCollection()) {
                throw new Error.YamlParserException("two block mapping keys cannot be defined in the same line", state.getLine(), state.getColumn());
            }
            if (state.getLastExplicitKeyLine() == state.getLineIndex() && !state.getLexerState().isFlowCollection()) {
                throw new Error.YamlParserException("mappings are not allowed as keys for explicit keys", state.getLine(), state.getColumn());
            }
            state.setLastKeyLine(state.getLineIndex());
            if (state.isExplicitDoc()) {
                throw new Error.YamlParserException("'${lexer:PLANAR_CHAR}' token cannot start in the same line as the directive marker", state.getLine(), state.getColumn());
            }
            YamlParser.separate(state);
            if (state.isEmptyKey() && (option == ParserUtils.ParserOption.EXPECT_MAP_VALUE || option == ParserUtils.ParserOption.EXPECT_SEQUENCE_VALUE)) {
                state.setEmptyKey(false);
                state.getEventBuffer().add(new YamlEvent.ScalarEvent());
            } else if (option == ParserUtils.ParserOption.EXPECT_MAP_VALUE) {
                buffer = YamlParser.constructEvent(new YamlEvent.ScalarEvent(), newNodeTagStructure);
            } else if (option == ParserUtils.ParserOption.EXPECT_SEQUENCE_ENTRY || option == ParserUtils.ParserOption.EXPECT_SEQUENCE_VALUE && state.getLexerState().isFlowCollection()) {
                buffer = new YamlEvent.StartEvent(Types.Collection.MAPPING, false, true);
            }
        } else {
            IndentUtils.Indentation peekedIndentation;
            if (definedProperties != null) {
                if (definedProperties.anchor != null && tagStructure.anchor != null) {
                    throw new Error.YamlParserException("only one anchor is allowed for a node", state.getLine(), state.getColumn());
                }
                if (definedProperties.tag != null && tagStructure.tag != null) {
                    throw new Error.YamlParserException("only one tag is allowed for a node", state.getLine(), state.getColumn());
                }
            }
            if (option == ParserUtils.ParserOption.EXPECT_MAP_KEY && !explicitKey) {
                throw new Error.YamlParserException("expected a key for the block mapping", state.getLine(), state.getColumn());
            }
            if (explicitKey && (peekedIndentation = state.getBufferedToken().getIndentation()) != null && peekedIndentation.change() == IndentUtils.Indentation.IndentationChange.INDENT_INCREASE && state.getBufferedToken().getType() != Token.TokenType.MAPPING_KEY) {
                throw new Error.YamlParserException("invalid explicit key", state.getLine(), state.getColumn());
            }
        }
        if (indentation != null && !state.isIndentationProcessed()) {
            int collectionSize = indentation.collection().size();
            switch (indentation.change()) {
                case INDENT_INCREASE: {
                    if (event.getKind() == YamlEvent.EventKind.START_EVENT && ((YamlEvent.StartEvent)event).getStartType() == Types.Collection.SEQUENCE) {
                        return YamlParser.constructEvent(new YamlEvent.StartEvent(indentation.collection().remove(collectionSize - 1)), tagStructure);
                    }
                    buffer = YamlParser.constructEvent(new YamlEvent.StartEvent(indentation.collection().remove(collectionSize - 1)), newNodeTagStructure);
                    break;
                }
                case INDENT_DECREASE: {
                    buffer = new YamlEvent.EndEvent(indentation.collection().remove(0));
                    for (Types.Collection collection : indentation.collection()) {
                        state.getEventBuffer().add(new YamlEvent.EndEvent(collection));
                    }
                    break;
                }
            }
        }
        state.setIndentationProcessed(false);
        if (isJsonKey && currentNodeTagStructure.tag == null) {
            currentNodeTagStructure.tag = "tag:yaml.org,2002:str";
        }
        event = YamlParser.constructEvent(event, isAlias ? null : currentNodeTagStructure);
        if (buffer == null) {
            return event;
        }
        if (explicitKey) {
            state.getEventBuffer().add(0, event);
        } else {
            state.getEventBuffer().add(event);
        }
        return buffer;
    }

    private static YamlEvent constructEvent(YamlEvent yamlEvent, TagStructure newNodeTagStructure) {
        YamlEvent event = yamlEvent.clone();
        if (newNodeTagStructure != null) {
            event.setAnchor(newNodeTagStructure.anchor);
            event.setTag(newNodeTagStructure.tag);
        }
        return event;
    }

    private static YamlEvent content(ParserState state, boolean peeked, boolean explicitKey, TagStructure tagStructure) throws Error.YamlParserException {
        if (!peeked) {
            YamlParser.separate(state);
            YamlParser.getNextToken(state);
        }
        switch (state.getCurrentToken().getType()) {
            case SINGLE_QUOTE_DELIMITER: {
                state.getLexerState().setJsonKey(true);
                String value = YamlParser.singleQuoteScalar(state);
                YamlParser.checkEmptyKey(state);
                return new YamlEvent.ScalarEvent(value);
            }
            case DOUBLE_QUOTE_DELIMITER: {
                state.getLexerState().setJsonKey(true);
                String value = YamlParser.doubleQuoteScalar(state);
                YamlParser.checkEmptyKey(state);
                return new YamlEvent.ScalarEvent(value);
            }
            case PLANAR_CHAR: {
                String value = YamlParser.planarScalar(state);
                YamlParser.checkEmptyKey(state);
                return new YamlEvent.ScalarEvent(value);
            }
            case SEQUENCE_ENTRY: {
                if (state.isTagPropertiesInLine()) {
                    throw new Error.YamlParserException("'-' cannot be defined after tag properties", state.getLine(), state.getColumn());
                }
                switch (state.getCurrentToken().getIndentation().change()) {
                    case INDENT_INCREASE: {
                        return new YamlEvent.StartEvent(Types.Collection.SEQUENCE);
                    }
                    case INDENT_NO_CHANGE: {
                        return new YamlEvent.ScalarEvent();
                    }
                    case INDENT_DECREASE: {
                        state.setIndentationProcessed(true);
                        for (Types.Collection collection : state.getCurrentToken().getIndentation().collection()) {
                            state.getEventBuffer().add(new YamlEvent.EndEvent(collection));
                        }
                        return YamlParser.constructEvent(new YamlEvent.ScalarEvent(), tagStructure);
                    }
                }
                break;
            }
            case LITERAL: 
            case FOLDED: {
                if (state.getLexerState().isFlowCollection()) {
                    throw new Error.YamlParserException("cannot have a block node inside a flow node", state.getLine(), state.getColumn());
                }
                String value = YamlParser.blockScalar(state, state.getCurrentToken().getType() == Token.TokenType.FOLDED);
                YamlParser.checkEmptyKey(state);
                return new YamlEvent.ScalarEvent(value);
            }
            case ALIAS: {
                return new YamlEvent.AliasEvent(state.getCurrentToken().getValue());
            }
        }
        return new YamlEvent.ScalarEvent();
    }

    private static String blockScalar(ParserState state, boolean isFolded) throws Error.YamlParserException {
        String chompingIndicator = "";
        state.getLexerState().updateLexerState(LexerState.LEXER_BLOCK_HEADER);
        YamlParser.getNextToken(state);
        switch (state.getCurrentToken().getType()) {
            case CHOMPING_INDICATOR: {
                chompingIndicator = state.getCurrentToken().getValue();
                YamlParser.getNextToken(state, List.of(Token.TokenType.EOL));
                if (!state.getLexerState().isEndOfStream()) break;
                state.initLexer();
                break;
            }
            case EOL: {
                state.initLexer();
                chompingIndicator = "=";
            }
        }
        state.getLexerState().updateLexerState(LexerState.LEXER_BLOCK_SCALAR);
        StringBuilder lexemeBuffer = new StringBuilder();
        StringBuilder newLineBuffer = new StringBuilder();
        boolean isFirstLine = true;
        boolean onlyEmptyLine = false;
        boolean prevTokenIndented = false;
        YamlParser.getNextToken(state, true);
        boolean terminated = false;
        while (!terminated) {
            switch (state.getBufferedToken().getType()) {
                case PRINTABLE_CHAR: {
                    String bufferedTokenValue = state.getBufferedToken().getValue();
                    char bufferedTokenValueFirstChar = bufferedTokenValue.charAt(0);
                    if (!isFirstLine) {
                        String suffixChar = "\n";
                        if (isFolded && prevTokenIndented && bufferedTokenValueFirstChar != ' ' && bufferedTokenValueFirstChar != '\t') {
                            suffixChar = newLineBuffer.length() == 0 ? " " : "";
                        }
                        lexemeBuffer.append((CharSequence)newLineBuffer).append(suffixChar);
                        newLineBuffer = new StringBuilder();
                    }
                    lexemeBuffer.append(bufferedTokenValue);
                    prevTokenIndented = bufferedTokenValueFirstChar != ' ' && bufferedTokenValueFirstChar != '\t';
                    isFirstLine = false;
                    break;
                }
                case EOL: {
                    if (state.getLexerState().isEndOfStream()) {
                        terminated = true;
                        break;
                    }
                    state.initLexer();
                    break;
                }
                case TRAILING_COMMENT: {
                    state.getLexerState().setTrailingComment(true);
                    if (state.getLexerState().isEndOfStream()) {
                        YamlParser.getNextToken(state);
                        terminated = true;
                        break;
                    }
                    state.initLexer();
                    YamlParser.getNextToken(state);
                    YamlParser.getNextToken(state, true);
                    Token.TokenType bufferedTokenType = state.getBufferedToken().getType();
                    while (!(bufferedTokenType != Token.TokenType.EOL && bufferedTokenType != Token.TokenType.EMPTY_LINE || state.getLexerState().isEndOfStream())) {
                        state.initLexer();
                        YamlParser.getNextToken(state);
                        YamlParser.getNextToken(state, true);
                        bufferedTokenType = state.getBufferedToken().getType();
                    }
                    state.getLexerState().setTrailingComment(false);
                    terminated = true;
                    break;
                }
                default: {
                    terminated = true;
                }
            }
            if (terminated) continue;
            YamlParser.getNextToken(state);
            YamlParser.getNextToken(state, true);
        }
        switch (chompingIndicator) {
            case "+": {
                lexemeBuffer.append("\n");
                lexemeBuffer.append((CharSequence)newLineBuffer);
                break;
            }
            case "=": {
                if (onlyEmptyLine) break;
                lexemeBuffer.append("\n");
            }
        }
        return lexemeBuffer.toString();
    }

    private static String planarScalar(ParserState state) throws Error.YamlParserException {
        return YamlParser.planarScalar(state, true);
    }

    private static String planarScalar(ParserState state, boolean allowTokensAsPlanar) throws Error.YamlParserException {
        StringBuilder lexemeBuffer = new StringBuilder(state.getCurrentToken().getValue());
        boolean isFirstLine = true;
        StringBuilder newLineBuffer = new StringBuilder();
        state.getLexerState().setAllowTokensAsPlanar(allowTokensAsPlanar);
        YamlParser.getNextToken(state, true);
        boolean terminate = false;
        while (!terminate) {
            switch (state.getBufferedToken().getType()) {
                case PLANAR_CHAR: {
                    if (state.getBufferedToken().getIndentation() != null) {
                        terminate = true;
                        break;
                    }
                    YamlParser.getNextToken(state);
                    if (newLineBuffer.length() > 0) {
                        lexemeBuffer.append((CharSequence)newLineBuffer);
                        newLineBuffer = new StringBuilder();
                    } else {
                        lexemeBuffer.append(" ");
                    }
                    lexemeBuffer.append(state.getCurrentToken().getValue());
                    break;
                }
                case EOL: {
                    YamlParser.getNextToken(state);
                    LexerState lexerState = state.getLexerState();
                    if (lexerState.isEndOfStream()) {
                        terminate = true;
                        break;
                    }
                    state.initLexer();
                    isFirstLine = false;
                    break;
                }
                case COMMENT: {
                    YamlParser.getNextToken(state);
                    terminate = true;
                    break;
                }
                case EMPTY_LINE: {
                    newLineBuffer.append("\n");
                    YamlParser.getNextToken(state);
                    if (state.getLexerState().isEndOfStream()) {
                        terminate = true;
                        break;
                    }
                    state.initLexer();
                    break;
                }
                case SEPARATION_IN_LINE: {
                    YamlParser.getNextToken(state);
                    YamlParser.getNextToken(state, true);
                    if (state.getBufferedToken().getType() != Token.TokenType.MAPPING_VALUE) break;
                    terminate = true;
                    break;
                }
                default: {
                    terminate = true;
                }
            }
            if (terminate) continue;
            YamlParser.getNextToken(state, true);
        }
        if (state.getBufferedToken().getIndentation() == null) {
            YamlParser.verifyKey(state, isFirstLine);
        }
        state.getLexerState().setAllowTokensAsPlanar(false);
        return YamlParser.trimTailWhitespace(lexemeBuffer.toString());
    }

    private static String doubleQuoteScalar(ParserState state) throws Error.YamlParserException {
        state.getLexerState().updateLexerState(LexerState.LEXER_DOUBLE_QUOTE);
        Object lexemeBuffer = "";
        state.getLexerState().setFirstLine(true);
        boolean emptyLine = false;
        boolean escaped = false;
        YamlParser.getNextToken(state);
        while (state.getCurrentToken().getType() != Token.TokenType.DOUBLE_QUOTE_DELIMITER) {
            switch (state.getCurrentToken().getType()) {
                case DOUBLE_QUOTE_CHAR: {
                    String lexeme = state.getCurrentToken().getValue();
                    if (lexeme.length() > 0 && lexeme.charAt(lexeme.length() - 1) == '\\') {
                        escaped = true;
                        lexemeBuffer = (String)lexemeBuffer + lexeme.substring(0, lexeme.length() - 1);
                    } else if (!state.getLexerState().isFirstLine()) {
                        if (escaped) {
                            escaped = false;
                        } else if (!emptyLine) {
                            lexemeBuffer = (String)lexemeBuffer + " ";
                        }
                        lexemeBuffer = (String)lexemeBuffer + lexeme;
                    } else {
                        lexemeBuffer = (String)lexemeBuffer + lexeme;
                    }
                    if (!emptyLine) break;
                    emptyLine = false;
                    break;
                }
                case EMPTY_LINE: {
                    if (escaped && !state.getLexerState().isFirstLine()) {
                        lexemeBuffer = (String)lexemeBuffer + state.getCurrentToken().getValue() + "\n";
                    } else if (!state.getLexerState().isFirstLine()) {
                        lexemeBuffer = YamlParser.trimTailWhitespace((String)lexemeBuffer);
                        lexemeBuffer = (String)lexemeBuffer + "\n";
                    }
                    emptyLine = true;
                    state.initLexer();
                    boolean firstLineBuffer = state.getLexerState().isFirstLine();
                    state.getLexerState().setFirstLine(false);
                    YamlParser.getNextToken(state, true);
                    if (state.getBufferedToken().getType() == Token.TokenType.DOUBLE_QUOTE_DELIMITER && firstLineBuffer) {
                        lexemeBuffer = (String)lexemeBuffer + " ";
                    }
                    state.getLexerState().setFirstLine(false);
                    break;
                }
                default: {
                    String errorMsg = "invalid token '" + String.valueOf((Object)state.getCurrentToken().getType()) + "' inside the double-quoted scalar";
                    throw new Error.YamlParserException(errorMsg, state.getLine(), state.getColumn());
                }
            }
            YamlParser.getNextToken(state);
        }
        YamlParser.verifyKey(state, state.getLexerState().isFirstLine());
        state.getLexerState().setFirstLine(true);
        return lexemeBuffer;
    }

    private static void checkEmptyKey(ParserState state) throws Error.YamlParserException {
        YamlParser.separate(state);
        YamlParser.getNextToken(state, true);
        Token bufferedToken = state.getBufferedToken();
        if (bufferedToken.getType() != Token.TokenType.MAPPING_VALUE || bufferedToken.getIndentation() == null) {
            return;
        }
        state.setEmptyKey(true);
        IndentUtils.Indentation indentation = bufferedToken.getIndentation();
        switch (indentation.change()) {
            case INDENT_INCREASE: {
                int collectionSize = indentation.collection().size();
                state.getEventBuffer().add(new YamlEvent.StartEvent(indentation.collection().remove(collectionSize - 1)));
                break;
            }
            case INDENT_DECREASE: {
                for (Types.Collection collection : indentation.collection()) {
                    state.getEventBuffer().add(new YamlEvent.EndEvent(collection));
                }
                break;
            }
        }
    }

    private static String singleQuoteScalar(ParserState state) throws Error.YamlParserException {
        state.getLexerState().updateLexerState(LexerState.LEXER_SINGLE_QUOTE);
        Object lexemeBuffer = "";
        state.getLexerState().setFirstLine(true);
        boolean emptyLine = false;
        YamlParser.getNextToken(state);
        while (state.getCurrentToken().getType() != Token.TokenType.SINGLE_QUOTE_DELIMITER) {
            switch (state.getCurrentToken().getType()) {
                case SINGLE_QUOTE_CHAR: {
                    String lexeme = state.getCurrentToken().getValue();
                    if (!state.getLexerState().isFirstLine()) {
                        if (emptyLine) {
                            emptyLine = false;
                        } else {
                            lexemeBuffer = (String)lexemeBuffer + " ";
                        }
                    }
                    lexemeBuffer = (String)lexemeBuffer + lexeme;
                    break;
                }
                case EOL: {
                    lexemeBuffer = YamlParser.trimTailWhitespace((String)lexemeBuffer);
                    state.getLexerState().setFirstLine(false);
                    state.initLexer();
                    YamlParser.getNextToken(state, true);
                    if (state.getBufferedToken().getType() != Token.TokenType.SINGLE_QUOTE_DELIMITER || emptyLine) break;
                    lexemeBuffer = (String)lexemeBuffer + " ";
                    break;
                }
                case EMPTY_LINE: {
                    if (!state.getLexerState().isFirstLine()) {
                        lexemeBuffer = YamlParser.trimTailWhitespace((String)lexemeBuffer);
                        lexemeBuffer = (String)lexemeBuffer + "\n";
                    }
                    emptyLine = true;
                    state.initLexer();
                    boolean firstLineBuffer = state.getLexerState().isFirstLine();
                    state.getLexerState().setFirstLine(false);
                    YamlParser.getNextToken(state, true);
                    if (state.getBufferedToken().getType() == Token.TokenType.SINGLE_QUOTE_DELIMITER && firstLineBuffer) {
                        lexemeBuffer = (String)lexemeBuffer + " ";
                    }
                    state.getLexerState().setFirstLine(false);
                    break;
                }
                default: {
                    String errorMsg = "invalid token '" + String.valueOf((Object)state.getCurrentToken().getType()) + "' inside the single-quoted scalar";
                    throw new Error.YamlParserException(errorMsg, state.getLine(), state.getColumn());
                }
            }
            YamlParser.getNextToken(state);
        }
        YamlParser.verifyKey(state, state.getLexerState().isFirstLine());
        state.getLexerState().setFirstLine(true);
        return lexemeBuffer;
    }

    private static String trimTailWhitespace(String value) {
        return YamlParser.trimTailWhitespace(value, -1);
    }

    private static String trimTailWhitespace(String value, int lastEscapedChar) {
        int i = value.length() - 1;
        if (i < 0) {
            return "";
        }
        char charAtI = value.charAt(i);
        while (!(charAtI != ' ' && charAtI != '\t' || i < 1 || lastEscapedChar != -1 && i == lastEscapedChar)) {
            charAtI = value.charAt(--i);
        }
        return value.substring(0, i + 1);
    }

    private static void verifyKey(ParserState state, boolean isSingleLine) throws Error.YamlParserException {
        if (state.isExplicitKey()) {
            return;
        }
        state.getLexerState().updateLexerState(LexerState.LEXER_START_STATE);
        YamlParser.getNextToken(state, true);
        if (state.getBufferedToken().getType() == Token.TokenType.MAPPING_VALUE && !isSingleLine) {
            throw new Error.YamlParserException("mapping keys cannot span multiple lines", state.getLine(), state.getColumn());
        }
    }

    public static void getNextToken(ParserState state) throws Error.YamlParserException {
        YamlParser.getNextToken(state, List.of(Token.TokenType.DUMMY));
    }

    public static void getNextToken(ParserState state, boolean peek) throws Error.YamlParserException {
        YamlParser.getNextToken(state, List.of(Token.TokenType.DUMMY), peek);
    }

    public static void getNextToken(ParserState state, List<Token.TokenType> expectedTokens) throws Error.YamlParserException {
        YamlParser.getNextToken(state, expectedTokens, false);
    }

    public static void getNextToken(ParserState state, List<Token.TokenType> expectedTokens, boolean peek) throws Error.YamlParserException {
        Token token;
        if (state.getBufferedToken().getType() == Token.TokenType.DUMMY) {
            state.updateLexerState(YamlLexer.scanTokens(state.getLexerState()));
            token = state.getLexerState().getToken();
        } else {
            token = state.getBufferedToken();
            state.setBufferedToken(ParserState.DUMMY_TOKEN);
        }
        if (peek) {
            state.setBufferedToken(token);
        } else {
            state.setCurrentToken(token);
        }
        if (expectedTokens.get(0) == Token.TokenType.DUMMY) {
            return;
        }
        if (!expectedTokens.contains((Object)token.getType())) {
            throw new Error.YamlParserException("expected token differ from the actual token", state.getLine(), state.getColumn());
        }
    }

    public static class ComposerState {
        private final ParserState parserState;
        private final Map<String, Object> anchorBuffer = new HashMap<String, Object>();
        Object currentYamlNode;
        Field currentField;
        Deque<Object> nodesStack = new ArrayDeque<Object>();
        Stack<Map<String, Field>> fieldHierarchy = new Stack();
        Stack<Map<String, Field>> visitedFieldHierarchy = new Stack();
        Stack<Type> restType = new Stack();
        Stack<Type> expectedTypes = new Stack();
        Stack<Stack<String>> fieldNameHierarchy = new Stack();
        int jsonFieldDepth = 0;
        Stack<Integer> arrayIndexes = new Stack();
        Stack<ParserContext> parserContexts = new Stack();
        YamlEvent terminatedDocEvent = null;
        int unionDepth = 0;
        boolean rootValueInitialized = false;
        final Types.YAMLSchema schema;
        final boolean allowAnchorRedefinition;
        final boolean allowMapEntryRedefinition;
        final boolean allowDataProjection;
        final boolean nilAsOptionalField;
        final boolean absentAsNilableType;
        final boolean enableYamlStreamReorder;
        boolean expectedTypeIsReadonly = false;
        boolean isPossibleStream = false;
        DynamicTupleState dynamicTupleState = null;

        public ComposerState(ParserState parserState, OptionsUtils.ReadConfig readConfig) {
            this.parserState = parserState;
            this.schema = readConfig.schema();
            this.allowAnchorRedefinition = readConfig.allowAnchorRedefinition();
            this.allowMapEntryRedefinition = readConfig.allowMapEntryRedefinition();
            this.allowDataProjection = readConfig.allowDataProjection();
            this.nilAsOptionalField = readConfig.nilAsOptionalField();
            this.absentAsNilableType = readConfig.absentAsNilableType();
            this.enableYamlStreamReorder = readConfig.enableYamlStreamReorder();
        }

        public int getLine() {
            return this.parserState.getLine();
        }

        public int getColumn() {
            return this.parserState.getColumn();
        }

        private void updateIndexOfArrayElement() {
            int arrayIndex = this.arrayIndexes.pop();
            this.arrayIndexes.push(arrayIndex + 1);
        }

        public void updateFieldHierarchiesAndRestType(Map<String, Field> fields, Type restType) {
            this.fieldHierarchy.push(new HashMap<String, Field>(fields));
            this.visitedFieldHierarchy.push(new HashMap());
            this.restType.push(restType);
            this.fieldNameHierarchy.push(new Stack());
        }

        private void checkUnionAndFinalizeArrayObject() {
            this.arrayIndexes.pop();
            if (this.unionDepth > 0) {
                this.finalizeObject();
                return;
            }
            this.finalizeArrayObjectAndRemoveExpectedType();
        }

        public void checkUnionAndFinalizeNonArrayObject() {
            if (this.unionDepth > 0) {
                this.fieldNameHierarchy.pop();
                this.finalizeObject();
                return;
            }
            this.finalizeNonArrayObjectAndRemoveExpectedType();
        }

        private void finalizeArrayObjectAndRemoveExpectedType() {
            this.finalizeObject();
            this.expectedTypes.pop();
        }

        public void finalizeNonArrayObjectAndRemoveExpectedType() {
            this.finalizeNonArrayObject();
            this.expectedTypes.pop();
        }

        private void finalizeNonArrayObject() {
            if (this.jsonFieldDepth > 0) {
                --this.jsonFieldDepth;
            }
            if (!this.expectedTypes.isEmpty() && this.expectedTypes.peek() == null) {
                this.parserContexts.pop();
                this.fieldNameHierarchy.pop();
                return;
            }
            Map<String, Field> remainingFields = this.fieldHierarchy.pop();
            this.visitedFieldHierarchy.pop();
            this.fieldNameHierarchy.pop();
            this.restType.pop();
            for (Field field : remainingFields.values()) {
                if (this.absentAsNilableType && field.getFieldType().isNilable() || !SymbolFlags.isFlagOn((long)field.getFlags(), (long)256L)) continue;
                throw DiagnosticLog.error(DiagnosticErrorCode.REQUIRED_FIELD_NOT_PRESENT, field.getFieldName());
            }
            this.finalizeObject();
        }

        public Object verifyAndConvertToUnion(Object json) {
            if (this.unionDepth > 0) {
                return json;
            }
            BMap options = ValueCreator.createMapValue();
            BMap allowDataProjectionMap = ValueCreator.createMapValue();
            if (!this.allowDataProjection) {
                options.put((Object)Constants.ALLOW_DATA_PROJECTION, (Object)false);
            } else {
                allowDataProjectionMap.put((Object)Constants.NIL_AS_OPTIONAL_FIELD, (Object)this.nilAsOptionalField);
                allowDataProjectionMap.put((Object)Constants.ABSENT_AS_NILABLE_TYPE, (Object)this.absentAsNilableType);
                options.put((Object)Constants.ALLOW_DATA_PROJECTION, (Object)allowDataProjectionMap);
            }
            return JsonTraverse.traverse(json, (BMap<BString, Object>)options, this.expectedTypes.peek(), this.schema);
        }

        private void finalizeObject() {
            this.parserContexts.pop();
            if (this.unionDepth > 0) {
                --this.unionDepth;
                this.currentYamlNode = this.verifyAndConvertToUnion(this.currentYamlNode);
            }
            if (!this.expectedTypes.isEmpty() && this.expectedTypes.peek() == null) {
                return;
            }
            if (this.nodesStack.isEmpty()) {
                return;
            }
            Object parentNode = this.nodesStack.pop();
            Type parentNodeType = TypeUtils.getType((Object)parentNode);
            int parentNodeTypeTag = TypeUtils.getReferredType((Type)parentNodeType).getTag();
            if (parentNodeTypeTag == 24 || parentNodeTypeTag == 27) {
                Type expType = TypeUtils.getReferredType((Type)this.expectedTypes.peek());
                if (expType.getTag() == 34) {
                    this.currentYamlNode = CloneReadOnly.cloneReadOnly((Object)this.currentYamlNode);
                }
                ((BMap)parentNode).put((Object)StringUtils.fromString((String)this.fieldNameHierarchy.peek().pop()), this.currentYamlNode);
                this.currentYamlNode = parentNode;
                return;
            }
            switch (TypeUtils.getType((Object)parentNode).getTag()) {
                case 32: {
                    ArrayType arrayType = (ArrayType)parentNodeType;
                    if (arrayType.getState() == ArrayType.ArrayState.CLOSED && arrayType.getSize() <= this.arrayIndexes.peek()) break;
                    Type expType = TypeUtils.getReferredType((Type)this.expectedTypes.peek());
                    if (expType.getTag() == 34) {
                        this.currentYamlNode = CloneReadOnly.cloneReadOnly((Object)this.currentYamlNode);
                    }
                    ((BArray)parentNode).add((long)this.arrayIndexes.peek().intValue(), this.currentYamlNode);
                    break;
                }
                case 44: {
                    Type expType = TypeUtils.getReferredType((Type)this.expectedTypes.peek());
                    if (expType.getTag() == 34) {
                        this.currentYamlNode = CloneReadOnly.cloneReadOnly((Object)this.currentYamlNode);
                    }
                    ((BArray)parentNode).add((long)this.arrayIndexes.peek().intValue(), this.currentYamlNode);
                    break;
                }
            }
            this.currentYamlNode = parentNode;
        }

        public void finalizeAnchorValueObject() {
            if (!this.expectedTypes.isEmpty() && this.expectedTypes.peek() == null) {
                return;
            }
            if (this.nodesStack.isEmpty()) {
                return;
            }
            Object parentNode = this.nodesStack.pop();
            Type parentNodeType = TypeUtils.getType((Object)parentNode);
            int parentNodeTypeTag = TypeUtils.getReferredType((Type)parentNodeType).getTag();
            if (parentNodeTypeTag == 24 || parentNodeTypeTag == 27) {
                ((BMap)parentNode).put((Object)StringUtils.fromString((String)this.fieldNameHierarchy.peek().pop()), this.currentYamlNode);
                this.currentYamlNode = parentNode;
                return;
            }
            switch (TypeUtils.getType((Object)parentNode).getTag()) {
                case 32: {
                    ArrayType arrayType = (ArrayType)parentNodeType;
                    if (arrayType.getState() == ArrayType.ArrayState.CLOSED && arrayType.getSize() <= this.arrayIndexes.peek()) break;
                    ((BArray)parentNode).add((long)this.arrayIndexes.peek().intValue(), this.currentYamlNode);
                    break;
                }
                case 44: {
                    ((BArray)parentNode).add((long)this.arrayIndexes.peek().intValue(), this.currentYamlNode);
                    break;
                }
            }
            this.currentYamlNode = parentNode;
        }

        static boolean hasMemberWithArraySubType(Type type) {
            Type referredType = TypeUtils.getReferredType((Type)type);
            int referredTypeTag = referredType.getTag();
            if (referredTypeTag == 32 || referredType.getTag() == 44 || referredTypeTag == 23 || referredTypeTag == 15) {
                return true;
            }
            if (referredTypeTag == 34) {
                for (Type constituentType : ((IntersectionType)referredType).getConstituentTypes()) {
                    if (constituentType.getTag() == 51) continue;
                    return ComposerState.hasMemberWithArraySubType(constituentType);
                }
            }
            return false;
        }

        public void handleExpectedType(Type type) {
            block0 : switch (type.getTag()) {
                case 24: {
                    RecordType recordType = (RecordType)type;
                    this.expectedTypes.add((Type)recordType);
                    this.updateFieldHierarchiesAndRestType(ParserUtils.getAllFieldsInRecord(recordType), recordType.getRestFieldType());
                    break;
                }
                case 32: {
                    this.isPossibleStream = true;
                    this.expectedTypes.add(type);
                    this.arrayIndexes.push(0);
                    Type elementType = TypeUtils.getReferredType((Type)((ArrayType)type).getElementType());
                    UnionType unionType = TypeCreator.createUnionType((Type[])new Type[]{type, elementType});
                    this.expectedTypes.push((Type)unionType);
                    break;
                }
                case 44: {
                    this.isPossibleStream = true;
                    this.expectedTypes.add(type);
                    this.arrayIndexes.push(0);
                    TupleType tupleType = (TupleType)type;
                    List tupleElementTypes = tupleType.getTupleTypes();
                    ArrayList<Type> unionMembers = new ArrayList<Type>();
                    unionMembers.add(type);
                    unionMembers.addAll(tupleElementTypes);
                    Type tupleRestType = tupleType.getRestType();
                    if (tupleRestType != null) {
                        unionMembers.add(tupleRestType);
                    }
                    UnionType unionType = TypeCreator.createUnionType(unionMembers);
                    this.expectedTypes.push((Type)unionType);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 46: {
                    this.expectedTypes.push(type);
                    break;
                }
                case 33: {
                    UnionType unionType = (UnionType)type;
                    for (Type memberType : unionType.getMemberTypes()) {
                        if (!ComposerState.hasMemberWithArraySubType(memberType)) continue;
                        this.isPossibleStream = true;
                        break;
                    }
                    this.expectedTypes.push(type);
                    break;
                }
                case 15: 
                case 23: {
                    this.isPossibleStream = true;
                    this.expectedTypes.push(type);
                    this.updateFieldHierarchiesAndRestType(new HashMap<String, Field>(), type);
                    break;
                }
                case 27: {
                    this.expectedTypes.push(type);
                    this.updateFieldHierarchiesAndRestType(new HashMap<String, Field>(), ((MapType)type).getConstrainedType());
                    break;
                }
                case 34: {
                    Type effectiveType = ((IntersectionType)type).getEffectiveType();
                    if (!SymbolFlags.isFlagOn((long)32L, (long)effectiveType.getFlags())) {
                        throw DiagnosticLog.error(DiagnosticErrorCode.UNSUPPORTED_TYPE, type);
                    }
                    for (Type constituentType : ((IntersectionType)type).getConstituentTypes()) {
                        if (constituentType.getTag() == 51) continue;
                        this.handleExpectedType(TypeUtils.getReferredType((Type)constituentType));
                        this.expectedTypeIsReadonly = true;
                        break block0;
                    }
                    break;
                }
                case 53: {
                    this.handleExpectedType(TypeUtils.getReferredType((Type)type));
                    break;
                }
                default: {
                    throw DiagnosticLog.error(DiagnosticErrorCode.UNSUPPORTED_TYPE, type);
                }
            }
        }
    }

    private static class DynamicTupleState {
        UnionType tupleMembersUnion;
        List<Map<Integer, Integer>> indexToTupleMemberMapping;
        final int tupleSize;
        final TupleType tupleType;
        final Type restType;
        int restIndex;

        DynamicTupleState(TupleType tupleType) {
            this.tupleType = tupleType;
            this.restIndex = this.tupleSize = tupleType.getTupleTypes().size();
            this.restType = tupleType.getRestType();
            this.indexToTupleMemberMapping = DynamicTupleState.constructTupleMembersTableEntry(tupleType);
            this.tupleMembersUnion = DynamicTupleState.createTupleMembersUnion(tupleType, this.restType);
        }

        private boolean isTupleValueCompleted() {
            return this.indexToTupleMemberMapping.size() == 0;
        }

        private boolean canAddMoreRestMembers() {
            return this.restType != null;
        }

        private void updateTupleMemberIndexTableAndAddToTuple(Object value, BArray tupleValue) {
            Type type = TypeUtils.getType((Object)value);
            int typeHashOfBValue = type.hashCode();
            for (int i = 0; i < this.indexToTupleMemberMapping.size(); ++i) {
                Map<Integer, Integer> typeMapping = this.indexToTupleMemberMapping.get(i);
                if (!typeMapping.containsKey(typeHashOfBValue)) continue;
                this.indexToTupleMemberMapping.remove(i);
                tupleValue.add((long)typeMapping.get(typeHashOfBValue).intValue(), value);
                return;
            }
            if (this.restType != null && TypeUtils.getReferredType((Type)this.restType).hashCode() == typeHashOfBValue) {
                tupleValue.add((long)this.restIndex++, value);
            }
        }

        private void updateUnionType() {
            ArrayList<Type> allMembers = new ArrayList<Type>();
            List tupleMembers = this.tupleType.getTupleTypes();
            for (Map<Integer, Integer> mapping : this.indexToTupleMemberMapping) {
                mapping.values().stream().findFirst().ifPresent(index -> allMembers.add((Type)tupleMembers.get((int)index)));
            }
            if (this.restType != null) {
                allMembers.add(this.restType);
            }
            this.tupleMembersUnion = TypeCreator.createUnionType(allMembers);
        }

        private static UnionType createTupleMembersUnion(TupleType tupleType, Type restType) {
            ArrayList<Type> allMembers = new ArrayList<Type>(tupleType.getTupleTypes());
            if (restType != null) {
                allMembers.add(restType);
            }
            return TypeCreator.createUnionType(allMembers);
        }

        private static List<Map<Integer, Integer>> constructTupleMembersTableEntry(TupleType tupleType) {
            List memberTypes = tupleType.getTupleTypes();
            LinkedList<Map<Integer, Integer>> tupleIndexTable = new LinkedList<Map<Integer, Integer>>();
            for (int i = 0; i < memberTypes.size(); ++i) {
                HashMap<Integer, Integer> typeMapping = new HashMap<Integer, Integer>();
                DynamicTupleState.createIndexToTypeMapping((Type)memberTypes.get(i), typeMapping, i);
                tupleIndexTable.add(typeMapping);
            }
            return tupleIndexTable;
        }

        private static void createIndexToTypeMapping(Type type, Map<Integer, Integer> typeMapping, int index) {
            Type referredType = TypeUtils.getReferredType((Type)type);
            if (referredType.getTag() == 33) {
                UnionType unionType = (UnionType)referredType;
                for (Type memberType : unionType.getMemberTypes()) {
                    DynamicTupleState.createIndexToTypeMapping(memberType, typeMapping, index);
                }
            } else {
                int hashValue = referredType.hashCode();
                typeMapping.put(hashValue, index);
            }
        }
    }

    public static class TagStructure {
        String anchor = null;
        String tag = null;
    }

    record TagDetails(String tagPrefix, String tagHandle) {
    }

    public static enum ParserContext {
        MAP,
        ARRAY;

    }
}

