/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.utils;

import io.ballerina.lib.data.yaml.utils.DiagnosticLog;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.constraint.Constraints;

public class DataUtils {
    public static Object validateConstraints(Object convertedValue, BTypedesc typed, boolean requireValidation) {
        if (!requireValidation) {
            return convertedValue;
        }
        Object result = Constraints.validate((Object)convertedValue, (BTypedesc)typed);
        if (result instanceof BError) {
            BError bError = (BError)((Object)result);
            return DiagnosticLog.getYamlError(DataUtils.getPrintableErrorMsg(bError));
        }
        return convertedValue;
    }

    private static String getPrintableErrorMsg(BError err) {
        Object errorMsg = err.getMessage() != null ? err.getMessage() : "";
        Object details = err.getDetails();
        if (details != null && !details.toString().equals("{}")) {
            errorMsg = (String)errorMsg + ", " + String.valueOf(details);
        }
        return errorMsg;
    }
}

