/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.utils;

import io.ballerina.lib.data.yaml.ModuleUtils;
import io.ballerina.lib.data.yaml.utils.DiagnosticErrorCode;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class DiagnosticLog {
    private static final String ERROR_PREFIX = "error";
    private static final String ERROR = "Error";
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle("yaml_error", Locale.getDefault());

    private DiagnosticLog() {
    }

    public static BError error(DiagnosticErrorCode code, Object ... args) {
        String msg = DiagnosticLog.formatMessage(code, args);
        return DiagnosticLog.getYamlError(msg);
    }

    private static String formatMessage(DiagnosticErrorCode code, Object[] args) {
        String msgKey = MESSAGES.getString("error." + code.messageKey());
        return MessageFormat.format(msgKey, args);
    }

    public static BError getYamlError(String message) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)ERROR, (BString)StringUtils.fromString((String)message), null, null);
    }
}

