/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.core.builder;

import com.google.api.AnnotationsProto;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.TomlDocument;
import io.ballerina.protoc.core.BalFileGenerationUtils;
import io.ballerina.protoc.core.builder.balgen.BalGenConstants;
import io.ballerina.protoc.core.builder.stub.Descriptor;
import io.ballerina.protoc.core.builder.stub.EnumMessage;
import io.ballerina.protoc.core.builder.stub.Message;
import io.ballerina.protoc.core.builder.stub.Method;
import io.ballerina.protoc.core.builder.stub.ServiceFile;
import io.ballerina.protoc.core.builder.stub.ServiceStub;
import io.ballerina.protoc.core.builder.stub.StubFile;
import io.ballerina.protoc.core.builder.syntaxtree.SyntaxTreeGenerator;
import io.ballerina.protoc.core.builder.syntaxtree.components.Class;
import io.ballerina.protoc.core.builder.syntaxtree.utils.ClientSampleSyntaxTreeUtils;
import io.ballerina.protoc.core.builder.syntaxtree.utils.CommonUtils;
import io.ballerina.protoc.core.descriptor.DescriptorMeta;
import io.ballerina.protoc.core.exception.CodeBuilderException;
import io.ballerina.protoc.core.exception.CodeGeneratorException;
import io.ballerina.toml.api.Toml;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

public class BallerinaFileBuilder {
    private final DescriptorMeta rootDescriptor;
    private final Set<DescriptorMeta> dependentDescriptors;
    private String balOutPath;
    private Optional<String> currentPackageName;
    private static final String PROTO_FILE_EXTENSION = ".proto";
    private static final int EXTENSION = 1148;
    public static Map<String, String> enumDefaultValueMap = new HashMap<String, String>();
    public static HashSet<String> dependentValueTypeMap;
    public static Map<String, String> protofileModuleMap;
    public static Map<String, String> componentsModuleMap;
    public static Map<String, Class> streamClassMap;
    public static Map<String, Message> messageMap;

    public BallerinaFileBuilder(DescriptorMeta rootDescriptor, Set<DescriptorMeta> dependentDescriptors) {
        this.rootDescriptor = rootDescriptor;
        this.dependentDescriptors = dependentDescriptors;
        streamClassMap = new HashMap<String, Class>();
        dependentValueTypeMap = new HashSet();
        protofileModuleMap = new HashMap<String, String>();
        componentsModuleMap = new HashMap<String, String>();
        messageMap = new HashMap<String, Message>();
        this.currentPackageName = Optional.empty();
    }

    public BallerinaFileBuilder(DescriptorMeta rootDescriptor, Set<DescriptorMeta> dependentDescriptors, String balOutPath) throws IOException {
        this.rootDescriptor = rootDescriptor;
        this.dependentDescriptors = dependentDescriptors;
        this.balOutPath = balOutPath;
        streamClassMap = new HashMap<String, Class>();
        dependentValueTypeMap = new HashSet();
        protofileModuleMap = new HashMap<String, String>();
        componentsModuleMap = new HashMap<String, String>();
        messageMap = new HashMap<String, Message>();
        this.currentPackageName = Optional.ofNullable(this.getExistingPackageName(this.balOutPath));
    }

    public void build(String mode) throws CodeBuilderException, CodeGeneratorException {
        for (byte[] descriptorData : this.getDependentDescriptorSet(this.dependentDescriptors)) {
            this.computeSourceContent(descriptorData, null, false);
        }
        this.computeSourceContent(this.rootDescriptor.getDescriptor(), mode, true);
    }

    /*
     * WARNING - void declaration
     */
    private void computeSourceContent(byte[] descriptor, String mode, boolean isRoot) throws CodeBuilderException, CodeGeneratorException {
        HashMap<String, List<String>> unusedImports = new HashMap<String, List<String>>();
        if (this.rootDescriptor.getUnusedImports().size() > 0) {
            unusedImports.put(this.rootDescriptor.getProtoName(), this.rootDescriptor.getUnusedImports());
        }
        unusedImports.putAll(this.getUnusedImportsInDependentDescriptorSet(this.dependentDescriptors));
        try (ByteArrayInputStream targetStream = new ByteArrayInputStream(descriptor);){
            String filename;
            ExtensionRegistry extensionRegistry = ExtensionRegistry.newInstance();
            AnnotationsProto.registerAllExtensions(extensionRegistry);
            DescriptorProtos.FileDescriptorProto fileDescriptorSet = DescriptorProtos.FileDescriptorProto.parseFrom(targetStream, (ExtensionRegistryLite)extensionRegistry);
            if (fileDescriptorSet.getPackage().contains("google.protobuf") || fileDescriptorSet.getPackage().contains("google.api") || fileDescriptorSet.getPackage().contains("ballerina.protobuf")) {
                return;
            }
            List<DescriptorProtos.ServiceDescriptorProto> serviceDescriptorList = fileDescriptorSet.getServiceList();
            List<DescriptorProtos.DescriptorProto> messageTypeList = fileDescriptorSet.getMessageTypeList();
            List<DescriptorProtos.EnumDescriptorProto> enumDescriptorProtos = fileDescriptorSet.getEnumTypeList();
            ArrayList<Message> messageList = new ArrayList<Message>();
            ArrayList<EnumMessage> enumList = new ArrayList<EnumMessage>();
            TreeSet<Descriptor> descriptors = new TreeSet<Descriptor>((descriptor1, descriptor2) -> {
                if (descriptor1.getKey().equalsIgnoreCase(descriptor2.getKey())) {
                    return 0;
                }
                return 1;
            });
            String stubRootDescriptor = "";
            if (isRoot) {
                File protoFile = new File(fileDescriptorSet.getName());
                filename = protoFile.getName().replace(PROTO_FILE_EXTENSION, "");
            } else {
                filename = fileDescriptorSet.getName().replace(PROTO_FILE_EXTENSION, "").replace("/", "_");
            }
            String moduleName = this.getModuleName(fileDescriptorSet);
            if (!moduleName.isEmpty() && Objects.isNull(this.balOutPath)) {
                this.balOutPath = Paths.get("", new String[0]).toAbsolutePath().toString();
                this.currentPackageName = Optional.ofNullable(this.getExistingPackageName(this.balOutPath));
            }
            if (!moduleName.isEmpty()) {
                if (this.currentPackageName.isPresent()) {
                    this.validateDirectoryWithPackageName(moduleName, this.currentPackageName.get());
                } else {
                    this.currentPackageName = Optional.of(this.createBallerinaPackage(moduleName));
                }
                if (!isRoot) {
                    fileDescriptorSet.getMessageTypeList().forEach(descriptorProto -> componentsModuleMap.put(descriptorProto.getName(), moduleName));
                    fileDescriptorSet.getEnumTypeList().forEach(descriptorProto -> componentsModuleMap.put(descriptorProto.getName(), moduleName));
                }
                protofileModuleMap.put(filename, moduleName);
            }
            String filePackage = fileDescriptorSet.getPackage();
            StubFile stubFileObject = new StubFile(filename);
            for (Iterator<GeneratedMessageV3> protobufImport : fileDescriptorSet.getDependencyList()) {
                if (unusedImports.containsKey(fileDescriptorSet.getName())) {
                    if (((List)unusedImports.get(fileDescriptorSet.getName())).contains(protobufImport)) continue;
                    stubFileObject.addImport((String)((Object)protobufImport));
                    continue;
                }
                stubFileObject.addImport((String)((Object)protobufImport));
            }
            Descriptor rootDesc = Descriptor.newBuilder(descriptor).build();
            stubRootDescriptor = rootDesc.getData();
            descriptors.add(rootDesc);
            for (byte[] byArray : this.getDependentDescriptorSet(this.dependentDescriptors)) {
                Descriptor dependentDescriptor = Descriptor.newBuilder(byArray).build();
                descriptors.add(dependentDescriptor);
            }
            for (DescriptorProtos.EnumDescriptorProto enumDescriptorProto : enumDescriptorProtos) {
                EnumMessage enumMessage = EnumMessage.newBuilder(enumDescriptorProto).build();
                enumList.add(enumMessage);
            }
            for (DescriptorProtos.DescriptorProto descriptorProto2 : messageTypeList) {
                Message message2 = Message.newBuilder(descriptorProto2, filePackage).build();
                messageList.add(message2);
                messageMap.put(message2.getMessageName(), message2);
            }
            if (this.balOutPath == null && moduleName.isEmpty()) {
                this.balOutPath = StringUtils.isNotBlank((CharSequence)filePackage) ? filePackage.replace(".", BalGenConstants.FILE_SEPARATOR) : "temp";
            }
            stubFileObject.setMessageMap(messageList.stream().collect(Collectors.toMap(Message::getMessageName, message -> message)));
            for (DescriptorProtos.ServiceDescriptorProto serviceDescriptorProto : serviceDescriptorList) {
                ServiceStub.Builder serviceStubBuilder = ServiceStub.newBuilder(serviceDescriptorProto.getName());
                ServiceFile.Builder sampleServiceBuilder = ServiceFile.newBuilder(serviceDescriptorProto.getName());
                List<DescriptorProtos.MethodDescriptorProto> methodList = serviceDescriptorProto.getMethodList();
                for (DescriptorProtos.MethodDescriptorProto methodDescriptorProto : methodList) {
                    String methodID = !filePackage.isEmpty() ? filePackage + "." + serviceDescriptorProto.getName() + "/" + methodDescriptorProto.getName() : serviceDescriptorProto.getName() + "/" + methodDescriptorProto.getName();
                    Method method = Method.newBuilder(methodID).setMethodDescriptor(methodDescriptorProto).setMessageMap(stubFileObject.getMessageMap()).build();
                    serviceStubBuilder.addMethod(method);
                    sampleServiceBuilder.addMethod(method);
                }
                ServiceStub serviceStub = serviceStubBuilder.build();
                stubFileObject.addServiceStub(serviceStub);
            }
            stubFileObject.setEnumList(enumList);
            stubFileObject.setDescriptors(descriptors);
            if (!stubRootDescriptor.isEmpty()) {
                stubFileObject.setRootDescriptor(stubRootDescriptor);
            }
            List<String> fileImports = CommonUtils.removeStandardImports(stubFileObject.getImportList());
            boolean bl = false;
            for (ServiceStub serviceStub : stubFileObject.getStubList()) {
                void var21_32;
                if ("service".equals(mode)) {
                    String serviceFilePath = this.generateOutputFile(this.balOutPath, serviceStub.getServiceName().toLowerCase() + "_service.bal");
                    BallerinaFileBuilder.writeOutputFile(SyntaxTreeGenerator.generateSyntaxTreeForServiceSample(serviceStub, var21_32 == false, stubFileObject.getFileName(), fileImports), serviceFilePath);
                } else if ("client".equals(mode)) {
                    String clientFilePath = this.generateOutputFile(this.balOutPath, serviceStub.getServiceName().toLowerCase() + "_client.bal");
                    BallerinaFileBuilder.writeOutputFile(ClientSampleSyntaxTreeUtils.generateSyntaxTreeForClientSample(serviceStub, filename, messageMap), clientFilePath);
                }
                ++var21_32;
            }
            String stubFilePath = moduleName.contains(".") ? this.generateOutputFile(this.balOutPath, "modules/" + moduleName.substring(moduleName.indexOf(".") + 1) + "/" + filename + "_pb.bal") : this.generateOutputFile(this.balOutPath, filename + "_pb.bal");
            BallerinaFileBuilder.writeOutputFile(SyntaxTreeGenerator.generateSyntaxTree(stubFileObject, isRoot, mode, fileImports), stubFilePath);
        }
        catch (IOException e) {
            throw new CodeBuilderException("IO Error while reading proto file descriptor. " + e.getMessage(), e);
        }
    }

    private void validateDirectoryWithPackageName(String moduleName, String currentPackageName) throws CodeBuilderException {
        if (!moduleName.equals(currentPackageName) && !moduleName.startsWith(currentPackageName + ".")) {
            throw new CodeBuilderException("Ballerina package name does not match with the given package name in the proto file");
        }
    }

    private String getExistingPackageName(String packagePath) throws IOException {
        File ballerinaTomlFile = new File(packagePath, BalGenConstants.FILE_SEPARATOR + "Ballerina.toml");
        if (ballerinaTomlFile.isFile()) {
            Optional packageNameToml;
            String content = new String(Files.readAllBytes(Paths.get(ballerinaTomlFile.getPath(), new String[0])));
            TomlDocument ballerinaToml = TomlDocument.from((String)"Ballerina.toml", (String)content);
            Optional packageTable = ballerinaToml.toml().getTable("package");
            if (packageTable.isPresent() && (packageNameToml = ((Toml)packageTable.get()).get("name")).isPresent()) {
                return ((TomlValueNode)packageNameToml.get()).toNativeValue().toString();
            }
            return ballerinaTomlFile.getParentFile().getName();
        }
        return null;
    }

    private String createBallerinaPackage(String packageName) throws CodeGeneratorException, IOException {
        if (packageName.contains(".")) {
            packageName = packageName.substring(0, packageName.indexOf("."));
        }
        Files.createDirectories(Paths.get(this.balOutPath, new String[0]), new FileAttribute[0]);
        File ballerinaDir = new File(this.balOutPath + BalGenConstants.FILE_SEPARATOR + packageName);
        if (!ballerinaDir.isDirectory()) {
            this.runBalNewProcess(packageName);
        }
        this.balOutPath = this.balOutPath + BalGenConstants.FILE_SEPARATOR + packageName;
        BalFileGenerationUtils.delete(new File(this.balOutPath + BalGenConstants.FILE_SEPARATOR + "main.bal"));
        return packageName;
    }

    private void runBalNewProcess(String packageName) throws IOException, CodeGeneratorException {
        Process balNewProcess = BalFileGenerationUtils.runProcess("cd " + Paths.get(this.balOutPath, new String[0]).toAbsolutePath().toString() + " && bal new " + packageName);
        try {
            balNewProcess.waitFor();
        }
        catch (InterruptedException e) {
            throw new CodeGeneratorException("Failed to create a new Ballerina module. " + e.getMessage(), e);
        }
        BalFileGenerationUtils.handleProcessExecutionErrors(balNewProcess);
    }

    private String getModuleName(DescriptorProtos.FileDescriptorProto fileDescriptorSet) {
        if (!fileDescriptorSet.getOptions().getUnknownFields().hasField(1148)) {
            return "";
        }
        return fileDescriptorSet.getOptions().getUnknownFields().getField(1148).getLengthDelimitedList().get(0).toStringUtf8();
    }

    private String generateOutputFile(String outputDir, String fileName) throws CodeBuilderException {
        try {
            Files.createDirectories(Paths.get(outputDir, fileName).getParent(), new FileAttribute[0]);
            File file = new File(outputDir, fileName);
            if (!file.isFile()) {
                Files.createFile(Paths.get(file.getAbsolutePath(), new String[0]), new FileAttribute[0]);
            }
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new CodeBuilderException("IO Error while creating output Ballerina files. " + e.getMessage(), e);
        }
    }

    private static void writeOutputFile(SyntaxTree syntaxTree, String outPath) throws CodeBuilderException {
        String content;
        try {
            content = Formatter.format((String)syntaxTree.toSourceCode());
        }
        catch (FormatterException e) {
            throw new CodeBuilderException("Formatter Error while formatting output source code. " + e.getMessage(), e);
        }
        try (PrintWriter writer = new PrintWriter(outPath, StandardCharsets.UTF_8.name());){
            writer.print(content);
        }
        catch (IOException e) {
            throw new CodeBuilderException("IO Error while writing output to Ballerina file. " + e.getMessage(), e);
        }
    }

    private Set<byte[]> getDependentDescriptorSet(Set<DescriptorMeta> descriptorMetaSet) {
        HashSet<byte[]> dependentDescriptorSet = new HashSet<byte[]>();
        for (DescriptorMeta descriptorMeta : descriptorMetaSet) {
            dependentDescriptorSet.add(descriptorMeta.getDescriptor());
        }
        return dependentDescriptorSet;
    }

    private Map<String, List<String>> getUnusedImportsInDependentDescriptorSet(Set<DescriptorMeta> descriptorMetaSet) {
        HashMap<String, List<String>> unusedImports = new HashMap<String, List<String>>();
        for (DescriptorMeta descriptorMeta : descriptorMetaSet) {
            if (descriptorMeta.getUnusedImports().size() <= 0) continue;
            unusedImports.put(descriptorMeta.getProtoName(), descriptorMeta.getUnusedImports());
        }
        return unusedImports;
    }
}

