/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.core.builder.balgen;

public class BalGenerationUtils {
    private BalGenerationUtils() {
    }

    public static String bytesToHex(byte[] data) {
        char[] hexChars = new char[data.length * 2];
        for (int j = 0; j < data.length; ++j) {
            int v = data[j] & 0xFF;
            hexChars[j * 2] = "0123456789ABCDEF".toCharArray()[v >>> 4];
            hexChars[j * 2 + 1] = "0123456789ABCDEF".toCharArray()[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String getMappingBalType(String protoType) {
        switch (protoType) {
            case ".google.protobuf.DoubleValue": 
            case ".google.protobuf.FloatValue": {
                return "float";
            }
            case ".google.protobuf.Int32Value": 
            case ".google.protobuf.Int64Value": 
            case ".google.protobuf.UInt64Value": 
            case ".google.protobuf.UInt32Value": {
                return "int";
            }
            case ".google.protobuf.BoolValue": {
                return "boolean";
            }
            case ".google.protobuf.StringValue": {
                return "string";
            }
            case ".google.protobuf.BytesValue": {
                return "byte[]";
            }
            case ".google.protobuf.Any": {
                return "'any:Any";
            }
            case ".google.protobuf.Empty": {
                return null;
            }
            case ".google.protobuf.Timestamp": {
                return "time:Utc";
            }
            case ".google.protobuf.Duration": {
                return "time:Seconds";
            }
            case ".google.protobuf.Struct": {
                return "map<anydata>";
            }
        }
        return protoType.substring(protoType.lastIndexOf(".") + 1);
    }
}

