/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.core.builder.stub;

import com.google.protobuf.DescriptorProtos;
import io.ballerina.protoc.core.builder.BallerinaFileBuilder;
import io.ballerina.protoc.core.builder.stub.utils.StubUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.wso2.ballerinalang.compiler.util.Names;

public class Field {
    private final String fieldType;
    private final String fieldLabel;
    private final String fieldName;
    private final String defaultValue;
    private final String moduleName;
    private static final Map<DescriptorProtos.FieldDescriptorProto.Type, String> FIELD_TYPE_MAP = new HashMap<DescriptorProtos.FieldDescriptorProto.Type, String>();
    private static final Map<String, String> CUSTOM_FIELD_TYPE_MAP;
    private static final Map<DescriptorProtos.FieldDescriptorProto.Label, String> FIELD_LABEL_MAP;
    private static final Map<DescriptorProtos.FieldDescriptorProto.Type, String> FIELD_DEFAULT_VALUE_MAP;
    private static final Map<String, String> CUSTOM_DEFAULT_VALUE_MAP;

    private Field(String fieldName, String fieldType, String fieldLabel, String defaultValue, String moduleName) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.fieldLabel = fieldLabel;
        this.defaultValue = defaultValue;
        this.moduleName = moduleName;
    }

    public static Builder newBuilder(DescriptorProtos.FieldDescriptorProto fieldDescriptor) {
        return new Builder(fieldDescriptor, fieldDescriptor.getTypeName());
    }

    public static Builder newBuilder(DescriptorProtos.FieldDescriptorProto fieldDescriptor, String fieldType) {
        return new Builder(fieldDescriptor, fieldType);
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public String getFieldLabel() {
        return this.fieldLabel;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getDefaultValue(String filename) {
        if (this.isFieldInsideSubModule(filename)) {
            return this.moduleName + ":" + this.defaultValue;
        }
        return this.defaultValue;
    }

    public String getPackageName(String filename) {
        if (this.isFieldInsideSubModule(filename)) {
            return this.moduleName + ":";
        }
        return "";
    }

    private boolean isFieldInsideSubModule(String filename) {
        return !this.moduleName.isEmpty() && BallerinaFileBuilder.protofileModuleMap.containsKey(filename) && !BallerinaFileBuilder.protofileModuleMap.get(filename).substring(BallerinaFileBuilder.protofileModuleMap.get(filename).lastIndexOf(".") + 1).equals(this.moduleName);
    }

    static {
        FIELD_TYPE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE, "float");
        FIELD_TYPE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT, "float");
        FIELD_TYPE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32, "int");
        FIELD_TYPE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64, "int");
        FIELD_TYPE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT32, "int:Unsigned32");
        FIELD_TYPE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT64, "int");
        FIELD_TYPE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT32, "int:Signed32");
        FIELD_TYPE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT64, "int");
        FIELD_TYPE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED32, "int");
        FIELD_TYPE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED64, "int");
        FIELD_TYPE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED32, "int");
        FIELD_TYPE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED64, "int");
        FIELD_TYPE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL, "boolean");
        FIELD_TYPE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING, "string");
        FIELD_TYPE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES, "byte[]");
        CUSTOM_FIELD_TYPE_MAP = new HashMap<String, String>();
        CUSTOM_FIELD_TYPE_MAP.put(".google.protobuf.Any", "'any:Any");
        CUSTOM_FIELD_TYPE_MAP.put(".google.protobuf.Timestamp", "time:Utc");
        CUSTOM_FIELD_TYPE_MAP.put(".google.protobuf.Duration", "time:Seconds");
        FIELD_DEFAULT_VALUE_MAP = new HashMap<DescriptorProtos.FieldDescriptorProto.Type, String>();
        FIELD_DEFAULT_VALUE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE, "0.0");
        FIELD_DEFAULT_VALUE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT, "0.0");
        FIELD_DEFAULT_VALUE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32, "0");
        FIELD_DEFAULT_VALUE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64, "0");
        FIELD_DEFAULT_VALUE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT32, "0");
        FIELD_DEFAULT_VALUE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT64, "0");
        FIELD_DEFAULT_VALUE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT32, "0");
        FIELD_DEFAULT_VALUE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT64, "0");
        FIELD_DEFAULT_VALUE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED32, "0");
        FIELD_DEFAULT_VALUE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED64, "0");
        FIELD_DEFAULT_VALUE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED32, "0");
        FIELD_DEFAULT_VALUE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED64, "0");
        FIELD_DEFAULT_VALUE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL, "false");
        FIELD_DEFAULT_VALUE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING, "");
        FIELD_DEFAULT_VALUE_MAP.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES, "[]");
        CUSTOM_DEFAULT_VALUE_MAP = new HashMap<String, String>();
        CUSTOM_DEFAULT_VALUE_MAP.put(".google.protobuf.Any", "()");
        CUSTOM_DEFAULT_VALUE_MAP.put(".google.protobuf.Timestamp", "[0, 0.0d]");
        CUSTOM_DEFAULT_VALUE_MAP.put(".google.protobuf.Duration", "0.0d");
        FIELD_LABEL_MAP = new HashMap<DescriptorProtos.FieldDescriptorProto.Label, String>();
        FIELD_LABEL_MAP.put(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL, null);
        FIELD_LABEL_MAP.put(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED, null);
        FIELD_LABEL_MAP.put(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED, "[]");
    }

    public static class Builder {
        private final DescriptorProtos.FieldDescriptorProto fieldDescriptor;
        private final String type;

        public Field build() {
            String fieldType = this.type;
            String fieldDefaultValue = null;
            if (CUSTOM_FIELD_TYPE_MAP.get(this.fieldDescriptor.getTypeName()) != null) {
                fieldType = CUSTOM_FIELD_TYPE_MAP.get(this.fieldDescriptor.getTypeName());
                fieldDefaultValue = CUSTOM_DEFAULT_VALUE_MAP.get(this.fieldDescriptor.getTypeName());
            } else if (FIELD_TYPE_MAP.get(this.fieldDescriptor.getType()) != null) {
                fieldType = FIELD_TYPE_MAP.get(this.fieldDescriptor.getType());
                fieldDefaultValue = FIELD_DEFAULT_VALUE_MAP.get(this.fieldDescriptor.getType());
            }
            if (fieldType.startsWith(".")) {
                String[] fieldTypeArray = fieldType.split("\\.");
                fieldType = fieldTypeArray[fieldTypeArray.length - 1];
            }
            String fieldLabel = FIELD_LABEL_MAP.get(this.fieldDescriptor.getLabel());
            if (this.fieldDescriptor.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED) {
                fieldDefaultValue = fieldLabel;
            }
            Object fieldName = this.fieldDescriptor.getName();
            if (Arrays.stream(StubUtils.RESERVED_LITERAL_NAMES).anyMatch(((String)fieldName)::equalsIgnoreCase) || Names.ERROR.getValue().equalsIgnoreCase((String)fieldName)) {
                fieldName = "'" + (String)fieldName;
            }
            if (this.fieldDescriptor.getType().equals(DescriptorProtos.FieldDescriptorProto.Type.TYPE_ENUM)) {
                fieldDefaultValue = BallerinaFileBuilder.enumDefaultValueMap.get(fieldType);
            }
            String moduleName = "";
            if (fieldType.length() > 0 && BallerinaFileBuilder.componentsModuleMap.containsKey(fieldType)) {
                moduleName = BallerinaFileBuilder.componentsModuleMap.get(fieldType).substring(BallerinaFileBuilder.componentsModuleMap.get(fieldType).lastIndexOf(".") + 1);
            }
            return new Field((String)fieldName, fieldType, fieldLabel, fieldDefaultValue, moduleName);
        }

        private Builder(DescriptorProtos.FieldDescriptorProto fieldDescriptor, String fieldType) {
            this.fieldDescriptor = fieldDescriptor;
            this.type = fieldType != null ? fieldType : "empty:Empty";
        }
    }
}

