/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.core.builder.stub;

import com.google.protobuf.DescriptorProtos;
import io.ballerina.protoc.core.builder.balgen.BalGenerationUtils;
import io.ballerina.protoc.core.builder.stub.EnumMessage;
import io.ballerina.protoc.core.builder.stub.Field;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Message {
    private final List<Field> fieldList;
    private String messageName;
    private Map<String, List<Field>> oneofFieldMap;
    private List<EnumMessage> enumList;
    private List<Message> nestedMessageList;
    private List<Message> mapList;

    private Message(String messageName, List<Field> fieldList) {
        this.messageName = messageName;
        this.fieldList = fieldList;
    }

    private void setOneofFieldMap(Map<String, List<Field>> oneofFieldMap) {
        this.oneofFieldMap = oneofFieldMap;
    }

    public Map<String, List<Field>> getOneofFieldMap() {
        return this.oneofFieldMap;
    }

    public List<EnumMessage> getEnumList() {
        return this.enumList;
    }

    private void setEnumList(List<EnumMessage> enumList) {
        this.enumList = enumList;
    }

    public void setMapList(List<Message> mapList) {
        this.mapList = mapList;
    }

    public List<Message> getMapList() {
        return this.mapList;
    }

    public static Builder newBuilder(DescriptorProtos.DescriptorProto messageDescriptor, String packageName) {
        return new Builder(messageDescriptor, messageDescriptor.getName(), packageName);
    }

    public static Builder newBuilder(DescriptorProtos.DescriptorProto messageDescriptor, String messageName, String packageName) {
        return new Builder(messageDescriptor, messageName, packageName);
    }

    public List<Message> getNestedMessageList() {
        return this.nestedMessageList;
    }

    private void setNestedMessageList(List<Message> nestedMessageList) {
        this.nestedMessageList = nestedMessageList;
    }

    public List<Field> getFieldList() {
        return this.fieldList;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public void setMessageName(String messageName) {
        this.messageName = messageName;
    }

    private static String getFieldType(String typeName, String packageName) {
        StringBuilder fieldType = new StringBuilder();
        if (!packageName.isBlank()) {
            typeName = typeName.replaceFirst("^\\." + packageName, "");
        }
        String[] types = typeName.split("\\.");
        for (int i = 1; i < types.length; ++i) {
            if (fieldType.toString().isBlank()) {
                fieldType.append(types[i]);
                continue;
            }
            fieldType.append("_").append(types[i]);
        }
        return fieldType.toString();
    }

    private static boolean isWellKnownProtoType(String type) {
        switch (type) {
            case ".google.protobuf.DoubleValue": 
            case ".google.protobuf.FloatValue": 
            case ".google.protobuf.Int32Value": 
            case ".google.protobuf.Int64Value": 
            case ".google.protobuf.UInt64Value": 
            case ".google.protobuf.UInt32Value": 
            case ".google.protobuf.BoolValue": 
            case ".google.protobuf.BytesValue": 
            case ".google.protobuf.Any": 
            case ".google.protobuf.Empty": 
            case ".google.protobuf.Timestamp": 
            case ".google.protobuf.Duration": 
            case ".google.protobuf.Struct": 
            case ".google.protobuf.StringValue": 
            case "": {
                return true;
            }
        }
        return false;
    }

    public static class Builder {
        private final DescriptorProtos.DescriptorProto messageDescriptor;
        private final String messageName;
        private final String packageName;

        public Message build() {
            ArrayList<Message> nestedMessageList = new ArrayList<Message>();
            ArrayList<Message> mapList = new ArrayList<Message>();
            ArrayList<CallSite> mapNames = new ArrayList<CallSite>();
            for (DescriptorProtos.DescriptorProto descriptorProto : this.messageDescriptor.getNestedTypeList()) {
                Message nestedMessage = descriptorProto.getOptions().hasMapEntry() ? Message.newBuilder(descriptorProto, this.packageName).build() : Message.newBuilder(descriptorProto, this.messageName + "_" + descriptorProto.getName(), this.packageName).build();
                if (descriptorProto.hasOptions() && descriptorProto.getOptions().hasMapEntry()) {
                    mapNames.add((CallSite)((Object)(this.messageName + "_" + descriptorProto.getName())));
                    Optional<DescriptorProtos.FieldDescriptorProto> mapFieldDescriptor = this.messageDescriptor.getFieldList().stream().filter(field -> field.getTypeName().endsWith(nestedMessage.getMessageName())).findFirst();
                    mapFieldDescriptor.ifPresent(fieldDescriptorProto -> nestedMessage.setMessageName(fieldDescriptorProto.getName()));
                    mapList.add(nestedMessage);
                    continue;
                }
                nestedMessageList.add(nestedMessage);
            }
            ArrayList<EnumMessage> enumList = new ArrayList<EnumMessage>();
            for (DescriptorProtos.EnumDescriptorProto enumDescriptorProto : this.messageDescriptor.getEnumTypeList()) {
                EnumMessage enumMessage = EnumMessage.newBuilder(enumDescriptorProto, this.messageName + "_" + enumDescriptorProto.getName()).build();
                enumList.add(enumMessage);
            }
            ArrayList<Field> arrayList = new ArrayList<Field>();
            HashMap<String, List<Field>> oneofFieldMap = new HashMap<String, List<Field>>();
            for (DescriptorProtos.FieldDescriptorProto fieldDescriptorProto2 : this.messageDescriptor.getFieldList()) {
                Field field2;
                if (Message.isWellKnownProtoType(fieldDescriptorProto2.getTypeName())) {
                    Field field22 = Field.newBuilder(fieldDescriptorProto2, BalGenerationUtils.getMappingBalType(fieldDescriptorProto2.getTypeName())).build();
                } else {
                    field2 = Field.newBuilder(fieldDescriptorProto2, Message.getFieldType(fieldDescriptorProto2.getTypeName(), this.packageName)).build();
                }
                if (fieldDescriptorProto2.hasOneofIndex()) {
                    String oneofField = this.messageDescriptor.getOneofDecl(fieldDescriptorProto2.getOneofIndex()).getName();
                    List oneofMessageList = oneofFieldMap.computeIfAbsent(oneofField, k -> new ArrayList());
                    oneofMessageList.add(field2);
                    continue;
                }
                if (mapNames.contains(field2.getFieldType())) continue;
                arrayList.add(field2);
            }
            Message message = new Message(this.messageName, arrayList);
            if (!oneofFieldMap.isEmpty()) {
                message.setOneofFieldMap(oneofFieldMap);
            }
            if (!enumList.isEmpty()) {
                message.setEnumList(enumList);
            }
            if (!nestedMessageList.isEmpty()) {
                message.setNestedMessageList(nestedMessageList);
            }
            if (!mapList.isEmpty()) {
                message.setMapList(mapList);
            }
            return message;
        }

        private Builder(DescriptorProtos.DescriptorProto messageDescriptor, String messageName, String packageName) {
            this.messageDescriptor = messageDescriptor;
            this.messageName = messageName;
            this.packageName = packageName;
        }
    }
}

