/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.core.builder.stub;

import com.google.protobuf.DescriptorProtos;
import io.ballerina.protoc.core.MessageUtils;
import io.ballerina.protoc.core.MethodDescriptor;
import io.ballerina.protoc.core.builder.BallerinaFileBuilder;
import io.ballerina.protoc.core.builder.balgen.BalGenerationUtils;
import io.ballerina.protoc.core.builder.stub.Message;
import java.util.Map;

public class Method {
    private final String methodName;
    private final String methodId;
    private final String inputType;
    private final String outputType;
    private final MethodDescriptor.MethodType methodType;
    private final String inputPackagePrefix;
    private final String outputPackagePrefix;

    private Method(String methodName, String methodId, String inputType, String outputType, MethodDescriptor.MethodType methodType, String inputPackagePrefix, String outputPackagePrefix) {
        this.methodName = methodName;
        this.methodType = methodType;
        this.methodId = methodId;
        this.inputType = inputType;
        this.outputType = outputType;
        this.inputPackagePrefix = inputPackagePrefix;
        this.outputPackagePrefix = outputPackagePrefix;
    }

    public static Builder newBuilder(String methodId) {
        return new Builder(methodId);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodId() {
        return this.methodId;
    }

    public String getInputType() {
        return this.inputType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public MethodDescriptor.MethodType getMethodType() {
        return this.methodType;
    }

    public String getInputPackagePrefix(String filename) {
        if (!this.inputPackagePrefix.isEmpty() && BallerinaFileBuilder.protofileModuleMap.containsKey(filename) && !BallerinaFileBuilder.protofileModuleMap.get(filename).substring(BallerinaFileBuilder.protofileModuleMap.get(filename).lastIndexOf(".") + 1).equals(this.inputPackagePrefix)) {
            return this.inputPackagePrefix + ":";
        }
        return "";
    }

    public String getOutputPackageType(String filename) {
        if (!this.outputPackagePrefix.isEmpty() && BallerinaFileBuilder.protofileModuleMap.containsKey(filename) && !BallerinaFileBuilder.protofileModuleMap.get(filename).substring(BallerinaFileBuilder.protofileModuleMap.get(filename).lastIndexOf(".") + 1).equals(this.outputPackagePrefix)) {
            return this.outputPackagePrefix + ":";
        }
        return "";
    }

    public boolean containsEmptyType() {
        return this.inputType == null || this.outputType == null;
    }

    public static class Builder {
        String methodId;
        DescriptorProtos.MethodDescriptorProto methodDescriptor;
        Map<String, Message> messageMap;

        private Builder(String methodId) {
            this.methodId = methodId;
        }

        public Builder setMethodDescriptor(DescriptorProtos.MethodDescriptorProto methodDescriptor) {
            this.methodDescriptor = methodDescriptor;
            return this;
        }

        public Builder setMessageMap(Map<String, Message> messageMap) {
            this.messageMap = messageMap;
            return this;
        }

        public Method build() {
            MethodDescriptor.MethodType methodType = MessageUtils.getMethodType(this.methodDescriptor);
            String methodName = this.methodDescriptor.getName();
            String inputType = this.methodDescriptor.getInputType();
            inputType = BalGenerationUtils.getMappingBalType(inputType);
            String outputType = this.methodDescriptor.getOutputType();
            outputType = BalGenerationUtils.getMappingBalType(outputType);
            String inputPackageType = "";
            if (BallerinaFileBuilder.componentsModuleMap.containsKey(inputType)) {
                inputPackageType = BallerinaFileBuilder.componentsModuleMap.get(inputType).substring(BallerinaFileBuilder.componentsModuleMap.get(inputType).lastIndexOf(".") + 1);
            }
            String outputPackageType = "";
            if (BallerinaFileBuilder.componentsModuleMap.containsKey(outputType)) {
                outputPackageType = BallerinaFileBuilder.componentsModuleMap.get(outputType).substring(BallerinaFileBuilder.componentsModuleMap.get(outputType).lastIndexOf(".") + 1);
            }
            return new Method(methodName, this.methodId, inputType, outputType, methodType, inputPackageType, outputPackageType);
        }
    }
}

