/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.core.builder.stub;

import io.ballerina.protoc.core.MessageUtils;
import io.ballerina.protoc.core.builder.stub.Method;
import io.ballerina.protoc.core.exception.CodeBuilderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceStub {
    private final String serviceName;
    private final List<Method> unaryFunctions = new ArrayList<Method>();
    private final List<Method> serverStreamingFunctions = new ArrayList<Method>();
    private final List<Method> clientStreamingFunctions = new ArrayList<Method>();
    private final List<Method> bidiStreamingFunctions = new ArrayList<Method>();
    private final Map<String, String> callerMap = new HashMap<String, String>();
    private final Map<String, Boolean> valueTypeMap = new HashMap<String, Boolean>();

    private ServiceStub(String serviceName) {
        this.serviceName = serviceName;
    }

    public static Builder newBuilder(String serviceName) {
        return new Builder(serviceName);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public List<Method> getUnaryFunctions() {
        return Collections.unmodifiableList(this.unaryFunctions);
    }

    public List<Method> getServerStreamingFunctions() {
        return Collections.unmodifiableList(this.serverStreamingFunctions);
    }

    public List<Method> getClientStreamingFunctions() {
        return Collections.unmodifiableList(this.clientStreamingFunctions);
    }

    public List<Method> getBidiStreamingFunctions() {
        return Collections.unmodifiableList(this.bidiStreamingFunctions);
    }

    public Map<String, Boolean> getValueTypeMap() {
        return Collections.unmodifiableMap(this.valueTypeMap);
    }

    public Map<String, String> getCallerMap() {
        return Collections.unmodifiableMap(this.callerMap);
    }

    public static class Builder {
        String serviceName;
        List<Method> methodList = new ArrayList<Method>();

        private Builder(String serviceName) {
            this.serviceName = serviceName;
        }

        public void addMethod(Method method) {
            this.methodList.add(method);
        }

        public ServiceStub build() throws CodeBuilderException {
            ServiceStub serviceStub = new ServiceStub(this.serviceName);
            block6: for (Method method : this.methodList) {
                String callerTypeName = MessageUtils.getCallerTypeName(this.serviceName, method.getOutputType());
                serviceStub.callerMap.put(callerTypeName, method.getOutputType());
                switch (method.getMethodType()) {
                    case UNARY: {
                        this.updateValueTypeMap(serviceStub, method.getInputType(), Boolean.FALSE);
                        this.updateValueTypeMap(serviceStub, method.getOutputType(), Boolean.FALSE);
                        serviceStub.unaryFunctions.add(method);
                        continue block6;
                    }
                    case SERVER_STREAMING: {
                        this.updateValueTypeMap(serviceStub, method.getInputType(), Boolean.FALSE);
                        this.updateValueTypeMap(serviceStub, method.getOutputType(), Boolean.TRUE);
                        serviceStub.serverStreamingFunctions.add(method);
                        continue block6;
                    }
                    case CLIENT_STREAMING: {
                        this.updateValueTypeMap(serviceStub, method.getInputType(), Boolean.TRUE);
                        this.updateValueTypeMap(serviceStub, method.getOutputType(), Boolean.FALSE);
                        serviceStub.clientStreamingFunctions.add(method);
                        continue block6;
                    }
                    case BIDI_STREAMING: {
                        this.updateValueTypeMap(serviceStub, method.getInputType(), Boolean.TRUE);
                        this.updateValueTypeMap(serviceStub, method.getOutputType(), Boolean.TRUE);
                        serviceStub.bidiStreamingFunctions.add(method);
                        continue block6;
                    }
                }
                throw new CodeBuilderException("Method type is unknown or not supported.");
            }
            return serviceStub;
        }

        private void updateValueTypeMap(ServiceStub serviceStub, String key, Boolean value) {
            if (!serviceStub.valueTypeMap.containsKey(key)) {
                serviceStub.valueTypeMap.put(key, value);
            } else if (!serviceStub.valueTypeMap.get(key).booleanValue()) {
                serviceStub.valueTypeMap.put(key, value);
            }
        }
    }
}

