/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.core.builder.syntaxtree.components;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.protoc.core.builder.syntaxtree.constants.SyntaxTreeConstants;

public class Class {
    private Token visibilityQualifier;
    private NodeList<Token> classTypeQualifiers;
    private final Token classKeyWord = AbstractNodeFactory.createIdentifierToken((String)"class ");
    private final Token className;
    private NodeList<Node> members;

    public Class(String name, boolean isPublic) {
        if (isPublic) {
            this.visibilityQualifier = AbstractNodeFactory.createIdentifierToken((String)"public ");
        }
        this.classTypeQualifiers = AbstractNodeFactory.createEmptyNodeList();
        this.className = AbstractNodeFactory.createIdentifierToken((String)(name + " "));
        this.members = NodeFactory.createEmptyNodeList();
    }

    public ClassDefinitionNode getClassDefinitionNode() {
        return NodeFactory.createClassDefinitionNode(null, (Token)this.visibilityQualifier, this.classTypeQualifiers, (Token)this.classKeyWord, (Token)this.className, (Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_BRACE, this.members, (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_BRACE, null);
    }

    public void addMember(Node member) {
        if (this.members.size() > 0) {
            this.members = this.members.add((Node)SyntaxTreeConstants.SYNTAX_TREE_BLANK_LINE);
        }
        this.members = this.members.add(member);
    }

    public void addQualifiers(String[] qualifiers) {
        for (String qualifier : qualifiers) {
            this.classTypeQualifiers = this.classTypeQualifiers.add((Node)AbstractNodeFactory.createIdentifierToken((String)(qualifier + " ")));
        }
    }
}

