/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.core.builder.syntaxtree.components;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.OptionalFieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeTestExpressionNode;
import io.ballerina.compiler.syntax.tree.UnaryExpressionNode;
import io.ballerina.protoc.core.builder.syntaxtree.components.TypeDescriptor;
import io.ballerina.protoc.core.builder.syntaxtree.constants.SyntaxTreeConstants;
import java.util.ArrayList;
import java.util.List;

public class Expression {
    private Expression() {
    }

    public static FieldAccessExpressionNode getFieldAccessExpressionNode(String var, String fieldName) {
        return NodeFactory.createFieldAccessExpressionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode(var), (Token)SyntaxTreeConstants.SYNTAX_TREE_DOT, (NameReferenceNode)TypeDescriptor.getSimpleNameReferenceNode(fieldName));
    }

    public static OptionalFieldAccessExpressionNode getOptionalFieldAccessExpressionNode(String var, String fieldName) {
        return NodeFactory.createOptionalFieldAccessExpressionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode(var), (Token)SyntaxTreeConstants.SYNTAX_TREE_OPTIONAL_CHAINING, (NameReferenceNode)TypeDescriptor.getSimpleNameReferenceNode(fieldName));
    }

    public static MethodCallExpressionNode getMethodCallExpressionNode(ExpressionNode expression, String methodName, String ... args) {
        ArrayList<Object> argList = new ArrayList<Object>();
        for (String arg : args) {
            if (argList.size() > 0) {
                argList.add(SyntaxTreeConstants.SYNTAX_TREE_COMMA);
            }
            argList.add(NodeFactory.createPositionalArgumentNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode(arg)));
        }
        SeparatedNodeList arguments = NodeFactory.createSeparatedNodeList(argList);
        return NodeFactory.createMethodCallExpressionNode((ExpressionNode)expression, (Token)SyntaxTreeConstants.SYNTAX_TREE_DOT, (NameReferenceNode)TypeDescriptor.getSimpleNameReferenceNode(methodName), (Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_PAREN, (SeparatedNodeList)arguments, (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_PAREN);
    }

    public static RemoteMethodCallActionNode getRemoteMethodCallActionNode(ExpressionNode expression, String methodName, String ... args) {
        ArrayList<Object> argList = new ArrayList<Object>();
        for (String arg : args) {
            if (argList.size() > 0) {
                argList.add(SyntaxTreeConstants.SYNTAX_TREE_COMMA);
            }
            argList.add(NodeFactory.createPositionalArgumentNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode(arg)));
        }
        SeparatedNodeList arguments = NodeFactory.createSeparatedNodeList(argList);
        return NodeFactory.createRemoteMethodCallActionNode((ExpressionNode)expression, (Token)SyntaxTreeConstants.SYNTAX_TREE_RIGHT_ARROW, (SimpleNameReferenceNode)TypeDescriptor.getSimpleNameReferenceNode(methodName), (Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_PAREN, (SeparatedNodeList)arguments, (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_PAREN);
    }

    public static ImplicitNewExpressionNode getImplicitNewExpressionNode(String ... args) {
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (String arg : args) {
            if (arguments.size() > 0) {
                arguments.add(SyntaxTreeConstants.SYNTAX_TREE_COMMA);
            }
            arguments.add(NodeFactory.createPositionalArgumentNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode(arg)));
        }
        return NodeFactory.createImplicitNewExpressionNode((Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_NEW, (ParenthesizedArgList)NodeFactory.createParenthesizedArgList((Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_PAREN, (SeparatedNodeList)NodeFactory.createSeparatedNodeList(arguments), (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_PAREN));
    }

    public static ExplicitNewExpressionNode getExplicitNewExpressionNode(String type, String[] args) {
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (String arg : args) {
            if (arguments.size() > 0) {
                arguments.add(SyntaxTreeConstants.SYNTAX_TREE_COMMA);
            }
            arguments.add(NodeFactory.createPositionalArgumentNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode(arg)));
        }
        return NodeFactory.createExplicitNewExpressionNode((Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_NEW, (TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(type), (ParenthesizedArgList)NodeFactory.createParenthesizedArgList((Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_PAREN, (SeparatedNodeList)NodeFactory.createSeparatedNodeList(arguments), (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_PAREN));
    }

    public static ExplicitNewExpressionNode getExplicitNewExpressionNode(TypeDescriptorNode type, String ... args) {
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (String arg : args) {
            if (arguments.size() > 0) {
                arguments.add(SyntaxTreeConstants.SYNTAX_TREE_COMMA);
            }
            arguments.add(NodeFactory.createPositionalArgumentNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode(arg)));
        }
        return NodeFactory.createExplicitNewExpressionNode((Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_NEW, (TypeDescriptorNode)type, (ParenthesizedArgList)NodeFactory.createParenthesizedArgList((Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_PAREN, (SeparatedNodeList)NodeFactory.createSeparatedNodeList(arguments), (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_PAREN));
    }

    public static FunctionCallExpressionNode getFunctionCallExpressionNode(String name, String[] args) {
        ArrayList<SpecificFieldNode> arguments = new ArrayList<SpecificFieldNode>();
        for (String arg : args) {
            arguments.add(NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)arg), (Token)SyntaxTreeConstants.SYNTAX_TREE_COLON, (ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)arg))));
        }
        return NodeFactory.createFunctionCallExpressionNode((NameReferenceNode)TypeDescriptor.getSimpleNameReferenceNode(name), (Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_PAREN, (SeparatedNodeList)NodeFactory.createSeparatedNodeList(arguments), (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_PAREN);
    }

    public static ListConstructorExpressionNode getListConstructorExpressionNode(List<Node> expressions) {
        if (expressions == null) {
            expressions = new ArrayList<Node>();
        }
        return NodeFactory.createListConstructorExpressionNode((Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_BRACKET, (SeparatedNodeList)NodeFactory.createSeparatedNodeList(expressions), (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_BRACKET);
    }

    public static BinaryExpressionNode getBinaryExpressionNode(Node lhs, Node rhs, Token operator) {
        return NodeFactory.createBinaryExpressionNode((SyntaxKind)SyntaxKind.BINARY_EXPRESSION, (Node)lhs, (Token)operator, (Node)rhs);
    }

    public static UnaryExpressionNode getUnaryExpressionNode(ExpressionNode expression) {
        return NodeFactory.createUnaryExpressionNode((Token)SyntaxTreeConstants.SYNTAX_TREE_OPERATOR_UNARY, (ExpressionNode)expression);
    }

    public static BracedExpressionNode getBracedExpressionNode(ExpressionNode expression) {
        return NodeFactory.createBracedExpressionNode((SyntaxKind)SyntaxKind.BRACED_EXPRESSION, (Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_PAREN, (ExpressionNode)expression, (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_PAREN);
    }

    public static TypeTestExpressionNode getTypeTestExpressionNode(ExpressionNode expression, Node typeDescriptor) {
        return NodeFactory.createTypeTestExpressionNode((ExpressionNode)expression, (Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_IS, (Node)typeDescriptor);
    }

    public static TypeTestExpressionNode getUnaryTypeTestExpressionNode(ExpressionNode expression, Node typeDescriptor) {
        return NodeFactory.createTypeTestExpressionNode((ExpressionNode)expression, (Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_NOT_IS, (Node)typeDescriptor);
    }

    public static CheckExpressionNode getCheckExpressionNode(ExpressionNode expression) {
        return NodeFactory.createCheckExpressionNode((SyntaxKind)SyntaxKind.CHECK_ACTION, (Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_CHECK, (ExpressionNode)expression);
    }
}

