/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.core.builder.syntaxtree.components;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.protoc.core.builder.syntaxtree.components.Statement;
import io.ballerina.protoc.core.builder.syntaxtree.components.TypeDescriptor;
import io.ballerina.protoc.core.builder.syntaxtree.constants.SyntaxTreeConstants;
import java.util.ArrayList;
import java.util.List;

public class Function {
    private final SyntaxKind kind = SyntaxKind.OBJECT_METHOD_DEFINITION;
    private NodeList<Token> qualifierList;
    private final Token finalKeyWord = AbstractNodeFactory.createIdentifierToken((String)"function ");
    private final IdentifierToken functionName;
    private final NodeList<Node> relativeResourcePath;
    private final List<Node> parameters;
    private ReturnTypeDescriptorNode returnTypeDescriptorNode;
    private NodeList<StatementNode> statements;

    public Function(String name) {
        this.qualifierList = AbstractNodeFactory.createEmptyNodeList();
        this.functionName = AbstractNodeFactory.createIdentifierToken((String)name);
        this.relativeResourcePath = AbstractNodeFactory.createEmptyNodeList();
        this.parameters = new ArrayList<Node>();
        this.statements = NodeFactory.createEmptyNodeList();
    }

    public Function() {
        this.qualifierList = AbstractNodeFactory.createEmptyNodeList();
        this.functionName = AbstractNodeFactory.createIdentifierToken((String)"");
        this.relativeResourcePath = AbstractNodeFactory.createEmptyNodeList();
        this.parameters = new ArrayList<Node>();
        this.statements = NodeFactory.createEmptyNodeList();
    }

    public FunctionDefinitionNode getFunctionDefinitionNode() {
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)this.kind, null, this.qualifierList, (Token)this.finalKeyWord, (IdentifierToken)this.functionName, this.relativeResourcePath, (FunctionSignatureNode)this.getFunctionSignature(), (FunctionBodyNode)this.getFunctionBody());
    }

    public void addQualifiers(String[] qualifiers) {
        for (String qualifier : qualifiers) {
            this.qualifierList = this.qualifierList.add((Node)AbstractNodeFactory.createIdentifierToken((String)(qualifier + " ")));
        }
    }

    public FunctionSignatureNode getFunctionSignature() {
        return NodeFactory.createFunctionSignatureNode((Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_PAREN, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList(this.parameters), (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_PAREN, (ReturnTypeDescriptorNode)this.returnTypeDescriptorNode);
    }

    public void addRequiredParameter(Node typeName, String name) {
        if (this.parameters.size() > 0) {
            this.parameters.add((Node)SyntaxTreeConstants.SYNTAX_TREE_COMMA);
        }
        NodeList annotations = NodeFactory.createEmptyNodeList();
        this.parameters.add((Node)NodeFactory.createRequiredParameterNode((NodeList)annotations, (Node)typeName, (Token)AbstractNodeFactory.createIdentifierToken((String)name)));
    }

    public void addIncludedRecordParameter(Node typeName, String name) {
        if (this.parameters.size() > 0) {
            this.parameters.add((Node)SyntaxTreeConstants.SYNTAX_TREE_COMMA);
        }
        NodeList annotations = NodeFactory.createEmptyNodeList();
        this.parameters.add((Node)NodeFactory.createIncludedRecordParameterNode((NodeList)annotations, (Token)SyntaxTreeConstants.SYNTAX_TREE_ASTERISK, (Node)typeName, (Token)AbstractNodeFactory.createIdentifierToken((String)name)));
    }

    public void addReturns(TypeDescriptorNode node) {
        this.returnTypeDescriptorNode = TypeDescriptor.getReturnTypeDescriptorNode((Node)node);
    }

    public FunctionBodyNode getFunctionBody() {
        return NodeFactory.createFunctionBodyBlockNode((Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_BRACE, null, this.statements, (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_BRACE, null);
    }

    public void addReturnStatement(ExpressionNode expressionNode) {
        this.statements = this.statements.add((Node)Statement.getReturnStatementNode(expressionNode));
    }

    public void addVariableStatement(VariableDeclarationNode node) {
        this.statements = this.statements.add((Node)node);
    }

    public void addAssignmentStatement(Node varRef, ExpressionNode expressionNode) {
        this.statements = this.statements.add((Node)NodeFactory.createAssignmentStatementNode((Node)varRef, (Token)SyntaxTreeConstants.SYNTAX_TREE_EQUAL, (ExpressionNode)expressionNode, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON));
    }

    public void addIfElseStatement(IfElseStatementNode node) {
        this.statements = this.statements.add((Node)node);
    }

    public void addExpressionStatement(ExpressionStatementNode expressionStatement) {
        this.statements = this.statements.add((Node)expressionStatement);
    }
}

