/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.core.builder.syntaxtree.components;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.CompoundAssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.protoc.core.builder.syntaxtree.components.Literal;
import io.ballerina.protoc.core.builder.syntaxtree.components.TypeDescriptor;
import io.ballerina.protoc.core.builder.syntaxtree.constants.SyntaxTreeConstants;
import java.util.ArrayList;

public class Statement {
    private Statement() {
    }

    public static AssignmentStatementNode getAssignmentStatementNode(String varRef, ExpressionNode expression) {
        return NodeFactory.createAssignmentStatementNode((Node)TypeDescriptor.getSimpleNameReferenceNode(varRef), (Token)SyntaxTreeConstants.SYNTAX_TREE_EQUAL, (ExpressionNode)expression, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON);
    }

    public static CompoundAssignmentStatementNode getCompoundAssignmentStatementNode(String lhs, Token binaryOperator, int value) {
        return NodeFactory.createCompoundAssignmentStatementNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode(lhs), (Token)binaryOperator, (Token)SyntaxTreeConstants.SYNTAX_TREE_EQUAL, (ExpressionNode)Literal.getNumericLiteralNode(value), (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON);
    }

    public static ReturnStatementNode getReturnStatementNode(ExpressionNode expression) {
        return NodeFactory.createReturnStatementNode((Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_RETURN, (ExpressionNode)expression, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON);
    }

    public static ExpressionStatementNode getCallStatementNode(ExpressionNode expression) {
        return NodeFactory.createExpressionStatementNode((SyntaxKind)SyntaxKind.CALL_STATEMENT, (ExpressionNode)expression, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON);
    }

    public static FunctionCallExpressionNode getFunctionCallExpressionNode(String modulePrefix, String identifier, String ... args) {
        ArrayList<PositionalArgumentNode> argNodeList = new ArrayList<PositionalArgumentNode>();
        for (String arg : args) {
            argNodeList.add(NodeFactory.createPositionalArgumentNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode(arg)));
        }
        return NodeFactory.createFunctionCallExpressionNode((NameReferenceNode)TypeDescriptor.getQualifiedNameReferenceNode(modulePrefix, identifier), (Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_PAREN, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList(argNodeList), (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_PAREN);
    }
}

