/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.core.builder.syntaxtree.utils;

import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.protoc.core.builder.BallerinaFileBuilder;
import io.ballerina.protoc.core.builder.syntaxtree.components.Class;
import io.ballerina.protoc.core.builder.syntaxtree.components.Expression;
import io.ballerina.protoc.core.builder.syntaxtree.components.Function;
import io.ballerina.protoc.core.builder.syntaxtree.components.TypeDescriptor;
import io.ballerina.protoc.core.builder.syntaxtree.constants.SyntaxTreeConstants;
import io.ballerina.protoc.core.builder.syntaxtree.utils.CommonUtils;

public class CallerUtils {
    private CallerUtils() {
    }

    public static Class getCallerClass(String key, String value, String filename) {
        Class caller = new Class(key, true);
        caller.addQualifiers(new String[]{"isolated", "client"});
        caller.addMember((Node)TypeDescriptor.getObjectFieldNode("private", new String[]{"final"}, (Node)TypeDescriptor.getQualifiedNameReferenceNode("grpc", "Caller"), "caller"));
        Function init = new Function("init");
        init.addRequiredParameter((Node)TypeDescriptor.getQualifiedNameReferenceNode("grpc", "Caller"), "caller");
        init.addAssignmentStatement((Node)Expression.getFieldAccessExpressionNode("self", "caller"), (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("caller"));
        init.addQualifiers(new String[]{"public", "isolated"});
        caller.addMember((Node)init.getFunctionDefinitionNode());
        Function getId = new Function("getId");
        getId.addReturns((TypeDescriptorNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode("int"));
        getId.addReturnStatement((ExpressionNode)Expression.getMethodCallExpressionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("self", "caller"), "getId", new String[0]));
        getId.addQualifiers(new String[]{"public", "isolated"});
        caller.addMember((Node)getId.getFunctionDefinitionNode());
        if (value != null) {
            String valueCap = switch (value) {
                case "byte[]" -> "Bytes";
                case "time:Utc" -> "Timestamp";
                case "time:Seconds" -> "Duration";
                case "map<anydata>" -> "Struct";
                case "'any:Any" -> "Any";
                default -> CommonUtils.capitalize((String)value);
            };
            if (BallerinaFileBuilder.protofileModuleMap.containsKey(filename) && BallerinaFileBuilder.componentsModuleMap.containsKey(value)) {
                String componentModule = BallerinaFileBuilder.componentsModuleMap.get(value);
                if (!BallerinaFileBuilder.protofileModuleMap.get(filename).equals(componentModule)) {
                    value = componentModule.substring(componentModule.lastIndexOf(".") + 1) + ":" + (String)value;
                }
            }
            Function send = new Function("send" + valueCap);
            send.addRequiredParameter((Node)TypeDescriptor.getSimpleNameReferenceNode((String)value), "response");
            send.addReturns((TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL);
            send.addReturnStatement((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("self", "caller"), "send", "response"));
            send.addQualifiers(new String[]{"isolated", "remote"});
            caller.addMember((Node)send.getFunctionDefinitionNode());
            String contextParam = "Context" + valueCap;
            contextParam = CommonUtils.isBallerinaProtobufType((String)value) ? CommonUtils.getProtobufType((String)value) + ":" + contextParam : CommonUtils.getModulePrefix(contextParam, filename) + contextParam;
            Function sendContext = new Function("sendContext" + valueCap);
            sendContext.addRequiredParameter((Node)TypeDescriptor.getSimpleNameReferenceNode(contextParam), "response");
            sendContext.addReturns((TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL);
            sendContext.addReturnStatement((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("self", "caller"), "send", "response"));
            sendContext.addQualifiers(new String[]{"isolated", "remote"});
            caller.addMember((Node)sendContext.getFunctionDefinitionNode());
        }
        Function sendError = new Function("sendError");
        sendError.addRequiredParameter((Node)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR, "response");
        sendError.addReturns((TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL);
        sendError.addReturnStatement((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("self", "caller"), "sendError", "response"));
        sendError.addQualifiers(new String[]{"isolated", "remote"});
        caller.addMember((Node)sendError.getFunctionDefinitionNode());
        Function complete = new Function("complete");
        complete.addReturns((TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL);
        complete.addReturnStatement((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("self", "caller"), "complete", new String[0]));
        complete.addQualifiers(new String[]{"isolated", "remote"});
        caller.addMember((Node)complete.getFunctionDefinitionNode());
        Function isCancelled = new Function("isCancelled");
        isCancelled.addReturns((TypeDescriptorNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode("boolean"));
        isCancelled.addReturnStatement((ExpressionNode)Expression.getMethodCallExpressionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("self", "caller"), "isCancelled", new String[0]));
        isCancelled.addQualifiers(new String[]{"public", "isolated"});
        caller.addMember((Node)isCancelled.getFunctionDefinitionNode());
        return caller;
    }
}

