/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.core.builder.syntaxtree.utils;

import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.protoc.core.MethodDescriptor;
import io.ballerina.protoc.core.builder.BallerinaFileBuilder;
import io.ballerina.protoc.core.builder.stub.Method;
import io.ballerina.protoc.core.builder.stub.ServiceStub;
import io.ballerina.protoc.core.builder.stub.StubFile;
import io.ballerina.protoc.core.builder.syntaxtree.components.Expression;
import io.ballerina.protoc.core.builder.syntaxtree.components.Function;
import io.ballerina.protoc.core.builder.syntaxtree.components.IfElse;
import io.ballerina.protoc.core.builder.syntaxtree.components.Imports;
import io.ballerina.protoc.core.builder.syntaxtree.components.Map;
import io.ballerina.protoc.core.builder.syntaxtree.components.Statement;
import io.ballerina.protoc.core.builder.syntaxtree.components.TypeDescriptor;
import io.ballerina.protoc.core.builder.syntaxtree.components.VariableDeclaration;
import io.ballerina.protoc.core.builder.syntaxtree.constants.SyntaxTreeConstants;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CommonUtils {
    private static final Set<String> STANDARD_IMPORTS = Set.of("google/protobuf/wrappers.proto", "google/protobuf/timestamp.proto", "google/protobuf/duration.proto", "google/protobuf/any.proto", "google/protobuf/empty.proto", "google/protobuf/type.proto", "google/protobuf/struct.proto", "google/protobuf/descriptor.proto", "google/protobuf/api.proto", "google/protobuf/field_mask.proto", "google/protobuf/source_context.proto", "google/api/annotations.proto", "google/api/http.proto", "ballerina/protobuf/descriptor.proto");

    private CommonUtils() {
    }

    public static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String capitalizeFirstLetter(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
    }

    public static String toCamelCase(String value) {
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }

    public static String toPascalCase(String str) {
        StringBuilder pascalCaseOutput = new StringBuilder();
        for (String s : str.split("_")) {
            s = s.replaceAll("[^a-zA-Z0-9]", "");
            pascalCaseOutput.append(CommonUtils.capitalize(s));
        }
        return pascalCaseOutput.toString();
    }

    public static boolean isBallerinaBasicType(String type) {
        switch (type) {
            case "string": 
            case "int": 
            case "float": 
            case "boolean": 
            case "bytes": {
                return true;
            }
        }
        return false;
    }

    public static boolean isBallerinaProtobufType(String type) {
        if (type == null) {
            return true;
        }
        switch (type) {
            case "string": 
            case "int": 
            case "float": 
            case "boolean": 
            case "byte[]": 
            case "time:Utc": 
            case "time:Seconds": 
            case "map<anydata>": 
            case "'any:Any": {
                return true;
            }
        }
        return false;
    }

    public static String getProtobufType(String type) {
        if (type == null) {
            return "empty";
        }
        switch (type) {
            case "string": 
            case "int": 
            case "float": 
            case "boolean": 
            case "byte[]": {
                return "wrappers";
            }
            case "time:Utc": {
                return "timestamp";
            }
            case "time:Seconds": {
                return "duration";
            }
            case "map<anydata>": {
                return "struct";
            }
            case "'any:Any": {
                return "'any";
            }
        }
        return "";
    }

    public static String getMethodType(String methodType) {
        if (methodType == null) {
            return "";
        }
        switch (methodType) {
            case "byte[]": {
                return "Bytes";
            }
            case "time:Utc": {
                return "Timestamp";
            }
            case "time:Seconds": {
                return "Duration";
            }
            case "map<anydata>": {
                return "Struct";
            }
            case "'any:Any": {
                return "Any";
            }
        }
        return CommonUtils.capitalize(methodType);
    }

    public static void addClientCallBody(Function function, String inputCap, Method method, String filename) {
        String methodName;
        String string = methodName = method.getMethodType().equals((Object)MethodDescriptor.MethodType.UNARY) ? "executeSimpleRPC" : "executeServerStreaming";
        if (method.getInputType() == null) {
            Map empty = new Map();
            VariableDeclaration message = new VariableDeclaration(TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode("empty:Empty"), (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode("message")), (ExpressionNode)empty.getMappingConstructorExpressionNode());
            function.addVariableStatement(message.getVariableDeclarationNode());
        }
        VariableDeclaration headers = new VariableDeclaration(TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getMapTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode(SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING, SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING_ARRAY)), (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode("headers")), (ExpressionNode)new Map().getMappingConstructorExpressionNode());
        function.addVariableStatement(headers.getVariableDeclarationNode());
        if (method.getInputType() != null) {
            Object messageType = method.getInputType().equals("string") ? TypeDescriptor.getBuiltinSimpleNameReferenceNode("string") : TypeDescriptor.getSimpleNameReferenceNode(method.getInputPackagePrefix(filename) + method.getInputType());
            VariableDeclaration message = new VariableDeclaration(TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)messageType, (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode("message")), null);
            function.addVariableStatement(message.getVariableDeclarationNode());
            String contextParam = "Context" + inputCap;
            contextParam = CommonUtils.isBallerinaProtobufType(method.getInputType()) ? CommonUtils.getProtobufType(method.getInputType()) + ":" + contextParam : CommonUtils.getModulePrefix(contextParam, filename) + contextParam;
            IfElse reqIsContext = new IfElse((ExpressionNode)Expression.getTypeTestExpressionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("req"), (Node)TypeDescriptor.getSimpleNameReferenceNode(contextParam)));
            reqIsContext.addIfStatement((StatementNode)Statement.getAssignmentStatementNode("message", (ExpressionNode)Expression.getFieldAccessExpressionNode("req", "content")));
            reqIsContext.addIfStatement((StatementNode)Statement.getAssignmentStatementNode("headers", (ExpressionNode)Expression.getFieldAccessExpressionNode("req", "headers")));
            reqIsContext.addElseStatement((StatementNode)Statement.getAssignmentStatementNode("message", (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("req")));
            function.addIfElseStatement(reqIsContext.getIfElseStatementNode());
        }
        CheckExpressionNode checkExpressionNode = Expression.getCheckExpressionNode((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("self", "grpcClient"), methodName, "\"" + method.getMethodId() + "\"", "message", "headers"));
        if (method.getOutputType() == null && !function.getFunctionDefinitionNode().functionName().toString().endsWith("Context")) {
            function.addAssignmentStatement((Node)TypeDescriptor.getWildcardBindingPatternNode(), (ExpressionNode)checkExpressionNode);
        } else {
            VariableDeclaration payload = new VariableDeclaration(TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode("var"), (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode("payload")), (ExpressionNode)checkExpressionNode);
            function.addVariableStatement(payload.getVariableDeclarationNode());
        }
    }

    public static boolean checkForImportsInServices(List<Method> methodList, String type) {
        for (Method method : methodList) {
            if (!CommonUtils.isType(method.getInputType(), type) && !CommonUtils.isType(method.getOutputType(), type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isType(String methodType, String type) {
        return methodType != null && methodType.equals(type);
    }

    public static void addImports(StubFile stubFile, Set<String> ballerinaImports, Set<String> protobufImports) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (ServiceStub serviceStub : stubFile.getStubList()) {
            methodList.addAll(serviceStub.getUnaryFunctions());
            methodList.addAll(serviceStub.getClientStreamingFunctions());
            methodList.addAll(serviceStub.getServerStreamingFunctions());
            methodList.addAll(serviceStub.getBidiStreamingFunctions());
        }
        Iterator<Object> iterator = stubFile.getImportList().iterator();
        while (iterator.hasNext()) {
            String protobufImport;
            switch (protobufImport = (String)iterator.next()) {
                case "google/protobuf/wrappers.proto": {
                    if (!CommonUtils.checkForImportsInServices(methodList, "string") && !CommonUtils.checkForImportsInServices(methodList, "int") && !CommonUtils.checkForImportsInServices(methodList, "float") && !CommonUtils.checkForImportsInServices(methodList, "byte[]") && !CommonUtils.checkForImportsInServices(methodList, "boolean")) break;
                    protobufImports.add("wrappers");
                    break;
                }
                case "google/protobuf/timestamp.proto": 
                case "google/protobuf/duration.proto": {
                    ballerinaImports.add("time");
                    break;
                }
                case "google/protobuf/any.proto": {
                    protobufImports.add("'any");
                    break;
                }
                case "google/protobuf/empty.proto": {
                    protobufImports.add("empty");
                    break;
                }
            }
        }
    }

    public static List<String> removeStandardImports(List<String> importList) {
        ArrayList<String> filteredImports = new ArrayList<String>();
        for (String importName : importList) {
            if (STANDARD_IMPORTS.contains(importName)) continue;
            filteredImports.add(importName);
        }
        return filteredImports;
    }

    public static String getModulePrefix(String contextParam, String filename) {
        if (BallerinaFileBuilder.componentsModuleMap.containsKey(contextParam) && BallerinaFileBuilder.protofileModuleMap.containsKey(filename) && !BallerinaFileBuilder.protofileModuleMap.get(filename).equals(BallerinaFileBuilder.componentsModuleMap.get(contextParam))) {
            return BallerinaFileBuilder.componentsModuleMap.get(contextParam).substring(BallerinaFileBuilder.componentsModuleMap.get(contextParam).lastIndexOf(".") + 1) + ":";
        }
        return "";
    }

    public static NodeList<ImportDeclarationNode> addSubModuleImports(List<Method> methodList, String filename, NodeList<ImportDeclarationNode> imports) {
        HashSet<String> importedModules = new HashSet<String>();
        for (Method method : methodList) {
            if (BallerinaFileBuilder.componentsModuleMap.containsKey(method.getInputType())) {
                importedModules.add(BallerinaFileBuilder.componentsModuleMap.get(method.getInputType()));
            }
            if (!BallerinaFileBuilder.componentsModuleMap.containsKey(method.getOutputType())) continue;
            importedModules.add(BallerinaFileBuilder.componentsModuleMap.get(method.getOutputType()));
        }
        for (String type : importedModules.toArray(new String[importedModules.size()])) {
            if (!BallerinaFileBuilder.protofileModuleMap.containsKey(filename) || BallerinaFileBuilder.protofileModuleMap.get(filename).equals(type)) continue;
            imports = imports.add((Node)Imports.getImportDeclarationNode(type));
        }
        return imports;
    }

    public static NodeList<ImportDeclarationNode> addAnyImportIfExists(List<Method> methods, NodeList<ImportDeclarationNode> imports) {
        if (CommonUtils.checkForImportsInServices(methods, "'any:Any")) {
            return imports.add((Node)Imports.getImportDeclarationNode("ballerina", "protobuf.types.'any"));
        }
        return imports;
    }

    public static NodeList<ImportDeclarationNode> addTimeImportsIfExists(List<Method> methods, NodeList<ImportDeclarationNode> imports) {
        if (CommonUtils.checkForImportsInServices(methods, "time:Utc") || CommonUtils.checkForImportsInServices(methods, "time:Seconds")) {
            return imports.add((Node)Imports.getImportDeclarationNode("ballerina", "time"));
        }
        return imports;
    }
}

